/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import org.isqlviewer.swing.ActionManager;
import org.isqlviewer.util.BasicUtilities;

public abstract class ActionPanel
extends JPanel
implements ActionListener {
    private static final ActionManager shared = ActionManager.createDefaultInstance();
    private static final Thread sharedThread = new Thread((Runnable)shared, "shared-action");
    private ActionManager manager = null;
    private ActionListener delegate = new ActionDelegate(this);

    public ActionPanel(ActionManager actionManager) {
        if (actionManager == null) {
            throw new NullPointerException();
        }
        this.manager = actionManager;
        this.manager.addActionListener(this.delegate);
        if (!sharedThread.isAlive()) {
            sharedThread.setDaemon(true);
            sharedThread.start();
        }
    }

    public ActionPanel() {
        this(shared);
    }

    public abstract void processActionEvent(ActionEvent var1);

    public void finalize() throws Throwable {
        this.manager.removeActionListener(this.delegate);
        super.finalize();
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        this.manager.forwardAction(actionEvent);
    }

    private static class ActionDelegate
    implements ActionListener {
        private ActionPanel reference = null;

        public ActionDelegate(ActionPanel actionPanel) {
            this.reference = actionPanel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                this.reference.processActionEvent(actionEvent);
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable);
            }
            finally {
                this.reference.invalidate();
                this.reference.validateTree();
                this.reference.repaint();
            }
        }
    }
}

