/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.renderers;

import java.awt.Dimension;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Clob;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.isqlviewer.core.renderers.AbstractDataRenderer;
import org.isqlviewer.util.BasicUtilities;

public class ImageRenderer
extends AbstractDataRenderer {
    private static final String RAW_IMAGE_PROPERTY = "RAW_IMAGE";

    public Object getPrintableData(JComponent jComponent) {
        return (ImageIcon)((JLabel)jComponent).getIcon();
    }

    public JComponent getDataRenderer() {
        return new JLabel();
    }

    public Runnable renderContent(Object object, JComponent jComponent) throws IllegalArgumentException {
        if (object == null || !(object instanceof String) && !(object instanceof Clob) && !(object instanceof Blob)) {
            throw new IllegalArgumentException();
        }
        return new ImageRendererProcess((JLabel)jComponent, object);
    }

    public String getName() {
        return BasicUtilities.getString("ImgViewer_Name");
    }

    public String getDescription() {
        return BasicUtilities.getString("ImgViewer_Desc");
    }

    public Icon getUserIcon() {
        return BasicUtilities.loadIconResource("Image16");
    }

    public boolean isPrintable(JComponent jComponent) {
        return ((JLabel)jComponent).getIcon() != null;
    }

    public InputStream getBinaryStream(JComponent jComponent) {
        byte[] byArray = (byte[])((JLabel)jComponent).getClientProperty(RAW_IMAGE_PROPERTY);
        if (byArray == null) {
            byArray = new byte[]{};
        }
        return new ByteArrayInputStream(byArray);
    }

    private static class ImageRendererProcess
    implements Runnable {
        private JLabel imageView = null;
        private Object data = null;

        public ImageRendererProcess(JLabel jLabel, Object object) {
            this.imageView = jLabel;
            this.data = object;
        }

        public void run() {
            byte[] byArray = null;
            if (this.data == null) {
                return;
            }
            try {
                ImageIcon imageIcon = null;
                if (this.data instanceof String) {
                    String string = (String)this.data;
                    byArray = string.getBytes();
                    imageIcon = new ImageIcon(byArray);
                    imageIcon.setDescription("TEXT (" + imageIcon.getIconWidth() + "x" + imageIcon.getIconHeight() + ")");
                } else if (this.data instanceof Blob) {
                    Blob blob = (Blob)this.data;
                    long l2 = blob.length();
                    if (l2 > Integer.MAX_VALUE) {
                        System.out.println(BasicUtilities.getString("Blob_TooLarge"));
                        byArray = blob.getBytes(0L, 0x7FFFFFFE);
                    } else if (l2 < 0L) {
                        System.out.println(BasicUtilities.getString("Blob_LengthError"));
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1);
                        InputStream inputStream = blob.getBinaryStream();
                        BasicUtilities.copyStream(inputStream, byteArrayOutputStream);
                        byArray = byteArrayOutputStream.toByteArray();
                        inputStream.close();
                        byteArrayOutputStream.reset();
                        byteArrayOutputStream.close();
                    } else {
                        byArray = blob.getBytes(0L, (int)l2);
                    }
                    imageIcon = new ImageIcon(byArray);
                    imageIcon.setDescription("BLOB (" + imageIcon.getIconWidth() + "x" + imageIcon.getIconHeight() + ")");
                } else if (this.data instanceof Clob) {
                    Clob clob = (Clob)this.data;
                    long l3 = clob.length();
                    if (l3 > Integer.MAX_VALUE) {
                        System.out.println(BasicUtilities.getString("Clob_TooLarge"));
                        byArray = clob.getSubString(0L, 0x7FFFFFFE).getBytes();
                    } else if (l3 < 0L) {
                        System.out.println(BasicUtilities.getString("Clob_LengthError"));
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1);
                        InputStream inputStream = clob.getAsciiStream();
                        BasicUtilities.copyStream(inputStream, byteArrayOutputStream);
                        byArray = byteArrayOutputStream.toByteArray();
                        inputStream.close();
                        byteArrayOutputStream.reset();
                        byteArrayOutputStream.close();
                    } else {
                        byArray = clob.getSubString(0L, (int)l3).getBytes();
                    }
                    imageIcon = new ImageIcon(byArray);
                    imageIcon.setDescription("CLOB (" + imageIcon.getIconWidth() + "x" + imageIcon.getIconHeight() + ")");
                }
                this.imageView.setIcon(imageIcon);
                this.imageView.putClientProperty(ImageRenderer.RAW_IMAGE_PROPERTY, byArray);
                this.imageView.setText(null);
                this.imageView.setToolTipText(imageIcon.getDescription());
                this.imageView.setHorizontalAlignment(0);
                this.imageView.setPreferredSize(new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight()));
            }
            finally {
                return;
            }
        }
    }
}

