/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.renderers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.util.Date;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.isqlviewer.core.model.HexViewTableModel;
import org.isqlviewer.core.renderers.AbstractDataRenderer;
import org.isqlviewer.swing.ITable;
import org.isqlviewer.util.BasicUtilities;

public class BinaryRenderer
extends AbstractDataRenderer {
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Number;

    public Object getPrintableData(JComponent jComponent) {
        ITable iTable = new ITable();
        HexTableCellRenderer hexTableCellRenderer = new HexTableCellRenderer();
        Class<?> clazz = class$java$lang$Number;
        if (clazz == null) {
            clazz = class$java$lang$Number = new Number[0].getClass().getComponentType();
        }
        iTable.setDefaultRenderer(clazz, hexTableCellRenderer);
        Class<?> clazz2 = class$java$lang$String;
        if (clazz2 == null) {
            clazz2 = class$java$lang$String = new String[0].getClass().getComponentType();
        }
        iTable.setDefaultRenderer(clazz2, hexTableCellRenderer);
        HexViewTableModel hexViewTableModel = ((RendererView)jComponent).mdlHexView;
        iTable.setModel(hexViewTableModel);
        return iTable;
    }

    public Runnable renderContent(Object object, JComponent jComponent) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        return new BinaryRendererProcess((RendererView)jComponent, object);
    }

    public JComponent getDataRenderer() {
        return new RendererView();
    }

    public String getName() {
        return BasicUtilities.getString("HexViewer_Name");
    }

    public String getDescription() {
        return BasicUtilities.getString("HexViewer_Desc");
    }

    public Icon getUserIcon() {
        return BasicUtilities.loadIconResource("Csv16");
    }

    public boolean isPrintable(JComponent jComponent) {
        HexViewTableModel hexViewTableModel = ((RendererView)jComponent).mdlHexView;
        return hexViewTableModel.toString().length() >= 1;
    }

    public InputStream getBinaryStream(JComponent jComponent) {
        HexViewTableModel hexViewTableModel = ((RendererView)jComponent).mdlHexView;
        return new ByteArrayInputStream(hexViewTableModel.toString().getBytes());
    }

    private static class HexTableCellRenderer
    extends DefaultTableCellRenderer {
        public Font fnt = new Font("Monospaced", 0, 9);

        public HexTableCellRenderer() {
            this.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
            try {
                super.getTableCellRendererComponent(jTable, object, bl2, bl3, n2, n3);
                this.setFont(this.fnt);
                if (object instanceof Number) {
                    try {
                        String string = Integer.toHexString(((Number)object).intValue()).toUpperCase();
                        if (string.length() == 1) {
                            string = "0".concat(string);
                        }
                        this.setText(string);
                    }
                    catch (Throwable throwable) {}
                } else {
                    String string = n3 == jTable.getColumnCount() - 1 ? (String)object : ((String)object).toUpperCase();
                    this.setText(string);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return this;
        }
    }

    private static class BinaryRendererProcess
    implements Runnable {
        private RendererView view = null;
        private HexViewTableModel mdl = null;
        private Object data = null;

        public BinaryRendererProcess(RendererView rendererView, Object object) {
            this.mdl = rendererView.mdlHexView;
            this.view = rendererView;
            this.data = object;
        }

        public void run() {
            if (this.data == null || this.mdl == null) {
                return;
            }
            try {
                if (this.data instanceof String) {
                    this.view.original = (String)this.data;
                    this.mdl.setData(this.view.original, "UTF8");
                } else if (this.data instanceof Clob) {
                    Clob clob = (Clob)this.data;
                    long l2 = clob.length();
                    if (l2 > Integer.MAX_VALUE) {
                        System.out.println(BasicUtilities.getString("Clob_TooLarge"));
                        this.view.original = clob.getSubString(0L, 0x7FFFFFFE);
                    } else if (l2 < 0L) {
                        System.out.println(BasicUtilities.getString("Clob_LengthError"));
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1);
                        InputStream inputStream = clob.getAsciiStream();
                        BasicUtilities.copyStream(inputStream, byteArrayOutputStream);
                        this.view.original = byteArrayOutputStream.toString();
                        inputStream.close();
                        byteArrayOutputStream.reset();
                        byteArrayOutputStream.close();
                    } else {
                        this.view.original = clob.getSubString(0L, (int)l2);
                    }
                    this.mdl.setData(this.view.original, "UTF8");
                } else if (this.data instanceof Blob) {
                    Blob blob = (Blob)this.data;
                    long l3 = blob.length();
                    if (l3 > Integer.MAX_VALUE) {
                        System.out.println(BasicUtilities.getString("Blob_TooLarge"));
                        this.mdl.setData(blob.getBytes(0L, 0x7FFFFFFE));
                    } else if (l3 < 0L) {
                        System.out.println(BasicUtilities.getString("Blob_LengthError"));
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1);
                        InputStream inputStream = blob.getBinaryStream();
                        BasicUtilities.copyStream(inputStream, byteArrayOutputStream);
                        this.mdl.setData(byteArrayOutputStream.toByteArray());
                        inputStream.close();
                        byteArrayOutputStream.reset();
                        byteArrayOutputStream.close();
                    } else {
                        this.mdl.setData(blob.getBytes(0L, (int)l3));
                    }
                    this.view.original = this.mdl.toString();
                } else if (this.data instanceof Double) {
                    this.mdl.setData(HexViewTableModel.getDoubleBytes((Double)this.data));
                    this.view.original = this.mdl.toString();
                } else if (this.data instanceof Float) {
                    this.mdl.setData(HexViewTableModel.getFloatBytes((Float)this.data));
                    this.view.original = this.mdl.toString();
                } else if (this.data instanceof Long) {
                    this.mdl.setData(HexViewTableModel.getLongBytes((Long)this.data));
                    this.view.original = this.mdl.toString();
                } else if (this.data instanceof Integer) {
                    this.mdl.setData(HexViewTableModel.getIntBytes((Integer)this.data));
                    this.view.original = this.mdl.toString();
                } else if (this.data instanceof Short) {
                    this.mdl.setData(HexViewTableModel.getShortBytes((Short)this.data));
                } else if (this.data instanceof Date) {
                    this.mdl.setData(HexViewTableModel.getLongBytes(new Long(((Date)this.data).getTime())));
                    this.view.original = this.mdl.toString();
                } else {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
                    XMLEncoder xMLEncoder = new XMLEncoder(byteArrayOutputStream);
                    xMLEncoder.writeObject(this.data);
                    xMLEncoder.flush();
                    byteArrayOutputStream.flush();
                    this.mdl.setData(byteArrayOutputStream.toByteArray());
                    this.view.original = this.mdl.toString();
                    xMLEncoder.close();
                    byteArrayOutputStream.close();
                }
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable, "BinaryRendererProcess::run()");
                return;
            }
        }
    }

    private static class RendererView
    extends JPanel
    implements ActionListener {
        private HexViewTableModel mdlHexView = new HexViewTableModel("");
        private ITable tabHexView = new ITable(this.mdlHexView);
        private JComboBox cmbCharsets = new JComboBox<Object>(Charset.availableCharsets().keySet().toArray());
        private String original = null;
        static /* synthetic */ Class class$java$lang$String;
        static /* synthetic */ Class class$java$lang$Number;

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                this.mdlHexView.setData(this.original, this.cmbCharsets.getSelectedItem().toString());
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable);
            }
        }

        public RendererView() {
            try {
                this.initUI();
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable);
            }
        }

        private void initUI() {
            this.setLayout(new BorderLayout());
            this.cmbCharsets.setSelectedItem(Charset.forName("UTF8").name());
            this.cmbCharsets.addActionListener(this);
            this.cmbCharsets.setMaximumRowCount(6);
            this.cmbCharsets.setLightWeightPopupEnabled(true);
            JPanel jPanel = new JPanel(new GridLayout(1, 3));
            JLabel jLabel = new JLabel(BasicUtilities.getString("Apply_Encoding"), 4);
            jPanel.add(Box.createHorizontalGlue());
            jPanel.add(jLabel);
            jPanel.add(this.cmbCharsets);
            this.add((Component)jPanel, "North");
            this.add((Component)new JScrollPane(this.tabHexView), "Center");
            this.tabHexView.getTableHeader().setReorderingAllowed(false);
            this.tabHexView.getTableHeader().setResizingAllowed(true);
            HexTableCellRenderer hexTableCellRenderer = new HexTableCellRenderer();
            Class<?> clazz = class$java$lang$Number;
            if (clazz == null) {
                clazz = class$java$lang$Number = new Number[0].getClass().getComponentType();
            }
            this.tabHexView.setDefaultRenderer(clazz, hexTableCellRenderer);
            Class<?> clazz2 = class$java$lang$String;
            if (clazz2 == null) {
                clazz2 = class$java$lang$String = new String[0].getClass().getComponentType();
            }
            this.tabHexView.setDefaultRenderer(clazz2, hexTableCellRenderer);
        }
    }
}

