/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.model;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.isqlviewer.core.model.EnhancedTableModel;
import org.isqlviewer.util.BasicUtilities;

public class iSQLTableModel
extends EnhancedTableModel {
    public static final int TYPE_MAP = 0;
    public static final int TYPE_RESULTSET = 1;
    public static final int TYPE_UNKNOWN = 2;
    private boolean isEditable = false;
    private boolean isOptimized = false;
    private int type = 2;

    public iSQLTableModel(ResultSet resultSet) {
        this.setData(resultSet);
    }

    public iSQLTableModel(Map map) {
        this.setData(map);
    }

    public iSQLTableModel() {
    }

    public boolean isCellEditable(int n2, int n3) {
        return this.isEditable;
    }

    public void clearAll() {
        super.clearAll();
        this.isOptimized = false;
        this.type = 2;
    }

    public int getTrueRowCount() {
        if (this.type == 1 && this.isOptimized) {
            return 1;
        }
        return super.getTrueRowCount();
    }

    public int getModelType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(ResultSet resultSet) {
        this.clearAllData();
        this.type = 1;
        iSQLTableModel iSQLTableModel2 = this;
        synchronized (iSQLTableModel2) {
            try {
                int n2;
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n3 = resultSetMetaData.getColumnCount();
                for (n2 = 1; n2 <= n3; ++n2) {
                    try {
                        this.columns.add(resultSetMetaData.getColumnLabel(n2));
                        continue;
                    }
                    catch (Throwable throwable) {
                        this.columns.add(resultSetMetaData.getColumnName(n2));
                    }
                }
                n2 = 1;
                while (resultSet.next()) {
                    ArrayList<String> arrayList = new ArrayList<String>(n3);
                    for (int i2 = 1; i2 <= resultSetMetaData.getColumnCount(); ++i2) {
                        String string = resultSet.getString(i2);
                        arrayList.add(resultSet.wasNull() ? null : string.trim());
                    }
                    this.addRow(arrayList);
                    ++n2;
                }
                resultSetMetaData = null;
                this.optimizeResultSetView();
            }
            catch (Throwable throwable) {
                this.clearAllData();
                BasicUtilities.HandleException(throwable, "iSQLTableModel::setData(ResultSet)", true);
            }
        }
        this.fireTableStructureChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(Map map) {
        this.clearAllData();
        this.type = 0;
        iSQLTableModel iSQLTableModel2 = this;
        synchronized (iSQLTableModel2) {
            this.columns.add(BasicUtilities.getString("Property_Name"));
            this.columns.add(BasicUtilities.getString("Property_Value"));
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Object k2 = iterator.next();
                if (k2 == null) continue;
                ArrayList<String> arrayList = new ArrayList<String>(2);
                String string = new String(k2.toString());
                arrayList.add(string);
                Object v2 = map.get(string);
                arrayList.add(v2 != null ? v2.toString() : null);
                this.addRow(arrayList);
            }
        }
        this.fireTableStructureChanged();
    }

    public Properties getTableAsProperties() {
        Properties properties = new Properties();
        if (this.getColumnCount() >= 2) {
            for (int i2 = 0; i2 < this.getRowCount(); ++i2) {
                try {
                    String string = (String)this.getValueAt(i2, 0);
                    String string2 = (String)this.getValueAt(i2, 1);
                    properties.setProperty(string, string2);
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    continue;
                }
                catch (ClassCastException classCastException) {
                    continue;
                }
                catch (Throwable throwable) {
                    BasicUtilities.HandleException(throwable, "iSQLTableModel::getTableAsProperties()");
                }
            }
        }
        return properties;
    }

    public void allowEditing(boolean bl2) {
        this.isEditable = bl2;
    }

    public boolean optimizeResultSetView() {
        if (this.getRowCount() != 1 || this.getModelType() != 1) {
            return false;
        }
        ArrayList arrayList = (ArrayList)((ArrayList)this.dataStore.get(0)).clone();
        ArrayList arrayList2 = (ArrayList)this.columns.clone();
        this.clearAllData();
        this.isOptimized = true;
        this.type = 1;
        String[] stringArray = new String[]{BasicUtilities.getString("Table_Column_Name"), BasicUtilities.getString("Column_Value")};
        this.setColumns(stringArray);
        Iterator iterator = arrayList2.iterator();
        Iterator iterator2 = arrayList.iterator();
        while (iterator.hasNext()) {
            ArrayList arrayList3 = new ArrayList(2);
            arrayList3.add(iterator.next());
            if (iterator2.hasNext()) {
                arrayList3.add(iterator2.next());
            } else {
                arrayList3.add(null);
            }
            this.addRow(arrayList3);
        }
        iterator = null;
        iterator2 = null;
        arrayList2 = null;
        arrayList = null;
        System.runFinalization();
        return true;
    }
}

