/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.lang.reflect.Array;
import org.garret.perst.impl.FilterIterator;
import org.garret.perst.impl.Node;

class UnaryOpNode
extends Node {
    Node opd;

    public boolean equals(Object object) {
        return object instanceof UnaryOpNode && super.equals(object) && ((UnaryOpNode)object).opd.equals(this.opd);
    }

    Object evaluateObj(FilterIterator filterIterator) {
        Object object = this.opd.evaluateObj(filterIterator);
        switch (this.tag) {
            case 127: {
                return object instanceof Double || object instanceof Float ? (Number)new Double(-((Number)object).doubleValue()) : (Number)new Long(-((Number)object).longValue());
            }
            case 129: {
                if (object instanceof Double || object instanceof Float) {
                    double d2 = ((Number)object).doubleValue();
                    return new Double(d2 < 0.0 ? -d2 : d2);
                }
                long l2 = ((Number)object).longValue();
                return new Long(l2 < 0L ? -l2 : l2);
            }
            case 128: {
                return object instanceof Boolean ? (Comparable<Boolean>)(((Boolean)object).booleanValue() ? Boolean.FALSE : Boolean.TRUE) : (Comparable<Boolean>)new Long(((Number)object).longValue() ^ 0xFFFFFFFFFFFFFFFFL);
            }
        }
        throw new Error("Invalid tag " + this.tag);
    }

    long evaluateInt(FilterIterator filterIterator) {
        switch (this.tag) {
            case 8: {
                return this.opd.evaluateInt(filterIterator) ^ 0xFFFFFFFFFFFFFFFFL;
            }
            case 7: {
                return -this.opd.evaluateInt(filterIterator);
            }
            case 9: {
                long l2 = this.opd.evaluateInt(filterIterator);
                return l2 < 0L ? -l2 : l2;
            }
            case 46: {
                return (long)this.opd.evaluateReal(filterIterator);
            }
            case 138: {
                Object object = this.opd.evaluateObj(filterIterator);
                if (object instanceof String) {
                    return ((String)object).length();
                }
                try {
                    return Array.getLength(object);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new Error("Argument is not array");
                }
            }
            case 61: {
                try {
                    return Array.getLength(this.opd.evaluateObj(filterIterator));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new Error("Argument is not array");
                }
            }
            case 100: {
                return this.opd.evaluateStr(filterIterator).length();
            }
        }
        throw new Error("Invalid tag " + this.tag);
    }

    double evaluateReal(FilterIterator filterIterator) {
        switch (this.tag) {
            case 42: {
                return -this.opd.evaluateReal(filterIterator);
            }
            case 43: {
                double d2 = this.opd.evaluateReal(filterIterator);
                return d2 < 0.0 ? -d2 : d2;
            }
            case 83: {
                return Math.sin(this.opd.evaluateReal(filterIterator));
            }
            case 84: {
                return Math.cos(this.opd.evaluateReal(filterIterator));
            }
            case 85: {
                return Math.tan(this.opd.evaluateReal(filterIterator));
            }
            case 86: {
                return Math.asin(this.opd.evaluateReal(filterIterator));
            }
            case 87: {
                return Math.acos(this.opd.evaluateReal(filterIterator));
            }
            case 88: {
                return Math.atan(this.opd.evaluateReal(filterIterator));
            }
            case 90: {
                return Math.exp(this.opd.evaluateReal(filterIterator));
            }
            case 91: {
                return Math.log(this.opd.evaluateReal(filterIterator));
            }
            case 89: {
                return Math.sqrt(this.opd.evaluateReal(filterIterator));
            }
            case 92: {
                return Math.ceil(this.opd.evaluateReal(filterIterator));
            }
            case 93: {
                return Math.floor(this.opd.evaluateReal(filterIterator));
            }
            case 45: {
                return this.opd.evaluateInt(filterIterator);
            }
        }
        throw new Error("Invalid tag " + this.tag);
    }

    String evaluateStr(FilterIterator filterIterator) {
        switch (this.tag) {
            case 98: {
                return this.opd.evaluateStr(filterIterator).toUpperCase();
            }
            case 97: {
                return this.opd.evaluateStr(filterIterator).toLowerCase();
            }
            case 47: {
                return Long.toString(this.opd.evaluateInt(filterIterator), 10);
            }
            case 48: {
                return Double.toString(this.opd.evaluateReal(filterIterator));
            }
            case 140: {
                return this.opd.evaluateObj(filterIterator).toString();
            }
        }
        throw new Error("Invalid tag " + this.tag);
    }

    boolean evaluateBool(FilterIterator filterIterator) {
        switch (this.tag) {
            case 96: {
                return !this.opd.evaluateBool(filterIterator);
            }
            case 49: {
                return this.opd.evaluateObj(filterIterator) == null;
            }
        }
        throw new Error("Invalid tag " + this.tag);
    }

    UnaryOpNode(int n2, int n3, Node node) {
        super(n2, n3);
        this.opd = node;
    }
}

