/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.garret.perst.IPersistent;
import org.garret.perst.PersistentIterator;
import org.garret.perst.PersistentResource;
import org.garret.perst.RectangleR2;
import org.garret.perst.SpatialIndexR2;
import org.garret.perst.Storage;
import org.garret.perst.StorageError;
import org.garret.perst.impl.QueryImpl;
import org.garret.perst.impl.RtreeR2Page;

public class RtreeR2
extends PersistentResource
implements SpatialIndexR2 {
    private int height;
    private int n;
    private RtreeR2Page root;
    private transient int updateCounter;

    RtreeR2() {
    }

    RtreeR2(Storage storage) {
        super(storage);
    }

    public void put(RectangleR2 rectangleR2, IPersistent iPersistent) {
        if (this.root == null) {
            this.root = new RtreeR2Page(this.getStorage(), iPersistent, rectangleR2);
            this.height = 1;
        } else {
            RtreeR2Page rtreeR2Page = this.root.insert(this.getStorage(), rectangleR2, iPersistent, this.height);
            if (rtreeR2Page != null) {
                this.root = new RtreeR2Page(this.getStorage(), this.root, rtreeR2Page);
                ++this.height;
            }
        }
        ++this.n;
        ++this.updateCounter;
        this.modify();
    }

    public int size() {
        return this.n;
    }

    public void remove(RectangleR2 rectangleR2, IPersistent iPersistent) {
        if (this.root == null) {
            throw new StorageError(5);
        }
        ArrayList arrayList = new ArrayList();
        int n2 = this.root.remove(rectangleR2, iPersistent, this.height, arrayList);
        if (n2 < 0) {
            throw new StorageError(5);
        }
        int n3 = arrayList.size();
        while (--n3 >= 0) {
            RtreeR2Page rtreeR2Page = (RtreeR2Page)arrayList.get(n3);
            int n4 = rtreeR2Page.n;
            for (int i2 = 0; i2 < n4; ++i2) {
                RtreeR2Page rtreeR2Page2 = this.root.insert(this.getStorage(), rtreeR2Page.b[i2], rtreeR2Page.branch.get(i2), this.height - n2);
                if (rtreeR2Page2 == null) continue;
                this.root = new RtreeR2Page(this.getStorage(), this.root, rtreeR2Page2);
                ++this.height;
            }
            --n2;
            rtreeR2Page.deallocate();
        }
        if (this.root.n == 1 && this.height > 1) {
            RtreeR2Page rtreeR2Page = (RtreeR2Page)this.root.branch.get(0);
            this.root.deallocate();
            this.root = rtreeR2Page;
            --this.height;
        }
        --this.n;
        ++this.updateCounter;
        this.modify();
    }

    public IPersistent[] get(RectangleR2 rectangleR2) {
        ArrayList arrayList = new ArrayList();
        if (this.root != null) {
            this.root.find(rectangleR2, arrayList, this.height);
        }
        return arrayList.toArray(new IPersistent[arrayList.size()]);
    }

    public ArrayList getList(RectangleR2 rectangleR2) {
        ArrayList arrayList = new ArrayList();
        if (this.root != null) {
            this.root.find(rectangleR2, arrayList, this.height);
        }
        return arrayList;
    }

    public IPersistent[] toArray() {
        return this.get(this.getWrappingRectangle());
    }

    public IPersistent[] toArray(IPersistent[] iPersistentArray) {
        return this.getList(this.getWrappingRectangle()).toArray(iPersistentArray);
    }

    public RectangleR2 getWrappingRectangle() {
        if (this.root != null) {
            return this.root.cover();
        }
        return null;
    }

    public void clear() {
        if (this.root != null) {
            this.root.purge(this.height);
            this.root = null;
        }
        this.height = 0;
        this.n = 0;
        ++this.updateCounter;
        this.modify();
    }

    public void deallocate() {
        this.clear();
        super.deallocate();
    }

    public Iterator iterator() {
        return this.iterator(this.getWrappingRectangle());
    }

    public Iterator entryIterator() {
        return this.entryIterator(this.getWrappingRectangle());
    }

    public Iterator iterator(RectangleR2 rectangleR2) {
        return new RtreeIterator(rectangleR2);
    }

    public Iterator entryIterator(RectangleR2 rectangleR2) {
        return new RtreeEntryIterator(rectangleR2);
    }

    public Iterator select(Class clazz, String string) {
        QueryImpl queryImpl = new QueryImpl(this.getStorage());
        return queryImpl.select(clazz, this.iterator(), string);
    }

    class RtreeEntryIterator
    extends RtreeIterator {
        RtreeEntryIterator(RectangleR2 rectangleR2) {
            super(rectangleR2);
        }

        protected Object current(int n2) {
            return new RtreeEntry(this.pageStack[n2], this.posStack[n2]);
        }
    }

    static class RtreeEntry
    implements Map.Entry {
        RtreeR2Page pg;
        int pos;

        public Object getKey() {
            return this.pg.b[this.pos];
        }

        public Object getValue() {
            return this.pg.branch.get(this.pos);
        }

        public Object setValue(Object object) {
            throw new UnsupportedOperationException();
        }

        RtreeEntry(RtreeR2Page rtreeR2Page, int n2) {
            this.pg = rtreeR2Page;
            this.pos = n2;
        }
    }

    class RtreeIterator
    implements PersistentIterator {
        RtreeR2Page[] pageStack;
        int[] posStack;
        int counter;
        RectangleR2 r;

        RtreeIterator(RectangleR2 rectangleR2) {
            this.counter = RtreeR2.this.updateCounter;
            if (RtreeR2.this.height == 0) {
                return;
            }
            this.r = rectangleR2;
            this.pageStack = new RtreeR2Page[RtreeR2.this.height];
            this.posStack = new int[RtreeR2.this.height];
            if (!this.gotoFirstItem(0, RtreeR2.this.root)) {
                this.pageStack = null;
                this.posStack = null;
            }
        }

        public boolean hasNext() {
            if (this.counter != RtreeR2.this.updateCounter) {
                throw new ConcurrentModificationException();
            }
            return this.pageStack != null;
        }

        protected Object current(int n2) {
            return this.pageStack[n2].branch.get(this.posStack[n2]);
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object object = this.current(RtreeR2.this.height - 1);
            if (!this.gotoNextItem(RtreeR2.this.height - 1)) {
                this.pageStack = null;
                this.posStack = null;
            }
            return object;
        }

        public int nextOid() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int n2 = this.pageStack[((RtreeR2)RtreeR2.this).height - 1].branch.getRaw(this.posStack[RtreeR2.this.height - 1]).getOid();
            if (!this.gotoNextItem(RtreeR2.this.height - 1)) {
                this.pageStack = null;
                this.posStack = null;
            }
            return n2;
        }

        private boolean gotoFirstItem(int n2, RtreeR2Page rtreeR2Page) {
            int n3 = rtreeR2Page.n;
            for (int i2 = 0; i2 < n3; ++i2) {
                if (!this.r.intersects(rtreeR2Page.b[i2]) || n2 + 1 != RtreeR2.this.height && !this.gotoFirstItem(n2 + 1, (RtreeR2Page)rtreeR2Page.branch.get(i2))) continue;
                this.pageStack[n2] = rtreeR2Page;
                this.posStack[n2] = i2;
                return true;
            }
            return false;
        }

        private boolean gotoNextItem(int n2) {
            RtreeR2Page rtreeR2Page = this.pageStack[n2];
            int n3 = this.posStack[n2];
            int n4 = rtreeR2Page.n;
            while (++n3 < n4) {
                if (!this.r.intersects(rtreeR2Page.b[n3]) || n2 + 1 != RtreeR2.this.height && !this.gotoFirstItem(n2 + 1, (RtreeR2Page)rtreeR2Page.branch.get(n3))) continue;
                this.pageStack[n2] = rtreeR2Page;
                this.posStack[n2] = n3;
                return true;
            }
            this.pageStack[n2] = null;
            return n2 > 0 ? this.gotoNextItem(n2 - 1) : false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

