/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.garret.perst.IPersistent;
import org.garret.perst.PersistentIterator;
import org.garret.perst.PersistentResource;
import org.garret.perst.Rectangle;
import org.garret.perst.SpatialIndex;
import org.garret.perst.StorageError;
import org.garret.perst.impl.QueryImpl;
import org.garret.perst.impl.RtreePage;

public class Rtree
extends PersistentResource
implements SpatialIndex {
    private int height;
    private int n;
    private RtreePage root;
    private transient int updateCounter;

    Rtree() {
    }

    public void put(Rectangle rectangle, IPersistent iPersistent) {
        if (this.root == null) {
            this.root = new RtreePage(this.getStorage(), iPersistent, rectangle);
            this.height = 1;
        } else {
            RtreePage rtreePage = this.root.insert(this.getStorage(), rectangle, iPersistent, this.height);
            if (rtreePage != null) {
                this.root = new RtreePage(this.getStorage(), this.root, rtreePage);
                ++this.height;
            }
        }
        ++this.updateCounter;
        ++this.n;
        this.modify();
    }

    public int size() {
        return this.n;
    }

    public void remove(Rectangle rectangle, IPersistent iPersistent) {
        if (this.root == null) {
            throw new StorageError(5);
        }
        ArrayList arrayList = new ArrayList();
        int n2 = this.root.remove(rectangle, iPersistent, this.height, arrayList);
        if (n2 < 0) {
            throw new StorageError(5);
        }
        int n3 = arrayList.size();
        while (--n3 >= 0) {
            RtreePage rtreePage = (RtreePage)arrayList.get(n3);
            int n4 = rtreePage.n;
            for (int i2 = 0; i2 < n4; ++i2) {
                RtreePage rtreePage2 = this.root.insert(this.getStorage(), rtreePage.b[i2], rtreePage.branch.get(i2), this.height - n2);
                if (rtreePage2 == null) continue;
                this.root = new RtreePage(this.getStorage(), this.root, rtreePage2);
                ++this.height;
            }
            --n2;
            rtreePage.deallocate();
        }
        if (this.root.n == 1 && this.height > 1) {
            RtreePage rtreePage = (RtreePage)this.root.branch.get(0);
            this.root.deallocate();
            this.root = rtreePage;
            --this.height;
        }
        --this.n;
        ++this.updateCounter;
        this.modify();
    }

    public IPersistent[] get(Rectangle rectangle) {
        ArrayList arrayList = this.getList(rectangle);
        return arrayList.toArray(new IPersistent[arrayList.size()]);
    }

    public ArrayList getList(Rectangle rectangle) {
        ArrayList arrayList = new ArrayList();
        if (this.root != null) {
            this.root.find(rectangle, arrayList, this.height);
        }
        return arrayList;
    }

    public IPersistent[] toArray() {
        return this.get(this.getWrappingRectangle());
    }

    public IPersistent[] toArray(IPersistent[] iPersistentArray) {
        return this.getList(this.getWrappingRectangle()).toArray(iPersistentArray);
    }

    public Rectangle getWrappingRectangle() {
        if (this.root != null) {
            return this.root.cover();
        }
        return null;
    }

    public void clear() {
        if (this.root != null) {
            this.root.purge(this.height);
            this.root = null;
        }
        this.height = 0;
        this.n = 0;
        this.modify();
    }

    public void deallocate() {
        this.clear();
        super.deallocate();
    }

    public Iterator iterator() {
        return this.iterator(this.getWrappingRectangle());
    }

    public Iterator entryIterator() {
        return this.entryIterator(this.getWrappingRectangle());
    }

    public Iterator iterator(Rectangle rectangle) {
        return new RtreeIterator(rectangle);
    }

    public Iterator entryIterator(Rectangle rectangle) {
        return new RtreeEntryIterator(rectangle);
    }

    public Iterator select(Class clazz, String string) {
        QueryImpl queryImpl = new QueryImpl(this.getStorage());
        return queryImpl.select(clazz, this.iterator(), string);
    }

    class RtreeEntryIterator
    extends RtreeIterator {
        RtreeEntryIterator(Rectangle rectangle) {
            super(rectangle);
        }

        protected Object current(int n2) {
            return new RtreeEntry(this.pageStack[n2], this.posStack[n2]);
        }
    }

    static class RtreeEntry
    implements Map.Entry {
        RtreePage pg;
        int pos;

        public Object getKey() {
            return this.pg.b[this.pos];
        }

        public Object getValue() {
            return this.pg.branch.get(this.pos);
        }

        public Object setValue(Object object) {
            throw new UnsupportedOperationException();
        }

        RtreeEntry(RtreePage rtreePage, int n2) {
            this.pg = rtreePage;
            this.pos = n2;
        }
    }

    class RtreeIterator
    implements PersistentIterator {
        RtreePage[] pageStack;
        int[] posStack;
        int counter;
        Rectangle r;

        RtreeIterator(Rectangle rectangle) {
            this.counter = Rtree.this.updateCounter;
            if (Rtree.this.height == 0) {
                return;
            }
            this.r = rectangle;
            this.pageStack = new RtreePage[Rtree.this.height];
            this.posStack = new int[Rtree.this.height];
            if (!this.gotoFirstItem(0, Rtree.this.root)) {
                this.pageStack = null;
                this.posStack = null;
            }
        }

        public boolean hasNext() {
            if (this.counter != Rtree.this.updateCounter) {
                throw new ConcurrentModificationException();
            }
            return this.pageStack != null;
        }

        protected Object current(int n2) {
            return this.pageStack[n2].branch.get(this.posStack[n2]);
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object object = this.current(Rtree.this.height - 1);
            if (!this.gotoNextItem(Rtree.this.height - 1)) {
                this.pageStack = null;
                this.posStack = null;
            }
            return object;
        }

        public int nextOid() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int n2 = this.pageStack[((Rtree)Rtree.this).height - 1].branch.getRaw(this.posStack[Rtree.this.height - 1]).getOid();
            if (!this.gotoNextItem(Rtree.this.height - 1)) {
                this.pageStack = null;
                this.posStack = null;
            }
            return n2;
        }

        private boolean gotoFirstItem(int n2, RtreePage rtreePage) {
            int n3 = rtreePage.n;
            for (int i2 = 0; i2 < n3; ++i2) {
                if (!this.r.intersects(rtreePage.b[i2]) || n2 + 1 != Rtree.this.height && !this.gotoFirstItem(n2 + 1, (RtreePage)rtreePage.branch.get(i2))) continue;
                this.pageStack[n2] = rtreePage;
                this.posStack[n2] = i2;
                return true;
            }
            return false;
        }

        private boolean gotoNextItem(int n2) {
            RtreePage rtreePage = this.pageStack[n2];
            int n3 = this.posStack[n2];
            int n4 = rtreePage.n;
            while (++n3 < n4) {
                if (!this.r.intersects(rtreePage.b[n3]) || n2 + 1 != Rtree.this.height && !this.gotoFirstItem(n2 + 1, (RtreePage)rtreePage.branch.get(n3))) continue;
                this.pageStack[n2] = rtreePage;
                this.posStack[n2] = n3;
                return true;
            }
            this.pageStack[n2] = null;
            return n2 > 0 ? this.gotoNextItem(n2 - 1) : false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

