/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.garret.perst.Assert;
import org.garret.perst.IPersistent;
import org.garret.perst.Index;
import org.garret.perst.Key;
import org.garret.perst.PersistentIterator;
import org.garret.perst.PersistentResource;
import org.garret.perst.StorageError;
import org.garret.perst.impl.BtreeKey;
import org.garret.perst.impl.BtreePage;
import org.garret.perst.impl.Bytes;
import org.garret.perst.impl.ClassDescriptor;
import org.garret.perst.impl.Page;
import org.garret.perst.impl.QueryImpl;
import org.garret.perst.impl.StorageImpl;
import org.garret.perst.impl.XMLExporter;

class Btree
extends PersistentResource
implements Index {
    int root;
    int height;
    int type;
    int nElems;
    boolean unique;
    transient int updateCounter;
    static final int sizeof = 25;
    static final int op_done = 0;
    static final int op_overflow = 1;
    static final int op_underflow = 2;
    static final int op_not_found = 3;
    static final int op_duplicate = 4;
    static final int op_overwrite = 5;
    static final IPersistent[] emptySelection = new IPersistent[0];
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$org$garret$perst$IPersistent;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$Comparable;

    Btree() {
    }

    static int checkType(Class clazz) {
        int n2 = ClassDescriptor.getTypeCode(clazz);
        if (n2 > 10 && n2 != 21) {
            throw new StorageError(8, clazz);
        }
        return n2;
    }

    int compareByteArrays(byte[] byArray, byte[] byArray2, int n2, int n3) {
        int n4 = byArray.length >= n3 ? n3 : byArray.length;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = byArray[i2] - byArray2[i2 + n2];
            if (n5 == 0) continue;
            return n5;
        }
        return byArray.length - n3;
    }

    Btree(Class clazz, boolean bl2) {
        this.unique = bl2;
        this.type = Btree.checkType(clazz);
    }

    Btree(int n2, boolean bl2) {
        this.type = n2;
        this.unique = bl2;
    }

    Btree(byte[] byArray, int n2) {
        this.root = Bytes.unpack4(byArray, n2);
        this.height = Bytes.unpack4(byArray, n2 += 4);
        this.type = Bytes.unpack4(byArray, n2 += 4);
        this.nElems = Bytes.unpack4(byArray, n2 += 4);
        this.unique = byArray[n2 += 4] != 0;
    }

    public Class[] getKeyTypes() {
        return new Class[]{this.getKeyType()};
    }

    public Class getKeyType() {
        return Btree.mapKeyType(this.type);
    }

    static Class mapKeyType(int n2) {
        switch (n2) {
            case 0: {
                return Boolean.TYPE;
            }
            case 1: {
                return Byte.TYPE;
            }
            case 2: {
                return Character.TYPE;
            }
            case 3: {
                return Short.TYPE;
            }
            case 4: {
                return Integer.TYPE;
            }
            case 5: {
                return Long.TYPE;
            }
            case 6: {
                return Float.TYPE;
            }
            case 7: {
                return Double.TYPE;
            }
            case 8: {
                return class$java$lang$String == null ? (class$java$lang$String = Btree.class$("java.lang.String")) : class$java$lang$String;
            }
            case 9: {
                return class$java$util$Date == null ? (class$java$util$Date = Btree.class$("java.util.Date")) : class$java$util$Date;
            }
            case 10: {
                return class$org$garret$perst$IPersistent == null ? (class$org$garret$perst$IPersistent = Btree.class$("org.garret.perst.IPersistent")) : class$org$garret$perst$IPersistent;
            }
            case 21: {
                return array$B == null ? (array$B = Btree.class$("[B")) : array$B;
            }
        }
        return class$java$lang$Comparable == null ? (class$java$lang$Comparable = Btree.class$("java.lang.Comparable")) : class$java$lang$Comparable;
    }

    Key checkKey(Key key) {
        if (key != null) {
            if (key.type != this.type) {
                throw new StorageError(9);
            }
            if (this.type == 10 && key.ival == 0 && key.oval != null) {
                IPersistent iPersistent = (IPersistent)key.oval;
                this.getStorage().makePersistent(iPersistent);
                key = new Key(iPersistent, key.inclusion != 0);
            }
            if (key.oval instanceof String) {
                key = new Key(((String)key.oval).toCharArray(), key.inclusion != 0);
            }
        }
        return key;
    }

    public IPersistent get(Key key) {
        key = this.checkKey(key);
        if (this.root != 0) {
            ArrayList arrayList = new ArrayList();
            BtreePage.find((StorageImpl)this.getStorage(), this.root, key, key, this, this.height, arrayList);
            if (arrayList.size() > 1) {
                throw new StorageError(4);
            }
            if (arrayList.size() == 0) {
                return null;
            }
            return (IPersistent)arrayList.get(0);
        }
        return null;
    }

    public IPersistent[] prefixSearch(String string) {
        if (8 != this.type) {
            throw new StorageError(9);
        }
        if (this.root != 0) {
            ArrayList arrayList = new ArrayList();
            BtreePage.prefixSearch((StorageImpl)this.getStorage(), this.root, string.toCharArray(), this.height, arrayList);
            if (arrayList.size() != 0) {
                return arrayList.toArray(new IPersistent[arrayList.size()]);
            }
        }
        return emptySelection;
    }

    public IPersistent[] get(Key key, Key key2) {
        if (this.root != 0) {
            ArrayList arrayList = new ArrayList();
            BtreePage.find((StorageImpl)this.getStorage(), this.root, this.checkKey(key), this.checkKey(key2), this, this.height, arrayList);
            if (arrayList.size() != 0) {
                return arrayList.toArray(new IPersistent[arrayList.size()]);
            }
        }
        return emptySelection;
    }

    public boolean put(Key key, IPersistent iPersistent) {
        return this.insert(key, iPersistent, false) >= 0;
    }

    public IPersistent set(Key key, IPersistent iPersistent) {
        int n2 = this.insert(key, iPersistent, true);
        return n2 != 0 ? ((StorageImpl)this.getStorage()).lookupObject(n2, null) : null;
    }

    final int insert(Key key, IPersistent iPersistent, boolean bl2) {
        StorageImpl storageImpl = (StorageImpl)this.getStorage();
        if (storageImpl == null) {
            throw new StorageError(16);
        }
        key = this.checkKey(key);
        if (!iPersistent.isPersistent()) {
            storageImpl.makePersistent(iPersistent);
        }
        BtreeKey btreeKey = new BtreeKey(key, iPersistent.getOid());
        if (this.root == 0) {
            this.root = BtreePage.allocate(storageImpl, 0, this.type, btreeKey);
            this.height = 1;
        } else {
            int n2 = BtreePage.insert(storageImpl, this.root, this, btreeKey, this.height, this.unique, bl2);
            if (n2 == 1) {
                this.root = BtreePage.allocate(storageImpl, this.root, this.type, btreeKey);
                ++this.height;
            } else {
                if (n2 == 4) {
                    return -1;
                }
                if (n2 == 5) {
                    return btreeKey.oldOid;
                }
            }
        }
        ++this.updateCounter;
        ++this.nElems;
        this.modify();
        return 0;
    }

    public void remove(Key key, IPersistent iPersistent) {
        this.remove(new BtreeKey(this.checkKey(key), iPersistent.getOid()));
    }

    void remove(BtreeKey btreeKey) {
        if (!this.removeIfExists(btreeKey)) {
            throw new StorageError(5);
        }
    }

    boolean removeIfExists(BtreeKey btreeKey) {
        StorageImpl storageImpl = (StorageImpl)this.getStorage();
        if (storageImpl == null) {
            throw new StorageError(16);
        }
        if (this.root == 0) {
            return false;
        }
        int n2 = BtreePage.remove(storageImpl, this.root, this, btreeKey, this.height);
        if (n2 == 3) {
            return false;
        }
        --this.nElems;
        if (n2 == 2) {
            Page page = storageImpl.getPage(this.root);
            if (BtreePage.getnItems(page) == 0) {
                int n3 = 0;
                if (this.height != 1) {
                    n3 = this.type == 8 || this.type == 21 ? BtreePage.getKeyStrOid(page, 0) : BtreePage.getReference(page, 1022);
                }
                storageImpl.freePage(this.root);
                this.root = n3;
                --this.height;
            }
            storageImpl.pool.unfix(page);
        } else if (n2 == 1) {
            this.root = BtreePage.allocate(storageImpl, this.root, this.type, btreeKey);
            ++this.height;
        }
        ++this.updateCounter;
        this.modify();
        return true;
    }

    public IPersistent remove(Key key) {
        if (!this.unique) {
            throw new StorageError(4);
        }
        BtreeKey btreeKey = new BtreeKey(this.checkKey(key), 0);
        StorageImpl storageImpl = (StorageImpl)this.getStorage();
        this.remove(btreeKey);
        return storageImpl.lookupObject(btreeKey.oldOid, null);
    }

    public IPersistent get(String string) {
        return this.get(new Key(string.toCharArray(), true));
    }

    public IPersistent[] getPrefix(String string) {
        return this.get(new Key(string.toCharArray(), true), new Key((string + '\uffff').toCharArray(), false));
    }

    public boolean put(String string, IPersistent iPersistent) {
        return this.put(new Key(string.toCharArray(), true), iPersistent);
    }

    public IPersistent set(String string, IPersistent iPersistent) {
        return this.set(new Key(string.toCharArray(), true), iPersistent);
    }

    public void remove(String string, IPersistent iPersistent) {
        this.remove(new Key(string.toCharArray(), true), iPersistent);
    }

    public IPersistent remove(String string) {
        return this.remove(new Key(string.toCharArray(), true));
    }

    public int size() {
        return this.nElems;
    }

    public void clear() {
        if (this.root != 0) {
            BtreePage.purge((StorageImpl)this.getStorage(), this.root, this.type, this.height);
            this.root = 0;
            this.nElems = 0;
            this.height = 0;
            ++this.updateCounter;
            this.modify();
        }
    }

    public IPersistent[] toPersistentArray() {
        IPersistent[] iPersistentArray = new IPersistent[this.nElems];
        if (this.root != 0) {
            BtreePage.traverseForward((StorageImpl)this.getStorage(), this.root, this.type, this.height, iPersistentArray, 0);
        }
        return iPersistentArray;
    }

    public IPersistent[] toPersistentArray(IPersistent[] iPersistentArray) {
        if (iPersistentArray.length < this.nElems) {
            iPersistentArray = (IPersistent[])Array.newInstance(iPersistentArray.getClass().getComponentType(), this.nElems);
        }
        if (this.root != 0) {
            BtreePage.traverseForward((StorageImpl)this.getStorage(), this.root, this.type, this.height, iPersistentArray, 0);
        }
        if (iPersistentArray.length > this.nElems) {
            iPersistentArray[this.nElems] = null;
        }
        return iPersistentArray;
    }

    public void deallocate() {
        if (this.root != 0) {
            BtreePage.purge((StorageImpl)this.getStorage(), this.root, this.type, this.height);
        }
        super.deallocate();
    }

    public int markTree() {
        if (this.root != 0) {
            return BtreePage.markPage((StorageImpl)this.getStorage(), this.root, this.type, this.height);
        }
        return 0;
    }

    public void export(XMLExporter xMLExporter) throws IOException {
        if (this.root != 0) {
            BtreePage.exportPage((StorageImpl)this.getStorage(), xMLExporter, this.root, this.type, this.height);
        }
    }

    Object unpackKey(StorageImpl storageImpl, Page page, int n2) {
        byte[] byArray = page.data;
        int n3 = 4 + n2 * ClassDescriptor.sizeof[this.type];
        switch (this.type) {
            case 0: {
                return byArray[n3] != 0;
            }
            case 1: {
                return new Byte(byArray[n3]);
            }
            case 3: {
                return new Short(Bytes.unpack2(byArray, n3));
            }
            case 2: {
                return new Character((char)Bytes.unpack2(byArray, n3));
            }
            case 4: {
                return new Integer(Bytes.unpack4(byArray, n3));
            }
            case 10: {
                return storageImpl.lookupObject(Bytes.unpack4(byArray, n3), null);
            }
            case 5: {
                return new Long(Bytes.unpack8(byArray, n3));
            }
            case 9: {
                return new Date(Bytes.unpack8(byArray, n3));
            }
            case 6: {
                return new Float(Float.intBitsToFloat(Bytes.unpack4(byArray, n3)));
            }
            case 7: {
                return new Double(Double.longBitsToDouble(Bytes.unpack8(byArray, n3)));
            }
            case 8: {
                return Btree.unpackStrKey(page, n2);
            }
            case 21: {
                return this.unpackByteArrayKey(page, n2);
            }
        }
        Assert.failed("Invalid type");
        return null;
    }

    static String unpackStrKey(Page page, int n2) {
        int n3 = BtreePage.getKeyStrSize(page, n2);
        int n4 = 4 + BtreePage.getKeyStrOffs(page, n2);
        byte[] byArray = page.data;
        char[] cArray = new char[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            cArray[i2] = (char)Bytes.unpack2(byArray, n4);
            n4 += 2;
        }
        return new String(cArray);
    }

    Object unpackByteArrayKey(Page page, int n2) {
        int n3 = BtreePage.getKeyStrSize(page, n2);
        int n4 = 4 + BtreePage.getKeyStrOffs(page, n2);
        byte[] byArray = new byte[n3];
        System.arraycopy(page.data, n4, byArray, 0, n3);
        return byArray;
    }

    public Iterator iterator() {
        return this.iterator(null, null, 0);
    }

    public Iterator entryIterator() {
        return this.entryIterator(null, null, 0);
    }

    final int compareByteArrays(Key key, Page page, int n2) {
        return this.compareByteArrays((byte[])key.oval, page.data, BtreePage.getKeyStrOffs(page, n2) + 4, BtreePage.getKeyStrSize(page, n2));
    }

    public Iterator iterator(Key key, Key key2, int n2) {
        return new BtreeSelectionIterator(this.checkKey(key), this.checkKey(key2), n2);
    }

    public Iterator prefixIterator(String string) {
        return this.iterator(new Key(string.toCharArray()), new Key((string + '\uffff').toCharArray(), false), 0);
    }

    public Iterator entryIterator(Key key, Key key2, int n2) {
        return new BtreeSelectionEntryIterator(this.checkKey(key), this.checkKey(key2), n2);
    }

    public Iterator select(Class clazz, String string) {
        QueryImpl queryImpl = new QueryImpl(this.getStorage());
        return queryImpl.select(clazz, this.iterator(), string);
    }

    public Object getAt(int n2) {
        Iterator iterator;
        if (n2 < 0 || n2 >= this.nElems) {
            throw new IndexOutOfBoundsException("Position " + n2 + ", index size " + this.nElems);
        }
        if (n2 <= this.nElems / 2) {
            iterator = this.entryIterator(null, null, 0);
            while (--n2 >= 0) {
                iterator.next();
            }
        } else {
            iterator = this.entryIterator(null, null, 1);
            n2 -= this.nElems;
            while (++n2 < 0) {
                iterator.next();
            }
        }
        return ((Map.Entry)iterator.next()).getValue();
    }

    public Iterator entryIterator(int n2, int n3) {
        return new BtreeEntryStartFromIterator(n2, n3);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class BtreeEntryStartFromIterator
    extends BtreeSelectionEntryIterator {
        int start;

        BtreeEntryStartFromIterator(int n2, int n3) {
            super(null, null, n3);
            this.start = n2;
            this.reset();
        }

        void reset() {
            int n2;
            super.reset();
            int n3 = n2 = this.order == 0 ? this.start : Btree.this.nElems - this.start - 1;
            while (--n2 >= 0 && this.hasNext()) {
                this.next();
            }
        }
    }

    class BtreeSelectionEntryIterator
    extends BtreeSelectionIterator {
        BtreeSelectionEntryIterator(Key key, Key key2, int n2) {
            super(key, key2, n2);
        }

        protected Object getCurrent(Page page, int n2) {
            StorageImpl storageImpl = (StorageImpl)Btree.this.getStorage();
            switch (Btree.this.type) {
                case 8: {
                    return new BtreeEntry(storageImpl, Btree.unpackStrKey(page, n2), BtreePage.getKeyStrOid(page, n2));
                }
                case 21: {
                    return new BtreeEntry(storageImpl, Btree.this.unpackByteArrayKey(page, n2), BtreePage.getKeyStrOid(page, n2));
                }
            }
            return new BtreeEntry(storageImpl, Btree.this.unpackKey(storageImpl, page, n2), BtreePage.getReference(page, 1022 - n2));
        }
    }

    class BtreeSelectionIterator
    implements PersistentIterator {
        int[] pageStack;
        int[] posStack;
        int currPage;
        int currPos;
        int sp;
        int end;
        Key from;
        Key till;
        int order;
        int counter;
        BtreeKey nextKey;
        BtreeKey currKey;

        BtreeSelectionIterator(Key key, Key key2, int n2) {
            this.from = key;
            this.till = key2;
            this.order = n2;
            this.reset();
        }

        void reset() {
            this.sp = 0;
            this.counter = Btree.this.updateCounter;
            if (Btree.this.height == 0) {
                return;
            }
            int n2 = Btree.this.root;
            StorageImpl storageImpl = (StorageImpl)Btree.this.getStorage();
            if (storageImpl == null) {
                throw new StorageError(16);
            }
            int n3 = Btree.this.height;
            this.pageStack = new int[n3];
            this.posStack = new int[n3];
            if (Btree.this.type == 8) {
                if (this.order == 0) {
                    Page page;
                    if (this.from == null) {
                        while (--n3 >= 0) {
                            this.posStack[this.sp] = 0;
                            this.pageStack[this.sp] = n2;
                            page = storageImpl.getPage(n2);
                            n2 = BtreePage.getKeyStrOid(page, 0);
                            this.end = BtreePage.getnItems(page);
                            storageImpl.pool.unfix(page);
                            ++this.sp;
                        }
                    } else {
                        int n4;
                        int n5;
                        int n6;
                        while (--n3 > 0) {
                            this.pageStack[this.sp] = n2;
                            page = storageImpl.getPage(n2);
                            n6 = 0;
                            n5 = BtreePage.getnItems(page);
                            while (n6 < n5) {
                                n4 = n6 + n5 >> 1;
                                if (BtreePage.compareStr(this.from, page, n4) >= this.from.inclusion) {
                                    n6 = n4 + 1;
                                    continue;
                                }
                                n5 = n4;
                            }
                            Assert.that(n5 == n6);
                            this.posStack[this.sp] = n5;
                            n2 = BtreePage.getKeyStrOid(page, n5);
                            storageImpl.pool.unfix(page);
                            ++this.sp;
                        }
                        this.pageStack[this.sp] = n2;
                        page = storageImpl.getPage(n2);
                        n6 = 0;
                        this.end = n5 = BtreePage.getnItems(page);
                        while (n6 < n5) {
                            n4 = n6 + n5 >> 1;
                            if (BtreePage.compareStr(this.from, page, n4) >= this.from.inclusion) {
                                n6 = n4 + 1;
                                continue;
                            }
                            n5 = n4;
                        }
                        Assert.that(n5 == n6);
                        if (n5 == this.end) {
                            ++this.sp;
                            this.gotoNextItem(page, n5 - 1);
                        } else {
                            this.posStack[this.sp++] = n5;
                            storageImpl.pool.unfix(page);
                        }
                    }
                    if (this.sp != 0 && this.till != null) {
                        page = storageImpl.getPage(this.pageStack[this.sp - 1]);
                        if (-BtreePage.compareStr(this.till, page, this.posStack[this.sp - 1]) >= this.till.inclusion) {
                            this.sp = 0;
                        }
                        storageImpl.pool.unfix(page);
                    }
                } else {
                    Page page;
                    if (this.till == null) {
                        while (--n3 > 0) {
                            this.pageStack[this.sp] = n2;
                            page = storageImpl.getPage(n2);
                            this.posStack[this.sp] = BtreePage.getnItems(page);
                            n2 = BtreePage.getKeyStrOid(page, this.posStack[this.sp]);
                            storageImpl.pool.unfix(page);
                            ++this.sp;
                        }
                        this.pageStack[this.sp] = n2;
                        page = storageImpl.getPage(n2);
                        this.posStack[this.sp++] = BtreePage.getnItems(page) - 1;
                        storageImpl.pool.unfix(page);
                    } else {
                        int n7;
                        int n8;
                        int n9;
                        while (--n3 > 0) {
                            this.pageStack[this.sp] = n2;
                            page = storageImpl.getPage(n2);
                            n9 = 0;
                            n8 = BtreePage.getnItems(page);
                            while (n9 < n8) {
                                n7 = n9 + n8 >> 1;
                                if (BtreePage.compareStr(this.till, page, n7) >= 1 - this.till.inclusion) {
                                    n9 = n7 + 1;
                                    continue;
                                }
                                n8 = n7;
                            }
                            Assert.that(n8 == n9);
                            this.posStack[this.sp] = n8;
                            n2 = BtreePage.getKeyStrOid(page, n8);
                            storageImpl.pool.unfix(page);
                            ++this.sp;
                        }
                        this.pageStack[this.sp] = n2;
                        page = storageImpl.getPage(n2);
                        n9 = 0;
                        n8 = BtreePage.getnItems(page);
                        while (n9 < n8) {
                            n7 = n9 + n8 >> 1;
                            if (BtreePage.compareStr(this.till, page, n7) >= 1 - this.till.inclusion) {
                                n9 = n7 + 1;
                                continue;
                            }
                            n8 = n7;
                        }
                        Assert.that(n8 == n9);
                        if (n8 == 0) {
                            ++this.sp;
                            this.gotoNextItem(page, n8);
                        } else {
                            this.posStack[this.sp++] = n8 - 1;
                            storageImpl.pool.unfix(page);
                        }
                    }
                    if (this.sp != 0 && this.from != null) {
                        page = storageImpl.getPage(this.pageStack[this.sp - 1]);
                        if (BtreePage.compareStr(this.from, page, this.posStack[this.sp - 1]) >= this.from.inclusion) {
                            this.sp = 0;
                        }
                        storageImpl.pool.unfix(page);
                    }
                }
            } else if (Btree.this.type == 21) {
                if (this.order == 0) {
                    Page page;
                    if (this.from == null) {
                        while (--n3 >= 0) {
                            this.posStack[this.sp] = 0;
                            this.pageStack[this.sp] = n2;
                            page = storageImpl.getPage(n2);
                            n2 = BtreePage.getKeyStrOid(page, 0);
                            this.end = BtreePage.getnItems(page);
                            storageImpl.pool.unfix(page);
                            ++this.sp;
                        }
                    } else {
                        int n10;
                        int n11;
                        int n12;
                        while (--n3 > 0) {
                            this.pageStack[this.sp] = n2;
                            page = storageImpl.getPage(n2);
                            n12 = 0;
                            n11 = BtreePage.getnItems(page);
                            while (n12 < n11) {
                                n10 = n12 + n11 >> 1;
                                if (Btree.this.compareByteArrays(this.from, page, n10) >= this.from.inclusion) {
                                    n12 = n10 + 1;
                                    continue;
                                }
                                n11 = n10;
                            }
                            Assert.that(n11 == n12);
                            this.posStack[this.sp] = n11;
                            n2 = BtreePage.getKeyStrOid(page, n11);
                            storageImpl.pool.unfix(page);
                            ++this.sp;
                        }
                        this.pageStack[this.sp] = n2;
                        page = storageImpl.getPage(n2);
                        n12 = 0;
                        this.end = n11 = BtreePage.getnItems(page);
                        while (n12 < n11) {
                            n10 = n12 + n11 >> 1;
                            if (Btree.this.compareByteArrays(this.from, page, n10) >= this.from.inclusion) {
                                n12 = n10 + 1;
                                continue;
                            }
                            n11 = n10;
                        }
                        Assert.that(n11 == n12);
                        if (n11 == this.end) {
                            ++this.sp;
                            this.gotoNextItem(page, n11 - 1);
                        } else {
                            this.posStack[this.sp++] = n11;
                            storageImpl.pool.unfix(page);
                        }
                    }
                    if (this.sp != 0 && this.till != null) {
                        page = storageImpl.getPage(this.pageStack[this.sp - 1]);
                        if (-Btree.this.compareByteArrays(this.till, page, this.posStack[this.sp - 1]) >= this.till.inclusion) {
                            this.sp = 0;
                        }
                        storageImpl.pool.unfix(page);
                    }
                } else {
                    Page page;
                    if (this.till == null) {
                        while (--n3 > 0) {
                            this.pageStack[this.sp] = n2;
                            page = storageImpl.getPage(n2);
                            this.posStack[this.sp] = BtreePage.getnItems(page);
                            n2 = BtreePage.getKeyStrOid(page, this.posStack[this.sp]);
                            storageImpl.pool.unfix(page);
                            ++this.sp;
                        }
                        this.pageStack[this.sp] = n2;
                        page = storageImpl.getPage(n2);
                        this.posStack[this.sp++] = BtreePage.getnItems(page) - 1;
                        storageImpl.pool.unfix(page);
                    } else {
                        int n13;
                        int n14;
                        int n15;
                        while (--n3 > 0) {
                            this.pageStack[this.sp] = n2;
                            page = storageImpl.getPage(n2);
                            n15 = 0;
                            n14 = BtreePage.getnItems(page);
                            while (n15 < n14) {
                                n13 = n15 + n14 >> 1;
                                if (Btree.this.compareByteArrays(this.till, page, n13) >= 1 - this.till.inclusion) {
                                    n15 = n13 + 1;
                                    continue;
                                }
                                n14 = n13;
                            }
                            Assert.that(n14 == n15);
                            this.posStack[this.sp] = n14;
                            n2 = BtreePage.getKeyStrOid(page, n14);
                            storageImpl.pool.unfix(page);
                            ++this.sp;
                        }
                        this.pageStack[this.sp] = n2;
                        page = storageImpl.getPage(n2);
                        n15 = 0;
                        n14 = BtreePage.getnItems(page);
                        while (n15 < n14) {
                            n13 = n15 + n14 >> 1;
                            if (Btree.this.compareByteArrays(this.till, page, n13) >= 1 - this.till.inclusion) {
                                n15 = n13 + 1;
                                continue;
                            }
                            n14 = n13;
                        }
                        Assert.that(n14 == n15);
                        if (n14 == 0) {
                            ++this.sp;
                            this.gotoNextItem(page, n14);
                        } else {
                            this.posStack[this.sp++] = n14 - 1;
                            storageImpl.pool.unfix(page);
                        }
                    }
                    if (this.sp != 0 && this.from != null) {
                        page = storageImpl.getPage(this.pageStack[this.sp - 1]);
                        if (Btree.this.compareByteArrays(this.from, page, this.posStack[this.sp - 1]) >= this.from.inclusion) {
                            this.sp = 0;
                        }
                        storageImpl.pool.unfix(page);
                    }
                }
            } else if (this.order == 0) {
                Page page;
                if (this.from == null) {
                    while (--n3 >= 0) {
                        this.posStack[this.sp] = 0;
                        this.pageStack[this.sp] = n2;
                        page = storageImpl.getPage(n2);
                        n2 = BtreePage.getReference(page, 1022);
                        this.end = BtreePage.getnItems(page);
                        storageImpl.pool.unfix(page);
                        ++this.sp;
                    }
                } else {
                    int n16;
                    int n17;
                    int n18;
                    while (--n3 > 0) {
                        this.pageStack[this.sp] = n2;
                        page = storageImpl.getPage(n2);
                        n18 = 0;
                        n17 = BtreePage.getnItems(page);
                        while (n18 < n17) {
                            n16 = n18 + n17 >> 1;
                            if (BtreePage.compare(this.from, page, n16) >= this.from.inclusion) {
                                n18 = n16 + 1;
                                continue;
                            }
                            n17 = n16;
                        }
                        Assert.that(n17 == n18);
                        this.posStack[this.sp] = n17;
                        n2 = BtreePage.getReference(page, 1022 - n17);
                        storageImpl.pool.unfix(page);
                        ++this.sp;
                    }
                    this.pageStack[this.sp] = n2;
                    page = storageImpl.getPage(n2);
                    n18 = 0;
                    n17 = this.end = BtreePage.getnItems(page);
                    while (n18 < n17) {
                        n16 = n18 + n17 >> 1;
                        if (BtreePage.compare(this.from, page, n16) >= this.from.inclusion) {
                            n18 = n16 + 1;
                            continue;
                        }
                        n17 = n16;
                    }
                    Assert.that(n17 == n18);
                    if (n17 == this.end) {
                        ++this.sp;
                        this.gotoNextItem(page, n17 - 1);
                    } else {
                        this.posStack[this.sp++] = n17;
                        storageImpl.pool.unfix(page);
                    }
                }
                if (this.sp != 0 && this.till != null) {
                    page = storageImpl.getPage(this.pageStack[this.sp - 1]);
                    if (-BtreePage.compare(this.till, page, this.posStack[this.sp - 1]) >= this.till.inclusion) {
                        this.sp = 0;
                    }
                    storageImpl.pool.unfix(page);
                }
            } else {
                Page page;
                if (this.till == null) {
                    while (--n3 > 0) {
                        this.pageStack[this.sp] = n2;
                        page = storageImpl.getPage(n2);
                        this.posStack[this.sp] = BtreePage.getnItems(page);
                        n2 = BtreePage.getReference(page, 1022 - this.posStack[this.sp]);
                        storageImpl.pool.unfix(page);
                        ++this.sp;
                    }
                    this.pageStack[this.sp] = n2;
                    page = storageImpl.getPage(n2);
                    this.posStack[this.sp++] = BtreePage.getnItems(page) - 1;
                    storageImpl.pool.unfix(page);
                } else {
                    int n19;
                    int n20;
                    int n21;
                    while (--n3 > 0) {
                        this.pageStack[this.sp] = n2;
                        page = storageImpl.getPage(n2);
                        n21 = 0;
                        n20 = BtreePage.getnItems(page);
                        while (n21 < n20) {
                            n19 = n21 + n20 >> 1;
                            if (BtreePage.compare(this.till, page, n19) >= 1 - this.till.inclusion) {
                                n21 = n19 + 1;
                                continue;
                            }
                            n20 = n19;
                        }
                        Assert.that(n20 == n21);
                        this.posStack[this.sp] = n20;
                        n2 = BtreePage.getReference(page, 1022 - n20);
                        storageImpl.pool.unfix(page);
                        ++this.sp;
                    }
                    this.pageStack[this.sp] = n2;
                    page = storageImpl.getPage(n2);
                    n21 = 0;
                    n20 = BtreePage.getnItems(page);
                    while (n21 < n20) {
                        n19 = n21 + n20 >> 1;
                        if (BtreePage.compare(this.till, page, n19) >= 1 - this.till.inclusion) {
                            n21 = n19 + 1;
                            continue;
                        }
                        n20 = n19;
                    }
                    Assert.that(n20 == n21);
                    if (n20 == 0) {
                        ++this.sp;
                        this.gotoNextItem(page, n20);
                    } else {
                        this.posStack[this.sp++] = n20 - 1;
                        storageImpl.pool.unfix(page);
                    }
                }
                if (this.sp != 0 && this.from != null) {
                    page = storageImpl.getPage(this.pageStack[this.sp - 1]);
                    if (BtreePage.compare(this.from, page, this.posStack[this.sp - 1]) >= this.from.inclusion) {
                        this.sp = 0;
                    }
                    storageImpl.pool.unfix(page);
                }
            }
        }

        public boolean hasNext() {
            if (this.counter != Btree.this.updateCounter) {
                if (((StorageImpl)Btree.this.getStorage()).concurrentIterator) {
                    this.refresh();
                } else {
                    throw new ConcurrentModificationException();
                }
            }
            return this.sp != 0;
        }

        public Object next() {
            int n2;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            StorageImpl storageImpl = (StorageImpl)Btree.this.getStorage();
            this.currPos = n2 = this.posStack[this.sp - 1];
            this.currPage = this.pageStack[this.sp - 1];
            Page page = storageImpl.getPage(this.currPage);
            Object object = this.getCurrent(page, n2);
            if (storageImpl.concurrentIterator) {
                this.currKey = this.getCurrentKey(page, n2);
            }
            this.gotoNextItem(page, n2);
            return object;
        }

        public int nextOid() {
            int n2;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            StorageImpl storageImpl = (StorageImpl)Btree.this.getStorage();
            this.currPos = n2 = this.posStack[this.sp - 1];
            this.currPage = this.pageStack[this.sp - 1];
            Page page = storageImpl.getPage(this.currPage);
            int n3 = this.getReference(page, n2);
            if (storageImpl.concurrentIterator) {
                this.currKey = this.getCurrentKey(page, n2);
            }
            this.gotoNextItem(page, n2);
            return n3;
        }

        private int getReference(Page page, int n2) {
            return Btree.this.type == 8 || Btree.this.type == 21 ? BtreePage.getKeyStrOid(page, n2) : BtreePage.getReference(page, 1022 - n2);
        }

        protected Object getCurrent(Page page, int n2) {
            StorageImpl storageImpl = (StorageImpl)Btree.this.getStorage();
            return storageImpl.lookupObject(this.getReference(page, n2), null);
        }

        protected final void gotoNextItem(Page page, int n2) {
            StorageImpl storageImpl = (StorageImpl)Btree.this.getStorage();
            if (Btree.this.type == 8) {
                if (this.order == 0) {
                    if (++n2 == this.end) {
                        while (--this.sp != 0) {
                            storageImpl.pool.unfix(page);
                            n2 = this.posStack[this.sp - 1];
                            page = storageImpl.getPage(this.pageStack[this.sp - 1]);
                            if (++n2 > BtreePage.getnItems(page)) continue;
                            this.posStack[this.sp - 1] = n2;
                            do {
                                int n3 = BtreePage.getKeyStrOid(page, n2);
                                storageImpl.pool.unfix(page);
                                page = storageImpl.getPage(n3);
                                this.end = BtreePage.getnItems(page);
                                this.pageStack[this.sp] = n3;
                                n2 = 0;
                                this.posStack[this.sp] = 0;
                            } while (++this.sp < this.pageStack.length);
                            break;
                        }
                    } else {
                        this.posStack[this.sp - 1] = n2;
                    }
                    if (this.sp != 0 && this.till != null && -BtreePage.compareStr(this.till, page, n2) >= this.till.inclusion) {
                        this.sp = 0;
                    }
                } else {
                    if (--n2 < 0) {
                        while (--this.sp != 0) {
                            storageImpl.pool.unfix(page);
                            n2 = this.posStack[this.sp - 1];
                            page = storageImpl.getPage(this.pageStack[this.sp - 1]);
                            if (--n2 < 0) continue;
                            this.posStack[this.sp - 1] = n2;
                            do {
                                int n4 = BtreePage.getKeyStrOid(page, n2);
                                storageImpl.pool.unfix(page);
                                page = storageImpl.getPage(n4);
                                this.pageStack[this.sp] = n4;
                                n2 = BtreePage.getnItems(page);
                                this.posStack[this.sp] = n2--;
                            } while (++this.sp < this.pageStack.length);
                            this.posStack[this.sp - 1] = n2;
                            break;
                        }
                    } else {
                        this.posStack[this.sp - 1] = n2;
                    }
                    if (this.sp != 0 && this.from != null && BtreePage.compareStr(this.from, page, n2) >= this.from.inclusion) {
                        this.sp = 0;
                    }
                }
            } else if (Btree.this.type == 21) {
                if (this.order == 0) {
                    if (++n2 == this.end) {
                        while (--this.sp != 0) {
                            storageImpl.pool.unfix(page);
                            n2 = this.posStack[this.sp - 1];
                            page = storageImpl.getPage(this.pageStack[this.sp - 1]);
                            if (++n2 > BtreePage.getnItems(page)) continue;
                            this.posStack[this.sp - 1] = n2;
                            do {
                                int n5 = BtreePage.getKeyStrOid(page, n2);
                                storageImpl.pool.unfix(page);
                                page = storageImpl.getPage(n5);
                                this.end = BtreePage.getnItems(page);
                                this.pageStack[this.sp] = n5;
                                n2 = 0;
                                this.posStack[this.sp] = 0;
                            } while (++this.sp < this.pageStack.length);
                            break;
                        }
                    } else {
                        this.posStack[this.sp - 1] = n2;
                    }
                    if (this.sp != 0 && this.till != null && -Btree.this.compareByteArrays(this.till, page, n2) >= this.till.inclusion) {
                        this.sp = 0;
                    }
                } else {
                    if (--n2 < 0) {
                        while (--this.sp != 0) {
                            storageImpl.pool.unfix(page);
                            n2 = this.posStack[this.sp - 1];
                            page = storageImpl.getPage(this.pageStack[this.sp - 1]);
                            if (--n2 < 0) continue;
                            this.posStack[this.sp - 1] = n2;
                            do {
                                int n6 = BtreePage.getKeyStrOid(page, n2);
                                storageImpl.pool.unfix(page);
                                page = storageImpl.getPage(n6);
                                this.pageStack[this.sp] = n6;
                                n2 = BtreePage.getnItems(page);
                                this.posStack[this.sp] = n2--;
                            } while (++this.sp < this.pageStack.length);
                            this.posStack[this.sp - 1] = n2;
                            break;
                        }
                    } else {
                        this.posStack[this.sp - 1] = n2;
                    }
                    if (this.sp != 0 && this.from != null && Btree.this.compareByteArrays(this.from, page, n2) >= this.from.inclusion) {
                        this.sp = 0;
                    }
                }
            } else if (this.order == 0) {
                if (++n2 == this.end) {
                    while (--this.sp != 0) {
                        storageImpl.pool.unfix(page);
                        n2 = this.posStack[this.sp - 1];
                        page = storageImpl.getPage(this.pageStack[this.sp - 1]);
                        if (++n2 > BtreePage.getnItems(page)) continue;
                        this.posStack[this.sp - 1] = n2;
                        do {
                            int n7 = BtreePage.getReference(page, 1022 - n2);
                            storageImpl.pool.unfix(page);
                            page = storageImpl.getPage(n7);
                            this.end = BtreePage.getnItems(page);
                            this.pageStack[this.sp] = n7;
                            n2 = 0;
                            this.posStack[this.sp] = 0;
                        } while (++this.sp < this.pageStack.length);
                        break;
                    }
                } else {
                    this.posStack[this.sp - 1] = n2;
                }
                if (this.sp != 0 && this.till != null && -BtreePage.compare(this.till, page, n2) >= this.till.inclusion) {
                    this.sp = 0;
                }
            } else {
                if (--n2 < 0) {
                    while (--this.sp != 0) {
                        storageImpl.pool.unfix(page);
                        n2 = this.posStack[this.sp - 1];
                        page = storageImpl.getPage(this.pageStack[this.sp - 1]);
                        if (--n2 < 0) continue;
                        this.posStack[this.sp - 1] = n2;
                        do {
                            int n8 = BtreePage.getReference(page, 1022 - n2);
                            storageImpl.pool.unfix(page);
                            page = storageImpl.getPage(n8);
                            this.pageStack[this.sp] = n8;
                            n2 = BtreePage.getnItems(page);
                            this.posStack[this.sp] = n2--;
                        } while (++this.sp < this.pageStack.length);
                        this.posStack[this.sp - 1] = n2;
                        break;
                    }
                } else {
                    this.posStack[this.sp - 1] = n2;
                }
                if (this.sp != 0 && this.from != null && BtreePage.compare(this.from, page, n2) >= this.from.inclusion) {
                    this.sp = 0;
                }
            }
            if (storageImpl.concurrentIterator && this.sp != 0) {
                this.nextKey = this.getCurrentKey(page, n2);
            }
            storageImpl.pool.unfix(page);
        }

        private void refresh() {
            if (this.sp != 0) {
                if (this.nextKey == null) {
                    this.reset();
                } else {
                    Page page;
                    if (this.order == 0) {
                        this.from = this.nextKey.key;
                    } else {
                        this.till = this.nextKey.key;
                    }
                    int n2 = this.nextKey.oid;
                    this.reset();
                    StorageImpl storageImpl = (StorageImpl)Btree.this.getStorage();
                    while (true) {
                        int n3;
                        int n4 = this.posStack[this.sp - 1];
                        page = storageImpl.getPage(this.pageStack[this.sp - 1]);
                        int n5 = n3 = Btree.this.type == 8 || Btree.this.type == 21 ? BtreePage.getKeyStrOid(page, n4) : BtreePage.getReference(page, 1022 - n4);
                        if (n3 == n2) break;
                        this.gotoNextItem(page, n4);
                    }
                    storageImpl.pool.unfix(page);
                }
            }
            this.counter = Btree.this.updateCounter;
        }

        BtreeKey getCurrentKey(Page page, int n2) {
            BtreeKey btreeKey;
            switch (Btree.this.type) {
                case 8: {
                    btreeKey = new BtreeKey(null, BtreePage.getKeyStrOid(page, n2));
                    btreeKey.getStr(page, n2);
                    break;
                }
                case 21: {
                    btreeKey = new BtreeKey(null, BtreePage.getKeyStrOid(page, n2));
                    btreeKey.getByteArray(page, n2);
                    break;
                }
                default: {
                    btreeKey = new BtreeKey(null, BtreePage.getReference(page, 1022 - n2));
                    btreeKey.extract(page, 4 + n2 * ClassDescriptor.sizeof[Btree.this.type], Btree.this.type);
                }
            }
            return btreeKey;
        }

        public void remove() {
            if (this.currPage == 0) {
                throw new NoSuchElementException();
            }
            StorageImpl storageImpl = (StorageImpl)Btree.this.getStorage();
            if (!storageImpl.concurrentIterator) {
                if (this.counter != Btree.this.updateCounter) {
                    throw new ConcurrentModificationException();
                }
                Page page = storageImpl.getPage(this.currPage);
                this.currKey = this.getCurrentKey(page, this.currPos);
                storageImpl.pool.unfix(page);
                if (this.sp != 0) {
                    int n2 = this.posStack[this.sp - 1];
                    page = storageImpl.getPage(this.pageStack[this.sp - 1]);
                    this.nextKey = this.getCurrentKey(page, n2);
                    storageImpl.pool.unfix(page);
                }
            }
            Btree.this.removeIfExists(this.currKey);
            this.refresh();
            this.currPage = 0;
        }
    }

    static class BtreeEntry
    implements Map.Entry {
        private Object key;
        private StorageImpl db;
        private int oid;

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.db.lookupObject(this.oid, null);
        }

        public Object setValue(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return (this.getKey() == null ? entry.getKey() == null : this.getKey().equals(entry.getKey())) && (this.getValue() == null ? this.getValue() == null : this.getValue().equals(entry.getValue()));
        }

        BtreeEntry(StorageImpl storageImpl, Object object, int n2) {
            this.db = storageImpl;
            this.key = object;
            this.oid = n2;
        }
    }
}

