/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.gs.beanutils.locale;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.gs.beanutils.locale.LocaleBeanUtilsBean;
import org.apache.commons.gs.beanutils.locale.LocaleConvertUtils;
import org.apache.commons.gs.beanutils.locale.LocaleConverter;
import org.apache.commons.gs.beanutils.locale.converters.BigDecimalLocaleConverter;
import org.apache.commons.gs.beanutils.locale.converters.BigIntegerLocaleConverter;
import org.apache.commons.gs.beanutils.locale.converters.ByteLocaleConverter;
import org.apache.commons.gs.beanutils.locale.converters.DoubleLocaleConverter;
import org.apache.commons.gs.beanutils.locale.converters.FloatLocaleConverter;
import org.apache.commons.gs.beanutils.locale.converters.IntegerLocaleConverter;
import org.apache.commons.gs.beanutils.locale.converters.LongLocaleConverter;
import org.apache.commons.gs.beanutils.locale.converters.ShortLocaleConverter;
import org.apache.commons.gs.beanutils.locale.converters.SqlDateLocaleConverter;
import org.apache.commons.gs.beanutils.locale.converters.SqlTimeLocaleConverter;
import org.apache.commons.gs.beanutils.locale.converters.SqlTimestampLocaleConverter;
import org.apache.commons.gs.beanutils.locale.converters.StringLocaleConverter;
import org.apache.commons.gs.collections.FastHashMap;

public class LocaleConvertUtilsBean {
    private Locale defaultLocale = Locale.getDefault();
    private boolean applyLocalized = false;
    private Logger log;
    private FastHashMap mapConverters;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$org$apache$commons$gs$beanutils$locale$LocaleConvertUtils;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$sql$Timestamp;

    public static LocaleConvertUtilsBean getInstance() {
        return LocaleBeanUtilsBean.getLocaleBeanUtilsInstance().getLocaleConvertUtils();
    }

    public LocaleConvertUtilsBean() {
        Class<?> clazz = class$org$apache$commons$gs$beanutils$locale$LocaleConvertUtils;
        if (clazz == null) {
            clazz = class$org$apache$commons$gs$beanutils$locale$LocaleConvertUtils = new LocaleConvertUtils[0].getClass().getComponentType();
        }
        this.log = Logger.getLogger(clazz.getName());
        this.mapConverters = new FastHashMap();
        this.deregister();
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public void setDefaultLocale(Locale locale) {
        this.defaultLocale = locale == null ? Locale.getDefault() : locale;
    }

    public boolean getApplyLocalized() {
        return this.applyLocalized;
    }

    public void setApplyLocalized(boolean bl2) {
        this.applyLocalized = bl2;
    }

    public String convert(Object object) {
        return this.convert(object, this.defaultLocale, null);
    }

    public String convert(Object object, String string) {
        return this.convert(object, this.defaultLocale, string);
    }

    public String convert(Object object, Locale locale, String string) {
        Class<?> clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = new String[0].getClass().getComponentType();
        }
        LocaleConverter localeConverter = this.lookup(clazz, locale);
        Class<?> clazz2 = class$java$lang$String;
        if (clazz2 == null) {
            clazz2 = class$java$lang$String = new String[0].getClass().getComponentType();
        }
        return (String)localeConverter.convert(clazz2, object, string);
    }

    public Object convert(String string, Class clazz) {
        return this.convert(string, clazz, this.defaultLocale, null);
    }

    public Object convert(String string, Class clazz, String string2) {
        return this.convert(string, clazz, this.defaultLocale, string2);
    }

    public Object convert(String string, Class clazz, Locale locale, String string2) {
        LocaleConverter localeConverter;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Convert string " + string + " to class " + clazz.getName() + " using " + locale.toString() + " locale and " + string2 + " pattern");
        }
        if ((localeConverter = this.lookup(clazz, locale)) == null) {
            Class<?> clazz2 = class$java$lang$String;
            if (clazz2 == null) {
                clazz2 = class$java$lang$String = new String[0].getClass().getComponentType();
            }
            localeConverter = this.lookup(clazz2, locale);
        }
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("  Using converter " + localeConverter);
        }
        return localeConverter.convert(clazz, string, string2);
    }

    public Object convert(String[] stringArray, Class clazz, String string) {
        return this.convert(stringArray, clazz, this.getDefaultLocale(), string);
    }

    public Object convert(String[] stringArray, Class clazz) {
        return this.convert(stringArray, clazz, this.getDefaultLocale(), null);
    }

    public Object convert(String[] stringArray, Class clazz, Locale locale, String string) {
        Class<?> clazz2 = clazz;
        if (clazz.isArray()) {
            clazz2 = clazz.getComponentType();
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Convert String[" + stringArray.length + "] to class " + clazz2.getName() + "[] using " + locale.toString() + " locale and " + string + " pattern");
        }
        Object object = Array.newInstance(clazz2, stringArray.length);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            Array.set(object, i2, this.convert(stringArray[i2], clazz2, locale, string));
        }
        return object;
    }

    public void register(LocaleConverter localeConverter, Class clazz, Locale locale) {
        this.lookup(locale).put(clazz, localeConverter);
    }

    public void deregister() {
        FastHashMap fastHashMap = this.lookup(this.defaultLocale);
        this.mapConverters.setFast(false);
        this.mapConverters.clear();
        this.mapConverters.put(this.defaultLocale, fastHashMap);
        this.mapConverters.setFast(true);
    }

    public void deregister(Locale locale) {
        this.mapConverters.remove(locale);
    }

    public void deregister(Class clazz, Locale locale) {
        this.lookup(locale).remove(clazz);
    }

    public LocaleConverter lookup(Class clazz, Locale locale) {
        LocaleConverter localeConverter = (LocaleConverter)this.lookup(locale).get(clazz);
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("LocaleConverter:" + localeConverter);
        }
        return localeConverter;
    }

    public FastHashMap lookup(Locale locale) {
        FastHashMap fastHashMap;
        if (locale == null) {
            fastHashMap = (FastHashMap)this.mapConverters.get(this.defaultLocale);
        } else {
            fastHashMap = (FastHashMap)this.mapConverters.get(locale);
            if (fastHashMap == null) {
                fastHashMap = this.create(locale);
                this.mapConverters.put(locale, fastHashMap);
            }
        }
        return fastHashMap;
    }

    public FastHashMap create(Locale locale) {
        FastHashMap fastHashMap = new FastHashMap();
        fastHashMap.setFast(false);
        Class<?> clazz = class$java$math$BigDecimal;
        if (clazz == null) {
            clazz = class$java$math$BigDecimal = new BigDecimal[0].getClass().getComponentType();
        }
        fastHashMap.put(clazz, new BigDecimalLocaleConverter(locale, this.applyLocalized));
        Class<?> clazz2 = class$java$math$BigInteger;
        if (clazz2 == null) {
            clazz2 = class$java$math$BigInteger = new BigInteger[0].getClass().getComponentType();
        }
        fastHashMap.put(clazz2, new BigIntegerLocaleConverter(locale, this.applyLocalized));
        Class<?> clazz3 = class$java$lang$Byte;
        if (clazz3 == null) {
            clazz3 = class$java$lang$Byte = new Byte[0].getClass().getComponentType();
        }
        fastHashMap.put(clazz3, new ByteLocaleConverter(locale, this.applyLocalized));
        fastHashMap.put(Byte.TYPE, new ByteLocaleConverter(locale, this.applyLocalized));
        Class<?> clazz4 = class$java$lang$Double;
        if (clazz4 == null) {
            clazz4 = class$java$lang$Double = new Double[0].getClass().getComponentType();
        }
        fastHashMap.put(clazz4, new DoubleLocaleConverter(locale, this.applyLocalized));
        fastHashMap.put(Double.TYPE, new DoubleLocaleConverter(locale, this.applyLocalized));
        Class<?> clazz5 = class$java$lang$Float;
        if (clazz5 == null) {
            clazz5 = class$java$lang$Float = new Float[0].getClass().getComponentType();
        }
        fastHashMap.put(clazz5, new FloatLocaleConverter(locale, this.applyLocalized));
        fastHashMap.put(Float.TYPE, new FloatLocaleConverter(locale, this.applyLocalized));
        Class<?> clazz6 = class$java$lang$Integer;
        if (clazz6 == null) {
            clazz6 = class$java$lang$Integer = new Integer[0].getClass().getComponentType();
        }
        fastHashMap.put(clazz6, new IntegerLocaleConverter(locale, this.applyLocalized));
        fastHashMap.put(Integer.TYPE, new IntegerLocaleConverter(locale, this.applyLocalized));
        Class<?> clazz7 = class$java$lang$Long;
        if (clazz7 == null) {
            clazz7 = class$java$lang$Long = new Long[0].getClass().getComponentType();
        }
        fastHashMap.put(clazz7, new LongLocaleConverter(locale, this.applyLocalized));
        fastHashMap.put(Long.TYPE, new LongLocaleConverter(locale, this.applyLocalized));
        Class<?> clazz8 = class$java$lang$Short;
        if (clazz8 == null) {
            clazz8 = class$java$lang$Short = new Short[0].getClass().getComponentType();
        }
        fastHashMap.put(clazz8, new ShortLocaleConverter(locale, this.applyLocalized));
        fastHashMap.put(Short.TYPE, new ShortLocaleConverter(locale, this.applyLocalized));
        Class<?> clazz9 = class$java$lang$String;
        if (clazz9 == null) {
            clazz9 = class$java$lang$String = new String[0].getClass().getComponentType();
        }
        fastHashMap.put(clazz9, new StringLocaleConverter(locale, this.applyLocalized));
        Class<?> clazz10 = class$java$sql$Date;
        if (clazz10 == null) {
            clazz10 = class$java$sql$Date = new Date[0].getClass().getComponentType();
        }
        fastHashMap.put(clazz10, new SqlDateLocaleConverter(locale, "yyyy-MM-dd"));
        Class<?> clazz11 = class$java$sql$Time;
        if (clazz11 == null) {
            clazz11 = class$java$sql$Time = new Time[0].getClass().getComponentType();
        }
        fastHashMap.put(clazz11, new SqlTimeLocaleConverter(locale, "HH:mm:ss"));
        Class<?> clazz12 = class$java$sql$Timestamp;
        if (clazz12 == null) {
            clazz12 = class$java$sql$Timestamp = new Timestamp[0].getClass().getComponentType();
        }
        fastHashMap.put(clazz12, new SqlTimestampLocaleConverter(locale, "yyyy-MM-dd HH:mm:ss.S"));
        fastHashMap.setFast(true);
        return fastHashMap;
    }
}

