/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import com.j_spaces.core.Constants;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.JSpaceAttributes;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.core.client.JSpaceProxyWrapper;
import com.j_spaces.core.filters.GenericPrincipal;
import com.j_spaces.core.filters.UserDefinedRole;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.cluster.ViewFileDialog;
import com.j_spaces.tools.filters.SortFiltersDialog;
import com.j_spaces.tools.spacebrowser.DistributedCachePanel;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import com.j_spaces.tools.spacebrowser.SpaceConfigException;
import com.j_spaces.tools.spacebrowser.SpaceConfigPanel;
import com.j_spaces.tools.spacebrowser.SpaceConfigStandardPanel;
import com.j_spaces.tools.spacebrowser.WholeNumberField;
import com.j_spaces.tools.spacebrowser.utils.ComboItemWrapper;
import com.j_spaces.tools.spacebrowser.utils.TypePlainDocument;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.tree.DefaultMutableTreeNode;

public class SpaceConfigAdvancedPanel
extends JPanel
implements ActionListener {
    public SpaceConfigPanel m_owner;
    public boolean m_isCreateMode;
    public SpaceBrowser m_spaceBrowser;
    public Hashtable m_uiComponentMap;
    private SortFiltersDialog m_filterDialog;
    public GenericPrincipal[] m_defaultFilterUserInfo;
    public ButtonGroupMapping butGroupCachePolicy = new ButtonGroupMapping(null);
    public ButtonGroupMapping butGroupSpaceProtocol = new ButtonGroupMapping(null);
    public JTabbedPane tabbedPanel = new JTabbedPane();
    private JScrollPane scrollPanSecurity = new JScrollPane();
    private JScrollPane scrollPanPerformance = new JScrollPane();
    private JScrollPane scrollPanCluster = new JScrollPane();
    private JScrollPane scrollPanGeneral = new JScrollPane();
    private JScrollPane scrollPanPersistence = new JScrollPane();
    private JScrollPane scrollPanMemory = new JScrollPane();
    private JScrollPane scrollPanDCache = new JScrollPane();
    private JScrollPane scrollPanJms = new JScrollPane();
    private JPanel panCacheManager = new JPanel();
    private JPanel panPerformCenter = new JPanel(new BorderLayout());
    private JPanel panGeneral = new JPanel();
    private JPanel panSA = new JPanel();
    private JPanel panEntryMatching = new JPanel();
    private JPanel panEngine = new JPanel();
    private JPanel panCluster = new JPanel();
    private JPanel panSecCenter = new JPanel(new BorderLayout());
    private JPanel panSecurity = new JPanel();
    private JPanel panPerformance = new JPanel();
    private JPanel panSSLOptions = new JPanel();
    private JPanel panPersistence = new JPanel();
    private JPanel panClusterCenter = new JPanel(new BorderLayout());
    private JPanel panPersCenter = new JPanel(new BorderLayout());
    private JPanel panGenCenter = new JPanel(new BorderLayout());
    private JPanel panLeaseManager = new JPanel();
    private JPanel panMemoryUsage = new JPanel();
    private JPanel panMemCenter = new JPanel(new BorderLayout());
    private JPanel panMemory = new JPanel();
    private JPanel panDistCacheCenter = new JPanel(new BorderLayout());
    private JPanel panJmsCenter = new JPanel(new BorderLayout());
    private JPanel panJms = new JPanel();
    private DistributedCachePanel panDistCache = new DistributedCachePanel();
    private JLabel labNumOfImplicitIndexes = new JLabel();
    private JLabel labMaxTheads = new JLabel();
    private JLabel labSSLPassConfirm = new JLabel();
    private JLabel labMinThreads = new JLabel();
    private JLabel labExpTimeInterval = new JLabel();
    private JLabel labSSLStubHandler = new JLabel();
    private JLabel labSSLTrustStore = new JLabel();
    private JLabel labClusterConfigURL = new JLabel();
    private JLabel labSSLKeyStore = new JLabel();
    private JLabel labCachePolicy = new JLabel();
    private JLabel labSAInitConnections = new JLabel();
    private JLabel labSAClass = new JLabel();
    private JLabel labConnectionRetries = new JLabel();
    private JLabel labNotifyRetries = new JLabel();
    private JLabel labSAMaxConnections = new JLabel();
    private JLabel labSSLPort = new JLabel();
    private JLabel labCacheSize = new JLabel();
    private JLabel labSSLPassword = new JLabel();
    private JLabel labSAUrl = new JLabel();
    private JLabel labSerializationType = new JLabel();
    private JLabel labSpacePort = new JLabel();
    private JLabel labHighWatermarkPercentage = new JLabel();
    private JLabel labLowWatermarkPercentage = new JLabel();
    private JLabel labWriteOnlyBlockPercentage = new JLabel();
    private JLabel labWriteOnlyCheckPercentage = new JLabel();
    private JLabel labMemUsageRetryCount = new JLabel();
    private JLabel labEvictionBatchSize = new JLabel();
    private JLabel labJmsRMIPort = new JLabel();
    private JLabel labJmsTopicNames = new JLabel();
    private JLabel labJmsQueueNames = new JLabel();
    private JButton butEditUserPermis = new JButton();
    private JButton butEditClusterConfigURL = new JButton();
    private JButton butEditSpaceFilters = new JButton();
    private JTextField txtfSSLStubHandler = new JTextField();
    private JTextField txtfSSLTrustStore = new JTextField();
    private JTextField txtfCacheSize = new WholeNumberField();
    private JTextField txtfSSLKeyStore = new JTextField();
    private JTextField txtfConnectionRetries = new WholeNumberField();
    private JTextField txtfSAInitConnections = new WholeNumberField();
    private JTextField txtfExpTimeInterval = new WholeNumberField();
    private JTextField txtfMinThreads = new WholeNumberField();
    private JTextField txtfSAMaxConnections = new WholeNumberField();
    private JTextField txtfMaxThreads = new WholeNumberField();
    private JTextField txtfNumOfImplicitIndexes = new JTextField();
    private JTextField txtfNotifyRetries = new WholeNumberField();
    private JTextField txtfSpacePort = new WholeNumberField();
    private JTextField txtfClientSocketPort = new WholeNumberField();
    private WholeNumberField txtfHighWatermarkPercentage = new WholeNumberField(false);
    private WholeNumberField txtfLowWatermarkPercentage = new WholeNumberField(false);
    private WholeNumberField txtfEvictionBatchSize = new WholeNumberField();
    private WholeNumberField txtfMemUsageRetryCount = new WholeNumberField();
    private WholeNumberField txtfWriteOnlyBlockPercentage = new WholeNumberField(false);
    private WholeNumberField txtfWriteOnlyCheckPercentage = new WholeNumberField(false);
    private JTextField txtfJmsRMIPort = new WholeNumberField(true);
    private JTextField txtfJmsTopicNames = new JTextField();
    private JTextField txtfJmsQueueNames = new JTextField();
    private JPasswordField txtfSSLPassword = new JPasswordField();
    private JPasswordField txtfSSLPassConfirm = new JPasswordField();
    private JCheckBox chboxSpaceFilters = new JCheckBox();
    private JCheckBox chboxSSLEncryption = new JCheckBox();
    private JCheckBox chboxUserPermis = new JCheckBox();
    private JCheckBox chboxSAResetOnFailure = new JCheckBox();
    private JCheckBox chboxMemoryUsageEnable = new JCheckBox();
    private JCheckBox chboxExtendedIndexing = new JCheckBox();
    private JCheckBox chboxMultiplexConnection = new JCheckBox("Multiplex Connection");
    public JRadioButton rbutCachePolicyLRU = new JRadioButton();
    private JRadioButton rbutCachePolicyAllCache = new JRadioButton();
    private JRadioButton rbutSpaceProtocolRMI = new JRadioButton();
    private JRadioButton rbutSpaceProtocolNIO = new JRadioButton();
    private JComboBox cmboxSerialType = new JComboBox();
    public JComboBox cmboxSAUrl = new JComboBox();
    public JComboBox cmboxSAClass = new JComboBox();
    public JComboBox cmboxClusterConfigURL = new JComboBox();
    private JTextField adapterTypeField = new JTextField();
    private JTextField dbNameField = new JTextField();
    private JTextField dbUserNameField = new JTextField();
    private JPasswordField dbUserPasswordField = new JPasswordField();
    private JTextField numberSyncObjectsField = new JTextField(new TypePlainDocument(1), "", 1);
    private JTextField checkPointPeriodField = new JTextField(new TypePlainDocument(1), "", 1);
    private JComboBox pagePoolSizeComboBox;
    private JCheckBox syncOnCommitCB = new JCheckBox("Sync On Commit", true);
    private PoolSizeWrapper poolSizeWrapper4KB = new PoolSizeWrapper(4);
    private PoolSizeWrapper poolSizeWrapper16KB = new PoolSizeWrapper(16);
    private PoolSizeWrapper poolSizeWrapper32KB = new PoolSizeWrapper(32);
    private PoolSizeWrapper poolSizeWrapper64KB = new PoolSizeWrapper(64);
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private GridBagLayout gridBagLayout3 = new GridBagLayout();
    private GridBagLayout gridBagLayout4 = new GridBagLayout();
    private GridBagLayout gridBagLayout5 = new GridBagLayout();
    private GridBagLayout gridBagLayout6 = new GridBagLayout();
    private GridBagLayout gridBagLayout7 = new GridBagLayout();
    private GridBagLayout gridBagLayout8 = new GridBagLayout();
    private GridBagLayout gridBagLayout11 = new GridBagLayout();
    private GridBagLayout gridBagLayout12 = new GridBagLayout();
    private GridBagLayout gridBagLayout14 = new GridBagLayout();
    private GridBagLayout gridBagLayout18 = new GridBagLayout();
    private GridBagLayout gridBagLayout19 = new GridBagLayout();
    private GridBagLayout gridBagLayout20 = new GridBagLayout();
    private ComboItemWrapper comboItemNativeSerialization;
    private ComboItemWrapper comboItemLightSerialization;
    private ComboItemWrapper comboItemFullSerialization;
    private ComboItemWrapper comboItemCompressedSerialization;
    private static final int comboHeight = 23;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.ui.spacebrowser");
    private String adminPass;
    private SpaceConfig curSpaceConfig;

    public SpaceConfigAdvancedPanel(SpaceConfigPanel spaceConfigPanel, SpaceBrowser spaceBrowser, boolean bl2) {
        this.m_owner = spaceConfigPanel;
        this.m_spaceBrowser = spaceBrowser;
        this.m_isCreateMode = bl2;
        try {
            this.m_filterDialog = new SortFiltersDialog(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.jbInit();
            this.init();
            this.setFirstEnableComponentsMode();
            this.createUIMapping();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.rbutSpaceProtocolRMI) {
            this.chboxMultiplexConnection.setVisible(false);
        } else if (object == this.rbutSpaceProtocolNIO) {
            this.chboxMultiplexConnection.setVisible(true);
        }
    }

    private void createUIMapping() {
    }

    private void init() throws Exception {
        this.butGroupCachePolicy.add(String.valueOf(0), this.rbutCachePolicyLRU);
        this.butGroupCachePolicy.add(String.valueOf(1), this.rbutCachePolicyAllCache);
        this.butGroupSpaceProtocol.add(String.valueOf("RMI"), this.rbutSpaceProtocolRMI);
        this.butGroupSpaceProtocol.add(String.valueOf("NIO"), this.rbutSpaceProtocolNIO);
        this.rbutSpaceProtocolRMI.addActionListener(this);
        this.rbutSpaceProtocolNIO.addActionListener(this);
        this.butEditSpaceFilters.setMnemonic(69);
        this.butEditSpaceFilters.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpaceConfigAdvancedPanel.this.m_filterDialog.showDialog();
            }
        });
        this.chboxSpaceFilters.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpaceConfigAdvancedPanel.this.butEditSpaceFilters.setEnabled(SpaceConfigAdvancedPanel.this.chboxSpaceFilters.isSelected());
            }
        });
        this.chboxMemoryUsageEnable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JSpaceUtilities.setAWTComponentsStatus(SpaceConfigAdvancedPanel.this.panMemoryUsage, SpaceConfigAdvancedPanel.this.chboxMemoryUsageEnable.isSelected());
                SpaceConfigAdvancedPanel.this.chboxMemoryUsageEnable.setEnabled(true);
            }
        });
        this.butEditClusterConfigURL.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = ((String)SpaceConfigAdvancedPanel.this.cmboxClusterConfigURL.getEditor().getItem()).trim();
                if (string.length() == 0 || string.equals("none") || !string.endsWith(".xml")) {
                    File file = SpaceConfigAdvancedPanel.this.m_spaceBrowser.chooseFile();
                    if (file != null) {
                        SpaceConfigAdvancedPanel.this.cmboxClusterConfigURL.getEditor().setItem(file.getPath().replace('\\', '/'));
                    }
                } else {
                    try {
                        ViewFileDialog viewFileDialog = new ViewFileDialog(SpaceConfigAdvancedPanel.this.m_spaceBrowser, string);
                        viewFileDialog.show();
                    }
                    catch (Exception exception) {
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, exception.toString(), exception);
                        }
                        JOptionPane.showConfirmDialog(SpaceConfigAdvancedPanel.this.m_spaceBrowser, exception.getClass().getName() + " " + exception.getMessage(), "Can't read the file", -1, 0, SpaceConfigAdvancedPanel.this.m_spaceBrowser.EXCEPTION_ICON);
                    }
                }
            }
        });
        this.rbutCachePolicyLRU.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpaceConfigAdvancedPanel.this.setMemoryManagementCompEnabled(true);
            }
        });
        this.rbutCachePolicyAllCache.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpaceConfigAdvancedPanel.this.setMemoryManagementCompEnabled(false);
            }
        });
        Font font = this.txtfSAInitConnections.getFont();
        this.cmboxSAClass.setFont(font);
        this.cmboxSAUrl.setFont(font);
        this.cmboxClusterConfigURL.setFont(font);
        this.cmboxSAClass.setEditor(new CustomComboBoxEditor(null));
        this.cmboxSAUrl.setEditor(new CustomComboBoxEditor(null));
        this.chboxUserPermis.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl2 = SpaceConfigAdvancedPanel.this.chboxUserPermis.isSelected();
                if (!SpaceConfigAdvancedPanel.this.m_filterDialog.adminAuthentication()) {
                    SpaceConfigAdvancedPanel.this.chboxUserPermis.setSelected(!bl2);
                    return;
                }
                SpaceConfigAdvancedPanel.this.butEditUserPermis.setEnabled(bl2);
                SpaceConfigAdvancedPanel.this.m_filterDialog.setDefaultSecurFilterEnabled(bl2);
            }
        });
        this.butEditUserPermis.setMnemonic(69);
        this.butEditUserPermis.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)SpaceConfigAdvancedPanel.this.m_spaceBrowser.getSelectedTreeNode();
                if (defaultMutableTreeNode != null && defaultMutableTreeNode.getUserObject() instanceof JSpaceProxyWrapper) {
                    SpaceConfigAdvancedPanel.this.m_spaceBrowser.setSelectedTreeNode((DefaultMutableTreeNode)defaultMutableTreeNode.getLastChild(), true, false);
                }
            }
        });
        this.chboxSSLEncryption.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JSpaceUtilities.setAWTComponentsStatus(SpaceConfigAdvancedPanel.this.panSSLOptions, SpaceConfigAdvancedPanel.this.chboxSSLEncryption.isSelected());
            }
        });
        this.txtfConnectionRetries.setToolTipText("Maximum number of times the proxy may retry connecting to the space.");
        this.txtfNotifyRetries.setToolTipText("Maximum number of times the space may try reconnecting to the proxy.");
        this.txtfExpTimeInterval.setToolTipText("Specifies how often the server deletes Entries whose lease has expired, in milliseconds.");
        this.chboxSpaceFilters.setToolTipText("Filters are hooks inside the GigaSpaces engine that enable integration with external systems and/or implementation of user-defined logic inside the space.");
        this.txtfNumOfImplicitIndexes.setToolTipText("It specifies the maximum number of indexes that will be created automatically.");
        this.txtfMinThreads.setToolTipText("This is the number of threads initialized when the server is loaded.");
        this.txtfMaxThreads.setToolTipText("Maximum number of threads the GigaSpaces engine may run per space.");
        this.cmboxSAClass.setToolTipText("JDBC interface with the database");
        this.cmboxSAUrl.setToolTipText("Define database properties");
        this.txtfSAInitConnections.setToolTipText("The number of database connections the Storage Adapter opens when it loads.");
        this.txtfSAMaxConnections.setToolTipText("The maximum number of connections the Storage Adapter may open to the database.");
        this.txtfCacheSize.setToolTipText("The maximum number of Entries that will be cached for speedy reuse.");
        this.rbutCachePolicyLRU.setToolTipText("Cache manager should operate on a least recently used basis.");
        this.rbutCachePolicyAllCache.setToolTipText("Cache manager should store all the space\ufffds information in memory.");
        this.cmboxClusterConfigURL.setToolTipText("Specifies the path to the XML configuration file of the cluster to which this space belongs to.");
        this.txtfWriteOnlyBlockPercentage.setToolTipText("Specifies a lower threshold for blocking write-type operations. Above this level only read/take operations are allowed.");
        this.txtfWriteOnlyCheckPercentage.setToolTipText("Specifies an upper threshold for checking only write-type operations. Above this level all operations are checked.");
        this.txtfMemUsageRetryCount.setToolTipText("Number of retries to lower the memory level below the low watermark percentage");
    }

    public void setMemoryManagementCompEnabled(boolean bl2) {
        this.txtfCacheSize.setEditable(bl2);
        this.txtfLowWatermarkPercentage.setEditable(bl2);
        this.txtfEvictionBatchSize.setEditable(bl2);
    }

    public SpaceConfig getConfig() throws SpaceConfigException {
        return this.getConfig(null);
    }

    public SpaceConfig getConfig(String string) throws SpaceConfigException {
        Object object;
        String string2;
        String string3;
        String string4;
        String string5;
        if (string == null) {
            string = this.m_owner.getSpaceName().trim();
        }
        SpaceConfig spaceConfig = new SpaceConfig(string);
        if (this.txtfConnectionRetries.getText().trim().length() != 0) {
            spaceConfig.setConnectionRetries(this.txtfConnectionRetries.getText());
        }
        if (this.txtfNotifyRetries.getText().trim().length() != 0) {
            spaceConfig.setNotifyRetries(this.txtfNotifyRetries.getText());
        }
        if (this.txtfExpTimeInterval.getText().trim().length() != 0) {
            spaceConfig.setExpirationTimeInterval(this.txtfExpTimeInterval.getText());
        }
        spaceConfig.setFiltersInfo(this.m_filterDialog.getFiltersInfo());
        if (this.txtfSpacePort.getText().trim().length() != 0) {
            spaceConfig.setLRMIServerPort(this.txtfSpacePort.getText());
        }
        if (this.txtfClientSocketPort.getText().trim().length() != 0) {
            spaceConfig.setLRMIClientPort(this.txtfClientSocketPort.getText());
        }
        if (this.rbutSpaceProtocolRMI.isSelected()) {
            spaceConfig.setLRMIProtocolName("RMI");
            spaceConfig.setLRMIMultiplexConnection(false);
        } else {
            if (this.rbutSpaceProtocolNIO.isSelected()) {
                spaceConfig.setLRMIProtocolName("NIO");
            }
            spaceConfig.setLRMIMultiplexConnection(this.chboxMultiplexConnection.isSelected());
        }
        if (this.txtfMinThreads.getText().trim().length() != 0) {
            spaceConfig.setEngineMinThreads(this.txtfMinThreads.getText());
        }
        if (this.txtfMaxThreads.getText().trim().length() != 0) {
            spaceConfig.setEngineMaxThreads(this.txtfMaxThreads.getText());
        }
        if (this.txtfNumOfImplicitIndexes.getText().trim().length() != 0) {
            spaceConfig.setNumberImplicitIndexes(this.txtfNumOfImplicitIndexes.getText());
        }
        ComboItemWrapper comboItemWrapper = (ComboItemWrapper)this.cmboxSerialType.getSelectedItem();
        spaceConfig.setSerializationType(comboItemWrapper.getValue());
        spaceConfig.setQPAutoCommit(this.curSpaceConfig.isQPAutoCommit());
        spaceConfig.setQPInitJMX(this.curSpaceConfig.isQPInitJMX());
        spaceConfig.setQpMaxJDBCClientConnections(this.curSpaceConfig.getQpMaxJDBCClientConnections());
        spaceConfig.setQpMinJDBCClientConnections(this.curSpaceConfig.getQpMinJDBCClientConnections());
        spaceConfig.setQPParserCaseSensetivity(this.curSpaceConfig.isQPParserCaseSensetivity());
        spaceConfig.setQpPort(this.curSpaceConfig.getQpPort());
        spaceConfig.setQpSpaceReadLeaseTime(this.curSpaceConfig.getQpSpaceReadLeaseTime());
        spaceConfig.setQpSpaceWriteLeaseTime(this.curSpaceConfig.getQpSpaceWriteLeaseTime());
        spaceConfig.setQPTraceExecTime(this.curSpaceConfig.isQPTraceExecTime());
        spaceConfig.setQpTransactionTimeout(this.curSpaceConfig.getQpTransactionTimeout());
        spaceConfig.setQpDateFormat(this.curSpaceConfig.getQpDateFormat());
        spaceConfig.setQpDateTimeFormat(this.curSpaceConfig.getQpDateTimeFormat());
        spaceConfig.setQpTimeFormat(this.curSpaceConfig.getQpTimeFormat());
        if (this.m_owner.chboxPersistent.isSelected()) {
            string5 = (String)this.cmboxSAClass.getEditor().getItem();
            string4 = (String)this.cmboxSAUrl.getEditor().getItem();
            if (string5 == null || string5.trim().length() == 0) {
                throw new SpaceConfigException("Please define storage adapter class and url value.");
            }
            spaceConfig.setStorageAdapterClass(string5);
            if (string4 == null || string4.trim().length() == 0) {
                throw new SpaceConfigException("Please define storage adapter class and url value.");
            }
            spaceConfig.setStorageAdapterURL(string4);
            string3 = this.checkPointPeriodField.getText();
            if (!JSpaceUtilities.isEmpty(string3, true)) {
                spaceConfig.setCheckPointPeriod(Integer.parseInt(string3));
            } else {
                spaceConfig.setCheckPointPeriod(-1);
            }
            string2 = this.numberSyncObjectsField.getText();
            if (!JSpaceUtilities.isEmpty(string2, true)) {
                spaceConfig.setNumberSyncObjects(Integer.parseInt(string2));
            } else {
                spaceConfig.setNumberSyncObjects(-1);
            }
            object = (PoolSizeWrapper)this.pagePoolSizeComboBox.getSelectedItem();
            spaceConfig.setPagePoolSize(((PoolSizeWrapper)object).getPoolSize());
            spaceConfig.setDbName(this.dbNameField.getText());
            spaceConfig.setDbPassword(new String(this.dbUserPasswordField.getPassword()));
            spaceConfig.setDbUserName(this.dbUserNameField.getText());
            spaceConfig.setAdapterType(this.adapterTypeField.getText());
            spaceConfig.setSyncOnCommit(this.syncOnCommitCB.isSelected());
            if (this.txtfSAInitConnections.getText().trim().length() != 0) {
                spaceConfig.setInitSAConnections(this.txtfSAInitConnections.getText());
            }
            if (this.txtfSAMaxConnections.getText().trim().length() != 0) {
                spaceConfig.setMaxSAConnections(this.txtfSAMaxConnections.getText());
            }
            spaceConfig.setResetOnFailure(this.chboxSAResetOnFailure.isSelected());
        }
        if (this.m_owner.chboxClustered.isSelected()) {
            spaceConfig.setClustered(true);
            string5 = ((String)this.cmboxClusterConfigURL.getEditor().getItem()).trim();
            if (string5.length() != 0 && !string5.equals("none")) {
                spaceConfig.setClusterConfigURL(string5);
            } else {
                throw new SpaceConfigException("Please define cluster configuration file name.");
            }
        }
        spaceConfig.setSSLEnabled(String.valueOf(this.chboxSSLEncryption.isSelected()));
        if (this.txtfSSLStubHandler.getText().trim().length() > 0) {
            spaceConfig.setStubHandler(this.txtfSSLStubHandler.getText());
        }
        if (this.txtfSSLKeyStore.getText().trim().length() > 0) {
            spaceConfig.setSSLKeyStore(this.txtfSSLKeyStore.getText());
        }
        if (this.txtfSSLTrustStore.getText().trim().length() > 0) {
            spaceConfig.setSSLTrustStore(this.txtfSSLTrustStore.getText());
        }
        if (this.chboxSSLEncryption.isSelected()) {
            string5 = String.valueOf(this.txtfSSLPassword.getPassword()).trim();
            string4 = String.valueOf(this.txtfSSLPassConfirm.getPassword()).trim();
            if (string5.length() > 0 && string4.length() > 0 && string5.equals(string4)) {
                spaceConfig.setSSLPassword(string5);
            } else {
                throw new SpaceConfigException("The password you typed do not match. Type the new password in both text boxes.");
            }
        }
        if (this.txtfCacheSize.getText().trim().length() != 0) {
            spaceConfig.setCacheManagerSize(this.txtfCacheSize.getText());
        }
        if (this.rbutCachePolicyAllCache.isSelected()) {
            spaceConfig.setCachePolicy(String.valueOf(1));
        } else if (this.rbutCachePolicyLRU.isSelected()) {
            spaceConfig.setCachePolicy(String.valueOf(0));
        }
        boolean bl2 = this.chboxMemoryUsageEnable.isSelected();
        spaceConfig.setEngineMemoryUsageEnabled(String.valueOf(bl2));
        if (bl2) {
            float f2 = this.txtfHighWatermarkPercentage.getValueFloat();
            float f3 = this.txtfLowWatermarkPercentage.getValueFloat();
            float f4 = this.txtfWriteOnlyBlockPercentage.getValueFloat();
            float f5 = this.txtfWriteOnlyCheckPercentage.getValueFloat();
            int n2 = this.txtfEvictionBatchSize.getValueInt();
            int n3 = this.txtfMemUsageRetryCount.getValueInt();
            this.verifyMemoryUsageSettings(spaceConfig, f2, f3, f4, f5, n2, n3);
        }
        JSpaceAttributes jSpaceAttributes = this.panDistCache.getConfig();
        spaceConfig.setDCacheConfigName(jSpaceAttributes.getDCacheConfigName());
        spaceConfig.setDCacheProperties(jSpaceAttributes.getDCacheProperties());
        string3 = this.txtfJmsRMIPort.getText().trim();
        string2 = this.txtfJmsTopicNames.getText().trim();
        object = this.txtfJmsQueueNames.getText().trim();
        spaceConfig.setJMSRmiPort(string3);
        spaceConfig.setJMSTopicNames(string2);
        spaceConfig.setJMSQueueNames((String)object);
        String string6 = "";
        if (this.chboxExtendedIndexing.isSelected()) {
            string6 = "*";
        }
        spaceConfig.setEngineExtendedMatchClasses(string6);
        return spaceConfig;
    }

    private boolean verifyMemoryUsageSettings(JSpaceAttributes jSpaceAttributes, float f2, float f3, float f4, float f5, int n2, int n3) throws SpaceConfigException {
        if (f2 > 0.0f) {
            if (!(f2 <= 100.0f)) {
                throw new SpaceConfigException("The High Watermark Percentage must be less or equals to 100.");
            }
        } else {
            throw new SpaceConfigException("Wrong High Watermark Percentage value.");
        }
        jSpaceAttributes.setEngineMemoryUsageHighPercentageRatio(String.valueOf(f2));
        if (f4 >= f5) {
            if (!(f4 <= f2)) {
                throw new SpaceConfigException("Define <Write Only Block Percentage> less or equals than <High Watermark>");
            }
        } else {
            throw new SpaceConfigException("Wrong Write Only Block Percentage value.");
        }
        jSpaceAttributes.setEngineMemoryUsageWriteOnlyBlockPercentageRatio(String.valueOf(f4));
        if (f5 >= f3) {
            if (!(f5 <= f4)) {
                throw new SpaceConfigException("Define <Write Only Check Percentage> less or equals than <Write Only Block Percentage>");
            }
        } else {
            throw new SpaceConfigException("Wrong Write Only Check Percentage value.");
        }
        jSpaceAttributes.setEngineMemoryWriteOnlyCheckPercentageRatio(String.valueOf(f5));
        if (f3 >= 0.0f) {
            if (!(f3 <= f5)) {
                throw new SpaceConfigException("Define <Low Watermark Percentage> less or equals than <Write Only Check Percentage>");
            }
        } else {
            throw new SpaceConfigException("Wrong Low Watermark Percentage value.");
        }
        jSpaceAttributes.setEngineMemoryUsageLowPercentageRatio(String.valueOf(f3));
        if (n2 <= 0) {
            throw new SpaceConfigException("Wrong Eviction Batch Size value.");
        }
        jSpaceAttributes.setEngineMemoryUsageEvictionBatchSize(String.valueOf(n2));
        if (n3 < 1) {
            throw new SpaceConfigException("Wrong Retry Count value.");
        }
        jSpaceAttributes.setEngineMemoryUsageRetryCount(String.valueOf(n3));
        return true;
    }

    public void cleanup() {
        JSpaceUtilities.cleanAWTContainer(this);
        this.setFirstEnableComponentsMode();
        if (this.m_filterDialog != null) {
            this.m_filterDialog.setDefaultFilterConfig(this.m_defaultFilterUserInfo);
            this.m_filterDialog.setDefaultSecurFilterEnabled(false);
        }
    }

    public void setPersistenceTabEnabled(boolean bl2, boolean bl3) {
        this.tabbedPanel.setEnabledAt(2, bl2);
        if (bl2 && bl3) {
            this.tabbedPanel.setSelectedIndex(2);
        } else if (!bl2 && this.tabbedPanel.getSelectedIndex() == 2) {
            this.tabbedPanel.setSelectedIndex(0);
        }
    }

    public void setClusterTabEnabled(boolean bl2, boolean bl3) {
        this.tabbedPanel.setEnabledAt(3, bl2);
        this.tabbedPanel.setEnabledAt(6, !bl2);
        if (bl2 && bl3) {
            this.tabbedPanel.setSelectedIndex(3);
        } else if (!bl2 && this.tabbedPanel.getSelectedIndex() == 3) {
            this.tabbedPanel.setSelectedIndex(0);
        }
    }

    public void setDCacheTabEnabled(boolean bl2, boolean bl3) {
        this.tabbedPanel.setEnabledAt(6, bl2);
        if (bl2 && bl3) {
            this.tabbedPanel.setSelectedIndex(6);
        } else if (!bl2 && this.tabbedPanel.getSelectedIndex() == 6) {
            this.tabbedPanel.setSelectedIndex(0);
        }
    }

    public void setGenericPrincipal(GenericPrincipal[] genericPrincipalArray) {
        this.m_defaultFilterUserInfo = genericPrincipalArray;
    }

    public void setUserDefinedRoles(UserDefinedRole[] userDefinedRoleArray) {
        if (this.m_filterDialog != null) {
            this.m_filterDialog.setUserDefinedRoles(userDefinedRoleArray);
        }
    }

    public SortFiltersDialog getFiltersDialog() {
        return this.m_filterDialog;
    }

    public IJSpace getSpaceProxy() {
        return this.m_owner.getSpaceProxy();
    }

    private void setFirstEnableComponentsMode() {
        this.cmboxSerialType.setSelectedItem(this.comboItemFullSerialization);
        this.rbutCachePolicyLRU.setSelected(true);
        this.rbutSpaceProtocolNIO.setSelected(true);
        this.butEditSpaceFilters.setEnabled(this.chboxSpaceFilters.isSelected());
        JSpaceUtilities.setAWTComponentsStatus(this.panMemoryUsage, false);
        this.chboxMemoryUsageEnable.setEnabled(true);
        this.cmboxSAClass.setEnabled(this.m_isCreateMode);
        this.cmboxSAUrl.setEnabled(this.m_isCreateMode);
        this.setMemoryManagementCompEnabled(this.rbutCachePolicyLRU.isSelected());
        this.butEditUserPermis.setEnabled(this.chboxUserPermis.isSelected());
        JSpaceUtilities.setAWTComponentsStatus(this.panSSLOptions, this.chboxSSLEncryption.isSelected());
        this.setPersistenceTabEnabled(false, false);
        this.setClusterTabEnabled(false, false);
        this.chboxUserPermis.setEnabled(!this.m_isCreateMode);
    }

    public void setModelForSAComboxBoxes(ComboBoxModel comboBoxModel, ComboBoxModel comboBoxModel2) {
        this.cmboxSAClass.setModel(comboBoxModel);
        this.cmboxSAUrl.setModel(comboBoxModel2);
        if (comboBoxModel.getSize() > 0) {
            this.cmboxSAClass.setSelectedItem(comboBoxModel.getElementAt(0));
        }
        if (comboBoxModel2.getSize() > 0) {
            this.cmboxSAUrl.setSelectedItem(comboBoxModel2.getElementAt(0));
        }
    }

    public void setUserPermissionEnabled(boolean bl2) {
        if (this.m_isCreateMode) {
            return;
        }
        this.chboxUserPermis.setSelected(bl2);
        this.butEditUserPermis.setEnabled(bl2);
    }

    public void setAdminPass(String string) {
        this.adminPass = string;
    }

    public String getAdminPass() {
        return this.adminPass;
    }

    public void copySettingsTo(SpaceConfigStandardPanel spaceConfigStandardPanel) {
        if (this.m_isCreateMode) {
            this.m_owner.updateComboBoxModel(this.cmboxSAClass);
            this.m_owner.updateComboBoxModel(this.cmboxSAUrl);
        }
        spaceConfigStandardPanel.cmboxClusterConfigURL.getEditor().setItem(this.cmboxClusterConfigURL.getEditor().getItem());
        this.m_owner.updateComboBoxModel(this.cmboxClusterConfigURL);
    }

    public void setCurContainerName(String string) {
        this.m_filterDialog.setCurContainerName(string);
    }

    public void updateSettings(SpaceConfig spaceConfig, boolean bl2) {
        this.curSpaceConfig = spaceConfig;
        this.txtfConnectionRetries.setText(String.valueOf(spaceConfig.getConnectionRetries()));
        this.txtfNotifyRetries.setText(String.valueOf(spaceConfig.getNotifyRetries()));
        this.txtfExpTimeInterval.setText(String.valueOf(spaceConfig.getExpirationTimeInterval()));
        this.txtfSpacePort.setText(String.valueOf(spaceConfig.getLRMIServerPort()));
        this.txtfClientSocketPort.setText(String.valueOf(spaceConfig.getLRMIClientPort()));
        String string = spaceConfig.getLRMIProtocolName();
        if (string.equals("RMI")) {
            this.rbutSpaceProtocolRMI.setSelected(true);
            this.chboxMultiplexConnection.setVisible(false);
        } else if (string.equals("NIO")) {
            this.rbutSpaceProtocolNIO.setSelected(true);
            this.chboxMultiplexConnection.setVisible(true);
            this.chboxMultiplexConnection.setSelected(spaceConfig.isLRMIMultiplexConnection());
        }
        boolean bl3 = false;
        if (spaceConfig.getFiltersInfo() != null && spaceConfig.getFiltersInfo().length > 0) {
            boolean bl4 = bl3 = spaceConfig.getFiltersInfo().length > 1;
            if (this.m_filterDialog != null) {
                this.m_filterDialog.addFiltersInfo(spaceConfig.getFiltersInfo());
            }
        }
        this.chboxSpaceFilters.setSelected(bl3);
        this.butEditSpaceFilters.setEnabled(bl3);
        switch (spaceConfig.getSerializationType()) {
            case 0: {
                this.cmboxSerialType.setSelectedItem(this.comboItemNativeSerialization);
                break;
            }
            case 2: {
                this.cmboxSerialType.setSelectedItem(this.comboItemFullSerialization);
                break;
            }
            case 3: {
                this.cmboxSerialType.setSelectedItem(this.comboItemCompressedSerialization);
                break;
            }
            case 1: {
                this.cmboxSerialType.setSelectedItem(this.comboItemLightSerialization);
                break;
            }
            default: {
                this.cmboxSerialType.setSelectedItem(this.comboItemFullSerialization);
            }
        }
        this.txtfMinThreads.setText(String.valueOf(spaceConfig.getEngineMinThreads()));
        this.txtfMaxThreads.setText(String.valueOf(spaceConfig.getEngineMaxThreads()));
        this.txtfNumOfImplicitIndexes.setText(String.valueOf(spaceConfig.getNumberImplicitIndexes()));
        this.setPersistenceTabEnabled(spaceConfig.isPersistent() ? !bl2 : false, false);
        this.initPersistenceSettings(spaceConfig);
        Object object = null;
        object = spaceConfig.getStorageAdapterClass() != null ? spaceConfig.getStorageAdapterClass() : (this.cmboxSAClass.getModel().getSize() > 0 ? this.cmboxSAClass.getSelectedItem() : "");
        this.cmboxSAClass.getEditor().setItem(object);
        object = spaceConfig.getStorageAdapterURL() != null ? spaceConfig.getStorageAdapterURL() : (this.cmboxSAUrl.getModel().getSize() > 0 ? this.cmboxSAUrl.getSelectedItem() : "");
        this.cmboxSAUrl.getEditor().setItem(object);
        if (((DefaultComboBoxModel)this.cmboxSAUrl.getModel()).getIndexOf(object) < 0) {
            this.cmboxSAUrl.addItem(object);
        }
        this.cmboxSAUrl.setSelectedItem(object);
        this.txtfSAInitConnections.setText(String.valueOf(spaceConfig.getInitSAConnections()));
        this.txtfSAMaxConnections.setText(String.valueOf(spaceConfig.getMaxSAConnections()));
        this.chboxSAResetOnFailure.setSelected(spaceConfig.isResetOnFailure());
        this.cmboxClusterConfigURL.getEditor().setItem(spaceConfig.getClusterConfigURL());
        this.setClusterTabEnabled(spaceConfig.isClustered(), false);
        boolean bl5 = this.m_filterDialog.isDefaultSecurFilterEnabled();
        this.chboxUserPermis.setSelected(bl5);
        boolean bl6 = Boolean.valueOf(spaceConfig.isSSLEnabled());
        this.chboxSSLEncryption.setSelected(bl6);
        if (bl6) {
            this.txtfSSLStubHandler.setText(spaceConfig.getStubHandler());
        } else {
            this.txtfSSLStubHandler.setText(Constants.SSLStubHandler.SSL_STUB_HANDLER_CLASS_DEFAULT);
        }
        this.txtfSSLKeyStore.setText(spaceConfig.getSSLKeyStore());
        this.txtfSSLTrustStore.setText(spaceConfig.getSSLTrustStore());
        String string2 = spaceConfig.getSSLPassword();
        this.txtfSSLPassword.setText(string2);
        this.txtfSSLPassConfirm.setText(string2);
        this.setUserPermissionEnabled(bl5);
        JSpaceUtilities.setAWTComponentsStatus(this.panSSLOptions, bl6);
        this.txtfCacheSize.setText(String.valueOf(spaceConfig.getCacheManagerSize()));
        int n2 = Integer.parseInt(spaceConfig.getCachePolicy());
        if (n2 == 1) {
            this.rbutCachePolicyAllCache.setSelected(true);
            this.setMemoryManagementCompEnabled(false);
        } else if (n2 == 0) {
            this.rbutCachePolicyLRU.setSelected(true);
            this.setMemoryManagementCompEnabled(true);
        }
        boolean bl7 = Boolean.valueOf(spaceConfig.isEngineMemoryUsageEnabled());
        this.chboxMemoryUsageEnable.setSelected(bl7);
        this.txtfHighWatermarkPercentage.setText(String.valueOf(spaceConfig.getEngineMemoryUsageHighPercentageRatio()));
        this.txtfLowWatermarkPercentage.setText(String.valueOf(spaceConfig.getEngineMemoryUsageLowPercentageRatio()));
        this.txtfWriteOnlyBlockPercentage.setText(String.valueOf(spaceConfig.getEngineMemoryUsageWriteOnlyBlockPercentageRatio()));
        this.txtfWriteOnlyCheckPercentage.setText(String.valueOf(spaceConfig.getEngineMemoryWriteOnlyCheckPercentageRatio()));
        this.txtfEvictionBatchSize.setText(String.valueOf(spaceConfig.getEngineMemoryUsageEvictionBatchSize()));
        this.txtfMemUsageRetryCount.setText(String.valueOf(spaceConfig.getEngineMemoryUsageRetryCount()));
        JSpaceUtilities.setAWTComponentsStatus(this.panMemoryUsage, bl7);
        this.chboxMemoryUsageEnable.setEnabled(true);
        if (spaceConfig.getDCacheProperties() != null) {
            this.panDistCache.setConfig(spaceConfig);
        } else {
            this.panDistCache.setConfig(this.m_owner.m_defaultSpaceConfig);
        }
        this.setDCacheTabEnabled(!spaceConfig.isClustered(), false);
        String string3 = spaceConfig.getJMSRmiPort();
        String string4 = spaceConfig.getJMSTopicNames();
        String string5 = spaceConfig.getJMSQueueNames();
        this.txtfJmsRMIPort.setText(string3);
        this.txtfJmsTopicNames.setText(string4);
        this.txtfJmsQueueNames.setText(string5);
        String string6 = spaceConfig.getEngineExtendedMatchClasses();
        this.chboxExtendedIndexing.setSelected(string6.equals("*"));
    }

    private void initPersistenceSettings(SpaceConfig spaceConfig) {
        this.numberSyncObjectsField.setText(String.valueOf(spaceConfig.getNumberSyncObjects()));
        this.checkPointPeriodField.setText(String.valueOf(spaceConfig.getCheckPointPeriod()));
        int n2 = spaceConfig.getPagePoolSize();
        switch (n2 / 1024) {
            case 4: {
                this.pagePoolSizeComboBox.setSelectedItem(this.poolSizeWrapper4KB);
                break;
            }
            case 16: {
                this.pagePoolSizeComboBox.setSelectedItem(this.poolSizeWrapper16KB);
                break;
            }
            case 32: {
                this.pagePoolSizeComboBox.setSelectedItem(this.poolSizeWrapper32KB);
                break;
            }
            case 64: {
                this.pagePoolSizeComboBox.setSelectedItem(this.poolSizeWrapper64KB);
                break;
            }
            default: {
                this.pagePoolSizeComboBox.setSelectedItem(this.poolSizeWrapper4KB);
            }
        }
        this.adapterTypeField.setText(spaceConfig.getAdapterType());
        this.dbNameField.setText(spaceConfig.getDbName());
        this.dbUserPasswordField.setText(spaceConfig.getDbPassword());
        this.dbUserNameField.setText(spaceConfig.getDbUserName());
        this.syncOnCommitCB.setSelected(spaceConfig.isSyncOnCommit());
    }

    private void jbInit() throws Exception {
        this.labNumOfImplicitIndexes.setText("Number Of Implicit Indexes:");
        this.labMaxTheads.setText("Maximum Threads:");
        this.rbutCachePolicyLRU.setText("LRU");
        this.labSSLPassConfirm.setText("Confirm Password:");
        this.labMinThreads.setText("Minimum Threads:");
        this.labExpTimeInterval.setText("Expiration Time Interval:");
        this.labSSLStubHandler.setText("Stub Handler:");
        this.labSSLTrustStore.setText("TrustStore:");
        this.labClusterConfigURL.setText("Cluster Config URL:");
        this.labSSLKeyStore.setText("KeyStore:");
        this.chboxSpaceFilters.setText("Space Filters");
        this.labCachePolicy.setText("Cache Policy:");
        this.labSAInitConnections.setText("Init Connections:");
        this.chboxSSLEncryption.setText("SSL Encryption");
        this.butEditUserPermis.setText("Edit...");
        this.labSAClass.setText("Storage Adapter Class:");
        this.rbutCachePolicyAllCache.setText("All In Cache");
        this.labSAMaxConnections.setText("Max SA Connections:");
        this.chboxUserPermis.setText("User Permissions");
        this.labSSLPort.setText("Port:");
        this.labCacheSize.setText("Cache Size:");
        this.labSSLPassword.setText("Password:");
        this.labSAUrl.setText("Storage Adapter URL:");
        this.butEditSpaceFilters.setText("Edit...");
        this.butEditClusterConfigURL.setText("...");
        this.labSerializationType.setText("Serialization Type:");
        this.labConnectionRetries.setText("Connection Retries (Client):");
        this.labNotifyRetries.setText("Notify Retries (Server):");
        this.labSpacePort.setText("Space Port:");
        this.rbutSpaceProtocolRMI.setText("RMI");
        this.rbutSpaceProtocolNIO.setText("NIO");
        this.labHighWatermarkPercentage.setText("High Watermark Percentage:");
        this.labLowWatermarkPercentage.setText("Low Watermark Percentage:");
        this.labWriteOnlyBlockPercentage.setText("Write Only Block Percentage:");
        this.labWriteOnlyCheckPercentage.setText("Write Only Check Percentage:");
        this.labMemUsageRetryCount.setText("Retry count:");
        this.chboxMemoryUsageEnable.setText("Enabled");
        this.chboxSAResetOnFailure.setText("Auto Reset on Failure");
        this.labEvictionBatchSize.setText("LRU Eviction Batch Size:");
        this.labJmsRMIPort.setText("RMI Port:");
        this.labJmsQueueNames.setText("Administrated Queue Names:");
        this.labJmsTopicNames.setText("Administrated Topic Names:");
        this.chboxExtendedIndexing.setText("Extended Indexing Enabled");
        this.cmboxSAUrl.setEditable(true);
        this.cmboxSAClass.setEditable(true);
        this.cmboxClusterConfigURL.setEditable(true);
        this.panGeneral.setLayout(this.gridBagLayout1);
        this.panSecurity.setLayout(this.gridBagLayout2);
        this.panPerformance.setLayout(this.gridBagLayout3);
        this.panCacheManager.setLayout(this.gridBagLayout4);
        this.panSA.setLayout(this.gridBagLayout5);
        this.panEntryMatching.setLayout(this.gridBagLayout6);
        this.panEngine.setLayout(this.gridBagLayout7);
        this.panCluster.setLayout(this.gridBagLayout8);
        this.panSSLOptions.setLayout(this.gridBagLayout11);
        this.panPersistence.setLayout(this.gridBagLayout12);
        this.panLeaseManager.setLayout(this.gridBagLayout14);
        this.panMemoryUsage.setLayout(this.gridBagLayout18);
        this.panMemory.setLayout(this.gridBagLayout19);
        this.panJms.setLayout(this.gridBagLayout20);
        this.panCacheManager.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), "Cache Manager"), BorderFactory.createEmptyBorder(5, 2, 5, 2)));
        this.panSA.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), "Storage Adapter"), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.panEntryMatching.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), "Indexing"), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.panEngine.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), "Engine Scalability"), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.panSSLOptions.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), "SSL Options"), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.panLeaseManager.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), "Lease Manager"), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.panMemoryUsage.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), "Memory Usage Control"), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.scrollPanSecurity.getViewport().add((Component)this.panSecCenter, null);
        this.panSecCenter.add((Component)this.panSecurity, "North");
        this.panSecurity.add((Component)this.chboxUserPermis, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.panSecurity.add((Component)this.butEditUserPermis, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, -2));
        this.panSecurity.add((Component)this.chboxSSLEncryption, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.panSecurity.add((Component)this.panSSLOptions, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 1, 0));
        this.panSSLOptions.add((Component)this.labSSLStubHandler, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 5), 0, 0));
        this.panSSLOptions.add((Component)this.txtfSSLStubHandler, new GridBagConstraints(1, 0, 5, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 0), 1, 0));
        this.panSSLOptions.add((Component)this.labSSLKeyStore, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 5), 0, 0));
        this.panSSLOptions.add((Component)this.txtfSSLKeyStore, new GridBagConstraints(1, 2, 5, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 0), 1, 0));
        this.panSSLOptions.add((Component)this.labSSLTrustStore, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 5), 0, 0));
        this.panSSLOptions.add((Component)this.txtfSSLTrustStore, new GridBagConstraints(1, 3, 5, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 0), 1, 0));
        this.panSSLOptions.add((Component)this.labSSLPassword, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 5), 0, 0));
        this.panSSLOptions.add((Component)this.txtfSSLPassword, new GridBagConstraints(3, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 0), 1, 0));
        this.panSSLOptions.add((Component)this.labSSLPassConfirm, new GridBagConstraints(4, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 0), 0, 0));
        this.panSSLOptions.add((Component)this.txtfSSLPassConfirm, new GridBagConstraints(5, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 0), 1, 0));
        this.scrollPanCluster.getViewport().add((Component)this.panClusterCenter, null);
        this.panClusterCenter.add((Component)this.panCluster, "North");
        this.panCluster.add((Component)this.labClusterConfigURL, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 2, 2), 0, 0));
        this.panCluster.add((Component)this.butEditClusterConfigURL, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 2, 5), -9, -4));
        this.panCluster.add((Component)this.cmboxClusterConfigURL, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 2, 2, 2), 1, -3));
        this.scrollPanPersistence.getViewport().add((Component)this.panPersCenter, null);
        this.panPersCenter.add((Component)this.panPersistence, "North");
        this.panCacheManager.add((Component)this.labCacheSize, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 5), 0, 0));
        this.panCacheManager.add((Component)this.txtfCacheSize, new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 1, 0));
        this.panCacheManager.add((Component)this.labCachePolicy, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 5), 0, 0));
        this.panCacheManager.add((Component)this.rbutCachePolicyLRU, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
        this.panCacheManager.add((Component)this.rbutCachePolicyAllCache, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.panPersistence.add((Component)this.panSA, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 2, 2, 2), 1, 0));
        this.createPersistenceFields();
        this.scrollPanPerformance.getViewport().add((Component)this.panPerformCenter, null);
        this.panPerformCenter.add((Component)this.panPerformance, "North");
        this.panPerformance.add((Component)this.panEngine, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 11, 2, new Insets(2, 2, 2, 2), 1, 0));
        this.panEngine.add((Component)this.labMinThreads, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 5), 0, 0));
        this.panEngine.add((Component)this.txtfMinThreads, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 1, 0));
        this.panEngine.add((Component)this.labMaxTheads, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 5), 0, 0));
        this.panEngine.add((Component)this.txtfMaxThreads, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 1, 0));
        JPanel jPanel = this.createSerializationPanel();
        this.panPerformance.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 1, 0));
        this.panPerformance.add((Component)this.panEntryMatching, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 1, 0));
        this.panEntryMatching.add((Component)this.labNumOfImplicitIndexes, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 5), 0, 0));
        this.panEntryMatching.add((Component)this.txtfNumOfImplicitIndexes, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 1, 0));
        this.panEntryMatching.add((Component)this.chboxExtendedIndexing, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 2, new Insets(2, 0, 2, 0), 0, 0));
        this.scrollPanGeneral.getViewport().add((Component)this.panGenCenter, null);
        this.panGenCenter.add((Component)this.panGeneral, "North");
        this.panGeneral.add((Component)this.labConnectionRetries, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 2, 2), 0, 0));
        this.panGeneral.add((Component)this.txtfConnectionRetries, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 2, 2, 4), 1, 0));
        this.panGeneral.add((Component)this.chboxSpaceFilters, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.panGeneral.add((Component)new JLabel(""), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.panGeneral.add((Component)this.labNotifyRetries, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 2), 0, 0));
        this.panGeneral.add((Component)this.txtfNotifyRetries, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 4), 0, 0));
        this.panGeneral.add((Component)this.butEditSpaceFilters, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, -2));
        this.panGeneral.add((Component)new JLabel(""), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, -2));
        this.panGeneral.add((Component)this.panLeaseManager, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 0, 2), 1, 0));
        JPanel jPanel2 = this.createSpaceProtocolPanel();
        this.panGeneral.add((Component)jPanel2, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 0, 2), 1, 0));
        this.panLeaseManager.add((Component)this.labExpTimeInterval, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 5), 0, 0));
        this.panLeaseManager.add((Component)this.txtfExpTimeInterval, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 0), 1, 0));
        this.panMemoryUsage.add((Component)this.chboxMemoryUsageEnable, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 0), 0, 0));
        this.panMemoryUsage.add((Component)this.labHighWatermarkPercentage, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.panMemoryUsage.add((Component)this.txtfHighWatermarkPercentage, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.panMemoryUsage.add((Component)this.labLowWatermarkPercentage, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.panMemoryUsage.add((Component)this.txtfLowWatermarkPercentage, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.panMemoryUsage.add((Component)this.labWriteOnlyBlockPercentage, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.panMemoryUsage.add((Component)this.txtfWriteOnlyBlockPercentage, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.panMemoryUsage.add((Component)this.labWriteOnlyCheckPercentage, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.panMemoryUsage.add((Component)this.txtfWriteOnlyCheckPercentage, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.panMemoryUsage.add((Component)this.labEvictionBatchSize, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.panMemoryUsage.add((Component)this.txtfEvictionBatchSize, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.panMemoryUsage.add((Component)this.labMemUsageRetryCount, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.panMemoryUsage.add((Component)this.txtfMemUsageRetryCount, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.scrollPanMemory.getViewport().add((Component)this.panMemCenter, null);
        this.panMemCenter.add((Component)this.panMemory, "North");
        this.panMemory.add((Component)this.panCacheManager, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 1, 0));
        this.panMemory.add((Component)this.panMemoryUsage, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 1, 0));
        this.scrollPanDCache.getViewport().add((Component)this.panDistCacheCenter, null);
        this.panDistCacheCenter.add((Component)this.panDistCache, "North");
        this.scrollPanJms.getViewport().add((Component)this.panJmsCenter, null);
        this.panJmsCenter.add((Component)this.panJms, "North");
        this.panJms.add((Component)this.labJmsRMIPort, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.panJms.add((Component)this.labJmsTopicNames, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.panJms.add((Component)this.labJmsQueueNames, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.panJms.add((Component)this.txtfJmsRMIPort, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.panJms.add((Component)this.txtfJmsTopicNames, new GridBagConstraints(0, 7, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.panJms.add((Component)this.txtfJmsQueueNames, new GridBagConstraints(0, 9, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.tabbedPanel.add((Component)this.scrollPanGeneral, "General");
        this.tabbedPanel.add((Component)this.scrollPanPerformance, "Performance");
        this.tabbedPanel.add((Component)this.scrollPanPersistence, "Persistence");
        this.tabbedPanel.add((Component)this.scrollPanCluster, "Cluster");
        this.tabbedPanel.add((Component)this.scrollPanSecurity, "Security");
        this.tabbedPanel.add((Component)this.scrollPanMemory, "Memory Management");
        this.tabbedPanel.add((Component)this.scrollPanDCache, "Master-Local Cache");
        this.tabbedPanel.add((Component)this.scrollPanJms, "JMS");
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPanel, "Center");
    }

    private void createPersistenceFields() {
        this.panSA.add((Component)this.labSAClass, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 14, 0, new Insets(2, 2, 2, 5), 0, 0));
        this.panSA.add((Component)this.cmboxSAClass, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 1, -3));
        this.panSA.add((Component)this.labSAUrl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 5), 0, 0));
        this.panSA.add((Component)this.cmboxSAUrl, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 1, -3));
        this.panSA.add((Component)this.labSAInitConnections, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 5), 0, 0));
        this.panSA.add((Component)this.txtfSAInitConnections, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 1, 0));
        this.panSA.add((Component)this.labSAMaxConnections, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 5), 0, 0));
        this.panSA.add((Component)this.txtfSAMaxConnections, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 1, 0));
        this.panSA.add((Component)this.chboxSAResetOnFailure, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 1, 0));
        JLabel jLabel = new JLabel("Adapter Type:");
        JLabel jLabel2 = new JLabel("Database Name:");
        JLabel jLabel3 = new JLabel("User Name:");
        JLabel jLabel4 = new JLabel("User Password:");
        JLabel jLabel5 = new JLabel("Number Sync Objects:");
        JLabel jLabel6 = new JLabel("Check Point Period:");
        JLabel jLabel7 = new JLabel("Page Pool Size:");
        PoolSizeWrapper[] poolSizeWrapperArray = new PoolSizeWrapper[]{this.poolSizeWrapper4KB, this.poolSizeWrapper16KB, this.poolSizeWrapper32KB, this.poolSizeWrapper64KB};
        DefaultComboBoxModel<PoolSizeWrapper> defaultComboBoxModel = new DefaultComboBoxModel<PoolSizeWrapper>(poolSizeWrapperArray);
        this.pagePoolSizeComboBox = new JComboBox<PoolSizeWrapper>(defaultComboBoxModel);
        this.panSA.add((Component)this.syncOnCommitCB, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 1, 0));
        this.panSA.add((Component)jLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 5), 0, 0));
        this.panSA.add((Component)this.adapterTypeField, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 1, 0));
        this.panSA.add((Component)jLabel2, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 5), 0, 0));
        this.panSA.add((Component)this.dbNameField, new GridBagConstraints(1, 7, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 1, 0));
        this.panSA.add((Component)jLabel3, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 5), 0, 0));
        this.panSA.add((Component)this.dbUserNameField, new GridBagConstraints(1, 8, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 1, 0));
        this.panSA.add((Component)jLabel4, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 5), 0, 0));
        this.panSA.add((Component)this.dbUserPasswordField, new GridBagConstraints(1, 9, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 1, 0));
        this.panSA.add((Component)jLabel5, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 5), 0, 0));
        this.panSA.add((Component)this.numberSyncObjectsField, new GridBagConstraints(1, 10, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 1, 0));
        this.panSA.add((Component)jLabel6, new GridBagConstraints(0, 11, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 5), 0, 0));
        this.panSA.add((Component)this.checkPointPeriodField, new GridBagConstraints(1, 11, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 1, 0));
        this.panSA.add((Component)jLabel7, new GridBagConstraints(0, 12, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 5), 0, 0));
        this.panSA.add((Component)this.pagePoolSizeComboBox, new GridBagConstraints(1, 12, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 570), 1, 0));
    }

    private JPanel createSpaceProtocolPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), "Space Protocol"), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        jPanel.add((Component)this.rbutSpaceProtocolRMI, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.rbutSpaceProtocolNIO, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.chboxMultiplexConnection, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        jPanel.add((Component)this.labSpacePort, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 5), 0, 0));
        jPanel.add((Component)this.txtfSpacePort, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 0), 0, 0));
        JLabel jLabel = new JLabel("Client Socket Port:");
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 5), 0, 0));
        jPanel.add((Component)this.txtfClientSocketPort, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 0), 0, 0));
        return jPanel;
    }

    private JPanel createSerializationPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), "Serialization Performance"), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        Dimension dimension = new Dimension(160, 23);
        this.cmboxSerialType.setPreferredSize(dimension);
        this.cmboxSerialType.setMaximumSize(dimension);
        this.initSerializationCombo();
        jPanel.add(Box.createHorizontalStrut(2));
        jPanel.add(this.labSerializationType);
        jPanel.add(Box.createHorizontalStrut(2));
        jPanel.add(this.cmboxSerialType);
        jPanel.add(Box.createHorizontalGlue());
        return jPanel;
    }

    private void initSerializationCombo() {
        this.comboItemNativeSerialization = new ComboItemWrapper("Native Serialization", 0);
        this.comboItemLightSerialization = new ComboItemWrapper("Light Serialization", 1);
        this.comboItemFullSerialization = new ComboItemWrapper("Full Serialization", 2);
        this.comboItemCompressedSerialization = new ComboItemWrapper("Compressed Serialization", 3);
        this.cmboxSerialType.addItem(this.comboItemNativeSerialization);
        this.cmboxSerialType.addItem(this.comboItemLightSerialization);
        this.cmboxSerialType.addItem(this.comboItemFullSerialization);
        this.cmboxSerialType.addItem(this.comboItemCompressedSerialization);
    }

    private class PoolSizeWrapper {
        private String suffix = " ( KB )";
        private int poolSize;
        private String description;

        public PoolSizeWrapper(int n2) {
            this.description = n2 + this.suffix;
            this.poolSize = n2 * 1024;
        }

        public String toString() {
            return this.description;
        }

        public int getPoolSize() {
            return this.poolSize;
        }
    }

    private class CustomComboBoxEditor
    extends BasicComboBoxEditor {
        private CustomComboBoxEditor() {
        }

        public void setItem(Object object) {
            try {
                super.setItem(object);
            }
            catch (RuntimeException runtimeException) {
                super.setItem(object);
            }
        }

        public /* synthetic */ CustomComboBoxEditor(1 var2_2) {
            this();
        }
    }

    private class ButtonGroupMapping
    extends ButtonGroup {
        private Hashtable componentsMap = new Hashtable();

        private ButtonGroupMapping() {
        }

        public void add(String string, AbstractButton abstractButton) {
            this.add(abstractButton);
            this.componentsMap.put(string, abstractButton.getModel());
            this.componentsMap.put(abstractButton.getModel(), string);
        }

        public void setSelection(String string) {
            this.setSelected((ButtonModel)this.componentsMap.get(string), true);
        }

        public String getSelectedContent() {
            return (String)this.componentsMap.get(this.getSelection());
        }

        public /* synthetic */ ButtonGroupMapping(1 var2_2) {
            this();
        }
    }
}

