/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.cluster;

import com.j_spaces.core.cluster.ClusterXML;
import com.j_spaces.core.cluster.ReplicationTransmissionPolicy;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.cluster.ClusterMemberInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TransmissionMatrixDlg
extends JDialog {
    private Component m_owner;
    private JTabbedPane m_panTabbed;
    private MatrixPanel m_panMatrix;
    private FiltRecPanel m_panFiltRec;
    private ButtonsPanel m_panButtons;
    private int m_matrixSize;
    private DefaultListModel m_groupListModel;
    private JList m_groupList;
    private HashSet m_groupMembersSet;
    private static final int LABEL_MAX_LENGTH = 45;
    private static final String DEFAULT_IN_OUT_FILTER = "com.j_spaces.core.cluster.DefaultReplicationFilter";
    private boolean m_groupSyncOnCommit;
    private String m_groupReplicationMode;
    private String m_groupCommunicationMode;
    private boolean m_groupRecovery;
    private String m_defOperations;
    private DefaultListModel backupGroupListModel;
    private static Logger _logger = Logger.getLogger("com.gigaspaces.ui.cluster.view");

    public TransmissionMatrixDlg(JDialog jDialog, String string, boolean bl2, DefaultListModel defaultListModel, boolean bl3, String string2, String string3, boolean bl4) {
        super(jDialog, string, bl2);
        this.m_owner = jDialog;
        this.m_groupSyncOnCommit = bl3;
        this.m_groupReplicationMode = string2;
        this.m_groupCommunicationMode = string3;
        this.m_groupRecovery = bl4;
        this.m_groupListModel = defaultListModel;
        this.init();
    }

    public TransmissionMatrixDlg(JFrame jFrame, String string, boolean bl2, DefaultListModel defaultListModel, boolean bl3, String string2, String string3, boolean bl4) {
        super(jFrame, string, bl2);
        this.m_owner = jFrame;
        this.m_groupSyncOnCommit = bl3;
        this.m_groupReplicationMode = string2;
        this.m_groupCommunicationMode = string3;
        this.m_groupRecovery = bl4;
        this.m_groupListModel = defaultListModel;
        this.init();
    }

    public MatrixPanel getMatrixPanel() {
        return this.m_panMatrix;
    }

    private void init() {
        block4: {
            try {
                this.m_groupMembersSet = new HashSet();
                for (int i2 = 0; i2 < this.m_groupListModel.size(); ++i2) {
                    this.m_groupMembersSet.add(((ClusterMemberInfo)this.m_groupListModel.get((int)i2)).memberName);
                }
                this.m_matrixSize = this.m_groupListModel.getSize();
                this.m_groupList = new JList(this.m_groupListModel);
                this.m_defOperations = "TWN";
                this.m_panMatrix = new MatrixPanel();
                this.m_panFiltRec = new FiltRecPanel();
                this.m_panButtons = new ButtonsPanel();
                this.m_panTabbed = new JTabbedPane();
                this.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        if (TransmissionMatrixDlg.this.backupGroupListModel != null) {
                            TransmissionMatrixDlg.this.m_groupListModel = TransmissionMatrixDlg.this.backupGroupListModel;
                        }
                        TransmissionMatrixDlg.this.backupGroupListModel = null;
                    }
                });
                this.m_panTabbed.add((Component)this.m_panMatrix, "Replications");
                this.m_panTabbed.add((Component)this.m_panFiltRec, "Filters/Recovery");
                JPanel jPanel = (JPanel)this.getContentPane();
                jPanel.setLayout(new BorderLayout());
                jPanel.add((Component)this.m_panTabbed, "Center");
                jPanel.add((Component)this.m_panButtons, "South");
                this.setDefaultCloseOperation(2);
                Dimension dimension = this.m_panFiltRec.membersList.getSize();
                this.m_panFiltRec.membersList.setPreferredSize(new Dimension(dimension.width + 25, dimension.height));
                this.pack();
                int n2 = 550;
                Dimension dimension2 = this.getSize();
                if (dimension2.width < n2) {
                    this.setSize(new Dimension(n2, dimension2.height));
                }
                this.m_panMatrix.setSplitPosition((int)(0.5 * this.getSize().getWidth()));
                this.backupGroupListModel = this.createBackupList();
                this.pack();
                JSpaceUtilities.setLocationRelativeTo(this, this.m_owner);
            }
            catch (Exception exception) {
                if (!_logger.isLoggable(Level.SEVERE)) break block4;
                _logger.log(Level.SEVERE, exception.toString(), exception);
            }
        }
    }

    private void setAWTComponentsStatus(Container container, boolean bl2) {
        Component component = null;
        int n2 = 0;
        if (container == null || (n2 = container.getComponentCount()) == 0) {
            return;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            component = container.getComponent(i2);
            if (component instanceof Container) {
                this.setAWTComponentsStatus((Container)component, bl2);
            }
            component.setEnabled(bl2);
            if (!(component instanceof JComboBox)) continue;
            component.invalidate();
            component.repaint();
        }
    }

    private void cleanComponents(Container container) {
        Component component = null;
        if (container == null || container.getComponentCount() == 0) {
            return;
        }
        for (int i2 = 0; i2 < container.getComponentCount(); ++i2) {
            component = container.getComponent(i2);
            if (component instanceof Container) {
                this.cleanComponents((Container)component);
            }
            if (component instanceof JTextField) {
                ((JTextField)component).setText("");
            }
            if (!(component instanceof JCheckBox)) continue;
            ((JCheckBox)component).setSelected(false);
        }
    }

    private void checkLengthAndSetText(JLabel jLabel, String string) {
        String string2 = string;
        if (string.length() > 50) {
            string = string.substring(0, 49);
            string = string + "...";
            if (jLabel != null) {
                jLabel.setToolTipText(string2);
            }
        }
        jLabel.setText(string);
    }

    private void resetDataDlg(int n2) {
        switch (n2) {
            case -1: {
                this.resetPoliciesData();
                this.resetFiltersRecoveryData();
                break;
            }
            case 0: {
                this.resetPoliciesData();
                break;
            }
            case 1: {
                this.resetFiltersRecoveryData();
            }
        }
    }

    private void setReplicationPoliciesMode(boolean bl2) {
        Component component = null;
        for (int i2 = 0; i2 < this.m_panMatrix.panTable.getComponentCount(); ++i2) {
            component = this.m_panMatrix.panTable.getComponent(i2);
            if (!(component instanceof JPolicy)) continue;
            JPolicy jPolicy = (JPolicy)component;
            if (jPolicy.state.col == jPolicy.state.row) continue;
            if (jPolicy.policy != null) {
                ((JPolicy)jPolicy).policy.m_DisableTransmission = bl2;
            } else {
                jPolicy.policy = new ReplicationTransmissionPolicy(jPolicy.source, jPolicy.target, this.m_defOperations, this.m_groupSyncOnCommit, bl2);
            }
            jPolicy.state.setSelected(!bl2);
        }
        this.setAWTComponentsStatus(this.m_panMatrix.panProperties, !bl2);
        this.m_panMatrix.panTable.validate();
        this.m_panMatrix.panTable.repaint();
    }

    private void resetPoliciesData() {
        Component component = null;
        for (int i2 = 0; i2 < this.m_panMatrix.panTable.getComponentCount(); ++i2) {
            component = this.m_panMatrix.panTable.getComponent(i2);
            if (!(component instanceof JPolicy)) continue;
            JPolicy jPolicy = (JPolicy)component;
            if (jPolicy.state.col == jPolicy.state.row) continue;
            jPolicy.state.setSelected(true);
            jPolicy.policy = new ReplicationTransmissionPolicy(jPolicy.source, jPolicy.target, this.m_defOperations, this.m_groupSyncOnCommit, false);
        }
        this.cleanComponents(this.m_panMatrix.panProperties);
        this.setAWTComponentsStatus(this.m_panMatrix.panProperties, false);
        if (this.m_panMatrix.lastIndex != 0) {
            this.m_panMatrix.showPolicyProperties((JPolicy)this.m_panMatrix.panTable.getComponent(this.m_panMatrix.lastIndex));
        }
        this.m_panMatrix.panTable.validate();
        this.m_panMatrix.panTable.repaint();
    }

    private void resetFiltersRecoveryData() {
        ClusterMemberInfo clusterMemberInfo = null;
        for (int i2 = 0; i2 < this.m_groupListModel.getSize(); ++i2) {
            clusterMemberInfo = (ClusterMemberInfo)this.m_groupListModel.getElementAt(i2);
            clusterMemberInfo.m_replFilters = null;
            clusterMemberInfo.m_replRecovery = null;
            clusterMemberInfo.m_replTransmissionPolicies = null;
        }
        this.m_panFiltRec.cboxFilters.setSelected(false);
        this.m_panFiltRec.cboxRecovery.setSelected(false);
        this.cleanComponents(this.m_panFiltRec.panFilters);
        this.setAWTComponentsStatus(this.m_panFiltRec.panFilters, false);
        if (this.m_panFiltRec.membersList.isSelectionEmpty()) {
            this.m_panFiltRec.panRecovery.setEnabled(false);
        } else {
            this.m_panFiltRec.panRecovery.setEnabled(this.m_groupRecovery);
            ((FiltRecPanel)this.m_panFiltRec).panRecovery.recovery.setSelected(this.m_groupRecovery);
            ((FiltRecPanel)this.m_panFiltRec).panRecovery.sourceName.setSelectedItem("First available member");
        }
        if (this.m_panFiltRec.membersList.isSelectionEmpty()) {
            this.m_panFiltRec.panRecovery.setEnabled(false);
        } else {
            this.m_panFiltRec.panRecovery.setEnabled(this.m_groupRecovery);
            ((FiltRecPanel)this.m_panFiltRec).panRecovery.recovery.setSelected(this.m_groupRecovery);
            ((FiltRecPanel)this.m_panFiltRec).panRecovery.sourceName.setSelectedItem("First available member");
        }
    }

    private DefaultListModel createBackupList() {
        DefaultListModel<ClusterMemberInfo> defaultListModel = new DefaultListModel<ClusterMemberInfo>();
        for (int i2 = 0; i2 < this.m_matrixSize; ++i2) {
            ClusterMemberInfo clusterMemberInfo = (ClusterMemberInfo)this.m_groupListModel.getElementAt(i2);
            ClusterMemberInfo clusterMemberInfo2 = (ClusterMemberInfo)clusterMemberInfo.clone();
            defaultListModel.add(i2, clusterMemberInfo2);
            ArrayList<ReplicationTransmissionPolicy> arrayList = new ArrayList<ReplicationTransmissionPolicy>();
            for (int i3 = 0; i3 < this.m_matrixSize; ++i3) {
                JPolicy jPolicy = (JPolicy)this.m_panMatrix.panTable.getComponent(i2 * this.m_matrixSize + i3);
                if (i3 == i2) continue;
                ReplicationTransmissionPolicy replicationTransmissionPolicy = (ReplicationTransmissionPolicy)jPolicy.policy.clone();
                arrayList.add(replicationTransmissionPolicy);
            }
            if (arrayList.size() <= 0) continue;
            clusterMemberInfo2.m_replTransmissionPolicies = arrayList;
        }
        return defaultListModel;
    }

    private void saveDataToSourceModel() {
        int n2;
        int n3 = this.m_groupListModel.getSize();
        ClusterMemberInfo clusterMemberInfo = null;
        ArrayList<ReplicationTransmissionPolicy> arrayList = null;
        JPolicy jPolicy = null;
        if (this.m_panMatrix.lastIndex != 0) {
            this.m_panMatrix.savePolicy((JPolicy)this.m_panMatrix.panTable.getComponent(this.m_panMatrix.lastIndex));
        }
        for (n2 = 0; n2 < this.m_matrixSize; ++n2) {
            try {
                clusterMemberInfo = (ClusterMemberInfo)this.m_groupListModel.getElementAt(n2);
                arrayList = new ArrayList<ReplicationTransmissionPolicy>();
                for (int i2 = 0; i2 < this.m_matrixSize; ++i2) {
                    jPolicy = (JPolicy)this.m_panMatrix.panTable.getComponent(n2 * this.m_matrixSize + i2);
                    if (i2 == n2 || jPolicy.isDefault()) continue;
                    arrayList.add(jPolicy.policy);
                }
                if (arrayList.size() > 0) {
                    clusterMemberInfo.m_replTransmissionPolicies = arrayList;
                    continue;
                }
                clusterMemberInfo.m_replTransmissionPolicies = null;
                continue;
            }
            catch (Exception exception) {
                if (!_logger.isLoggable(Level.SEVERE)) continue;
                _logger.log(Level.SEVERE, exception.toString(), exception);
            }
        }
        n2 = this.m_groupList.getSelectedIndex();
        if (n2 != -1) {
            this.m_panFiltRec.saveMemberInfo(n2);
        }
    }

    public DefaultListModel getGroupListModel() {
        return this.m_groupListModel;
    }

    private void restorePolicyFromSourceModel(JPanel jPanel) {
        ClusterMemberInfo clusterMemberInfo = null;
        JPolicy jPolicy = null;
        for (int i2 = 0; i2 < this.m_matrixSize; ++i2) {
            try {
                clusterMemberInfo = (ClusterMemberInfo)this.m_groupListModel.getElementAt(i2);
                if (clusterMemberInfo.m_replTransmissionPolicies == null) continue;
                Iterator iterator = clusterMemberInfo.m_replTransmissionPolicies.iterator();
                while (iterator.hasNext()) {
                    ReplicationTransmissionPolicy replicationTransmissionPolicy = (ReplicationTransmissionPolicy)iterator.next();
                    if (!this.m_groupMembersSet.contains(replicationTransmissionPolicy.m_TargetSpace)) {
                        iterator.remove();
                        continue;
                    }
                    jPolicy = this.findPolicyPanel(jPanel, i2, replicationTransmissionPolicy.m_TargetSpace);
                    if (jPolicy != null) {
                        jPolicy.policy = replicationTransmissionPolicy;
                        jPolicy.state.setSelected(!replicationTransmissionPolicy.m_DisableTransmission);
                    }
                    if (clusterMemberInfo.m_replRecovery == null || clusterMemberInfo.m_replRecovery.recoveryEnabled || this.m_groupRecovery) continue;
                    clusterMemberInfo.m_replRecovery = null;
                }
                continue;
            }
            catch (Exception exception) {
                if (!_logger.isLoggable(Level.SEVERE)) continue;
                _logger.log(Level.SEVERE, exception.toString(), exception);
            }
        }
    }

    private JPolicy findPolicyPanel(JPanel jPanel, int n2, String string) {
        JPolicy jPolicy = null;
        for (int i2 = 0; i2 < this.m_matrixSize; ++i2) {
            jPolicy = (JPolicy)jPanel.getComponent(n2 * this.m_matrixSize + i2);
            if (jPolicy.target.equals(string)) break;
        }
        return jPolicy;
    }

    public class ButtonsPanel
    extends JPanel
    implements ActionListener {
        public JButton butOK = new JButton("OK");
        public JButton butCancel = new JButton("Cancel");
        public JButton butReset = new JButton("Reset");
        public JCheckBox resetAll = new JCheckBox("Reset all dialog data");

        public ButtonsPanel() {
            this.butOK.addActionListener(this);
            this.butCancel.addActionListener(this);
            this.butReset.addActionListener(this);
            JPanel jPanel = new JPanel();
            jPanel.add(this.butOK);
            jPanel.add(this.butCancel);
            JPanel jPanel2 = new JPanel();
            jPanel2.add(this.butReset);
            jPanel2.add(this.resetAll);
            this.setLayout(new BorderLayout());
            this.add((Component)jPanel, "East");
            this.add((Component)jPanel2, "West");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object.equals(this.butOK)) {
                if (((TransmissionMatrixDlg)TransmissionMatrixDlg.this).m_panMatrix.lastIndex != 0 && !TransmissionMatrixDlg.this.m_panMatrix.checkLastPolicyProperties()) {
                    return;
                }
                if (!TransmissionMatrixDlg.this.m_panFiltRec.checkFiltersProperties()) {
                    return;
                }
                TransmissionMatrixDlg.this.saveDataToSourceModel();
                TransmissionMatrixDlg.this.backupGroupListModel = null;
                TransmissionMatrixDlg.this.dispose();
            }
            if (object.equals(this.butCancel)) {
                if (TransmissionMatrixDlg.this.backupGroupListModel != null) {
                    TransmissionMatrixDlg.this.m_groupListModel = TransmissionMatrixDlg.this.backupGroupListModel;
                }
                TransmissionMatrixDlg.this.backupGroupListModel = null;
                TransmissionMatrixDlg.this.dispose();
            }
            if (object.equals(this.butReset)) {
                int n2 = TransmissionMatrixDlg.this.m_panTabbed.getSelectedIndex();
                String string = "all " + TransmissionMatrixDlg.this.m_panTabbed.getTitleAt(n2);
                if (this.resetAll.isSelected()) {
                    string = "all dialog";
                    n2 = -1;
                }
                if (JOptionPane.showConfirmDialog(TransmissionMatrixDlg.this, "Reset " + string + " settings, are you sure?", "Select an option", 0) != 0) {
                    return;
                }
                TransmissionMatrixDlg.this.resetDataDlg(n2);
            }
        }
    }

    private class RecoveryPanel
    extends JPanel {
        public JLabel labelSource = new JLabel("Source Member:");
        public JCheckBox recovery = new JCheckBox("Enabled");
        public JComboBox sourceName;
        public JPanel panCenter = new JPanel();
        public JPanel panWest = new JPanel();
        public Vector vecMembers = new Vector();

        public RecoveryPanel() {
            this.vecMembers.add("First available member");
            for (int i2 = 0; i2 < TransmissionMatrixDlg.this.m_groupListModel.getSize(); ++i2) {
                this.vecMembers.add(TransmissionMatrixDlg.this.m_groupListModel.getElementAt(i2).toString());
            }
            this.sourceName = new JComboBox(this.vecMembers);
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setBorder(new EmptyBorder(2, 2, 2, 2));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(2, 3, 2, 3);
            jPanel.add((Component)this.recovery, gridBagConstraints);
            gridBagConstraints.gridy = 1;
            jPanel.add((Component)this.labelSource, gridBagConstraints);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 1;
            jPanel.add((Component)this.sourceName, gridBagConstraints);
            this.recovery.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    RecoveryPanel.this.setEnabled(RecoveryPanel.this.recovery.isSelected());
                }
            });
            this.setBorder(new TitledBorder("Recovery"));
            this.setLayout(new BorderLayout());
            this.add((Component)jPanel, "North");
        }

        public void setEnabled(boolean bl2) {
            super.setEnabled(bl2);
            this.recovery.setEnabled(true);
            this.labelSource.setEnabled(bl2);
            this.sourceName.setEnabled(bl2);
        }
    }

    private class FiltersPanel
    extends JPanel {
        public JTextField inputClassName = new JTextField();
        public JTextField inputParamURL = new JTextField();
        public JTextField outputClassName = new JTextField();
        public JTextField outputParamURL = new JTextField();
        public JPanel panCenter = new JPanel();
        public JPanel panWest = new JPanel();
        public String[] labelsString = new String[]{"Input Filter Class Name:", "Input Filter Param URL:", "Output Filter Class Name:", "Output Filter Param URL:"};

        public FiltersPanel() {
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setBorder(new EmptyBorder(2, 2, 2, 2));
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(2, 3, 2, 3);
            for (int i2 = 0; i2 < this.labelsString.length; ++i2) {
                gridBagConstraints.gridy = i2;
                jPanel.add((Component)new JLabel(this.labelsString[i2]), gridBagConstraints);
            }
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            jPanel.add((Component)this.inputClassName, gridBagConstraints);
            gridBagConstraints.gridy = 1;
            jPanel.add((Component)this.inputParamURL, gridBagConstraints);
            gridBagConstraints.gridy = 2;
            jPanel.add((Component)this.outputClassName, gridBagConstraints);
            gridBagConstraints.gridy = 3;
            jPanel.add((Component)this.outputParamURL, gridBagConstraints);
            this.setBorder(new EtchedBorder());
            this.setLayout(new BorderLayout());
            this.add((Component)jPanel, "Center");
        }
    }

    private class FiltRecPanel
    extends JPanel
    implements ActionListener,
    ListSelectionListener {
        private FiltersPanel panFilters;
        private RecoveryPanel panRecovery;
        private JCheckBox cboxFilters;
        private JCheckBox cboxRecovery;
        private JList membersList;
        private int index;
        private int lastIndex;
        private String removedItem;

        public FiltRecPanel() {
            this.panFilters = new FiltersPanel();
            this.panRecovery = new RecoveryPanel();
            this.cboxFilters = new JCheckBox("Filters");
            this.cboxRecovery = new JCheckBox("Recovery");
            this.membersList = TransmissionMatrixDlg.this.m_groupList;
            this.lastIndex = -1;
            this.membersList.setBorder(new BevelBorder(1));
            this.membersList.addListSelectionListener(this);
            this.cboxFilters.addActionListener(this);
            this.cboxRecovery.addActionListener(this);
            JPanel jPanel = new JPanel(new BorderLayout());
            JScrollPane jScrollPane = new JScrollPane(this.membersList);
            jPanel.setBorder(new TitledBorder("Members"));
            jPanel.add((Component)jScrollPane, "Center");
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(1, 5, 1, 5);
            jPanel2.add((Component)this.cboxFilters, gridBagConstraints);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            jPanel2.add((Component)this.panFilters, gridBagConstraints);
            gridBagConstraints.gridy = 2;
            jPanel2.add((Component)this.panRecovery, gridBagConstraints);
            this.setLayout(new BoxLayout(this, 0));
            this.add(jPanel);
            this.add(jPanel2);
            this.membersList.setSelectedIndex(0);
            this.lastIndex = 0;
            this.restoreMemberInfo(0);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(this.cboxFilters)) {
                if (this.cboxFilters.isSelected() && ((ClusterMemberInfo)this.membersList.getSelectedValue()).m_replFilters == null) {
                    this.panFilters.inputClassName.setText(TransmissionMatrixDlg.DEFAULT_IN_OUT_FILTER);
                    this.panFilters.outputClassName.setText(TransmissionMatrixDlg.DEFAULT_IN_OUT_FILTER);
                }
                TransmissionMatrixDlg.this.setAWTComponentsStatus(this.panFilters, this.cboxFilters.isSelected());
            }
            if (actionEvent.getSource().equals(this.cboxRecovery)) {
                TransmissionMatrixDlg.this.setAWTComponentsStatus(this.panRecovery, this.cboxRecovery.isSelected());
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (TransmissionMatrixDlg.this.isVisible()) {
                this.index = this.membersList.getSelectedIndex();
                if (this.index == this.lastIndex) {
                    return;
                }
                if (this.lastIndex != -1) {
                    if (!this.checkFiltersProperties()) {
                        this.membersList.setSelectedIndex(this.lastIndex);
                        return;
                    }
                    this.saveMemberInfo(this.lastIndex);
                } else {
                    this.cboxFilters.setEnabled(true);
                    this.cboxRecovery.setEnabled(true);
                }
                this.restoreMemberInfo(this.index);
                this.lastIndex = this.index;
            }
        }

        public void restoreMemberInfo(int n2) {
            ClusterMemberInfo clusterMemberInfo = (ClusterMemberInfo)this.membersList.getModel().getElementAt(n2);
            if (clusterMemberInfo.m_replFilters != null) {
                this.panFilters.inputClassName.setText(clusterMemberInfo.m_replFilters.inputReplicationFilterClassName);
                this.panFilters.inputParamURL.setText(clusterMemberInfo.m_replFilters.inputReplicationFilterParamUrl);
                this.panFilters.outputClassName.setText(clusterMemberInfo.m_replFilters.outputReplicationFilterClassName);
                this.panFilters.outputParamURL.setText(clusterMemberInfo.m_replFilters.outputReplicationFilterParamUrl);
                TransmissionMatrixDlg.this.setAWTComponentsStatus(this.panFilters, true);
                this.cboxFilters.setSelected(true);
            } else {
                TransmissionMatrixDlg.this.cleanComponents(this.panFilters);
                TransmissionMatrixDlg.this.setAWTComponentsStatus(this.panFilters, false);
                this.cboxFilters.setSelected(false);
            }
            if (this.removedItem != null) {
                this.panRecovery.sourceName.addItem(this.removedItem);
            }
            this.removedItem = clusterMemberInfo.memberName;
            this.panRecovery.sourceName.removeItem(this.removedItem);
            this.panRecovery.sourceName.validate();
            if (clusterMemberInfo.m_replRecovery != null) {
                this.panRecovery.recovery.setSelected(clusterMemberInfo.m_replRecovery.recoveryEnabled);
                this.panRecovery.sourceName.setSelectedItem(clusterMemberInfo.m_replRecovery.sourceMemberRecovery);
                this.panRecovery.setEnabled(clusterMemberInfo.m_replRecovery.recoveryEnabled);
            } else {
                this.panRecovery.recovery.setSelected(TransmissionMatrixDlg.this.m_groupRecovery);
                this.panRecovery.sourceName.setSelectedItem("First available member");
                this.panRecovery.setEnabled(TransmissionMatrixDlg.this.m_groupRecovery);
            }
        }

        public void saveMemberInfo(int n2) {
            String string = "";
            String string2 = "";
            String string3 = "";
            String string4 = "";
            ClusterMemberInfo clusterMemberInfo = (ClusterMemberInfo)this.membersList.getModel().getElementAt(n2);
            if (this.cboxFilters.isSelected()) {
                string = this.panFilters.inputClassName.getText().trim();
                if (string.length() > 0) {
                    string2 = this.panFilters.inputParamURL.getText().trim();
                }
                if ((string3 = this.panFilters.outputClassName.getText().trim()).length() > 0) {
                    string4 = this.panFilters.outputParamURL.getText().trim();
                }
                clusterMemberInfo.m_replFilters = new ClusterMemberInfo.ReplFilters(string, string2, string3, string4);
            } else {
                clusterMemberInfo.m_replFilters = null;
            }
            String string5 = (String)this.panRecovery.sourceName.getSelectedItem();
            boolean bl2 = this.panRecovery.recovery.isSelected();
            if (!TransmissionMatrixDlg.this.m_groupRecovery && !bl2 || TransmissionMatrixDlg.this.m_groupRecovery && bl2 && string5.equals("First available member")) {
                clusterMemberInfo.m_replRecovery = null;
            }
            if (!TransmissionMatrixDlg.this.m_groupRecovery && bl2 || TransmissionMatrixDlg.this.m_groupRecovery && !string5.equals("First available member") || TransmissionMatrixDlg.this.m_groupRecovery && !bl2) {
                clusterMemberInfo.m_replRecovery = new ClusterMemberInfo.ReplRecovery(bl2, string5);
            }
        }

        public boolean checkFiltersProperties() {
            String string = "";
            if (this.cboxFilters.isSelected() && this.panFilters.inputClassName.getText().trim().length() == 0 && this.panFilters.outputClassName.getText().trim().length() == 0) {
                string = "Please, check at <input/output replication filter class name> fields.";
                TransmissionMatrixDlg.this.m_panTabbed.setSelectedComponent(TransmissionMatrixDlg.this.m_panFiltRec);
                JOptionPane.showMessageDialog(TransmissionMatrixDlg.this, string);
                return false;
            }
            return true;
        }
    }

    public class LabelPanel
    extends JPanel {
        public boolean overloadPaint;
        public String str;
        public Font font = new Font("Arial", 0, 12);

        public LabelPanel(String string) {
            this.setBorder(new LineBorder(Color.gray));
            this.setLayout(new GridBagLayout());
            this.setToolTipText(string);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            while (stringTokenizer.hasMoreTokens()) {
                this.str = stringTokenizer.nextToken();
                if (this.str.length() > 45) {
                    this.str = this.str.substring(0, 44);
                    this.str = this.str + "...";
                }
                JLabel jLabel = new JLabel(this.str);
                jLabel.setFont(this.font);
                int n2 = jLabel.getFontMetrics(this.font).stringWidth(this.str);
                jLabel.setPreferredSize(new Dimension(n2 + 10, 18));
                jLabel.setHorizontalAlignment(0);
                ++gridBagConstraints.gridy;
                this.add((Component)jLabel, gridBagConstraints);
            }
        }

        public LabelPanel(String string, boolean bl2) {
            this(string);
            this.overloadPaint = bl2;
        }

        public Insets getInsets() {
            return new Insets(2, 3, 2, 3);
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (this.overloadPaint) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setColor(Color.gray);
                graphics2D.setFont(new Font("Arial", 1, 12));
                Rectangle rectangle = super.getBounds();
                graphics2D.drawLine(0, 0, rectangle.width, rectangle.height);
                graphics2D.drawString("Source", 5, rectangle.height - 5);
                String string = "Target";
                graphics2D.drawString(string, rectangle.width - graphics.getFontMetrics().stringWidth(string) - 5, 15);
            }
        }
    }

    public class JPolicy
    extends JPanel {
        private ReplicationTransmissionPolicy policy;
        public PolicyCheckBox state;
        public String source;
        public String target;

        public JPolicy(ActionListener actionListener, int n2, int n3, String string, String string2) {
            this.source = string;
            this.target = string2;
            this.state = new PolicyCheckBox(n2, n3);
            if (n2 != n3) {
                this.state.setSelected(true);
                this.state.addActionListener(actionListener);
                this.state.setBackground(Color.white);
                this.setBackground(Color.white);
                this.policy = new ReplicationTransmissionPolicy(string, string2, TransmissionMatrixDlg.this.m_defOperations, TransmissionMatrixDlg.this.m_groupSyncOnCommit, TransmissionMatrixDlg.this.m_groupCommunicationMode, false);
                this.policy.setOneWayReplication(ClusterXML.calculateOneWayReplicationValue(TransmissionMatrixDlg.this.m_groupReplicationMode));
                this.policy.setSyncReplication(ClusterXML.calculateSyncReplicationValue(TransmissionMatrixDlg.this.m_groupReplicationMode));
            }
            this.setBorder(new LineBorder(Color.gray));
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.add((Component)this.state, gridBagConstraints);
        }

        public boolean isDefault() {
            boolean bl2 = ClusterXML.calculateOneWayReplicationValue(TransmissionMatrixDlg.this.m_groupReplicationMode);
            boolean bl3 = ClusterXML.calculateSyncReplicationValue(TransmissionMatrixDlg.this.m_groupReplicationMode);
            return this.policy == null || !this.policy.m_DisableTransmission && this.policy.m_RepTransmissionOperations.equals(TransmissionMatrixDlg.this.m_defOperations) && this.policy.isOneWayReplication() == bl2 && this.policy.isSyncReplication() == bl3 && this.policy.getCommunicationMode().equals(TransmissionMatrixDlg.this.m_groupCommunicationMode) && this.policy.m_SyncOnCommit == TransmissionMatrixDlg.this.m_groupSyncOnCommit;
        }

        public void setBackgroundPolicy(Color color) {
            this.setBackground(color);
            this.state.setBackground(color);
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
        }

        public class PolicyCheckBox
        extends JCheckBox {
            public int row;
            public int col;

            public PolicyCheckBox(int n2, int n3) {
                this.row = n2;
                this.col = n3;
                this.setEnabled(n2 != n3);
                this.setHorizontalAlignment(0);
            }
        }
    }

    private class PolicyProperties
    extends JPanel {
        public JTextField sourceName = new JTextField();
        public JTextField targetName = new JTextField();
        public JCheckBox syncOnCommit = new JCheckBox("Sync on Commit");
        public JLabel replicationModeLabel = new JLabel();
        public JLabel communicationModeLabel = new JLabel();
        private JComboBox replicationModeCB;
        private JComboBox communicationModeCB;
        public JCheckBox[] operations = new JCheckBox[3];
        public String[] operLabels = new String[]{"take", "write", "notify"};
        public String[] labelsString = new String[]{"Source Member:", "Target Member:", "Operations:"};

        public PolicyProperties() {
            this.replicationModeLabel.setText("Replication Mode: ");
            this.communicationModeLabel.setText("Communication Mode: ");
            this.sourceName.setEditable(false);
            this.targetName.setEditable(false);
            String[] stringArray = new String[]{"sync", "async", "sync-rec-ack", "async-rec-ack"};
            this.replicationModeCB = new JComboBox<String>(stringArray);
            String[] stringArray2 = new String[]{"unicast", "multicast"};
            this.communicationModeCB = new JComboBox<String>(stringArray2);
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setBorder(new EmptyBorder(2, 2, 2, 2));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(2, 5, 2, 5);
            int n2 = 0;
            while (n2 < this.labelsString.length) {
                JLabel jLabel = new JLabel(this.labelsString[n2]);
                gridBagConstraints.gridy = n2++;
                jPanel.add((Component)jLabel, gridBagConstraints);
            }
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            jPanel.add((Component)this.sourceName, gridBagConstraints);
            gridBagConstraints.gridy = 1;
            jPanel.add((Component)this.targetName, gridBagConstraints);
            EmptyBorder emptyBorder = new EmptyBorder(1, 1, 1, 1);
            for (int i2 = 0; i2 < this.operLabels.length; ++i2) {
                this.operations[i2] = new JCheckBox(this.operLabels[i2]);
                this.operations[i2].setBorder(emptyBorder);
                gridBagConstraints.gridy = i2 + 2;
                jPanel.add((Component)this.operations[i2], gridBagConstraints);
            }
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            jPanel2.add((Component)this.syncOnCommit, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 3, 2, 2), 0, 0));
            jPanel2.add((Component)this.replicationModeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 6, 2, 2), 0, 0));
            jPanel2.add((Component)this.replicationModeCB, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 7), 0, 0));
            jPanel2.add((Component)this.communicationModeLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 6, 2, 2), 0, 0));
            jPanel2.add((Component)this.communicationModeCB, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 2, 2, 7), 0, 0));
            JPanel jPanel3 = new JPanel(new BorderLayout());
            jPanel3.setBorder(new EmptyBorder(2, 3, 2, 2));
            jPanel3.add((Component)jPanel, "Center");
            jPanel3.add((Component)jPanel2, "South");
            this.setBorder(new TitledBorder("Replication Properties"));
            this.setLayout(new BorderLayout());
            this.add((Component)jPanel3, "North");
            TransmissionMatrixDlg.this.setAWTComponentsStatus(this, false);
        }

        public void setSelectedReplicationMode(String string) {
            this.replicationModeCB.setSelectedItem(string);
        }

        public void setSelectedCommunicationMode(String string) {
            this.communicationModeCB.setSelectedItem(string);
        }

        public String getSelectedReplicationMode() {
            return (String)this.replicationModeCB.getSelectedItem();
        }

        public String getSelectedCommunicationMode() {
            return (String)this.communicationModeCB.getSelectedItem();
        }
    }

    public class MatrixPanel
    extends JPanel
    implements ActionListener,
    MouseListener {
        public JPanel panTable;
        public CustomJScrollPane scrollpanel;
        public PolicyProperties panProperties;
        public int row;
        public int col;
        public int lastRow;
        public int lastCol;
        public int lastIndex;
        public String[] members;
        public LabelPanel[] labels;
        public Color colorBackground;
        public Color colorSelectedBackground;
        public ClusterMemberInfo memberInfo;
        public boolean isDisabled;
        public int currentIndex;
        private JSplitPane splitPane;

        public MatrixPanel() {
            this.members = new String[TransmissionMatrixDlg.this.m_matrixSize];
            this.labels = new LabelPanel[TransmissionMatrixDlg.this.m_matrixSize];
            this.isDisabled = false;
            this.panProperties = new PolicyProperties();
            this.panTable = new JPanel(new GridLayout(TransmissionMatrixDlg.this.m_matrixSize, TransmissionMatrixDlg.this.m_matrixSize));
            this.panTable.addMouseListener(this);
            this.colorBackground = TransmissionMatrixDlg.this.m_groupList.getBackground();
            this.colorSelectedBackground = TransmissionMatrixDlg.this.m_groupList.getSelectionBackground();
            int n2 = 0;
            for (int i2 = 0; i2 < TransmissionMatrixDlg.this.m_matrixSize; ++i2) {
                this.memberInfo = (ClusterMemberInfo)TransmissionMatrixDlg.this.m_groupListModel.getElementAt(i2);
                this.members[i2] = this.memberInfo.memberName;
                if (this.members[i2].length() <= n2) continue;
                n2 = this.members[i2].length();
            }
            this.panProperties.sourceName.setPreferredSize(new Dimension(n2 * 7, 17));
            this.panProperties.targetName.setPreferredSize(new Dimension(n2 * 7, 17));
            Dimension dimension = null;
            for (int i3 = 0; i3 < TransmissionMatrixDlg.this.m_matrixSize; ++i3) {
                this.labels[i3] = new LabelPanel(this.members[i3]);
                dimension = this.labels[i3].getPreferredSize();
                for (int i4 = 0; i4 < TransmissionMatrixDlg.this.m_matrixSize; ++i4) {
                    JPolicy jPolicy = new JPolicy(this, i3, i4, this.members[i3], this.members[i4]);
                    jPolicy.setPreferredSize(dimension);
                    this.panTable.add(jPolicy);
                }
            }
            TransmissionMatrixDlg.this.restorePolicyFromSourceModel(this.panTable);
            this.scrollpanel = new CustomJScrollPane(this.panTable);
            this.scrollpanel.setPreferredSize(new Dimension(280, 200));
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)this.panProperties, "Center");
            jPanel.add((Component)new HelperPanel(), "South");
            this.splitPane = new JSplitPane(1, this.scrollpanel, jPanel);
            this.add((Component)this.splitPane, "Center");
        }

        public void setSplitPosition(int n2) {
            this.splitPane.setDividerLocation(n2);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JPolicy jPolicy = null;
            if (actionEvent.getSource() instanceof JPolicy.PolicyCheckBox) {
                JPolicy.PolicyCheckBox policyCheckBox = (JPolicy.PolicyCheckBox)actionEvent.getSource();
                this.currentIndex = policyCheckBox.row * TransmissionMatrixDlg.this.m_matrixSize + policyCheckBox.col;
                if (this.currentIndex != this.lastIndex) {
                    if (this.lastIndex != 0) {
                        if (!this.checkLastPolicyProperties()) {
                            policyCheckBox.setSelected(!policyCheckBox.isSelected());
                            return;
                        }
                        jPolicy = (JPolicy)this.panTable.getComponent(this.lastIndex);
                        jPolicy.setBackgroundPolicy(this.colorBackground);
                        this.savePolicy(jPolicy);
                    }
                    jPolicy = (JPolicy)this.panTable.getComponent(this.currentIndex);
                    jPolicy.setBackgroundPolicy(this.colorSelectedBackground);
                    this.showPolicyProperties(jPolicy);
                    this.lastIndex = this.currentIndex;
                }
                TransmissionMatrixDlg.this.setAWTComponentsStatus(this.panProperties, policyCheckBox.isSelected());
            }
        }

        public void savePolicy(JPolicy jPolicy) {
            String string = "";
            for (int i2 = 0; i2 < this.panProperties.operations.length; ++i2) {
                JCheckBox jCheckBox = this.panProperties.operations[i2];
                if (!jCheckBox.isSelected()) continue;
                string = string + String.valueOf(jCheckBox.getText().charAt(0)).toUpperCase();
            }
            String string2 = this.panProperties.getSelectedReplicationMode();
            jPolicy.policy = new ReplicationTransmissionPolicy(jPolicy.source, jPolicy.target, string, this.panProperties.syncOnCommit.isSelected(), this.panProperties.getSelectedCommunicationMode(), !jPolicy.state.isSelected());
            jPolicy.policy.setOneWayReplication(ClusterXML.calculateOneWayReplicationValue(string2));
            jPolicy.policy.setSyncReplication(ClusterXML.calculateSyncReplicationValue(string2));
        }

        public void showPolicyProperties(JPolicy jPolicy) {
            ReplicationTransmissionPolicy replicationTransmissionPolicy = jPolicy.policy;
            if (replicationTransmissionPolicy == null) {
                replicationTransmissionPolicy = new ReplicationTransmissionPolicy(jPolicy.source, jPolicy.target, TransmissionMatrixDlg.this.m_defOperations, TransmissionMatrixDlg.this.m_groupSyncOnCommit, TransmissionMatrixDlg.this.m_groupCommunicationMode, false);
                replicationTransmissionPolicy.setOneWayReplication(ClusterXML.calculateOneWayReplicationValue(TransmissionMatrixDlg.this.m_groupReplicationMode));
                replicationTransmissionPolicy.setSyncReplication(ClusterXML.calculateSyncReplicationValue(TransmissionMatrixDlg.this.m_groupReplicationMode));
                return;
            }
            jPolicy.state.setSelected(!replicationTransmissionPolicy.m_DisableTransmission);
            this.panProperties.sourceName.setText(replicationTransmissionPolicy.m_SourceSpace);
            this.panProperties.targetName.setText(replicationTransmissionPolicy.m_TargetSpace);
            for (int i2 = 0; i2 < this.panProperties.operations.length; ++i2) {
                String string = String.valueOf(this.panProperties.operations[i2].getText().charAt(0)).toUpperCase();
                this.panProperties.operations[i2].setSelected(replicationTransmissionPolicy.m_RepTransmissionOperations.indexOf(string) != -1);
            }
            this.panProperties.syncOnCommit.setSelected(replicationTransmissionPolicy.m_SyncOnCommit);
            String string = ClusterXML.calculateReplicationMode(replicationTransmissionPolicy.isSyncReplication(), replicationTransmissionPolicy.isOneWayReplication());
            this.panProperties.setSelectedReplicationMode(string);
            this.panProperties.setSelectedCommunicationMode(replicationTransmissionPolicy.getCommunicationMode());
            this.validate();
        }

        public void cleanPropertiesPanel() {
            this.panProperties.sourceName.setText("");
            this.panProperties.targetName.setText("");
            for (int i2 = 0; i2 < this.panProperties.operations.length; ++i2) {
                this.panProperties.operations[i2].setSelected(true);
            }
            this.panProperties.syncOnCommit.setSelected(false);
            this.panProperties.setSelectedReplicationMode("");
            this.panProperties.setSelectedCommunicationMode("");
            TransmissionMatrixDlg.this.setAWTComponentsStatus(this.panProperties, false);
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            JPolicy jPolicy = null;
            Component component = this.panTable.getComponentAt(mouseEvent.getPoint());
            if (component instanceof JPolicy) {
                JPolicy.PolicyCheckBox policyCheckBox = ((JPolicy)component).state;
                this.currentIndex = policyCheckBox.row * TransmissionMatrixDlg.this.m_matrixSize + policyCheckBox.col;
                if (this.currentIndex != this.lastIndex && policyCheckBox.row != policyCheckBox.col) {
                    if (this.lastIndex != 0) {
                        if (this.checkLastPolicyProperties()) {
                            jPolicy = (JPolicy)this.panTable.getComponent(this.lastIndex);
                            this.savePolicy(jPolicy);
                        } else {
                            return;
                        }
                    }
                    if (jPolicy != null) {
                        ((JPolicy)jPolicy).setBackgroundPolicy(this.colorBackground);
                    }
                    ((JPolicy)component).setBackgroundPolicy(this.colorSelectedBackground);
                    this.lastIndex = policyCheckBox.row * TransmissionMatrixDlg.this.m_matrixSize + policyCheckBox.col;
                    this.lastRow = policyCheckBox.row;
                    this.lastCol = policyCheckBox.col;
                    this.showPolicyProperties((JPolicy)component);
                    TransmissionMatrixDlg.this.setAWTComponentsStatus(this.panProperties, policyCheckBox.isSelected());
                }
            }
        }

        public boolean checkLastPolicyProperties() {
            if (this.lastIndex == 0) {
                return false;
            }
            JPolicy jPolicy = (JPolicy)this.panTable.getComponent(this.lastIndex);
            for (int i2 = 0; i2 < this.panProperties.operations.length; ++i2) {
                if (!this.panProperties.operations[i2].isSelected()) continue;
                return true;
            }
            TransmissionMatrixDlg.this.m_panTabbed.setSelectedComponent(TransmissionMatrixDlg.this.m_panMatrix);
            String string = "Please, select least one or more operations.";
            JOptionPane.showMessageDialog(TransmissionMatrixDlg.this, string);
            return false;
        }

        public boolean checkMemberNotStandAlone(JPolicy jPolicy) {
            JPolicy jPolicy2 = (JPolicy)this.panTable.getComponent(this.currentIndex);
            Object var3_3 = null;
            return true;
        }

        public class CustomJScrollPane
        extends JScrollPane {
            public CustomJScrollPane(Component component) {
                super(component);
                JPanel jPanel = new JPanel(new GridLayout(1, TransmissionMatrixDlg.this.m_matrixSize));
                JPanel jPanel2 = new JPanel(new GridLayout(TransmissionMatrixDlg.this.m_matrixSize, 1));
                for (int i2 = 0; i2 < TransmissionMatrixDlg.this.m_matrixSize; ++i2) {
                    jPanel.add(MatrixPanel.this.labels[i2]);
                    jPanel2.add(new LabelPanel(MatrixPanel.this.members[i2]));
                }
                this.setColumnHeaderView(jPanel);
                this.setRowHeaderView(jPanel2);
                LabelPanel labelPanel = new LabelPanel(":", true);
                this.setCorner("UPPER_LEFT_CORNER", labelPanel);
            }
        }
    }

    public class HelperPanel
    extends JPanel
    implements ActionListener {
        public JButton butApply = new JButton("Apply");
        public JRadioButton rbutEnabled = new JRadioButton("Enabled");
        public JRadioButton rbutDisabled = new JRadioButton("Disabled");
        public ButtonGroup butGroup = new ButtonGroup();

        public HelperPanel() {
            this.butApply.addActionListener(this);
            this.rbutEnabled.setSelected(true);
            this.butGroup.add(this.rbutEnabled);
            this.butGroup.add(this.rbutDisabled);
            JPanel jPanel = new JPanel();
            jPanel.add(this.rbutEnabled);
            jPanel.add(this.rbutDisabled);
            jPanel.add(this.butApply);
            this.setBorder(new TitledBorder("All To All Replication:"));
            this.setLayout(new BorderLayout());
            this.add((Component)jPanel, "West");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object.equals(this.butApply)) {
                String string;
                String string2 = string = this.rbutEnabled.isSelected() ? "enabled" : "disabled";
                if (JOptionPane.showConfirmDialog(this, "Set <" + string + "> mode for all transmission policies?", "Confirmation", 0) == 0) {
                    TransmissionMatrixDlg.this.setReplicationPoliciesMode(!this.rbutEnabled.isSelected());
                }
            }
        }
    }
}

