/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.cluster;

import com.j_spaces.core.cluster.ClusterXML;
import com.j_spaces.tools.cluster.ClusterMemberInfo;
import com.j_spaces.tools.cluster.GroupInfo;
import com.j_spaces.tools.cluster.ISetPanel;
import com.j_spaces.tools.cluster.TransmissionMatrixDlg;
import com.j_spaces.tools.spacebrowser.WholeNumberField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;

public class GroupReplicationPanel
extends JPanel
implements ISetPanel {
    private JPanel commonPanel;
    private JPanel asyncPanel;
    private JPanel syncPanel;
    private JTabbedPane ReplicationTabbedPane;
    private JPanel policyTypePan;
    private JPanel policyTypePanel;
    private JComboBox repModeComboBox;
    private JLabel repPolicyTypeLabel;
    private JCheckBox repMemoryRecCB;
    private JCheckBox repNotifyTemplCB;
    private JCheckBox triggerNotifyCB;
    private JLabel findTimeoutLabel;
    private WholeNumberField repFindTimeoutTF;
    private JRadioButton asyncButton;
    private JRadioButton syncButton;
    private ButtonGroup group;
    private Border replicationModeBorder;
    private TitledBorder replicationModeTitledBorder;
    private JButton butEditTransmMatrix;
    private JCheckBox chboxTransmMatrix;
    private DefaultListModel m_groupMembersListModel;
    private TransmissionMatrixDlg transmMatrixDlg;
    private JCheckBox syncOnCommitCB;
    private JLabel syncTimeOutLabel;
    private JLabel chunkSizeLabel;
    private JLabel interMsLabel;
    private JLabel interOperLabel;
    private JCheckBox repOriginalStateCB;
    private WholeNumberField interOperTF;
    private WholeNumberField interMsTF;
    private WholeNumberField chunkSizeTF;
    private WholeNumberField syncTimeOutTF;
    private JComboBox communicationModeComboBox;
    private JLabel todoQueueTimeoutLabel;
    private WholeNumberField todoQueueTimeoutTF;
    private JPanel unicastReplPanel;
    private JLabel minUnicastWorkThreadsLabel;
    private JLabel maxUnicastWorkThreadsLabel;
    private WholeNumberField minUnicastWorkThreadsTF;
    private WholeNumberField maxUnicastWorkThreadsTF;
    private JPanel multicastReplPanel;
    private JLabel ipGroupLabel;
    private JLabel portLabel;
    private JTextField ipGroupTF;
    private WholeNumberField portTF;
    private JLabel minMulticastWorkThreadsLabel;
    private JLabel maxMulticastWorkThreadsLabel;
    private WholeNumberField minMulticastWorkThreadsTF;
    private WholeNumberField maxMulticastWorkThreadsTF;
    private static final String UNICAST = "Unicast";
    private static final String MULTICAST = "Multicast";
    private JFrame frameOwner;
    private JDialog dialogOwner;
    private static Logger _logger = Logger.getLogger("com.gigaspaces.ui.cluster.view");

    public GroupReplicationPanel(GroupInfo groupInfo, JFrame jFrame, JDialog jDialog) {
        block2: {
            this.ReplicationTabbedPane = new JTabbedPane();
            this.policyTypePan = new JPanel();
            this.policyTypePanel = new JPanel();
            this.repModeComboBox = new JComboBox();
            this.repPolicyTypeLabel = new JLabel();
            this.repMemoryRecCB = new JCheckBox();
            this.repNotifyTemplCB = new JCheckBox();
            this.triggerNotifyCB = new JCheckBox();
            this.findTimeoutLabel = new JLabel();
            this.repFindTimeoutTF = new WholeNumberField();
            this.asyncButton = new JRadioButton();
            this.syncButton = new JRadioButton();
            this.group = new ButtonGroup();
            this.butEditTransmMatrix = new JButton();
            this.chboxTransmMatrix = new JCheckBox();
            this.syncOnCommitCB = new JCheckBox();
            this.syncTimeOutLabel = new JLabel();
            this.chunkSizeLabel = new JLabel();
            this.interMsLabel = new JLabel();
            this.interOperLabel = new JLabel();
            this.repOriginalStateCB = new JCheckBox();
            this.interOperTF = new WholeNumberField();
            this.interMsTF = new WholeNumberField();
            this.chunkSizeTF = new WholeNumberField();
            this.syncTimeOutTF = new WholeNumberField();
            this.communicationModeComboBox = new JComboBox();
            this.todoQueueTimeoutLabel = new JLabel();
            this.todoQueueTimeoutTF = new WholeNumberField();
            this.minUnicastWorkThreadsLabel = new JLabel();
            this.maxUnicastWorkThreadsLabel = new JLabel();
            this.minUnicastWorkThreadsTF = new WholeNumberField();
            this.maxUnicastWorkThreadsTF = new WholeNumberField();
            this.ipGroupLabel = new JLabel();
            this.portLabel = new JLabel();
            this.ipGroupTF = new JTextField();
            this.portTF = new WholeNumberField();
            this.minMulticastWorkThreadsLabel = new JLabel();
            this.maxMulticastWorkThreadsLabel = new JLabel();
            this.minMulticastWorkThreadsTF = new WholeNumberField();
            this.maxMulticastWorkThreadsTF = new WholeNumberField();
            try {
                this.frameOwner = jFrame;
                this.dialogOwner = jDialog;
                this.jbInit();
                this.reset();
                this.init(groupInfo);
            }
            catch (Exception exception) {
                if (!_logger.isLoggable(Level.SEVERE)) break block2;
                _logger.log(Level.SEVERE, exception.toString(), exception);
            }
        }
    }

    public void init(GroupInfo groupInfo) {
        if (groupInfo != null) {
            this.updateDataForRepMatrix(groupInfo.groupMembers, groupInfo.repInfo != null);
            this.restoreSettings(groupInfo.repInfo);
        }
    }

    public JPanel createCommonPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.repPolicyTypeLabel.setText("Policy Type: ");
        this.repModeComboBox.addItem("Full Replication");
        this.repModeComboBox.addItem("Partial Replication");
        this.repMemoryRecCB.setText("Recovery");
        this.repMemoryRecCB.setRequestFocusEnabled(false);
        this.repNotifyTemplCB.setText("Replicate Notify Templates");
        this.repNotifyTemplCB.setRequestFocusEnabled(false);
        this.triggerNotifyCB.setText("Trigger Notify Templates");
        this.triggerNotifyCB.setRequestFocusEnabled(false);
        this.chboxTransmMatrix.setText("Replication Matrix");
        this.chboxTransmMatrix.setRequestFocusEnabled(false);
        this.chboxTransmMatrix.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GroupReplicationPanel.this.butEditTransmMatrix.setEnabled(((JCheckBox)actionEvent.getSource()).isSelected());
            }
        });
        this.butEditTransmMatrix.setEnabled(false);
        this.butEditTransmMatrix.setText("Edit...");
        this.butEditTransmMatrix.setMargin(new Insets(2, 5, 2, 5));
        this.butEditTransmMatrix.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GroupReplicationPanel.this.m_groupMembersListModel != null) {
                    String string = "";
                    String string2 = "";
                    if (GroupReplicationPanel.this.syncButton.isSelected()) {
                        string = "sync";
                    } else if (GroupReplicationPanel.this.asyncButton.isSelected()) {
                        string = "async";
                    }
                    string2 = ((String)GroupReplicationPanel.this.communicationModeComboBox.getSelectedItem()).equalsIgnoreCase("unicast") ? "unicast".toLowerCase() : "multicast".toLowerCase();
                    if (GroupReplicationPanel.this.frameOwner != null) {
                        GroupReplicationPanel.this.transmMatrixDlg = new TransmissionMatrixDlg(GroupReplicationPanel.this.frameOwner, GroupReplicationPanel.this.chboxTransmMatrix.getText(), true, GroupReplicationPanel.this.m_groupMembersListModel, GroupReplicationPanel.this.syncOnCommitCB.isSelected(), string, string2, GroupReplicationPanel.this.repMemoryRecCB.isSelected());
                    } else {
                        GroupReplicationPanel.this.transmMatrixDlg = new TransmissionMatrixDlg(GroupReplicationPanel.this.dialogOwner, GroupReplicationPanel.this.chboxTransmMatrix.getText(), true, GroupReplicationPanel.this.m_groupMembersListModel, GroupReplicationPanel.this.syncOnCommitCB.isSelected(), string, string2, GroupReplicationPanel.this.repMemoryRecCB.isSelected());
                    }
                }
                if (GroupReplicationPanel.this.transmMatrixDlg != null) {
                    GroupReplicationPanel.this.transmMatrixDlg.setVisible(true);
                }
                GroupReplicationPanel.this.m_groupMembersListModel = GroupReplicationPanel.this.transmMatrixDlg.getGroupListModel();
            }
        });
        JLabel jLabel = new JLabel();
        jLabel.setText("Communication Mode: ");
        this.communicationModeComboBox.addItem(UNICAST);
        this.communicationModeComboBox.addItem(MULTICAST);
        this.findTimeoutLabel.setText("Find timeout msec: ");
        this.asyncButton.setText("Asynchronous");
        this.syncButton.setText("Synchronous");
        this.replicationModeBorder = new EtchedBorder(0, Color.white, new Color(148, 145, 140));
        this.replicationModeTitledBorder = new TitledBorder(this.replicationModeBorder, "Replication Mode");
        jPanel2.setBorder(this.replicationModeTitledBorder);
        this.group.add(this.asyncButton);
        this.group.add(this.syncButton);
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 7, 2, 2), 0, 0));
        jPanel.add((Component)this.communicationModeComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 2, 2, 7), 0, 0));
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 18, 2, new Insets(2, 5, 2, 5), 0, 0));
        jPanel2.add((Component)this.asyncButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        jPanel2.add((Component)this.syncButton, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        jPanel.add((Component)this.repPolicyTypeLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 7, 2, 2), 0, 0));
        jPanel.add((Component)this.repModeComboBox, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 7), 0, 0));
        jPanel.add((Component)this.findTimeoutLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 7, 2, 2), 0, 0));
        jPanel.add((Component)this.repFindTimeoutTF, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 7), 0, 0));
        jPanel.add((Component)this.repMemoryRecCB, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        jPanel.add((Component)this.repNotifyTemplCB, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        jPanel.add((Component)this.triggerNotifyCB, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        jPanel.add((Component)this.chboxTransmMatrix, new GridBagConstraints(0, 7, 1, 1, 0.0, 1.0, 18, 2, new Insets(2, 2, 2, 2), 0, 0));
        jPanel.add((Component)this.butEditTransmMatrix, new GridBagConstraints(1, 7, 1, 1, 1.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
        return jPanel;
    }

    public JPanel createAsynchronousPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.syncOnCommitCB.setRequestFocusEnabled(false);
        this.syncOnCommitCB.setText("Synch on Commit");
        this.syncTimeOutLabel.setText("Synch on Commit time limit msec: ");
        this.chunkSizeLabel.setText("Chunk Size: ");
        this.interMsLabel.setText("Interval Operations msec: ");
        this.interOperLabel.setText("Number of Operations: ");
        this.repOriginalStateCB.setText("Replicate Original State");
        jPanel.add((Component)this.chunkSizeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 7, 2, 2), 0, 0));
        jPanel.add((Component)this.chunkSizeTF, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 7), 0, 0));
        jPanel.add((Component)this.interMsLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 7, 2, 2), 0, 0));
        jPanel.add((Component)this.interMsTF, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 7), 0, 0));
        jPanel.add((Component)this.interOperLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 7, 2, 2), 0, 0));
        jPanel.add((Component)this.interOperTF, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 7), 0, 0));
        jPanel.add((Component)this.syncTimeOutLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 7, 2, 2), 0, 0));
        jPanel.add((Component)this.syncTimeOutTF, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 7), 0, 0));
        jPanel.add((Component)this.syncOnCommitCB, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        jPanel.add((Component)this.repOriginalStateCB, new GridBagConstraints(0, 5, 1, 1, 0.0, 1.0, 18, 2, new Insets(2, 2, 2, 2), 0, 0));
        return jPanel;
    }

    private JPanel createSynchronousPanel() throws Exception {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.unicastReplPanel = new JPanel(new GridBagLayout());
        this.multicastReplPanel = new JPanel(new GridBagLayout());
        this.unicastReplPanel.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), UNICAST), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.multicastReplPanel.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), MULTICAST), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.todoQueueTimeoutLabel.setText("Todo Queue Timeout: ");
        this.minUnicastWorkThreadsLabel.setText("Min Work Threads: ");
        this.maxUnicastWorkThreadsLabel.setText("Max Work Threads: ");
        this.ipGroupLabel.setText("IP Group: ");
        this.portLabel.setText("Port: ");
        this.minMulticastWorkThreadsLabel.setText("Min Work Threads: ");
        this.maxMulticastWorkThreadsLabel.setText("Max Work Threads: ");
        jPanel.add((Component)this.todoQueueTimeoutLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 7, 2, 2), 0, 0));
        jPanel.add((Component)this.todoQueueTimeoutTF, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 2, 2, 7), 0, 0));
        jPanel.add((Component)this.unicastReplPanel, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 12, 5), 0, 0));
        this.unicastReplPanel.add((Component)this.minUnicastWorkThreadsLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.unicastReplPanel.add((Component)this.minUnicastWorkThreadsTF, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.unicastReplPanel.add((Component)this.maxUnicastWorkThreadsLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.unicastReplPanel.add((Component)this.maxUnicastWorkThreadsTF, new GridBagConstraints(3, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        jPanel.add((Component)this.multicastReplPanel, new GridBagConstraints(0, 6, 2, 1, 1.0, 1.0, 18, 2, new Insets(7, 5, 2, 5), 0, 0));
        this.multicastReplPanel.add((Component)this.minMulticastWorkThreadsLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.multicastReplPanel.add((Component)this.minMulticastWorkThreadsTF, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.multicastReplPanel.add((Component)this.maxMulticastWorkThreadsLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.multicastReplPanel.add((Component)this.maxMulticastWorkThreadsTF, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.multicastReplPanel.add((Component)this.ipGroupLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.multicastReplPanel.add((Component)this.ipGroupTF, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.multicastReplPanel.add((Component)this.portLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.multicastReplPanel.add((Component)this.portTF, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        return jPanel;
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.commonPanel = this.createCommonPanel();
        this.asyncPanel = this.createAsynchronousPanel();
        this.syncPanel = this.createSynchronousPanel();
        this.ReplicationTabbedPane.add((Component)this.commonPanel, "Common");
        this.ReplicationTabbedPane.add((Component)this.asyncPanel, "Asynchronous");
        this.ReplicationTabbedPane.add((Component)this.syncPanel, "Synchronous");
        this.add((Component)this.ReplicationTabbedPane, "Center");
    }

    private void resetCommonPanel() {
        this.asyncButton.setSelected(true);
        this.ReplicationTabbedPane.setEnabledAt(2, false);
        this.ReplicationTabbedPane.setEnabledAt(1, true);
        this.repModeComboBox.setSelectedIndex(0);
        this.repMemoryRecCB.setSelected(false);
        this.repNotifyTemplCB.setSelected(false);
        this.triggerNotifyCB.setSelected(false);
        this.chboxTransmMatrix.setSelected(false);
        this.butEditTransmMatrix.setEnabled(false);
        this.repFindTimeoutTF.setText(String.valueOf(2000));
        this.ReplicationTabbedPane.setEnabledAt(1, true);
        this.ReplicationTabbedPane.setEnabledAt(2, false);
        RadioListener radioListener = new RadioListener();
        this.asyncButton.addActionListener(radioListener);
        this.syncButton.addActionListener(radioListener);
    }

    private void resetAsyncPanel() {
        this.syncOnCommitCB.setSelected(false);
        this.syncTimeOutTF.setText(String.valueOf(300000));
        this.chunkSizeTF.setText(String.valueOf(100));
        this.interMsTF.setText(String.valueOf(3000));
        this.interOperTF.setText(String.valueOf(100));
        this.repOriginalStateCB.setSelected(false);
    }

    private void resetSyncPanel() {
        this.communicationModeComboBox.setSelectedItem(UNICAST);
        this.todoQueueTimeoutTF.setText(String.valueOf(2000L));
        this.minUnicastWorkThreadsTF.setText(String.valueOf(4));
        this.maxUnicastWorkThreadsTF.setText(String.valueOf(64));
        this.ipGroupTF.setText(String.valueOf("224.0.0.1"));
        this.portTF.setText(String.valueOf(28672));
        this.minMulticastWorkThreadsTF.setText(String.valueOf(4));
        this.maxMulticastWorkThreadsTF.setText(String.valueOf(16));
    }

    public void reset() {
        this.resetCommonPanel();
        this.resetAsyncPanel();
        this.resetSyncPanel();
    }

    private void restoreCommonSettings(GroupInfo.ReplicationInfo replicationInfo) {
        if (replicationInfo.m_ReplicationMode.equalsIgnoreCase("async")) {
            this.asyncButton.setSelected(true);
            this.ReplicationTabbedPane.setEnabledAt(2, false);
            this.ReplicationTabbedPane.setEnabledAt(1, true);
        } else {
            this.syncButton.setSelected(true);
            this.ReplicationTabbedPane.setEnabledAt(1, false);
            this.ReplicationTabbedPane.setEnabledAt(2, true);
        }
        this.repModeComboBox.setSelectedIndex(replicationInfo.m_PolicyType);
        this.repMemoryRecCB.setSelected(replicationInfo.m_MemoryRecovery);
        this.repNotifyTemplCB.setSelected(replicationInfo.m_ReplicateNotifyTemplates);
        this.triggerNotifyCB.setSelected(replicationInfo.m_TriggerNotifyTemplates);
        this.chboxTransmMatrix.setSelected(replicationInfo.m_TransmissionMatrix);
        this.butEditTransmMatrix.setEnabled(replicationInfo.m_TransmissionMatrix);
        this.repFindTimeoutTF.setText(String.valueOf(replicationInfo.m_SpaceFinderTimeout));
        String string = replicationInfo.m_CommunicationMode;
        String string2 = replicationInfo.m_ReplicationMode;
        if (string2.equalsIgnoreCase("sync")) {
            this.syncButton.setSelected(true);
        } else if (string2.equalsIgnoreCase("async")) {
            this.asyncButton.setSelected(true);
        }
        if (string.equalsIgnoreCase("multicast")) {
            this.communicationModeComboBox.setSelectedItem(MULTICAST);
        } else {
            this.communicationModeComboBox.setSelectedItem(UNICAST);
        }
    }

    private void restoreAsyncSettings(GroupInfo.ReplicationInfo replicationInfo) {
        this.syncOnCommitCB.setSelected(replicationInfo.m_SyncOnCommit);
        this.syncTimeOutTF.setText(String.valueOf(replicationInfo.m_SyncOnCommitTimeOut));
        this.chunkSizeTF.setText(String.valueOf(replicationInfo.m_ReplicationChunkSize));
        this.interMsTF.setText(String.valueOf(replicationInfo.m_ReplicationIntervalMillis));
        this.interOperTF.setText(String.valueOf(replicationInfo.m_ReplicationIntervalOperations));
        this.repOriginalStateCB.setSelected(replicationInfo.m_ReplicateOriginalState);
    }

    private void restoreSyncSettings(GroupInfo.ReplicationInfo replicationInfo) {
        this.todoQueueTimeoutTF.setText(String.valueOf(replicationInfo.m_TodoQueueTimeout));
        this.minUnicastWorkThreadsTF.setText(String.valueOf(replicationInfo.m_MinUnicastWorkingThreads));
        this.maxUnicastWorkThreadsTF.setText(String.valueOf(replicationInfo.m_MaxUnicastWorkingThreads));
        this.ipGroupTF.setText(String.valueOf(replicationInfo.m_IpGroup));
        this.portTF.setText(String.valueOf(replicationInfo.m_Port));
        this.minMulticastWorkThreadsTF.setText(String.valueOf(replicationInfo.m_MinMulticastWorkingThreads));
        this.maxMulticastWorkThreadsTF.setText(String.valueOf(replicationInfo.m_MaxMulticastWorkingThreads));
    }

    public void restoreSettings(Object object) {
        if (object == null) {
            this.reset();
            return;
        }
        GroupInfo.ReplicationInfo replicationInfo = (GroupInfo.ReplicationInfo)object;
        this.restoreCommonSettings(replicationInfo);
        this.restoreAsyncSettings(replicationInfo);
        this.restoreSyncSettings(replicationInfo);
    }

    public Object saveSettings() {
        GroupInfo.ReplicationInfo replicationInfo = new GroupInfo.ReplicationInfo();
        replicationInfo.m_ReplicationMode = this.asyncButton.isSelected() ? "async" : "sync";
        replicationInfo.m_PolicyType = this.repModeComboBox.getSelectedIndex();
        replicationInfo.m_MemoryRecovery = this.repMemoryRecCB.isSelected();
        replicationInfo.m_ReplicateNotifyTemplates = this.repNotifyTemplCB.isSelected();
        replicationInfo.m_TriggerNotifyTemplates = this.triggerNotifyCB.isSelected();
        replicationInfo.m_TransmissionMatrix = this.chboxTransmMatrix.isSelected();
        replicationInfo.m_SpaceFinderTimeout = this.repFindTimeoutTF.getText().trim().length() > 0 ? this.repFindTimeoutTF.getText().trim() : Integer.toString(2000);
        replicationInfo.m_SyncOnCommit = this.syncOnCommitCB.isSelected();
        replicationInfo.m_SyncOnCommitTimeOut = this.syncTimeOutTF.getText().trim().length() > 0 ? this.syncTimeOutTF.getText().trim() : Integer.toString(300000);
        replicationInfo.m_ReplicationChunkSize = this.chunkSizeTF.getText().trim().length() > 0 ? this.chunkSizeTF.getText().trim() : Integer.toString(100);
        replicationInfo.m_ReplicationIntervalMillis = this.interMsTF.getText().trim().length() > 0 ? this.interMsTF.getText().trim() : Integer.toString(3000);
        replicationInfo.m_ReplicationIntervalOperations = this.interOperTF.getText().trim().length() > 0 ? this.interOperTF.getText().trim() : Integer.toString(100);
        replicationInfo.m_ReplicateOriginalState = this.repOriginalStateCB.isSelected();
        replicationInfo.m_CommunicationMode = (String)this.communicationModeComboBox.getSelectedItem();
        replicationInfo.m_TodoQueueTimeout = this.todoQueueTimeoutTF.getText().trim().length() > 0 ? this.todoQueueTimeoutTF.getText().trim() : String.valueOf(2000L);
        replicationInfo.m_MinUnicastWorkingThreads = this.minUnicastWorkThreadsTF.getText().trim().length() > 0 ? this.minUnicastWorkThreadsTF.getText().trim() : Integer.toString(4);
        replicationInfo.m_MaxUnicastWorkingThreads = this.maxUnicastWorkThreadsTF.getText().trim().length() > 0 ? this.maxUnicastWorkThreadsTF.getText().trim() : Integer.toString(64);
        replicationInfo.m_MinMulticastWorkingThreads = this.minMulticastWorkThreadsTF.getText().trim().length() > 0 ? this.minMulticastWorkThreadsTF.getText().trim() : Integer.toString(4);
        replicationInfo.m_MaxMulticastWorkingThreads = this.maxMulticastWorkThreadsTF.getText().trim().length() > 0 ? this.maxMulticastWorkThreadsTF.getText().trim() : Integer.toString(16);
        replicationInfo.m_IpGroup = this.ipGroupTF.getText().trim().length() > 0 ? this.ipGroupTF.getText().trim() : "224.0.0.1";
        replicationInfo.m_Port = this.portTF.getText().trim().length() > 0 ? this.portTF.getText().trim() : Integer.toString(28672);
        replicationInfo.m_TTL = ClusterXML.TTL_DEFAULT_VALUE;
        replicationInfo.m_ReplFindReportInterval = ClusterXML.REPL_FIND_REPORT_INTERVAL_DEFAULT_VALUE;
        replicationInfo.m_RedoLogCapacity = ClusterXML.REPL_REDO_LOG_CAPACITY_DEFAULT_VALUE;
        replicationInfo.m_RecoveryChunkSize = ClusterXML.RECOVERY_CHUNK_SIZE_DEFAULT_VALUE;
        return replicationInfo;
    }

    public void updateDataForRepMatrix(ClusterMemberInfo[] clusterMemberInfoArray, boolean bl2) {
        DefaultListModel<ClusterMemberInfo> defaultListModel = new DefaultListModel<ClusterMemberInfo>();
        for (int i2 = 0; i2 < clusterMemberInfoArray.length; ++i2) {
            defaultListModel.addElement(clusterMemberInfoArray[i2]);
        }
        this.updateDataForRepMatrix(defaultListModel, bl2);
    }

    public void updateDataForRepMatrix(DefaultListModel defaultListModel, boolean bl2) {
        this.m_groupMembersListModel = defaultListModel;
        boolean bl3 = defaultListModel.getSize() > 1 && bl2;
        this.chboxTransmMatrix.setSelected(bl3);
        this.butEditTransmMatrix.setEnabled(this.chboxTransmMatrix.isSelected() && bl3);
    }

    public void setGroupMembersListModel(DefaultListModel defaultListModel) {
        this.m_groupMembersListModel = defaultListModel;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
    }

    public void stateChanged(ChangeEvent changeEvent) {
    }

    public class RadioListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl2 = GroupReplicationPanel.this.asyncButton.isSelected();
            GroupReplicationPanel.this.ReplicationTabbedPane.setEnabledAt(1, bl2);
            GroupReplicationPanel.this.ReplicationTabbedPane.setEnabledAt(2, !bl2);
        }
    }
}

