/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.map;

import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.client.CacheException;
import com.j_spaces.core.client.CacheTimeoutException;
import com.j_spaces.core.client.DCacheSpaceImpl;
import com.j_spaces.core.client.EntryNotInSpaceException;
import com.j_spaces.core.client.ExternalEntry;
import com.j_spaces.core.client.JSpaceProxy;
import com.j_spaces.core.client.JSpaceProxyUtil;
import com.j_spaces.core.client.OperationTimeoutException;
import com.j_spaces.javax.cache.CacheEntry;
import com.j_spaces.javax.cache.CacheListener;
import com.j_spaces.map.AbstractMap;
import com.j_spaces.map.Attribute;
import com.j_spaces.map.Envelope;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.jini.core.entry.Entry;
import net.jini.core.transaction.Transaction;

public final class GSMapImpl
extends AbstractMap {
    private final int a;

    public GSMapImpl(IJSpace iJSpace, long l2, Transaction transaction, int n2) {
        super(iJSpace, l2, transaction, n2, iJSpace.isOptimisticLockingEnabled());
        try {
            iJSpace.snapshot(new Envelope());
            this.a = ((IRemoteJSpaceAdmin)iJSpace.getAdmin()).getConfig().getSerializationType();
        }
        catch (RemoteException remoteException) {
            throw new CacheException(remoteException);
        }
    }

    public GSMapImpl(IJSpace iJSpace) {
        this(iJSpace, -1L, null, 0);
    }

    public GSMapImpl(IJSpace iJSpace, long l2) {
        this(iJSpace, l2, null, 0);
    }

    public GSMapImpl(IJSpace iJSpace, int n2) {
        this(iJSpace, -1L, null, n2);
    }

    public GSMapImpl(IJSpace iJSpace, Transaction transaction) {
        this(iJSpace, -1L, transaction, 0);
    }

    public Object internalPut(Object object, Object object2, Attribute[] attributeArray, long l2) throws CacheException {
        try {
            Envelope envelope = this.buildEnvelope(object, object2, attributeArray, null);
            ExternalEntry externalEntry = null;
            try {
                externalEntry = (ExternalEntry)this._spaceProxy.update((Entry)envelope, this._transaction, l2, this._timeout, 4096);
            }
            catch (OperationTimeoutException operationTimeoutException) {
                throw new CacheTimeoutException(envelope.getUID());
            }
            Object object3 = null;
            if (externalEntry != null) {
                object3 = Envelope.getValue(externalEntry);
                if (this._isVersioned) {
                    _entryInfos.setEntryVersion(object2, object, externalEntry.m_VersionID);
                }
            }
            if (this._isVersioned) {
                _entryInfos.setEntryVersion(object2, object, envelope.m_VersionID);
            }
            return object3;
        }
        catch (Exception exception) {
            if (exception instanceof CacheTimeoutException) {
                throw (CacheTimeoutException)exception;
            }
            throw new CacheException(exception);
        }
    }

    public Object internalRemove(Object object, long l2) throws CacheException {
        return this.a(object, l2, true, false);
    }

    public boolean containsKey(Object object) {
        try {
            Envelope envelope = this.buildKeyEnvelope(object);
            return this._spaceProxy.read(envelope, this._transaction, 0L) != null;
        }
        catch (Exception exception) {
            throw new CacheException(exception);
        }
    }

    public boolean containsValue(Object object) {
        try {
            Envelope envelope = new Envelope((Object)null, object);
            return this._spaceProxy.count(envelope, this._transaction) > 0;
        }
        catch (Exception exception) {
            throw new CacheException(exception);
        }
    }

    public Object internalGet(Object object, long l2, boolean bl2) {
        return this.a(object, l2, false, bl2);
    }

    private Object a(Object object, long l2, boolean bl2, boolean bl3) {
        try {
            Envelope envelope = this.buildKeyEnvelope(object);
            ExternalEntry externalEntry = bl2 ? (this._transaction == null ? (ExternalEntry)this._spaceProxy.take(envelope, this._transaction, l2) : (ExternalEntry)this._spaceProxy.takeIfExists(envelope, this._transaction, l2)) : (this._transaction == null ? (this.a == 0 && l2 == 0L && this._spaceProxy instanceof JSpaceProxy && this._spaceProxy.isEmbedded() ? ((JSpaceProxy)this._spaceProxy).readEnvelope(envelope) : (ExternalEntry)this._spaceProxy.read(envelope, this._transaction, l2)) : (ExternalEntry)this._spaceProxy.readIfExists(envelope, this._transaction, l2));
            if (externalEntry == null || externalEntry.m_FieldsValues == null) {
                if (this._transaction == null) {
                    return null;
                }
                throw new CacheTimeoutException(envelope.getUID());
            }
            if (bl3) {
                return Envelope.getAttributes(externalEntry);
            }
            Object object2 = Envelope.getValue(externalEntry);
            try {
                object2 = JSpaceProxyUtil.deSerializeFieldValue(object2, this._compression, false);
            }
            catch (IOException iOException) {
                throw new CacheException(iOException);
            }
            if (this._isVersioned) {
                _entryInfos.setEntryVersion(object2, object, externalEntry.m_VersionID);
            }
            return object2;
        }
        catch (EntryNotInSpaceException entryNotInSpaceException) {
            return null;
        }
        catch (Exception exception) {
            if (exception instanceof CacheTimeoutException) {
                throw (CacheTimeoutException)exception;
            }
            throw new CacheException(exception);
        }
    }

    public void clear() {
        this.clear(false);
    }

    public void clear(boolean bl2) {
        try {
            if (this._spaceProxy instanceof DCacheSpaceImpl) {
                ((DCacheSpaceImpl)this._spaceProxy).getLocalSpace().clear(null, null);
                if (bl2) {
                    ((DCacheSpaceImpl)this._spaceProxy).getRemoteSpace().clear(null, null);
                }
            } else {
                this._spaceProxy.clear(null, null);
            }
        }
        catch (Exception exception) {
            throw new CacheException(exception);
        }
    }

    public Collection values() {
        Entry[] entryArray;
        Envelope envelope = new Envelope();
        try {
            entryArray = this._spaceProxy.readMultiple(envelope, this._transaction, Integer.MAX_VALUE);
        }
        catch (Exception exception) {
            throw new CacheException(exception);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(entryArray.length);
        Entry[] entryArray2 = entryArray;
        int n2 = entryArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Entry entry = entryArray2[i2];
            arrayList.add(Envelope.getValue((ExternalEntry)entry));
        }
        return arrayList;
    }

    public Set entrySet() {
        Entry[] entryArray;
        Envelope envelope = new Envelope();
        try {
            entryArray = this._spaceProxy.readMultiple(envelope, this._transaction, Integer.MAX_VALUE);
        }
        catch (Exception exception) {
            throw new CacheException(exception);
        }
        HashSet<SimpleEntry> hashSet = new HashSet<SimpleEntry>();
        Entry[] entryArray2 = entryArray;
        int n2 = entryArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Entry entry = entryArray2[i2];
            ExternalEntry externalEntry = (ExternalEntry)entry;
            SimpleEntry simpleEntry = new SimpleEntry(Envelope.getKey(externalEntry), Envelope.getValue(externalEntry), externalEntry.m_VersionID);
            hashSet.add(simpleEntry);
        }
        return hashSet;
    }

    public Set keySet() {
        Entry[] entryArray;
        Envelope envelope = new Envelope();
        try {
            entryArray = this._spaceProxy.readMultiple(envelope, this._transaction, Integer.MAX_VALUE);
        }
        catch (Exception exception) {
            throw new CacheException(exception);
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        Entry[] entryArray2 = entryArray;
        int n2 = entryArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Entry entry = entryArray2[i2];
            hashSet.add(Envelope.getKey((ExternalEntry)entry));
        }
        return hashSet;
    }

    public final void addListener(CacheListener cacheListener) {
        throw new UnsupportedOperationException();
    }

    public final boolean evict(Object object) {
        return true;
    }

    public final CacheEntry getCacheEntry(Object object) {
        Object object2 = this.get(object);
        long l2 = _entryInfos.getEntryVersion(object2, object);
        return new SimpleEntry(object, object2, l2);
    }

    public Object peek(Object object) {
        return this.get(object);
    }

    public void removeListener(CacheListener cacheListener) {
        throw new UnsupportedOperationException();
    }

    private static class SimpleEntry
    implements CacheEntry {
        private Object a;
        private Object b;
        private long c;

        public SimpleEntry(Object object, Object object2, long l2) {
            this.a = object;
            this.b = object2;
            this.c = l2;
        }

        public SimpleEntry(CacheEntry cacheEntry) {
            this.a = cacheEntry.getKey();
            this.b = cacheEntry.getValue();
        }

        public Object getKey() {
            return this.a;
        }

        public Object getValue() {
            return this.b;
        }

        public Object setValue(Object object) {
            Object object2 = this.b;
            this.b = object;
            return object2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return SimpleEntry.a(this.a, entry.getKey()) && SimpleEntry.a(this.b, entry.getValue());
        }

        public int hashCode() {
            return (this.a == null ? 0 : this.a.hashCode()) ^ (this.b == null ? 0 : this.b.hashCode());
        }

        public String toString() {
            return this.a + "=" + this.b;
        }

        private static boolean a(Object object, Object object2) {
            return object == null ? object2 == null : object.equals(object2);
        }

        public long getVersion() {
            return this.c;
        }
    }
}

