/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.kernel;

import com.j_spaces.core.cluster.ClusterXML;
import com.j_spaces.core.exception.ClusterConfigurationException;
import com.j_spaces.core.exception.SpaceConfigurationException;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.obf.be;
import com.j_spaces.obf.li;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ResourceLoader {
    private static final Logger a = Logger.getLogger("com.gigaspaces.kernel");

    public static InputStream getResourceStream(String string) {
        InputStream inputStream = null;
        try {
            ClassLoader classLoader;
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            Thread thread = Thread.currentThread();
            inputStream = classLoader.getResourceAsStream(string);
            if (a.isLoggable(Level.FINE)) {
                StringBuffer stringBuffer = new StringBuffer("ClassLoader Hierarchy: ");
                for (classLoader = thread.getContextClassLoader(); classLoader != null; classLoader = classLoader.getParent()) {
                    stringBuffer.append(classLoader.getClass().toString() + " <-- ");
                }
                a.log(Level.FINE, "Load resource: [" + string + "] Thread: [" + thread.getName() + "] using ClassLoader: [" + classLoader + "] \n" + " [ " + stringBuffer.toString() + " ] \n" + JSpaceUtilities.getStackTrace(new Exception("Debugging stack trace: ")));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return inputStream;
    }

    public static URL getResourceURL(String string) {
        URL uRL = null;
        try {
            ClassLoader classLoader;
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            Thread thread = Thread.currentThread();
            uRL = classLoader.getResource(string);
            if (a.isLoggable(Level.FINE)) {
                StringBuffer stringBuffer = new StringBuffer("ClassLoader Hierarchy: ");
                for (classLoader = thread.getContextClassLoader(); classLoader != null; classLoader = classLoader.getParent()) {
                    stringBuffer.append(classLoader.getClass().toString() + " <-- ");
                }
                a.log(Level.FINE, "Load resource: [" + string + "] Thread: [" + thread.getName() + "] using ClassLoader: [" + classLoader + "] \n" + " [ " + stringBuffer.toString() + " ] \n" + JSpaceUtilities.getStackTrace(new Exception("Debugging stack trace: ")));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return uRL;
    }

    public static Properties findCustomPropertiesObj(String string) throws IOException {
        Serializable serializable;
        InputStream inputStream = null;
        String string2 = null;
        boolean bl2 = string.startsWith("http:");
        if (bl2) {
            try {
                serializable = new URL(string);
                URLConnection uRLConnection = ((URL)serializable).openConnection();
                inputStream = uRLConnection.getInputStream();
                string2 = string;
            }
            catch (Exception exception) {
                System.out.println("CONFIG: Failed to download properties file from '" + string + "' cause: " + exception.getClass().getName() + " message: " + exception.getMessage());
                if (a.isLoggable(Level.FINE)) {
                    a.log(Level.FINE, exception.getMessage(), exception);
                }
                return null;
            }
        } else {
            string2 = "config/" + string + ".properties";
            inputStream = ResourceLoader.getResourceStream(string2);
        }
        serializable = null;
        if (inputStream != null) {
            if (a.isLoggable(Level.CONFIG)) {
                a.config("Loading properties file from: " + (bl2 ? string : ResourceLoader.getResourceURL(string2).toString()));
            }
            serializable = new Properties();
            ((Properties)serializable).load(inputStream);
            inputStream.close();
            if (a.isLoggable(Level.FINE)) {
                a.fine("custom properties file values: ");
                ((Properties)serializable).list(System.out);
            }
        } else if (a.isLoggable(Level.WARNING)) {
            a.warning("Failed to load properties file: " + string2);
        }
        return serializable;
    }

    public static InputStream findClusterXSLSchema(InputStream inputStream) throws ClusterConfigurationException {
        String string = null;
        try {
            Document document = JSpaceUtilities.getDocumentBuilder(true, true).parse(inputStream);
            string = ClusterXML.getNodeValueIfExists(document.getDocumentElement(), "cluster-schema-name");
            if (JSpaceUtilities.isEmpty(string)) {
                String string2 = "Could not find the <cluster-schema-name> tag in the cluster members xml file.";
                throw new ClusterConfigurationException(string2);
            }
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        return ResourceLoader.findClusterXSLSchema(string);
    }

    public static InputStream resolveClusterXSLSchema(String string) throws ClusterConfigurationException {
        String string2 = null;
        InputStream inputStream = ResourceLoader.findClusterXML(string);
        try {
            Document document = JSpaceUtilities.getDocumentBuilder(true, true).parse(inputStream);
            string2 = ClusterXML.getNodeValueIfExists(document.getDocumentElement(), "cluster-schema-name");
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        if (JSpaceUtilities.isEmpty(string2)) {
            String string3 = "Could not find the <cluster-schema-name> tag for cluster members xml file: " + string;
            throw new ClusterConfigurationException(string3);
        }
        String string4 = "config/schemas/" + string2 + "-cluster-schema.xsl";
        InputStream inputStream2 = ResourceLoader.getResourceStream(string4);
        if (inputStream2 != null) {
            if (a.isLoggable(Level.CONFIG)) {
                a.config("Loaded the cluster xsl schema < " + ResourceLoader.getResourceURL(string4) + " > for the cluster config setup.");
            }
            return inputStream2;
        }
        String string5 = "Could not find the cluster xsl schema file: " + string4;
        throw new ClusterConfigurationException(string5);
    }

    public static InputStream findClusterXML(String string) {
        String string2 = string;
        String string3 = "config/" + string2 + "-cluster.xml";
        InputStream inputStream = ResourceLoader.getResourceStream(string3);
        if (inputStream != null) {
            if (a.isLoggable(Level.CONFIG)) {
                a.config("Loaded the cluster XML < " + ResourceLoader.getResourceURL(string2) + " > for the cluster config setup.");
            }
            return inputStream;
        }
        String string4 = "config/default-cluster.xml";
        inputStream = ResourceLoader.getResourceStream(string4);
        if (inputStream != null) {
            if (a.isLoggable(Level.WARNING)) {
                a.warning("Could not find the cluster xml file: " + string3 + ".\n Loaded the default cluster xml < " + ResourceLoader.getResourceURL(string4) + " > for the cluster config setup.");
            }
            return inputStream;
        }
        if (a.isLoggable(Level.WARNING)) {
            a.warning("The requested cluster xml file does not exist in the following path: " + string4);
        }
        return inputStream;
    }

    public static InputStream findClusterXSLSchema(String string) throws ClusterConfigurationException {
        String string2 = string;
        String string3 = "config/schemas/" + string2 + "-cluster-schema.xsl";
        InputStream inputStream = ResourceLoader.getResourceStream(string3);
        if (inputStream != null) {
            if (a.isLoggable(Level.CONFIG)) {
                a.config("Loaded the cluster xsl schema < " + ResourceLoader.getResourceURL(string3) + " > for the cluster config setup.");
            }
            return inputStream;
        }
        String string4 = "Could not find the cluster xsl schema file: " + string;
        throw new ClusterConfigurationException(string4);
    }

    public static InputStream findContainerSchema(String string) {
        String string2;
        InputStream inputStream;
        String string3 = string;
        if (JSpaceUtilities.isEmpty(string)) {
            string3 = "default";
        }
        if ((inputStream = ResourceLoader.getResourceStream(string2 = "config/schemas/" + string3 + "-container-schema.xml")) != null) {
            if (a.isLoggable(Level.CONFIG)) {
                a.config("Loaded the container schema < " + ResourceLoader.getResourceURL(string2) + " > for the container configuration.");
            }
            return inputStream;
        }
        String string4 = "config/schemas/default-container-schema.xml";
        inputStream = ResourceLoader.getResourceStream(string4);
        if (inputStream != null) {
            if (a.isLoggable(Level.WARNING)) {
                URL uRL = ResourceLoader.getResourceURL(string2);
                if (uRL != null) {
                    a.warning("Could not find the container schema file at: " + uRL + ".\nInstead, loaded the default container schema < " + string4 + " > for the container configuration.");
                } else {
                    a.warning("Could not find the container schema: " + string2 + ".\nInstead, loaded the default container schema < " + string4 + " > for the container configuration.");
                }
            }
            return inputStream;
        }
        if (a.isLoggable(Level.WARNING)) {
            a.warning("The requested container schema file does not exist in the following path: " + string4);
        }
        return inputStream;
    }

    public static InputStream findConfigDCache(String string, String string2, String string3, String string4) throws SpaceConfigurationException {
        String string5 = "config/" + string + "_DCache.xml";
        InputStream inputStream = ResourceLoader.getResourceStream(string5);
        if (inputStream == null) {
            String string6 = "\nCould not find the clustered DCache configuration '" + string + "'";
            String string7 = ".";
            if (string4 != null) {
                string7 = " for cluster config '" + string4 + "'.";
            } else if (string2 != null) {
                string7 = " for schema '" + string2 + "'.";
            } else if (string3 != null) {
                string7 = " for space '" + string3 + "'.";
            }
            string6 = string6 + string7;
            throw new SpaceConfigurationException(string6);
        }
        String string8 = ".";
        if (string4 != null) {
            string8 = "for the cluster configuration '" + string4 + "'.";
        } else if (string2 != null) {
            string8 = "for the space schema '" + string2 + "'.";
        } else if (string3 != null) {
            string8 = "for the space '" + string3 + "'.";
        }
        if (a.isLoggable(Level.FINE)) {
            a.fine("Loaded the clustered DCache configuration from < " + ResourceLoader.getResourceURL(string5) + " > " + string8);
        }
        return inputStream;
    }

    public static InputStream findConfigClusteredJMS(String string, String string2, String string3, String string4) throws SpaceConfigurationException {
        String string5 = "config/" + string + "_ClusteredJMS.xml";
        InputStream inputStream = ResourceLoader.getResourceStream(string5);
        if (inputStream == null) {
            String string6 = "\nCould not find the clustered JMS configuration file '" + string + "'";
            String string7 = ".";
            if (string4 != null) {
                string7 = " for cluster config '" + string4 + "'.";
            } else if (string2 != null) {
                string7 = " for schema '" + string2 + "'.";
            } else if (string3 != null) {
                string7 = " for space '" + string3 + "'.";
            }
            string6 = string6 + string7;
            throw new SpaceConfigurationException(string6);
        }
        String string8 = ".";
        if (string4 != null) {
            string8 = "for the cluster configuration '" + string4 + "'.";
        } else if (string2 != null) {
            string8 = "for the space schema '" + string2 + "'.";
        } else if (string3 != null) {
            string8 = "for the space '" + string3 + "'.";
        }
        if (a.isLoggable(Level.FINE)) {
            a.fine("Loaded the clustered JMS configuration from < " + ResourceLoader.getResourceURL(string5) + " > " + string8);
        }
        return inputStream;
    }

    public static InputStream findJMSConfig(String string) throws JMSException {
        InputStream inputStream;
        URL uRL = null;
        String string2 = "config/jms/";
        boolean bl2 = false;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (uRL != null && !JSpaceUtilities.isEmpty(uRL.getProtocol())) {
            string2 = uRL.getFile();
            bl2 = true;
        }
        if (!bl2) {
            string2 = string != null ? "config/jms/" + string : "config/jms/jms-config.xml";
        }
        if ((inputStream = ResourceLoader.getResourceStream(string2)) == null) {
            String string3 = "Could not find the JMS configuration file '" + string2 + "'. It does not exist or not readable.";
            throw new JMSException(string3);
        }
        if (a.isLoggable(Level.CONFIG)) {
            a.config("Loaded the JMS configuration file from < " + ResourceLoader.getResourceURL(string2) + " > ");
        }
        return inputStream;
    }

    public static InputStream findSpaceSchema(String string) {
        String string2;
        InputStream inputStream;
        String string3 = string;
        if (JSpaceUtilities.isEmpty(string)) {
            string3 = "default";
        }
        if ((inputStream = ResourceLoader.getResourceStream(string2 = "config/schemas/" + string3 + "-space-schema.xml")) != null) {
            if (a.isLoggable(Level.CONFIG)) {
                a.config("Loaded the space schema < " + ResourceLoader.getResourceURL(string2) + " > for the space configuration.");
            }
            return inputStream;
        }
        String string4 = "config/schemas/default-space-schema.xml";
        inputStream = ResourceLoader.getResourceStream(string4);
        if (inputStream != null) {
            if (a.isLoggable(Level.WARNING)) {
                URL uRL = ResourceLoader.getResourceURL(string2);
                if (uRL != null) {
                    a.warning("Could not find the space schema file at: " + ResourceLoader.getResourceURL(string2) + ".\nInstead, loaded the default space schema < " + string4 + " > for the space configuration.");
                } else {
                    a.warning("Could not find the space schema file: " + string2 + ".\nInstead, loaded the default space schema < " + string4 + " > for the space configuration.");
                }
            }
            return inputStream;
        }
        if (a.isLoggable(Level.WARNING)) {
            a.warning("The requested space schema file does not exist in the following path: " + string4);
        }
        return inputStream;
    }

    public static URL findContainerXML(String string) {
        URL uRL = null;
        String string2 = "config/" + string + ".xml";
        uRL = ResourceLoader.getResourceURL(string2);
        if (uRL != null && a.isLoggable(Level.CONFIG)) {
            a.config("Loaded the container xml file < " + uRL + " >.");
        }
        return uRL;
    }

    public static String[] getClusterSchemas() {
        File file = new File(li.a() + File.separator + "config" + File.separator + "schemas");
        return ResourceLoader.getClusterSchemas(file);
    }

    public static String[] getClusterSchemas(File file) {
        int n2;
        if (file == null || !file.exists() || !file.isDirectory()) {
            return new String[0];
        }
        Object[] objectArray = file.list(new be());
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            int n3 = ((String)objectArray[n2]).indexOf("-cluster-schema.xsl");
            objectArray[n2] = ((String)objectArray[n2]).substring(0, n3);
        }
        Arrays.sort(objectArray);
        for (n2 = 1; n2 < objectArray.length; ++n2) {
            if (!((String)objectArray[n2]).equals("async_replicated")) continue;
            Object object = objectArray[0];
            objectArray[0] = "async_replicated";
            objectArray[n2] = object;
            break;
        }
        return objectArray;
    }
}

