/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc;

import com.j_spaces.core.IJSpace;
import com.j_spaces.jdbc.ParserManagerMBean;
import com.j_spaces.jdbc.Query;
import com.j_spaces.jdbc.QueryProcessor;
import com.j_spaces.jdbc.SqlParser;
import com.j_spaces.obf.bm;
import java.io.BufferedReader;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;

public class ParserManager
implements ParserManagerMBean {
    private static Logger a = Logger.getLogger("com.gigaspaces.persistent");
    private static ParserManager b = null;
    private bm c = new bm();

    public ParserManager() {
        try {
            if (QueryProcessor.JMX_ON) {
                QueryProcessor.jmxServer.registerMBean(this, new ObjectName(QueryProcessor.jmxServer.getDefaultDomain() + ":type=" + this.getClass().getName()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static synchronized ParserManager getInstance() {
        return ParserManager.getInstance(false);
    }

    public static synchronized ParserManager getInstance(boolean bl2) {
        if (b == null || bl2) {
            b = new ParserManager();
        }
        return b;
    }

    public Query handleStatement(String string, IJSpace iJSpace, Hashtable hashtable) throws SQLException {
        Query query = this.a(string);
        try {
            if (query == null) {
                if (a.isLoggable(Level.FINE)) {
                    a.fine("Query wasn't in cache, will be parsed");
                }
                StringReader stringReader = new StringReader(string);
                BufferedReader bufferedReader = new BufferedReader(stringReader);
                SqlParser sqlParser = new SqlParser(bufferedReader);
                query = sqlParser.parseStatement();
                query.validateQuery(iJSpace, hashtable);
                this.a(string, query);
            }
            return query;
        }
        catch (Throwable throwable) {
            if (a.isLoggable(Level.FINE)) {
                a.log(Level.FINE, "Couldn't parse given statement [" + string + "]", throwable);
            }
            throw new SQLException("Error in statement [" + string + "]\n" + throwable, "GSP", -201);
        }
    }

    private void a(String string, Query query) {
        this.c.put(string, query);
    }

    private Query a(String string) {
        return (Query)this.c.get(string);
    }

    public String[] getCachedQueries() {
        String[] stringArray = new String[this.c.size()];
        stringArray = this.c.keySet().toArray(stringArray);
        return stringArray;
    }

    public synchronized void clean() {
        if (this.c != null) {
            this.c.clear();
        }
        b = null;
    }
}

