/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.service;

import com.j_spaces.core.exception.SpaceConfigurationException;
import com.j_spaces.core.service.AbstractService;
import com.j_spaces.core.service.ServiceAdmin;
import com.j_spaces.core.service.ServiceAdminProxy;
import com.j_spaces.kernel.log.JProperties;
import com.j_spaces.kernel.time.SystemTime;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.discovery.DiscoveryGroupManagement;
import net.jini.discovery.DiscoveryLocatorManagement;
import net.jini.export.Exporter;
import net.jini.lookup.JoinManager;

public class ServiceAdminImpl
implements ServiceAdmin {
    public static final long MAX_UNEXPORT_DELAY = 60000L;
    public final RemoteException jiniConfigurationException = new SpaceConfigurationException("The space has not configured to support Jini lookup features");
    public final RemoteException joinManagerNullException = new RemoteException("JoinManager is null");
    public AbstractService m_service;
    public Exporter m_exporter;
    public ServiceAdmin m_thisRemoteRef;
    public ServiceAdminProxy m_adminProxy;
    private static Logger a = Logger.getLogger("com.gigaspaces.admin");

    public ServiceAdminImpl(AbstractService abstractService, Exporter exporter) throws RemoteException {
        this.m_service = abstractService;
        this.m_exporter = exporter;
        this.m_thisRemoteRef = (ServiceAdmin)exporter.export(this);
    }

    public ServiceAdmin getProxy() {
        if (this.m_adminProxy == null) {
            this.m_adminProxy = ServiceAdminProxy.getInstance(this.m_thisRemoteRef, this.m_service.getUuid());
        }
        return this.m_adminProxy;
    }

    public void unexport(boolean bl2) {
        block7: {
            if (this.m_thisRemoteRef != null) {
                try {
                    if (bl2) {
                        this.m_exporter.unexport(true);
                    } else {
                        long l2 = SystemTime.timeMillis() + 60000L;
                        boolean bl3 = false;
                        while (!bl3 && SystemTime.timeMillis() < l2) {
                            bl3 = this.m_exporter.unexport(false);
                            if (bl3) continue;
                            Thread.yield();
                        }
                        if (!bl3) {
                            this.m_exporter.unexport(true);
                        }
                    }
                }
                catch (Exception exception) {
                    if (!a.isLoggable(Level.SEVERE)) break block7;
                    a.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
        }
    }

    public boolean isLookupRegEnabled() {
        return Boolean.valueOf(JProperties.getProperty("com.j_spaces.core.container.directory_services.jini_lus.enabled", "true"));
    }

    public void validateJoinManager(JoinManager joinManager) throws RemoteException {
        if (joinManager == null) {
            if (this.isLookupRegEnabled()) {
                throw this.joinManagerNullException;
            }
            throw this.jiniConfigurationException;
        }
    }

    public void destroy() throws RemoteException {
        this.m_service.shutdown();
    }

    public Entry[] getLookupAttributes() throws RemoteException {
        JoinManager joinManager = this.m_service.getJoinManager();
        this.validateJoinManager(joinManager);
        return joinManager.getAttributes();
    }

    public void addLookupAttributes(Entry[] entryArray) throws RemoteException {
        JoinManager joinManager = this.m_service.getJoinManager();
        this.validateJoinManager(joinManager);
        joinManager.addAttributes(entryArray, false);
    }

    public void modifyLookupAttributes(Entry[] entryArray, Entry[] entryArray2) throws RemoteException {
        JoinManager joinManager = this.m_service.getJoinManager();
        this.validateJoinManager(joinManager);
        joinManager.modifyAttributes(entryArray, entryArray2, false);
    }

    public String[] getLookupGroups() throws RemoteException {
        JoinManager joinManager = this.m_service.getJoinManager();
        this.validateJoinManager(joinManager);
        DiscoveryGroupManagement discoveryGroupManagement = (DiscoveryGroupManagement)((Object)joinManager.getDiscoveryManager());
        return discoveryGroupManagement.getGroups();
    }

    public void addLookupGroups(String[] stringArray) throws RemoteException {
        JoinManager joinManager = this.m_service.getJoinManager();
        this.validateJoinManager(joinManager);
        DiscoveryGroupManagement discoveryGroupManagement = (DiscoveryGroupManagement)((Object)joinManager.getDiscoveryManager());
        try {
            discoveryGroupManagement.addGroups(stringArray);
        }
        catch (IOException iOException) {
            throw new RemoteException(iOException.toString());
        }
    }

    public void removeLookupGroups(String[] stringArray) throws RemoteException {
        JoinManager joinManager = this.m_service.getJoinManager();
        this.validateJoinManager(joinManager);
        DiscoveryGroupManagement discoveryGroupManagement = (DiscoveryGroupManagement)((Object)joinManager.getDiscoveryManager());
        discoveryGroupManagement.removeGroups(stringArray);
    }

    public void setLookupGroups(String[] stringArray) throws RemoteException {
        JoinManager joinManager = this.m_service.getJoinManager();
        this.validateJoinManager(joinManager);
        DiscoveryGroupManagement discoveryGroupManagement = (DiscoveryGroupManagement)((Object)joinManager.getDiscoveryManager());
        try {
            discoveryGroupManagement.setGroups(stringArray);
        }
        catch (IOException iOException) {
            throw new RemoteException(iOException.toString());
        }
    }

    public LookupLocator[] getLookupLocators() throws RemoteException {
        JoinManager joinManager = this.m_service.getJoinManager();
        this.validateJoinManager(joinManager);
        DiscoveryLocatorManagement discoveryLocatorManagement = (DiscoveryLocatorManagement)((Object)joinManager.getDiscoveryManager());
        return discoveryLocatorManagement.getLocators();
    }

    public void addLookupLocators(LookupLocator[] lookupLocatorArray) throws RemoteException {
        JoinManager joinManager = this.m_service.getJoinManager();
        this.validateJoinManager(joinManager);
        DiscoveryLocatorManagement discoveryLocatorManagement = (DiscoveryLocatorManagement)((Object)joinManager.getDiscoveryManager());
        discoveryLocatorManagement.addLocators(lookupLocatorArray);
    }

    public void removeLookupLocators(LookupLocator[] lookupLocatorArray) throws RemoteException {
        JoinManager joinManager = this.m_service.getJoinManager();
        this.validateJoinManager(joinManager);
        DiscoveryLocatorManagement discoveryLocatorManagement = (DiscoveryLocatorManagement)((Object)joinManager.getDiscoveryManager());
        discoveryLocatorManagement.removeLocators(lookupLocatorArray);
    }

    public void setLookupLocators(LookupLocator[] lookupLocatorArray) throws RemoteException {
        JoinManager joinManager = this.m_service.getJoinManager();
        this.validateJoinManager(joinManager);
        DiscoveryLocatorManagement discoveryLocatorManagement = (DiscoveryLocatorManagement)((Object)joinManager.getDiscoveryManager());
        discoveryLocatorManagement.setLocators(lookupLocatorArray);
    }
}

