/*
 * Decompiled with CFR 0.152.
 */
package DTDDoc;

import DTDDoc.DTDCommenter;
import DTDDoc.Logger;
import DTDDoc.SystemLogger;
import DTDDoc.Tools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class DTDDoc {
    private Logger log;
    private Properties configuration = null;

    private RE[] propertyToREArray(Properties configuration, String propertyName) throws RESyntaxException {
        String[] s = Tools.listToArray(configuration.getProperty(propertyName), ",");
        RE[] l = new RE[s.length];
        for (int i = 0; i < s.length; ++i) {
            l[i] = new RE(s[i]);
        }
        return l;
    }

    private boolean satisfyOneRE(String s, RE[] regexps) {
        for (int i = 0; i < regexps.length; ++i) {
            if (!regexps[i].match(s)) continue;
            return true;
        }
        return false;
    }

    private Set fileScanner(File source, RE[] acceptList, RE[] rejectList) throws IOException {
        HashSet<File> files = new HashSet<File>();
        if (source.isDirectory()) {
            File[] allFiles = source.listFiles();
            if (allFiles != null) {
                for (int i = 0; i < allFiles.length; ++i) {
                    files.addAll(this.fileScanner(allFiles[i], acceptList, rejectList));
                }
            }
        } else if (source.isFile() && this.satisfyOneRE(source.getCanonicalPath(), acceptList) && !this.satisfyOneRE(source.getCanonicalPath(), rejectList)) {
            this.log.info("Scanned " + source.getCanonicalPath());
            files.add(source);
        }
        return files;
    }

    public String getConfig(String key) {
        if (this.configuration == null) {
            return null;
        }
        return this.configuration.getProperty(key);
    }

    public boolean isPropertySet(String key) {
        return this.configuration != null && this.configuration.containsKey(key);
    }

    public boolean isConfigTrueFor(String key) {
        return "true".equals(this.getConfig(key));
    }

    private void setConfiguration(File source) throws FileNotFoundException, IOException, RESyntaxException {
        if (!source.canRead()) {
            this.log.warn("Unable to read the configuration file : " + source.getCanonicalPath());
            source = new File("default.properties");
            this.log.info("Trying to read it at " + source.getCanonicalPath());
            if (!source.canRead()) {
                this.log.warn("Can't find " + source.getCanonicalPath() + " neither, we'll work blindly !");
                return;
            }
        }
        this.log.info("Configuration used is in :" + source.getCanonicalPath());
        this.configuration = new Properties();
        this.configuration.load(new FileInputStream(source));
    }

    public DTDDoc(Logger log) {
        this.log = log;
    }

    public static void main(String[] args) throws Exception {
        SystemLogger log = new SystemLogger();
        ((Logger)log).info("Welcome to DTDDoc !");
        DTDDoc doc = new DTDDoc(log);
        if (args != null && args[0] != null) {
            doc.setConfiguration(new File(args[0]));
        } else {
            doc.setConfiguration(new File(""));
        }
        String docTitle = doc.getConfig("docTitle");
        File sourceDir = new File(doc.getConfig("DTDsourceDir"));
        File destDir = new File(doc.getConfig("destinationDir"));
        boolean showHiddenTags = doc.isConfigTrueFor("showHiddenTags");
        boolean showFixmeTags = doc.isConfigTrueFor("showFixmeTags");
        boolean getAroundNetBeanComments = doc.isPropertySet("getAroundNetBeanComments") ? doc.isConfigTrueFor("getAroundNetBeanComments") : true;
        ((Logger)log).info("Source dir : " + sourceDir.getCanonicalPath());
        ((Logger)log).info("Destination dir : " + destDir.getCanonicalPath());
        Set scan = doc.fileScanner(sourceDir, doc.propertyToREArray(doc.configuration, "acceptList"), doc.propertyToREArray(doc.configuration, "rejectList"));
        DTDCommenter commenter = new DTDCommenter(log);
        commenter.commentDTDs(scan, sourceDir, destDir, showHiddenTags, showFixmeTags, getAroundNetBeanComments, docTitle, null);
    }
}

