/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.isqlviewer.core.HistoryItem;
import org.isqlviewer.core.HistoryManager;
import org.isqlviewer.core.IPCService;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.model.HistoryTreeModel;
import org.isqlviewer.swing.WizardPanel;
import org.isqlviewer.swing.text.SQLDocument;
import org.isqlviewer.ui.SQLEditor;
import org.isqlviewer.ui.SQLWorkBench;
import org.isqlviewer.util.BasicUtilities;

public final class HistoryViewer
extends JDialog {
    public final Insets insDefault = new Insets(1, 2, 2, 1);
    private static final GridBagConstraints UI_CONSTRAINT = new GridBagConstraints(0, 0, 0, 0, 0.0, 0.0, 0, 0, new Insets(1, 1, 1, 1), 0, 0);
    private JButton btnExec = new JButton(BasicUtilities.getString("Execute"));
    private JButton btnClear = new JButton(BasicUtilities.getString("Clear_All"));
    private JButton btnExit = new JButton(BasicUtilities.getString("Exit"));
    private JButton btnSelect = new JButton(BasicUtilities.getString("Select"));
    private JLabel lblMetaLabel = new JLabel(BasicUtilities.loadIconResource("History16"));
    private HistoryManager manager;
    private JTree treHistoryTree = new JTree();
    private JSplitPane jspRootSplitter = new JSplitPane(1);
    private JTextPane txtSQL = new JTextPane();
    private ListMouseAdapter actionHandler = new ListMouseAdapter(null);
    private HistoryTreeModel mdlHistoryTree = null;
    private SQLWorkBench workbench = null;

    public static final void showDialog(JFrame jFrame, HistoryManager historyManager, SQLWorkBench sQLWorkBench) {
        HistoryViewer historyViewer = new HistoryViewer(jFrame, historyManager, sQLWorkBench);
        historyViewer.setLocationRelativeTo(jFrame);
        historyViewer.show();
    }

    private HistoryViewer(JFrame jFrame, HistoryManager historyManager, SQLWorkBench sQLWorkBench) {
        super(jFrame, BasicUtilities.getString("History_Window_Title"), true);
        this.manager = historyManager;
        this.workbench = sQLWorkBench;
        try {
            this.initUI();
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable, "HistoryViewer()::initUI()", true);
        }
    }

    private void initUI() throws Exception {
        this.actionHandler.owner = this;
        JPanel jPanel = (JPanel)this.getContentPane();
        this.setContentPane(new WizardPanel());
        this.getContentPane().add((Component)jPanel, "root");
        SQLEditor sQLEditor = this.workbench.getEditor();
        SQLDocument sQLDocument = sQLEditor.getDocument();
        this.txtSQL.setDocument((SQLDocument)sQLDocument.clone());
        this.txtSQL.setPreferredSize(new Dimension(320, 100));
        this.txtSQL.setEditable(false);
        this.mdlHistoryTree = new HistoryTreeModel(this.manager);
        this.treHistoryTree.setModel(this.mdlHistoryTree);
        this.treHistoryTree.setCellRenderer(new HistoryTreeRenderer());
        this.treHistoryTree.setRootVisible(false);
        this.treHistoryTree.addTreeSelectionListener(this.actionHandler);
        this.treHistoryTree.addMouseListener(this.actionHandler);
        this.treHistoryTree.expandRow(0);
        this.treHistoryTree.getSelectionModel().setSelectionMode(1);
        this.treHistoryTree.setToolTipText(BasicUtilities.getString("HistoryTree_Tip"));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)this.lblMetaLabel, "North");
        jPanel3.add((Component)this.txtSQL, "Center");
        this.btnClear.addActionListener(this.actionHandler);
        this.btnExec.addActionListener(this.actionHandler);
        this.btnSelect.addActionListener(this.actionHandler);
        this.btnClear.setToolTipText(BasicUtilities.getString("History_Clear_Tip"));
        this.btnExec.setToolTipText(BasicUtilities.getString("History_Exec_Tip"));
        this.btnSelect.setToolTipText(BasicUtilities.getString("History_Select_Tip"));
        this.btnExit.addActionListener(this.actionHandler);
        this.btnClear.setEnabled(!this.manager.isEmpty());
        this.btnExec.setEnabled(false);
        this.btnSelect.setEnabled(false);
        HistoryViewer.constrain(0, 0, 1, 1, 1.0, 0.0, 10, 0);
        jPanel2.add(Box.createHorizontalGlue(), UI_CONSTRAINT);
        HistoryViewer.constrain(1, 0, 1, 1, 0.0, 0.0, 13, 0);
        jPanel2.add((Component)this.btnClear, UI_CONSTRAINT);
        HistoryViewer.constrain(2, 0, 1, 1, 0.0, 0.0, 13, 0);
        jPanel2.add((Component)this.btnSelect, UI_CONSTRAINT);
        HistoryViewer.constrain(3, 0, 1, 1, 0.0, 0.0, 13, 0);
        jPanel2.add((Component)this.btnExec, UI_CONSTRAINT);
        HistoryViewer.constrain(4, 0, 1, 1, 0.0, 0.0, 13, 0);
        jPanel2.add((Component)this.btnExit, UI_CONSTRAINT);
        this.jspRootSplitter.setLeftComponent(new JScrollPane(this.treHistoryTree));
        this.jspRootSplitter.setRightComponent(new JScrollPane(jPanel3));
        jPanel.add((Component)jPanel2, "South");
        jPanel.add((Component)this.jspRootSplitter, "Center");
        this.pack();
        this.setSize(630, 330);
        this.jspRootSplitter.setDividerLocation(this.treHistoryTree.getPreferredSize().width + 4);
    }

    private static void constrain(int n2, int n3, int n4, int n5, double d2, double d3, int n6, int n7) {
        HistoryViewer.UI_CONSTRAINT.gridx = n2;
        HistoryViewer.UI_CONSTRAINT.gridy = n3;
        HistoryViewer.UI_CONSTRAINT.gridwidth = n4;
        HistoryViewer.UI_CONSTRAINT.gridheight = n5;
        HistoryViewer.UI_CONSTRAINT.weightx = d2;
        HistoryViewer.UI_CONSTRAINT.weighty = d3;
        HistoryViewer.UI_CONSTRAINT.anchor = n6;
        HistoryViewer.UI_CONSTRAINT.fill = n7;
    }

    public static class 1 {
    }

    private static class HistoryTreeRenderer
    extends DefaultTreeCellRenderer {
        private SystemConfig sysConfig = SystemConfig.getInstance();
        private SimpleDateFormat leafFormat = new SimpleDateFormat(this.sysConfig.getFormatForSQLType(92));
        private SimpleDateFormat fmtDayNode = new SimpleDateFormat("MMM EEE dd, yyyy");
        private Calendar calendar = Calendar.getInstance();
        private int cdoy = 0;

        public HistoryTreeRenderer() {
            this.calendar.setTime(new Date());
            this.cdoy = this.calendar.get(6);
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl2, boolean bl3, boolean bl4, int n2, boolean bl5) {
            super.getTreeCellRendererComponent(jTree, object, bl2, bl3, bl4, n2, bl5);
            this.setFont(jTree.getFont().deriveFont(10.0f));
            if (bl4) {
                HistoryItem historyItem = (HistoryItem)object;
                this.setText(this.leafFormat.format(historyItem.getTimeStamp()));
                this.setIcon(BasicUtilities.loadIconResource("Time16"));
            } else {
                try {
                    this.calendar.setTime((Date)object);
                    int n3 = this.calendar.get(6);
                    if (n3 == this.cdoy) {
                        this.setText(BasicUtilities.getString("History_Today", this.fmtDayNode.format(object)));
                    } else if (n3 == this.cdoy - 1) {
                        this.setText(BasicUtilities.getString("History_Yesterday", this.fmtDayNode.format(object)));
                    } else {
                        this.setText(this.fmtDayNode.format(object));
                    }
                    this.setIcon(BasicUtilities.loadIconResource("Date16"));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return this;
        }
    }

    private static class ListMouseAdapter
    extends MouseAdapter
    implements TreeSelectionListener,
    ActionListener {
        private HistoryViewer owner = null;

        private ListMouseAdapter() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 3 && this.owner.btnSelect.isEnabled()) {
                this.actionPerformed(new ActionEvent(this.owner.btnSelect, 0, ""));
            }
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            Object object = this.owner.treHistoryTree.getSelectionPath().getLastPathComponent();
            if (object instanceof HistoryItem) {
                HistoryItem historyItem = (HistoryItem)object;
                this.owner.txtSQL.setText(historyItem.getSQLData());
                ((SQLDocument)this.owner.txtSQL.getDocument()).validateStyles();
                this.owner.lblMetaLabel.setText(BasicUtilities.getString("History_Item_Label", historyItem.getServiceReference()));
                this.owner.btnExec.setEnabled(true);
                this.owner.btnSelect.setEnabled(true);
            } else {
                this.owner.btnExec.setEnabled(false);
                this.owner.btnSelect.setEnabled(false);
                this.owner.txtSQL.setText("");
                this.owner.lblMetaLabel.setText("");
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            IPCService iPCService = SystemConfig.getInstance().getIPCService();
            Object object = actionEvent.getSource();
            if (object == this.owner.btnClear) {
                this.owner.manager.clear();
            } else if (object == this.owner.btnSelect) {
                iPCService.publish(this, "isql-sql-message", this.owner.txtSQL.getText());
            } else if (object == this.owner.btnExec) {
                iPCService.publish(this, "isql-sql-execute", this.owner.txtSQL.getText());
            }
            this.owner.dispose();
        }

        public /* synthetic */ ListMouseAdapter(1 var1_1) {
            this();
        }
    }
}

