/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.swing.ColorIcon;
import org.isqlviewer.swing.JFileList;
import org.isqlviewer.swing.JFontChoser;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.PropertyPage;
import org.isqlviewer.util.UserPreferences;

public abstract class AbstractPropertyPage
extends JPanel
implements PropertyPage {
    private static final String FONT_CLIENT_PROPERTY = "PP-GET-FONT";
    private static final String COLOR_CLIENT_PROPERTY = "PP-GET-COLOR";
    private static final Insets INS = new Insets(1, 1, 1, 1);
    public static final GridBagConstraints UI_CONSTRAINT = new GridBagConstraints(0, 0, 0, 0, 0.0, 0.0, 0, 0, INS, 0, 0);
    public static final UserPreferences prefs = SystemConfig.getInstance().getPreferences();
    private Action colorChooserAction = new ColorChangeAction(this);
    private Hashtable propertyMap = new Hashtable(1);
    private Vector childPages = new Vector();
    private PropertyChangeHandler propertyHandler = new PropertyChangeHandler(null);
    private boolean isModified = false;
    private boolean isLoaded = false;
    static /* synthetic */ Class class$java$awt$event$ActionListener;
    static /* synthetic */ Class class$javax$swing$RootPaneContainer;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public PropertyPage[] getChildren() {
        return this.childPages.toArray(new PropertyPage[0]);
    }

    public Icon getUserIcon() {
        return BasicUtilities.loadIconResource("Preferences16");
    }

    public boolean hasChangedProperties() {
        Iterator iterator = this.childPages.iterator();
        while (iterator.hasNext()) {
            PropertyPage propertyPage = (PropertyPage)iterator.next();
            if (!propertyPage.hasChangedProperties()) continue;
            return true;
        }
        return this.isModified;
    }

    public void revertChangedState() {
        this.setModified(false);
    }

    public void loadProperties() {
        Object object;
        Enumeration enumeration = this.propertyMap.keys();
        block0: while (enumeration.hasMoreElements()) {
            Serializable serializable;
            Object k2 = enumeration.nextElement();
            object = (String)this.propertyMap.get(k2);
            if (k2 instanceof JComponent) {
                serializable = (JComponent)k2;
                if (((JComponent)serializable).getClientProperty(FONT_CLIENT_PROPERTY) != null) {
                    ((JComponent)serializable).setFont(prefs.getFont((String)object));
                    continue;
                }
                if (((JComponent)serializable).getClientProperty(COLOR_CLIENT_PROPERTY) != null) {
                    ((JComponent)serializable).setForeground(prefs.getColor((String)object));
                    continue;
                }
                if (serializable instanceof JToggleButton) {
                    ((JToggleButton)serializable).setSelected(prefs.getBoolean((String)object));
                    continue;
                }
                if (serializable instanceof JComboBox) {
                    ((JComboBox)serializable).setSelectedItem(prefs.get((String)object));
                    continue;
                }
                if (serializable instanceof JTextComponent) {
                    ((JTextComponent)serializable).setText(prefs.get((String)object));
                    continue;
                }
                if (!(serializable instanceof JFileList)) continue;
                ((JFileList)serializable).setPathString(prefs.get((String)object));
                continue;
            }
            if (!(k2 instanceof ButtonGroup)) continue;
            serializable = (ButtonGroup)k2;
            Enumeration<AbstractButton> enumeration2 = ((ButtonGroup)serializable).getElements();
            String string = prefs.get((String)object);
            while (enumeration2.hasMoreElements()) {
                AbstractButton abstractButton = enumeration2.nextElement();
                String string2 = abstractButton.getModel().getActionCommand();
                if (!string.equalsIgnoreCase(string2) && enumeration2.hasMoreElements()) continue;
                ((ButtonGroup)serializable).setSelected(abstractButton.getModel(), true);
                continue block0;
            }
        }
        for (int i2 = 0; i2 < this.childPages.size(); ++i2) {
            object = (PropertyPage)this.childPages.get(i2);
            object.loadProperties();
            if (!(object instanceof AbstractPropertyPage)) continue;
            ((AbstractPropertyPage)object).updatePage();
        }
        this.updatePage();
        this.setLoaded(true);
    }

    public void revertProperties() {
        this.isLoaded = false;
        this.loadProperties();
        this.revertChangedState();
    }

    public void saveProperties() {
        Object object;
        Iterator iterator = this.childPages.iterator();
        while (iterator.hasNext()) {
            object = (PropertyPage)iterator.next();
            if (!object.hasChangedProperties()) continue;
            object.saveProperties();
        }
        if (this.isModified) {
            object = this.propertyMap.keySet().iterator();
            while (object.hasNext()) {
                Object object2;
                Object object3;
                Serializable serializable;
                Object e2 = object.next();
                String string = this.propertyMap.get(e2).toString();
                if (e2 instanceof JComponent) {
                    serializable = (JComponent)e2;
                    if (!((Component)serializable).isEnabled()) {
                        prefs.clear(string);
                        continue;
                    }
                    if (((JComponent)serializable).getClientProperty(FONT_CLIENT_PROPERTY) != null) {
                        prefs.putFont(string, ((Component)serializable).getFont());
                        continue;
                    }
                    if (((JComponent)serializable).getClientProperty(COLOR_CLIENT_PROPERTY) != null) {
                        prefs.putColor(string, ((Component)serializable).getForeground());
                        continue;
                    }
                    if (serializable instanceof JToggleButton) {
                        object3 = (JToggleButton)serializable;
                        prefs.putBoolean(string, ((AbstractButton)object3).isSelected());
                        continue;
                    }
                    if (serializable instanceof JComboBox) {
                        object3 = (JComboBox)serializable;
                        object2 = ((JComboBox)object3).getSelectedItem();
                        if (object2 != null) {
                            prefs.put(string, object2.toString());
                            continue;
                        }
                        prefs.clear(string);
                        continue;
                    }
                    if (serializable instanceof JPasswordField) {
                        object3 = (JPasswordField)serializable;
                        prefs.put(string, new String(((JPasswordField)object3).getPassword()));
                        continue;
                    }
                    if (serializable instanceof JTextComponent) {
                        object3 = (JTextComponent)serializable;
                        prefs.put(string, ((JTextComponent)object3).getText());
                        continue;
                    }
                    if (!(serializable instanceof JFileList)) continue;
                    object3 = (JFileList)serializable;
                    prefs.put(string, ((JFileList)object3).toPathString());
                    continue;
                }
                if (!(e2 instanceof ButtonGroup)) continue;
                serializable = (ButtonGroup)e2;
                object3 = ((ButtonGroup)serializable).getSelection();
                if (object3 != null) {
                    object2 = object3.getActionCommand();
                    prefs.put(string, (String)object2);
                    continue;
                }
                prefs.clear(string);
            }
        }
        this.setModified(false);
        this.applyChanges();
    }

    public final JComponent getPageComponent() {
        return this;
    }

    public void applyChanges() {
    }

    public void updatePage() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void setModified(boolean bl2) {
        AbstractPropertyPage abstractPropertyPage = this;
        synchronized (abstractPropertyPage) {
            this.isModified = bl2;
            try {
                RootPaneContainer rootPaneContainer;
                Class<?> clazz = class$javax$swing$RootPaneContainer;
                if (clazz == null) {
                    clazz = class$javax$swing$RootPaneContainer = new RootPaneContainer[0].getClass().getComponentType();
                }
                if ((rootPaneContainer = (RootPaneContainer)((Object)SwingUtilities.getAncestorOfClass(clazz, this))) != null) {
                    rootPaneContainer.getRootPane().putClientProperty("windowModified", bl2);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void setLoaded(boolean bl2) {
        AbstractPropertyPage abstractPropertyPage = this;
        synchronized (abstractPropertyPage) {
            this.isLoaded = bl2;
        }
    }

    public final void removeChild(PropertyPage propertyPage) {
        this.childPages.remove(propertyPage);
    }

    public final void removeChild(int n2) {
        this.childPages.remove(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChild(PropertyPage propertyPage) {
        Vector vector = this.childPages;
        synchronized (vector) {
            this.childPages.add(propertyPage);
        }
    }

    public final String getPropertyForComponent(JComponent jComponent) {
        return (String)this.propertyMap.get(jComponent);
    }

    public final void setFontPropertyForComponent(JComponent jComponent, String string) {
        jComponent.putClientProperty(FONT_CLIENT_PROPERTY, Boolean.TRUE);
        this.setPropertyForComponent(jComponent, string);
    }

    public final void setColorPropertyForComponent(JComponent jComponent, String string) {
        jComponent.putClientProperty(COLOR_CLIENT_PROPERTY, Boolean.TRUE);
        this.setPropertyForComponent(jComponent, string);
    }

    public final void addButtonGroupProperty(ButtonGroup buttonGroup, String string) {
        this.propertyMap.put(buttonGroup, string);
    }

    public final void setPropertyForComponent(JComponent jComponent, String string) {
        this.propertyMap.put(jComponent, string);
        this.configureComponent(jComponent);
    }

    public static final void constrain(int n2, int n3, int n4, int n5, double d2, double d3, int n6, int n7) {
        AbstractPropertyPage.UI_CONSTRAINT.gridx = n2;
        AbstractPropertyPage.UI_CONSTRAINT.gridy = n3;
        AbstractPropertyPage.UI_CONSTRAINT.gridwidth = n4;
        AbstractPropertyPage.UI_CONSTRAINT.gridheight = n5;
        AbstractPropertyPage.UI_CONSTRAINT.weightx = d2;
        AbstractPropertyPage.UI_CONSTRAINT.weighty = d3;
        AbstractPropertyPage.UI_CONSTRAINT.anchor = n6;
        AbstractPropertyPage.UI_CONSTRAINT.fill = n7;
    }

    public static final Component createHorizSeperator() {
        return new JSeparator(0);
    }

    private void configureComponent(JComponent jComponent) {
        Class<?> clazz;
        if (jComponent.getClientProperty(COLOR_CLIENT_PROPERTY) != null && jComponent instanceof JButton) {
            JButton jButton = (JButton)jComponent;
            jButton.setAction(this.colorChooserAction);
            jButton.setVerticalAlignment(0);
            jButton.setHorizontalAlignment(0);
            return;
        }
        if (jComponent instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            jTextComponent.getDocument().addDocumentListener(this.propertyHandler);
        }
        if ((clazz = class$java$awt$event$ActionListener) == null) {
            clazz = class$java$awt$event$ActionListener = new ActionListener[0].getClass().getComponentType();
        }
        this.addListener(jComponent, "addActionListener", clazz);
        Class<?> clazz2 = class$javax$swing$event$ChangeListener;
        if (clazz2 == null) {
            clazz2 = class$javax$swing$event$ChangeListener = new ChangeListener[0].getClass().getComponentType();
        }
        this.addListener(jComponent, "addChangeListener", clazz2);
    }

    private void addListener(Object object, String string, Class clazz) {
        try {
            object.getClass().getMethod(string, clazz).invoke(object, this.propertyHandler);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static class 1 {
    }

    protected static class ColorChangeAction
    extends AbstractAction {
        private final Icon icon = new ColorIcon();
        private AbstractPropertyPage page = null;

        public ColorChangeAction(AbstractPropertyPage abstractPropertyPage) {
            this.page = abstractPropertyPage;
            this.putValue("SmallIcon", this.icon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof JButton) {
                JButton jButton = (JButton)object;
                Color color = jButton.getForeground();
                Color color2 = JColorChooser.showDialog(this.page, "", color);
                if (color2 == null) {
                    return;
                }
                if (!color2.equals(color)) {
                    this.page.setModified(true);
                    jButton.setForeground(color2);
                }
            }
        }
    }

    protected static class FontChangeAction
    extends AbstractAction {
        private JLabel lbl = null;
        private AbstractPropertyPage page = null;

        public FontChangeAction(AbstractPropertyPage abstractPropertyPage, Font font, JLabel jLabel) {
            if (jLabel == null) {
                throw new NullPointerException();
            }
            this.lbl = jLabel;
            this.page = abstractPropertyPage;
            this.putValue("SmallIcon", BasicUtilities.loadIconResource("Font24"));
            this.putValue("ShortDescription", BasicUtilities.getString("Change_Font"));
            String string = jLabel.getName();
            String[] stringArray = new String[]{font.getName(), Integer.toString(font.getSize())};
            String string2 = BasicUtilities.getString(string, stringArray);
            jLabel.setText(string2);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof JButton) {
                JButton jButton = (JButton)object;
                JFontChoser jFontChoser = new JFontChoser();
                Font font = jButton.getFont();
                Font font2 = jFontChoser.showDialog(this.page, BasicUtilities.getString("Change_Font"), font);
                if (font2 == null) {
                    return;
                }
                if (!font.equals(font2)) {
                    String string = this.lbl.getName();
                    String[] stringArray = new String[]{font2.getName(), Integer.toString(font2.getSize())};
                    String string2 = BasicUtilities.getString(string, stringArray);
                    this.lbl.setText(string2);
                    jButton.setFont(font2);
                    this.page.setModified(true);
                }
            }
        }
    }

    private class PropertyChangeHandler
    implements ActionListener,
    ChangeListener,
    DocumentListener {
        private PropertyChangeHandler() {
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.toggle();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.toggle();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.toggle();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof JToggleButton) {
                this.toggle();
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() instanceof JToggleButton) {
                this.toggle();
            }
        }

        public void toggle() {
            if (AbstractPropertyPage.this.isLoaded) {
                AbstractPropertyPage.this.setModified(true);
            }
        }

        public /* synthetic */ PropertyChangeHandler(1 var2_2) {
            this();
        }
    }
}

