/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.sql.DriverPropertyInfo;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.isqlviewer.core.PluginFactory;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.TableFilter;
import org.isqlviewer.core.model.DriverPropertyTableModel;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.swing.ITable;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.UserPreferences;

public final class TableFilterEditor
extends JSplitPane {
    public static final String KEY_SES_EXPORT_FILTER = "session.export-selection";
    public static final String KEY_SES_IMPORT_FILTER = "session.import-selection";
    public static final int FILTER_IMPORT = 0;
    public static final int FILTER_EXPORT = 1;
    private PluginFactory factory = SystemConfig.getInstance().getPluginFactory();
    private UserPreferences preferences = SystemConfig.getInstance().getPreferences();
    private Object filterDataType = new Object();
    private int type = 0;
    private int lastSelection = -1;
    private boolean isChanging = false;
    private DriverPropertyTableModel mdlProperties = new DriverPropertyTableModel();
    private DefaultListModel mdlFilters = new DefaultListModel();
    private JList jlsFilters = new JList(this.mdlFilters);
    private ITable tabProperties = new ITable(this.mdlProperties);
    private JTextArea txtDescription = new JTextArea();
    private JSplitPane jspConfigSplit = new JSplitPane(0, true);
    private JScrollPane jspProperties = new JScrollPane(this.tabProperties);
    private JScrollPane jspFilters = new JScrollPane(this.jlsFilters);
    private JScrollPane jspDescription = new JScrollPane(this.txtDescription);
    private FilterSupport filterSupport = new FilterSupport(null);
    private TableFilter currentFilter;
    private DatabaseConnection dbc = null;
    static /* synthetic */ Class array$Ljava$lang$String;

    public TableFilterEditor(int n2, DatabaseConnection databaseConnection) {
        super(1, true);
        try {
            this.type = n2;
            this.dbc = databaseConnection;
            this.initUI();
            this.setPreferredSize(new Dimension(512, 348));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setSelectedFilterIndex(int n2) {
        this.jlsFilters.setSelectedIndex(n2);
        this.changeFilter(n2);
    }

    public int getSelectedFilterIndex() {
        return this.jlsFilters.getSelectedIndex();
    }

    public TableFilter getSelectedFilter() {
        this.validateFilter(this.lastSelection);
        return this.currentFilter;
    }

    public void setFilterContent(Object object) {
        this.filterDataType = object;
        this.loadFilters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object[] objectArray = this.mdlFilters.toArray();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            TableFilter tableFilter = (TableFilter)objectArray[i2];
            tableFilter.setDatabaseConnection(null);
            try {
                tableFilter.destroy();
                continue;
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable);
                continue;
            }
            finally {
                tableFilter = null;
            }
        }
    }

    private void validateFilter(int n2) {
        if (n2 < 0) {
            return;
        }
        this.currentFilter = (TableFilter)this.mdlFilters.get(n2);
        if (this.currentFilter != null) {
            this.tabProperties.editingCanceled(new ChangeEvent(this.tabProperties));
        }
    }

    private void loadFilters() {
        this.mdlFilters.clear();
        Collection collection = this.factory.createPluginsForType(1);
        Iterator iterator = collection.iterator();
        Preferences preferences = this.preferences.toPreferences();
        while (iterator.hasNext()) {
            TableFilter tableFilter = (TableFilter)iterator.next();
            String string = "filters/{0}/{1}";
            string = MessageFormat.format(string, tableFilter.getName(), TableFilterEditor.stringForType(this.type));
            tableFilter.initialize(this.type, preferences.node(string));
            tableFilter.setDatabaseConnection(this.dbc);
            boolean bl2 = tableFilter.isModeSupported(this.type);
            if (bl2 && this.type == 1) {
                bl2 = tableFilter.canFilter(this.type, this.filterDataType);
            }
            if (!bl2) continue;
            this.mdlFilters.addElement(tableFilter);
        }
    }

    private static String stringForType(int n2) {
        switch (n2) {
            case 1: {
                return "export";
            }
            case 0: {
                return "import";
            }
        }
        return "unknown";
    }

    private void changeFilter(int n2) {
        if (this.lastSelection == n2) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.isChanging = true;
        try {
            if (this.lastSelection >= 0) {
                this.validateFilter(this.lastSelection);
            }
            this.currentFilter = (TableFilter)this.mdlFilters.get(n2);
            DriverPropertyInfo[] driverPropertyInfoArray = this.currentFilter.getParameters(this.type);
            this.mdlProperties.setData(driverPropertyInfoArray);
            this.mdlProperties.setProperties(this.currentFilter.getConfiguration(this.type));
            this.tabProperties.refreshSorted();
            this.tabProperties.clearSelection();
            this.tabProperties.setEnabled(true);
            this.tabProperties.getSelectionModel().setSelectionInterval(0, 0);
            BasicUtilities.optimizeTableView(this.tabProperties);
            this.setDividerLocation(this.jlsFilters.getPreferredSize().width + 2 * this.getDividerSize() + 1);
            this.jspConfigSplit.setDividerLocation(0.75);
            this.lastSelection = n2;
        }
        catch (Throwable throwable) {
            BasicUtilities.beep();
            BasicUtilities.HandleException(throwable, "TableFilterEditor::changeFilter(" + n2 + ")");
        }
        this.isChanging = false;
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void initUI() {
        this.tabProperties.setSelectionToggleEnabled(false);
        this.tabProperties.setModel(this.mdlProperties);
        this.tabProperties.setSelectionMode(0);
        this.tabProperties.setRowSelectionAllowed(true);
        this.tabProperties.setColumnSelectionAllowed(false);
        this.tabProperties.getTableHeader().setReorderingAllowed(false);
        this.tabProperties.getSelectionModel().addListSelectionListener(this.filterSupport);
        Class<?> clazz = array$Ljava$lang$String;
        if (clazz == null) {
            clazz = array$Ljava$lang$String = new String[0].getClass();
        }
        this.tabProperties.setDefaultEditor(clazz, this.mdlProperties.getChoiceEditor());
        this.txtDescription.setRows(3);
        this.txtDescription.setEditable(false);
        this.txtDescription.setEnabled(false);
        this.txtDescription.setLineWrap(true);
        this.txtDescription.setWrapStyleWord(true);
        this.txtDescription.setDisabledTextColor(Color.black);
        this.jlsFilters.setCellRenderer(this.filterSupport);
        this.jlsFilters.setSelectionMode(0);
        this.jlsFilters.addListSelectionListener(this.filterSupport);
        this.mdlProperties.setToolTipsEnabled(false);
        this.mdlProperties.addTableModelListener(this.filterSupport);
        this.jspConfigSplit.setTopComponent(this.jspProperties);
        this.jspConfigSplit.setBottomComponent(this.jspDescription);
        this.setLeftComponent(this.jspFilters);
        this.setRightComponent(this.jspConfigSplit);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.jspConfigSplit.setBorder(BorderFactory.createEmptyBorder());
    }

    public static class 1 {
    }

    private class FilterSupport
    extends DefaultListCellRenderer
    implements TableModelListener,
    ListSelectionListener {
        private FilterSupport() {
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            if (TableFilterEditor.this.isChanging) {
                return;
            }
            int n2 = tableModelEvent.getFirstRow();
            switch (tableModelEvent.getType()) {
                case 0: {
                    String string = (String)TableFilterEditor.this.mdlProperties.getValueAt(n2, 1);
                    String string2 = (String)TableFilterEditor.this.mdlProperties.getValueAt(n2, 2);
                    try {
                        Preferences preferences = TableFilterEditor.this.currentFilter.getConfiguration(TableFilterEditor.this.type);
                        preferences.put(string, string2);
                        break;
                    }
                    catch (Throwable throwable) {
                        BasicUtilities.HandleException(throwable);
                        BasicUtilities.beep();
                    }
                }
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            if (listSelectionEvent.getSource() == TableFilterEditor.this.jlsFilters) {
                int n2 = TableFilterEditor.this.jlsFilters.getSelectedIndex();
                String string = null;
                string = TableFilterEditor.this.type == 0 ? TableFilterEditor.KEY_SES_IMPORT_FILTER : TableFilterEditor.KEY_SES_EXPORT_FILTER;
                SystemConfig.getInstance().getPreferences().putInt(string, n2);
                TableFilterEditor.this.changeFilter(n2);
            } else {
                int n3 = TableFilterEditor.this.tabProperties.getSelectedRow();
                if (n3 >= 0) {
                    TableFilterEditor.this.txtDescription.setText(((TableFilterEditor)TableFilterEditor.this).mdlProperties.getPropertyInfo((int)n3).description);
                } else {
                    TableFilterEditor.this.txtDescription.setText("");
                }
            }
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
            super.getListCellRendererComponent((JList<?>)jList, object, n2, bl2, bl3);
            try {
                if (object instanceof TableFilter) {
                    TableFilter tableFilter = (TableFilter)object;
                    this.setText(tableFilter.getName());
                    this.setIcon(tableFilter.getUserIcon());
                    this.setToolTipText(tableFilter.getDescription());
                } else {
                    this.setIcon(null);
                    this.setText(object == null ? "null" : object.toString());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return this;
        }

        public /* synthetic */ FilterSupport(1 var2_2) {
            this();
        }
    }
}

