/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableCellRenderer;
import org.isqlviewer.util.Sortable;

public class SortableHeaderRenderer
extends JLabel
implements TableCellRenderer {
    public static int SORT_ICON_WIDTH = 4;
    private int sortedColumn = -1;
    private String sortedColumnName = null;
    private boolean sortAsc = false;
    private int renderColumn = -1;
    private TableColumnModelListener columnListener = new SortableColumnModelListener(null);

    public SortableHeaderRenderer(JTable jTable) {
        jTable.getColumnModel().addColumnModelListener(this.columnListener);
        this.setHorizontalAlignment(0);
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        this.setHorizontalTextPosition(2);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
        Boolean bl4;
        Object object2;
        if (jTable != null && (object2 = jTable.getTableHeader()) != null) {
            this.setForeground(((Component)object2).getForeground());
            this.setBackground(((Component)object2).getBackground());
        }
        if (this.sortedColumnName != null && this.renderColumn == n3 && jTable != null) {
            object2 = jTable.getColumnName(n3);
            if (object2 != null) {
                if (((String)object2).compareTo(this.sortedColumnName) == 0) {
                    if (this.sortAsc) {
                        this.setIcon(new BasicArrowIcon(5, SORT_ICON_WIDTH));
                    } else {
                        this.setIcon(new BasicArrowIcon(1, SORT_ICON_WIDTH));
                    }
                }
            } else {
                this.setIcon(null);
            }
        } else {
            this.setIcon(null);
        }
        object2 = this.getIcon();
        if (object2 != null) {
            this.setSize(this.getPreferredSize().width + object2.getIconWidth(), this.getHeight());
        } else {
            this.setSize(this.getPreferredSize());
        }
        if (jTable != null && (bl4 = (Boolean)jTable.getClientProperty("isPrinting")) != null && bl4.booleanValue()) {
            this.setFont(jTable.getFont());
        }
        this.setText(object == null ? "" : object.toString());
        return this;
    }

    public boolean isAscending() {
        return this.sortAsc;
    }

    public int getSortedColumn() {
        return this.sortedColumn;
    }

    public int getRenderedSortedColumn() {
        return this.renderColumn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setSortedColumn(int n2, JTable jTable, boolean bl2) {
        SortableHeaderRenderer sortableHeaderRenderer = this;
        synchronized (sortableHeaderRenderer) {
            if (n2 < 0 || !(jTable.getModel() instanceof Sortable)) {
                this.sortedColumn = -1;
                this.sortedColumnName = null;
                this.sortAsc = false;
                this.renderColumn = -1;
            } else {
                this.sortAsc = bl2;
                this.renderColumn = n2;
                String string = jTable.getColumnName(n2);
                Sortable sortable = (Sortable)((Object)jTable.getModel());
                this.sortedColumn = sortable.getIndexOfColumnName(string);
                this.sortedColumnName = string;
            }
        }
    }

    public static class 1 {
    }

    private class SortableColumnModelListener
    implements TableColumnModelListener {
        private SortableColumnModelListener() {
        }

        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        }

        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        }

        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            if (SortableHeaderRenderer.this.renderColumn == -1) {
                return;
            }
            int n2 = tableColumnModelEvent.getFromIndex();
            int n3 = tableColumnModelEvent.getToIndex();
            if (n3 == n2) {
                return;
            }
            if (n3 == SortableHeaderRenderer.this.renderColumn) {
                SortableHeaderRenderer.this.renderColumn = n2;
            } else if (n2 == SortableHeaderRenderer.this.renderColumn) {
                SortableHeaderRenderer.this.renderColumn = n3;
            }
        }

        public void columnMarginChanged(ChangeEvent changeEvent) {
        }

        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        }

        public /* synthetic */ SortableColumnModelListener(1 var2_2) {
            this();
        }
    }

    public static class BasicArrowIcon
    implements Icon,
    SwingConstants {
        private int direction = 1;
        private int size = 0;

        public BasicArrowIcon() {
            this(3);
        }

        public BasicArrowIcon(int n2) {
            this(n2, 16);
        }

        public BasicArrowIcon(int n2, int n3) {
            this.size = n3;
            this.direction = n2;
        }

        public int getIconHeight() {
            return this.size;
        }

        public int getIconWidth() {
            return this.size;
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            Color color = graphics.getColor();
            boolean bl2 = component.isEnabled();
            int n4 = 0;
            this.size = Math.max(this.size, 2);
            int n5 = this.size / 2;
            graphics.translate(n2, n3);
            if (bl2) {
                graphics.setColor(UIManager.getColor("controlDkShadow"));
            } else {
                graphics.setColor(UIManager.getColor("controlShadow"));
            }
            switch (this.direction) {
                case 1: {
                    int n6;
                    for (n6 = 0; n6 < this.size; ++n6) {
                        graphics.drawLine(n5 - n6, n6, n5 + n6, n6);
                    }
                    if (bl2) break;
                    graphics.setColor(UIManager.getColor("controlLtHighlight"));
                    graphics.drawLine(n5 - n6 + 2, n6, n5 + n6, n6);
                    break;
                }
                case 5: {
                    int n7;
                    if (!bl2) {
                        graphics.translate(1, 1);
                        graphics.setColor(UIManager.getColor("controlLtHighlight"));
                        for (n7 = this.size - 1; n7 >= 0; --n7) {
                            graphics.drawLine(n5 - n7, n4, n5 + n7, n4);
                            ++n4;
                        }
                        graphics.translate(-1, -1);
                        graphics.setColor(UIManager.getColor("controlShadow"));
                    }
                    n4 = 0;
                    for (n7 = this.size - 1; n7 >= 0; --n7) {
                        graphics.drawLine(n5 - n7, n4, n5 + n7, n4);
                        ++n4;
                    }
                    break;
                }
                case 7: {
                    int n8;
                    for (n8 = 0; n8 < this.size; ++n8) {
                        graphics.drawLine(n8, n5 - n8, n8, n5 + n8);
                    }
                    if (bl2) break;
                    graphics.setColor(UIManager.getColor("controlLtHighlight"));
                    graphics.drawLine(n8, n5 - n8 + 2, n8, n5 + n8);
                    break;
                }
                case 3: {
                    int n9;
                    if (!bl2) {
                        graphics.translate(1, 1);
                        graphics.setColor(UIManager.getColor("controlLtHighlight"));
                        for (n9 = this.size - 1; n9 >= 0; --n9) {
                            graphics.drawLine(n4, n5 - n9, n4, n5 + n9);
                            ++n4;
                        }
                        graphics.translate(-1, -1);
                        graphics.setColor(UIManager.getColor("controlShadow"));
                    }
                    n4 = 0;
                    for (n9 = this.size - 1; n9 >= 0; --n9) {
                        graphics.drawLine(n4, n5 - n9, n4, n5 + n9);
                        ++n4;
                    }
                    break;
                }
            }
            graphics.translate(-n2, -n3);
            graphics.setColor(color);
        }
    }
}

