/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.sql;

import java.io.PrintWriter;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.util.BasicUtilities;

public final class DriverPool {
    private static final ArrayList driverSet = new ArrayList();

    private DriverPool() {
    }

    private static boolean isDriverAllReadyRegistered(Driver driver) {
        int n2 = driver.getMajorVersion() * 10 + driver.getMinorVersion();
        Iterator iterator = driverSet.iterator();
        while (iterator.hasNext()) {
            Driver driver2 = (Driver)iterator.next();
            int n3 = driver2.getMajorVersion() * 10 + driver2.getMinorVersion();
            if (n3 != n2 || !driver2.getClass().getName().equals(driver.getClass().getName())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void registerDriver(String string, ClassLoader classLoader) throws ClassNotFoundException {
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (string == null) {
            throw new IllegalArgumentException(BasicUtilities.getString(DatabaseConnection.resourceBundle, "DriverMgr_Register_Null"));
        }
        try {
            Driver driver = (Driver)Class.forName(string, false, classLoader).newInstance();
            if (DriverPool.isDriverAllReadyRegistered(driver)) return;
            String[] stringArray = driverSet;
            synchronized (driverSet) {
                driverSet.add(driver);
                // ** MonitorExit[var3_4] (shouldn't be in output)
                stringArray = new String[]{string, driver.toString()};
                String string2 = BasicUtilities.getString(DatabaseConnection.resourceBundle, "DriverMgr_Register", stringArray);
                DriverManager.println(string2);
                return;
            }
        }
        catch (Throwable throwable) {
            String string3 = BasicUtilities.getString(DatabaseConnection.resourceBundle, "DriverMgr_Error", throwable.getMessage());
            DriverManager.println(string3);
            throw new ClassNotFoundException(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregisterDriver(Driver driver) {
        if (driver == null) {
            String string = BasicUtilities.getString(DatabaseConnection.resourceBundle, "DriverMgr_Deregister_Null");
            DriverManager.println(string);
            return;
        }
        try {
            String[] stringArray = new String[]{driver.getClass().getName(), driver.toString()};
            String string = BasicUtilities.getString(DatabaseConnection.resourceBundle, "DriverMgr_Deregister", stringArray);
            DriverManager.println(string);
            ArrayList arrayList = driverSet;
            synchronized (arrayList) {
                Driver driver2;
                int n2 = 0;
                for (n2 = 0; n2 < driverSet.size() && (driver2 = (Driver)driverSet.get(n2)) != driver; ++n2) {
                }
                if (n2 >= driverSet.size()) {
                    string = BasicUtilities.getString(DatabaseConnection.resourceBundle, "DriverMgr_Deregister_Notfound", stringArray);
                    DriverManager.println(string);
                    return;
                }
                driverSet.remove(n2);
            }
        }
        catch (Throwable throwable) {
            String string = BasicUtilities.getString(DatabaseConnection.resourceBundle, "DriverMgr_Error", throwable.getMessage());
            DriverManager.println(string);
        }
    }

    public static Driver getDriver(String string) throws SQLException {
        Iterator iterator = driverSet.iterator();
        while (iterator.hasNext()) {
            Driver driver = (Driver)iterator.next();
            try {
                if (!driver.acceptsURL(string)) continue;
                return driver;
            }
            catch (SQLException sQLException) {
                PrintWriter printWriter = DriverManager.getLogWriter();
                if (printWriter == null) continue;
                String string2 = MessageFormat.format("acceptsURL({0})", string);
                BasicUtilities.HandleException((Throwable)sQLException, string2, true, printWriter);
            }
            catch (Throwable throwable) {
            }
        }
        return DriverManager.getDriver(string);
    }
}

