/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.filters;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.prefs.Preferences;
import java.util.zip.CRC32;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.Icon;
import org.isqlviewer.core.filters.AbstractTableFilter;
import org.isqlviewer.core.model.EnhancedTableModel;
import org.isqlviewer.sql.ByteArrayBlob;
import org.isqlviewer.sql.ByteArrayClob;
import org.isqlviewer.sql.FileBlob;
import org.isqlviewer.sql.FileClob;
import org.isqlviewer.sql.JDBCUtilities;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringUtilities;

public class LOBTableFilter
extends AbstractTableFilter {
    private SimpleDateFormat sdf = new SimpleDateFormat("");
    static /* synthetic */ Class class$java$sql$Clob;
    static /* synthetic */ Class class$java$sql$Blob;

    public String getName() {
        return this.getString("LOBFilter_Name");
    }

    public boolean isModeSupported(int n2) {
        switch (n2) {
            case 0: {
                return true;
            }
        }
        return false;
    }

    public boolean isFileRequired(int n2) {
        return true;
    }

    public int filterIn(EnhancedTableModel enhancedTableModel, File file, InputStream inputStream) throws IOException, InterruptedException {
        File[] fileArray;
        Preferences preferences = this.getConfiguration(0);
        String string = null;
        if (file.isDirectory()) {
            fileArray = file.listFiles();
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = file;
        }
        File[] fileArray3 = fileArray;
        string = this.getString("LOBFilter_Cmp");
        String string2 = preferences.get(string, Boolean.FALSE.toString());
        string = this.getString("LOBFilter_LoadType");
        String string3 = preferences.get(string, "BLOB");
        this.sdf.applyPattern(this.sysConfig.getPreferences().get("general.timestamp-format"));
        enhancedTableModel.setColumnCount(5);
        enhancedTableModel.setColumnName(0, string3);
        enhancedTableModel.setColumnName(1, this.getString("LOBFilter_FileLength"));
        enhancedTableModel.setColumnName(2, this.getString("LOBFilter_FileName"));
        enhancedTableModel.setColumnName(3, this.getString("LOBFilter_FileURL"));
        enhancedTableModel.setColumnName(4, this.getString("LOBFilter_FileTimestamp"));
        int n2 = JDBCUtilities.getTypeforName(string3);
        switch (n2) {
            case 2004: {
                Class<?> clazz = class$java$sql$Blob;
                if (clazz == null) {
                    clazz = class$java$sql$Blob = new Blob[0].getClass().getComponentType();
                }
                enhancedTableModel.setClassforColumn(0, clazz);
                break;
            }
            case 2005: {
                Class<?> clazz = class$java$sql$Clob;
                if (clazz == null) {
                    clazz = class$java$sql$Clob = new Clob[0].getClass().getComponentType();
                }
                enhancedTableModel.setClassforColumn(0, clazz);
                break;
            }
            default: {
                this.info(this.getString("LOBFilter_TypeError"));
                return 0;
            }
        }
        block8: for (int i2 = 0; i2 < fileArray3.length; ++i2) {
            this.checkIfCancelled();
            File file2 = fileArray3[i2];
            Clob clob = null;
            Blob blob = null;
            if (file2.isDirectory()) continue;
            ArrayList<Object> arrayList = new ArrayList<Object>(1);
            Long l2 = new Long(file2.length());
            switch (n2) {
                case 2004: {
                    string = this.getString("LOBFilter_ZipLvl");
                    blob = this.getBlobforFile(file2, string2, preferences.getInt(string, -1));
                    break;
                }
                case 2005: {
                    clob = this.getClobforFile(file2, string2);
                    break;
                }
                default: {
                    continue block8;
                }
            }
            if (blob != null) {
                arrayList.add(blob);
            } else {
                arrayList.add(clob);
            }
            arrayList.add(l2);
            arrayList.add(fileArray3[i2].getName());
            arrayList.add(file2.toURL().toExternalForm());
            arrayList.add(new Timestamp(file2.lastModified()));
            enhancedTableModel.addRow(arrayList);
        }
        return 3;
    }

    public int filterOut(Object object, File file, OutputStream outputStream) {
        return 0;
    }

    public boolean accept(int n2, File file) {
        switch (n2) {
            case 0: {
                return file.isDirectory() && file.list().length >= 1 || file.isFile() && file.canRead();
            }
        }
        return false;
    }

    public Icon getUserIcon() {
        return BasicUtilities.loadIconResource("Image16");
    }

    public void loadProperties(int n2) {
        String[] stringArray = new String[]{"BLOB", "CLOB"};
        switch (n2) {
            case 0: {
                String string = this.getString("LOBFilter_LoadType");
                String string2 = this.getString("LOBFilter_LoadType_Help");
                this.addProperty(string, stringArray, stringArray[0], false, string2);
                String[] stringArray2 = new String[]{Boolean.FALSE.toString(), BasicUtilities.getString("LOBFilter_Cmp_Zip"), BasicUtilities.getString("LOBFilter_Cmp_gZip")};
                string = this.getString("LOBFilter_Cmp");
                string2 = this.getString("LOBFilter_Cmp_Help");
                this.addProperty(string, stringArray2, stringArray2[2], false, string2);
                string = this.getString("LOBFilter_ZipLvl");
                string2 = this.getString("LOBFilter_ZipLvl_Help");
                this.addProperty(string, null, "3", false, string2);
            }
        }
    }

    public Blob getBlobforFile(File file, String string, int n2) throws IOException {
        Blob blob = null;
        if (string.equalsIgnoreCase(Boolean.FALSE.toString())) {
            blob = new FileBlob(file);
        } else {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
            FileInputStream fileInputStream = new FileInputStream(file);
            if (string.equals(BasicUtilities.getString("LOBFilter_Cmp_Zip"))) {
                BasicUtilities.copyStream(fileInputStream, byteArrayOutputStream);
                fileInputStream.close();
                CRC32 cRC32 = new CRC32();
                cRC32.update(byteArrayOutputStream.toByteArray());
                byteArrayOutputStream = new ByteArrayOutputStream(4096);
                ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
                zipOutputStream.setMethod(8);
                zipOutputStream.setLevel(n2);
                ZipEntry zipEntry = new ZipEntry(file.getName());
                zipEntry.setSize(file.length());
                zipEntry.setCrc(cRC32.getValue());
                zipEntry.setTime(System.currentTimeMillis());
                zipOutputStream.putNextEntry(zipEntry);
                String string2 = null;
                string2 = BasicUtilities.getString("Zip_Entry_Header", file.getName());
                this.info(string2);
                string2 = BasicUtilities.getString("Zip_Entry_CRC", Long.toHexString(zipEntry.getCrc()));
                this.info(string2);
                string2 = BasicUtilities.getString("Zip_Entry_Time", this.sdf.format(new Date(zipEntry.getTime())));
                this.info(string2);
                string2 = BasicUtilities.getString("Zip_Entry_Size", StringUtilities.getHumanReadableSize(zipEntry.getSize()));
                this.info(string2);
                fileInputStream = new FileInputStream(file);
                BasicUtilities.copyStream(fileInputStream, zipOutputStream);
                zipOutputStream.closeEntry();
                zipOutputStream.close();
            } else {
                GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
                BasicUtilities.copyStream(fileInputStream, gZIPOutputStream);
                gZIPOutputStream.close();
            }
            fileInputStream.close();
            blob = new ByteArrayBlob(byteArrayOutputStream.toByteArray());
        }
        return blob;
    }

    public Clob getClobforFile(File file, String string) throws IOException {
        Clob clob = null;
        if (string.equalsIgnoreCase(Boolean.FALSE.toString())) {
            clob = new FileClob(file);
        } else {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
            FileInputStream fileInputStream = new FileInputStream(file);
            if (string.equals(BasicUtilities.getString("LOBFilter_Cmp_Zip"))) {
                ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
                ZipEntry zipEntry = new ZipEntry(file.getName());
                zipEntry.setComment(file.getAbsolutePath());
                zipEntry.setMethod(8);
                zipEntry.setTime(System.currentTimeMillis());
                zipEntry.setSize(file.length());
                zipOutputStream.putNextEntry(zipEntry);
                BasicUtilities.copyStream(fileInputStream, zipOutputStream);
                zipOutputStream.closeEntry();
                zipOutputStream.close();
            } else {
                GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
                BasicUtilities.copyStream(fileInputStream, gZIPOutputStream);
                gZIPOutputStream.close();
            }
            fileInputStream.close();
            clob = new ByteArrayClob(byteArrayOutputStream.toString());
        }
        return clob;
    }
}

