/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.isqlviewer.core.HistoryItem;
import org.isqlviewer.core.IPCListener;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.UserPreferences;

public class HistoryManager {
    public static final String IPC_SERVICE_CHANGE = "isql-service-change";
    public static final int STYLE_GLOBAL = 0;
    public static final int STYLE_DRIVER = 1;
    public static final int STYLE_SERVICE = 2;
    private final ChangeEvent changeEvent = new ChangeEvent(this);
    private final Calendar cal = new GregorianCalendar();
    private ArrayList dataStore = new ArrayList();
    private ArrayList changeListeners = null;
    private int browseIdx = 0;
    private Thread loadThread = null;
    private String dbcID = null;
    private long sessionEpoch = 0L;
    private UserPreferences prefs = null;
    private HistorySupport support = new HistorySupport(null);

    public static HistoryManager createInstance(SystemConfig systemConfig) {
        return new HistoryManager(systemConfig);
    }

    private HistoryManager(SystemConfig systemConfig) {
        this.prefs = systemConfig.getPreferences();
        systemConfig.getPreferences().addPreferenceChangeListener(this.support);
        systemConfig.getIPCService().subscribe(this.support, IPC_SERVICE_CHANGE);
    }

    public void addHistoryItem(String string, DatabaseConnection databaseConnection) {
        HistoryItem historyItem = new HistoryItem(databaseConnection.getConnectionName(), string);
        this.addHistoryItem(historyItem);
        this.browseIdx = 0;
    }

    public boolean isEmpty() {
        return this.dataStore.isEmpty();
    }

    public boolean allowsDuplicates() {
        return this.prefs.getBoolean("history.duplicates-enabled");
    }

    public boolean isCircular() {
        return this.prefs.getBoolean("history.circular-enabled");
    }

    public HistoryItem get(int n2) {
        try {
            return (HistoryItem)this.dataStore.get(n2);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public HistoryItem newer() {
        --this.browseIdx;
        boolean bl2 = this.isCircular();
        this.browseIdx = this.browseIdx < 0 ? (bl2 ? this.size() - 1 : 0) : this.browseIdx;
        return this.get(this.browseIdx);
    }

    public HistoryItem older() {
        ++this.browseIdx;
        boolean bl2 = this.isCircular();
        this.browseIdx = this.browseIdx >= this.size() ? (bl2 ? 0 : this.size() - 1) : this.browseIdx;
        return this.get(this.browseIdx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(File file) {
        HistoryManager historyManager = this;
        synchronized (historyManager) {
            FileOutputStream fileOutputStream = null;
            try {
                file = new File(file.getParentFile(), BasicUtilities.getString("History_File_Template", file.getName()));
                fileOutputStream = new FileOutputStream(file);
                PrintWriter printWriter = new PrintWriter(fileOutputStream, true);
                ArrayList arrayList = this.dataStore;
                synchronized (arrayList) {
                    Iterator iterator = this.dataStore.iterator();
                    while (iterator.hasNext()) {
                        HistoryItem historyItem = (HistoryItem)iterator.next();
                        printWriter.print(historyItem.getSQLData());
                        printWriter.println(";");
                    }
                }
                System.out.println(BasicUtilities.getString("File_Saved", file.getAbsolutePath()));
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable, "HistoryManager::store(" + file + ")");
            }
            finally {
                file = null;
                try {
                    fileOutputStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHistoryItem(HistoryItem historyItem) {
        if (historyItem == null) {
            return;
        }
        try {
            Object object;
            int n2;
            boolean bl2;
            boolean bl3 = this.getMaximumSize() >= 1;
            boolean bl4 = this.getMaximumDays() >= 1;
            boolean bl5 = !bl3;
            boolean bl6 = bl2 = !bl4;
            if (bl4) {
                n2 = this.getMaximumDays();
                Date date = historyItem.getTimeStamp();
                if (date == null) {
                    date = new Date();
                }
                this.cal.setTime(new Date());
                this.rollActuallDays(n2);
                object = this.cal.getTime();
                bl2 = date.after((Date)object);
                if (!bl2) {
                    return;
                }
            }
            if (bl3) {
                n2 = this.size();
                bl5 = n2 + 1 < this.getMaximumSize();
            }
            ArrayList arrayList = this.dataStore;
            synchronized (arrayList) {
                if (!bl5) {
                    this.dataStore.remove(this.dataStore.size() - 1);
                }
                if (this.allowsDuplicates()) {
                    HistoryItem.setComparableMode(1, this.prefs.getBoolean("history.crc32-enabled"));
                    int n3 = this.dataStore.indexOf(historyItem);
                    object = historyItem.getSQLData();
                    if (n3 >= 0) {
                        historyItem = (HistoryItem)this.dataStore.remove(n3);
                        if (this.useCRC32()) {
                            historyItem.updateSQL((String)object);
                        }
                        historyItem.updateTimestamp();
                    }
                }
                this.dataStore.add(0, historyItem);
                this.browseIdx = 0;
            }
            this.fireStateChanged();
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable, "HistoryManager::addHistoryItem(HistoryItem)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection sublist(Date date, Date date2) {
        ArrayList<HistoryItem> arrayList = new ArrayList<HistoryItem>();
        ArrayList arrayList2 = this.dataStore;
        synchronized (arrayList2) {
            Iterator iterator = this.dataStore.iterator();
            while (iterator.hasNext()) {
                HistoryItem historyItem = (HistoryItem)iterator.next();
                Date date3 = historyItem.getTimeStamp();
                if (!date3.before(date2) || !date3.after(date)) continue;
                arrayList.add(historyItem);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getHistory() {
        ArrayList arrayList = this.dataStore;
        synchronized (arrayList) {
            return (Collection)this.dataStore.clone();
        }
    }

    public int getCursorIndex() {
        return this.browseIdx;
    }

    public void setCursorIndex(int n2) {
        this.browseIdx = Math.max(0, Math.min(this.size(), n2));
    }

    public Date getSessionTime() {
        return new Date(this.sessionEpoch);
    }

    public boolean isSessionPerserved() {
        return this.prefs.getBoolean("history.sessionclear-enabled");
    }

    public int getSessionStyle() {
        return this.prefs.getInt("history.style");
    }

    public int size() {
        return this.dataStore.size();
    }

    public int getMaximumSize() {
        return this.prefs.getInt("history.max-count");
    }

    public int getMaximumDays() {
        return this.prefs.getInt("history.max-days");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener changeListener) {
        ArrayList<ChangeListener> arrayList;
        ArrayList<ChangeListener> arrayList2 = arrayList = this.changeListeners == null ? new ArrayList<ChangeListener>() : this.changeListeners;
        if (!arrayList.contains(changeListener)) {
            ArrayList<ChangeListener> arrayList3 = arrayList;
            synchronized (arrayList3) {
                arrayList.add(changeListener);
            }
        }
        this.changeListeners = arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener changeListener) {
        if (this.changeListeners == null) {
            return;
        }
        if (this.changeListeners.contains(changeListener)) {
            ArrayList arrayList = this.changeListeners;
            synchronized (arrayList) {
                this.changeListeners.remove(changeListener);
            }
        }
    }

    public void shutdown(SystemConfig systemConfig) {
        boolean bl2;
        systemConfig.getPreferences().removePreferenceChangeListener(this.support);
        systemConfig.getIPCService().unSubscribeAll(this.support);
        if (this.changeListeners != null) {
            this.changeListeners.clear();
            this.changeListeners = null;
        }
        if (!(bl2 = this.prefs.getBoolean("history.persistent-enabled"))) {
            // empty if block
        }
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear() {
        if (!this.isSessionPerserved()) {
            ArrayList arrayList = this.dataStore;
            synchronized (arrayList) {
                this.dataStore.clear();
            }
        }
        Date date = new Date(this.sessionEpoch);
        ArrayList arrayList = this.dataStore;
        synchronized (arrayList) {
            Iterator iterator = this.dataStore.iterator();
            while (iterator.hasNext()) {
                HistoryItem historyItem = (HistoryItem)iterator.next();
                if (!historyItem.getTimeStamp().before(date)) continue;
                try {
                    iterator.remove();
                }
                catch (Throwable throwable) {}
            }
        }
        this.fireStateChanged();
    }

    public void updateHistoryKey(String string) {
        if (this.dbcID == string || string == null) {
            return;
        }
        if (this.dbcID == null) {
            this.dbcID = string;
        } else if (!this.dbcID.equals(string)) {
            if (this.prefs.getBoolean("history.persistent-enabled")) {
                this.clear();
            } else {
                this.dbcID = string;
            }
        }
    }

    public boolean useCRC32() {
        return this.prefs.getBoolean("history.crc32-enabled");
    }

    public void updateHistorySet(DatabaseConnection databaseConnection) {
        String string = null;
        switch (this.getSessionStyle()) {
            case 1: {
                string = databaseConnection == null ? null : databaseConnection.getDriver().getClass().getName();
                break;
            }
            case 2: {
                string = databaseConnection == null ? null : databaseConnection.getConnectionName();
                break;
            }
        }
        this.updateHistoryKey(string);
    }

    public void rollActuallDays(int n2) {
        int n3 = this.cal.get(6);
        int n4 = this.cal.getActualMaximum(6);
        if (n2 >= n4) {
            int n5;
            for (n5 = n2 / n4; n5 > 0; --n5) {
                this.cal.roll(1, -1 * n5);
                n4 = this.cal.getActualMaximum(6);
            }
            this.cal.roll(6, -1 * (n2 - n5 * n4));
            return;
        }
        if (n3 <= n2) {
            this.cal.roll(1, false);
        }
        this.cal.roll(6, -1 * n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireStateChanged() {
        if (this.changeListeners == null) {
            return;
        }
        ArrayList arrayList = this.changeListeners;
        synchronized (arrayList) {
            Iterator iterator = this.changeListeners.iterator();
            while (iterator.hasNext()) {
                ChangeListener changeListener = (ChangeListener)iterator.next();
                try {
                    changeListener.stateChanged(this.changeEvent);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static class 1 {
    }

    private static class HistoryLoader
    implements Runnable {
        private File file = null;
        private HistoryManager manager = null;

        public HistoryLoader(HistoryManager historyManager, File file) {
            this.file = file;
            this.manager = historyManager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            InputStreamReader inputStreamReader = null;
            BufferedReader bufferedReader = null;
            StringBuffer stringBuffer = new StringBuffer("");
            try {
                ArrayList arrayList = this.manager.dataStore;
                synchronized (arrayList) {
                    Object[] objectArray;
                    inputStreamReader = new FileReader(this.file);
                    bufferedReader = new BufferedReader(inputStreamReader);
                    while (bufferedReader.ready()) {
                        objectArray = bufferedReader.readLine();
                        if (objectArray.trim().length() == 0) {
                            try {
                                this.manager.addHistoryItem(HistoryItem.decode(stringBuffer.toString()));
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            stringBuffer.setLength(0);
                            continue;
                        }
                        stringBuffer.append((String)objectArray);
                        stringBuffer.append('\n');
                    }
                    objectArray = this.manager.dataStore.toArray();
                    HistoryItem.setComparableMode(0, this.manager.prefs.getBoolean("history.crc32-enabled"));
                    Arrays.sort(objectArray);
                    this.manager.dataStore.clear();
                    this.manager.dataStore.addAll(Arrays.asList(objectArray));
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                try {
                    bufferedReader.close();
                }
                catch (Throwable throwable) {}
                try {
                    inputStreamReader.close();
                }
                catch (Throwable throwable) {}
                this.manager.sessionEpoch = System.currentTimeMillis();
                this.manager.fireStateChanged();
            }
        }
    }

    private class HistorySupport
    implements IPCListener,
    PreferenceChangeListener {
        private HistorySupport() {
        }

        public void receiveMessage(Object object, String string, Object object2) {
            if (string.equals(HistoryManager.IPC_SERVICE_CHANGE)) {
                HistoryManager.this.updateHistorySet((DatabaseConnection)object2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
            String string = preferenceChangeEvent.getKey();
            String string2 = preferenceChangeEvent.getNewValue();
            if (string2 == null) {
                return;
            }
            if (string.equals("history.style")) {
                return;
            }
            if (string.equals("history.max-count")) {
                int n2 = Integer.parseInt(string2);
                if (n2 < HistoryManager.this.size()) {
                    ArrayList arrayList = HistoryManager.this.dataStore;
                    synchronized (arrayList) {
                        for (int i2 = HistoryManager.this.size() - 1; i2 > n2; --i2) {
                            HistoryManager.this.dataStore.remove(i2);
                        }
                    }
                }
                return;
            }
            if (string.equals("history.max-days")) {
                boolean bl2;
                boolean bl3 = bl2 = Integer.parseInt(string2) >= 1;
                if (!bl2) {
                    return;
                }
                if (!HistoryManager.this.isEmpty()) {
                    HistoryManager.this.cal.setTime(new Date());
                    HistoryManager.this.cal.roll(6, -1 * HistoryManager.this.prefs.getInt(string));
                    Date date = HistoryManager.this.cal.getTime();
                    ArrayList arrayList = HistoryManager.this.dataStore;
                    synchronized (arrayList) {
                        Iterator iterator = HistoryManager.this.dataStore.iterator();
                        while (iterator.hasNext()) {
                            HistoryItem historyItem = (HistoryItem)iterator.next();
                            if (!historyItem.getTimeStamp().before(date)) continue;
                            try {
                                iterator.remove();
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                }
                return;
            }
        }

        public /* synthetic */ HistorySupport(1 var2_2) {
            this();
        }
    }
}

