/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.io.IOException;
import java.io.Reader;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.garret.perst.BitIndex;
import org.garret.perst.CustomSerializable;
import org.garret.perst.IPersistent;
import org.garret.perst.Key;
import org.garret.perst.XMLImportException;
import org.garret.perst.impl.BitIndexImpl;
import org.garret.perst.impl.Btree;
import org.garret.perst.impl.BtreeCompoundIndex;
import org.garret.perst.impl.BtreeFieldIndex;
import org.garret.perst.impl.BtreeMultiFieldIndex;
import org.garret.perst.impl.ByteBuffer;
import org.garret.perst.impl.Bytes;
import org.garret.perst.impl.ClassDescriptor;
import org.garret.perst.impl.ObjectHeader;
import org.garret.perst.impl.PersistentSet;
import org.garret.perst.impl.PersistentStub;
import org.garret.perst.impl.StorageImpl;

public class XMLImporter {
    StorageImpl storage;
    XMLScanner scanner;
    int[] idMap;
    static final String dateFormat = "EEE, d MMM yyyy kk:mm:ss z";
    static final DateFormat httpFormatter = new SimpleDateFormat("EEE, d MMM yyyy kk:mm:ss z", Locale.ENGLISH);

    public XMLImporter(StorageImpl storageImpl, Reader reader) {
        this.storage = storageImpl;
        this.scanner = new XMLScanner(reader);
    }

    public void importDatabase() throws XMLImportException {
        int n2;
        if (this.scanner.scan() != 4 || this.scanner.scan() != 0 || !this.scanner.getIdentifier().equals("database")) {
            this.throwException("No root element");
        }
        if (this.scanner.scan() != 0 || !this.scanner.getIdentifier().equals("root") || this.scanner.scan() != 8 || this.scanner.scan() != 1 || this.scanner.scan() != 5) {
            this.throwException("Database element should have \"root\" attribute");
        }
        int n3 = 0;
        try {
            n3 = Integer.parseInt(this.scanner.getString());
        }
        catch (NumberFormatException numberFormatException) {
            this.throwException("Incorrect root object specification");
        }
        this.idMap = new int[n3 * 2];
        this.idMap[n3] = this.storage.allocateId();
        this.storage.header.root[1 - this.storage.currIndex].rootObject = this.idMap[n3];
        while ((n2 = this.scanner.scan()) == 4) {
            String string;
            if (this.scanner.scan() != 0) {
                this.throwException("Element name expected");
            }
            if ((string = this.scanner.getIdentifier()).equals("org.garret.perst.impl.Btree") || string.equals("org.garret.perst.impl.BitIndexImpl") || string.equals("org.garret.perst.impl.PersistentSet") || string.equals("org.garret.perst.impl.BtreeFieldIndex") || string.equals("org.garret.perst.impl.BtreeCompoundIndex") || string.equals("org.garret.perst.impl.BtreeMultiFieldIndex")) {
                this.createIndex(string);
                continue;
            }
            this.createObject(this.readElement(string));
        }
        if (n2 != 6 || this.scanner.scan() != 0 || !this.scanner.getIdentifier().equals("database") || this.scanner.scan() != 5) {
            this.throwException("Root element is not closed");
        }
    }

    final String getAttribute(XMLElement xMLElement, String string) throws XMLImportException {
        String string2 = xMLElement.getAttribute(string);
        if (string2 == null) {
            this.throwException("Attribute " + string + " is not set");
        }
        return string2;
    }

    final int getIntAttribute(XMLElement xMLElement, String string) throws XMLImportException {
        String string2 = xMLElement.getAttribute(string);
        if (string2 == null) {
            this.throwException("Attribute " + string + " is not set");
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            this.throwException("Attribute " + string + " should has integer value");
            return -1;
        }
    }

    final int mapId(int n2) {
        int n3 = 0;
        if (n2 != 0) {
            if (n2 >= this.idMap.length) {
                int[] nArray = new int[n2 * 2];
                System.arraycopy(this.idMap, 0, nArray, 0, this.idMap.length);
                this.idMap = nArray;
                this.idMap[n2] = n3 = this.storage.allocateId();
            } else {
                n3 = this.idMap[n2];
                if (n3 == 0) {
                    this.idMap[n2] = n3 = this.storage.allocateId();
                }
            }
        }
        return n3;
    }

    final int mapType(String string) throws XMLImportException {
        for (int i2 = 0; i2 < ClassDescriptor.signature.length; ++i2) {
            if (!ClassDescriptor.signature[i2].equals(string)) continue;
            return i2;
        }
        this.throwException("Bad type");
        return -1;
    }

    final Key createCompoundKey(int[] nArray, String[] stringArray) throws XMLImportException {
        ByteBuffer byteBuffer = new ByteBuffer();
        int n2 = 0;
        try {
            block15: for (int i2 = 0; i2 < nArray.length; ++i2) {
                String string = stringArray[i2];
                switch (nArray[i2]) {
                    case 0: {
                        byteBuffer.extend(n2 + 1);
                        byteBuffer.arr[n2++] = (byte)(Integer.parseInt(string) != 0 ? 1 : 0);
                        continue block15;
                    }
                    case 1: {
                        byteBuffer.extend(n2 + 1);
                        byteBuffer.arr[n2++] = Byte.parseByte(string);
                        continue block15;
                    }
                    case 2: {
                        byteBuffer.extend(n2 + 2);
                        Bytes.pack2(byteBuffer.arr, n2, (short)Integer.parseInt(string));
                        n2 += 2;
                        continue block15;
                    }
                    case 3: {
                        byteBuffer.extend(n2 + 2);
                        Bytes.pack2(byteBuffer.arr, n2, Short.parseShort(string));
                        n2 += 2;
                        continue block15;
                    }
                    case 4: {
                        byteBuffer.extend(n2 + 4);
                        Bytes.pack4(byteBuffer.arr, n2, Integer.parseInt(string));
                        n2 += 4;
                        continue block15;
                    }
                    case 10: {
                        byteBuffer.extend(n2 + 4);
                        Bytes.pack4(byteBuffer.arr, n2, this.mapId(Integer.parseInt(string)));
                        n2 += 4;
                        continue block15;
                    }
                    case 5: 
                    case 9: {
                        byteBuffer.extend(n2 + 8);
                        Bytes.pack8(byteBuffer.arr, n2, Long.parseLong(string));
                        n2 += 8;
                        continue block15;
                    }
                    case 6: {
                        byteBuffer.extend(n2 + 4);
                        Bytes.pack4(byteBuffer.arr, n2, Float.floatToIntBits(Float.parseFloat(string)));
                        n2 += 4;
                        continue block15;
                    }
                    case 7: {
                        byteBuffer.extend(n2 + 8);
                        Bytes.pack8(byteBuffer.arr, n2, Double.doubleToLongBits(Double.parseDouble(string)));
                        n2 += 8;
                        continue block15;
                    }
                    case 8: {
                        n2 = byteBuffer.packString(n2, string, this.storage.encoding);
                        continue block15;
                    }
                    case 21: {
                        byteBuffer.extend(n2 + 4 + (string.length() >>> 1));
                        Bytes.pack4(byteBuffer.arr, n2, string.length() >>> 1);
                        n2 += 4;
                        int n3 = string.length();
                        for (int i3 = 0; i3 < n3; i3 += 2) {
                            byteBuffer.arr[n2++] = (byte)(this.getHexValue(string.charAt(i3)) << 4 | this.getHexValue(string.charAt(i3 + 1)));
                        }
                        continue block15;
                    }
                    default: {
                        this.throwException("Bad key type");
                    }
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.throwException("Failed to convert key value");
        }
        return new Key(byteBuffer.toArray());
    }

    final Key createKey(int n2, String string) throws XMLImportException {
        try {
            switch (n2) {
                case 0: {
                    return new Key(Integer.parseInt(string) != 0);
                }
                case 1: {
                    return new Key(Byte.parseByte(string));
                }
                case 2: {
                    return new Key((char)Integer.parseInt(string));
                }
                case 3: {
                    return new Key(Short.parseShort(string));
                }
                case 4: {
                    return new Key(Integer.parseInt(string));
                }
                case 10: {
                    return new Key(new PersistentStub(this.storage, this.mapId(Integer.parseInt(string))));
                }
                case 5: {
                    return new Key(Long.parseLong(string));
                }
                case 6: {
                    return new Key(Float.parseFloat(string));
                }
                case 7: {
                    return new Key(Double.parseDouble(string));
                }
                case 8: {
                    return new Key(string);
                }
                case 21: {
                    byte[] byArray = new byte[string.length() >> 1];
                    for (int i2 = 0; i2 < byArray.length; ++i2) {
                        byArray[i2] = (byte)(this.getHexValue(string.charAt(i2 * 2)) << 4 | this.getHexValue(string.charAt(i2 * 2 + 1)));
                    }
                    return new Key(byArray);
                }
                case 9: {
                    Date date;
                    if (string.equals("null")) {
                        date = null;
                    } else {
                        date = httpFormatter.parse(string, new ParsePosition(0));
                        if (date == null) {
                            this.throwException("Invalid date");
                        }
                    }
                    return new Key(date);
                }
            }
            this.throwException("Bad key type");
        }
        catch (NumberFormatException numberFormatException) {
            this.throwException("Failed to convert key value");
        }
        return null;
    }

    final int parseInt(String string) throws XMLImportException {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.throwException("Bad integer constant");
            return -1;
        }
    }

    final void createIndex(String string) throws XMLImportException {
        Object object;
        int n2;
        Object object2;
        Object object3;
        int n3;
        Btree btree = null;
        int n4 = 0;
        boolean bl2 = false;
        String string2 = null;
        String string3 = null;
        String[] stringArray = null;
        String[] stringArray2 = null;
        long l2 = 0L;
        String string4 = null;
        while ((n3 = this.scanner.scan()) == 0) {
            object3 = this.scanner.getIdentifier();
            if (this.scanner.scan() != 8 || this.scanner.scan() != 1) {
                this.throwException("Attribute value expected");
            }
            object2 = this.scanner.getString();
            if (((String)object3).equals("id")) {
                n4 = this.mapId(this.parseInt((String)object2));
                continue;
            }
            if (((String)object3).equals("unique")) {
                bl2 = this.parseInt((String)object2) != 0;
                continue;
            }
            if (((String)object3).equals("class")) {
                string2 = object2;
                continue;
            }
            if (((String)object3).equals("type")) {
                string4 = object2;
                continue;
            }
            if (((String)object3).equals("autoinc")) {
                l2 = this.parseInt((String)object2);
                continue;
            }
            if (((String)object3).equals("field")) {
                string3 = object2;
                continue;
            }
            if (((String)object3).startsWith("type")) {
                n2 = Integer.parseInt(((String)object3).substring(4));
                if (stringArray2 == null || stringArray2.length <= n2) {
                    object = new int[n2 + 1];
                    if (stringArray2 != null) {
                        System.arraycopy(stringArray2, 0, object, 0, stringArray2.length);
                    }
                    stringArray2 = object;
                }
                stringArray2[n2] = (String)this.mapType((String)object2);
                continue;
            }
            if (!((String)object3).startsWith("field")) continue;
            n2 = Integer.parseInt(((String)object3).substring(5));
            if (stringArray == null || stringArray.length <= n2) {
                object = new String[n2 + 1];
                if (stringArray != null) {
                    System.arraycopy(stringArray, 0, object, 0, stringArray.length);
                }
                stringArray = object;
            }
            stringArray[n2] = object2;
        }
        if (n3 != 5) {
            this.throwException("Unclosed element tag");
        }
        if (n4 == 0) {
            this.throwException("ID is not specified or index");
        }
        if (string2 != null) {
            object3 = ClassDescriptor.loadClass(this.storage, string2);
            if (string3 != null) {
                btree = new BtreeFieldIndex((Class)object3, string3, bl2, l2);
            } else if (stringArray != null) {
                btree = new BtreeMultiFieldIndex((Class)object3, stringArray, bl2);
            } else {
                this.throwException("Field name is not specified for field index");
            }
        } else if (stringArray2 != null) {
            btree = new BtreeCompoundIndex((int[])stringArray2, bl2);
        } else if (string4 == null) {
            if (string.equals("org.garret.perst.impl.PersistentSet")) {
                btree = new PersistentSet();
            } else {
                this.throwException("Key type is not specified for index");
            }
        } else {
            btree = string.equals("org.garret.perst.impl.BitIndexImpl") ? new BitIndexImpl() : new Btree(this.mapType(string4), bl2);
        }
        this.storage.assignOid(btree, n4);
        while ((n3 = this.scanner.scan()) == 4) {
            int n5;
            if (this.scanner.scan() != 0 || !this.scanner.getIdentifier().equals("ref")) {
                this.throwException("<ref> element expected");
            }
            object3 = this.readElement("ref");
            object2 = null;
            n2 = 0;
            if (stringArray != null) {
                object = new String[stringArray.length];
                for (n5 = 0; n5 < ((String[])object).length; ++n5) {
                    object[n5] = this.getAttribute((XMLElement)object3, "key" + n5);
                }
                object2 = this.createCompoundKey(((BtreeMultiFieldIndex)btree).types, (String[])object);
            } else if (stringArray2 != null) {
                object = new String[stringArray2.length];
                for (n5 = 0; n5 < ((String[])object).length; ++n5) {
                    object[n5] = this.getAttribute((XMLElement)object3, "key" + n5);
                }
                object2 = this.createCompoundKey((int[])stringArray2, (String[])object);
            } else if (btree instanceof BitIndex) {
                n2 = this.getIntAttribute((XMLElement)object3, "key");
            } else {
                object2 = this.createKey(btree.type, this.getAttribute((XMLElement)object3, "key"));
            }
            object = new PersistentStub(this.storage, this.mapId(this.getIntAttribute((XMLElement)object3, "id")));
            if (btree instanceof BitIndex) {
                ((BitIndex)((Object)btree)).put((IPersistent)object, n2);
                continue;
            }
            btree.insert((Key)object2, (IPersistent)object, false);
        }
        if (n3 != 6 || this.scanner.scan() != 0 || !this.scanner.getIdentifier().equals(string) || this.scanner.scan() != 5) {
            this.throwException("Element is not closed");
        }
        object3 = this.storage.packObject(btree, false);
        int n6 = ObjectHeader.getSize((byte[])object3, 0);
        long l3 = this.storage.allocate(n6, 0);
        this.storage.setPos(n4, l3 | 2L);
        this.storage.pool.put(l3 & 0xFFFFFFFFFFFFFFF8L, (byte[])object3, n6);
    }

    final void createObject(XMLElement xMLElement) throws XMLImportException {
        Class clazz = ClassDescriptor.loadClass(this.storage, xMLElement.name);
        ClassDescriptor classDescriptor = this.storage.getClassDescriptor(clazz);
        int n2 = this.mapId(this.getIntAttribute(xMLElement, "id"));
        ByteBuffer byteBuffer = new ByteBuffer();
        int n3 = 8;
        byteBuffer.extend(n3);
        n3 = this.packObject(xMLElement, classDescriptor, n3, byteBuffer);
        ObjectHeader.setSize(byteBuffer.arr, 0, n3);
        ObjectHeader.setType(byteBuffer.arr, 0, classDescriptor.getOid());
        long l2 = this.storage.allocate(n3, 0);
        this.storage.setPos(n2, l2 | 2L);
        this.storage.pool.put(l2, byteBuffer.arr, n3);
    }

    final int getHexValue(char c2) throws XMLImportException {
        if (c2 >= '0' && c2 <= '9') {
            return c2 - 48;
        }
        if (c2 >= 'A' && c2 <= 'F') {
            return c2 - 65 + 10;
        }
        if (c2 >= 'a' && c2 <= 'f') {
            return c2 - 97 + 10;
        }
        this.throwException("Bad hexadecimal constant");
        return -1;
    }

    final int importBinary(XMLElement xMLElement, int n2, ByteBuffer byteBuffer, String string) throws XMLImportException {
        if (xMLElement == null || xMLElement.isNullValue()) {
            byteBuffer.extend(n2 + 4);
            Bytes.pack4(byteBuffer.arr, n2, -1);
            n2 += 4;
        } else if (xMLElement.isStringValue()) {
            String string2 = xMLElement.getStringValue();
            int n3 = string2.length();
            if (string2.startsWith("#")) {
                byteBuffer.extend(n2 + 4 + n3 / 2 - 1);
                Bytes.pack4(byteBuffer.arr, n2, -2 - this.getHexValue(string2.charAt(1)));
                n2 += 4;
                for (int i2 = 2; i2 < n3; i2 += 2) {
                    byteBuffer.arr[n2++] = (byte)(this.getHexValue(string2.charAt(i2)) << 4 | this.getHexValue(string2.charAt(i2 + 1)));
                }
            } else {
                byteBuffer.extend(n2 + 4 + n3 / 2);
                Bytes.pack4(byteBuffer.arr, n2, n3 / 2);
                n2 += 4;
                for (int i3 = 0; i3 < n3; i3 += 2) {
                    byteBuffer.arr[n2++] = (byte)(this.getHexValue(string2.charAt(i3)) << 4 | this.getHexValue(string2.charAt(i3 + 1)));
                }
            }
        } else {
            XMLElement xMLElement2 = xMLElement.getSibling("ref");
            if (xMLElement2 != null) {
                byteBuffer.extend(n2 + 4);
                Bytes.pack4(byteBuffer.arr, n2, this.mapId(this.getIntAttribute(xMLElement2, "id")));
                n2 += 4;
            } else {
                XMLElement xMLElement3 = xMLElement.getSibling("element");
                int n4 = xMLElement3 == null ? 0 : xMLElement3.getCounter();
                byteBuffer.extend(n2 + 4 + n4);
                Bytes.pack4(byteBuffer.arr, n2, n4);
                n2 += 4;
                while (--n4 >= 0) {
                    if (xMLElement3.isIntValue()) {
                        byteBuffer.arr[n2] = (byte)xMLElement3.getIntValue();
                    } else if (xMLElement3.isRealValue()) {
                        byteBuffer.arr[n2] = (byte)xMLElement3.getRealValue();
                    } else {
                        this.throwException("Conversion for field " + string + " is not possible");
                    }
                    xMLElement3 = xMLElement3.getNextSibling();
                    ++n2;
                }
            }
        }
        return n2;
    }

    final int packObject(XMLElement xMLElement, ClassDescriptor classDescriptor, int n2, ByteBuffer byteBuffer) throws XMLImportException {
        ClassDescriptor.FieldDescriptor[] fieldDescriptorArray = classDescriptor.allFields;
        int n3 = fieldDescriptorArray.length;
        block28: for (int i2 = 0; i2 < n3; ++i2) {
            ClassDescriptor.FieldDescriptor fieldDescriptor = fieldDescriptorArray[i2];
            String string = fieldDescriptor.fieldName;
            XMLElement xMLElement2 = xMLElement != null ? xMLElement.getSibling(string) : null;
            switch (fieldDescriptor.type) {
                case 1: {
                    byteBuffer.extend(n2 + 1);
                    if (xMLElement2 != null) {
                        if (xMLElement2.isIntValue()) {
                            byteBuffer.arr[n2] = (byte)xMLElement2.getIntValue();
                        } else if (xMLElement2.isRealValue()) {
                            byteBuffer.arr[n2] = (byte)xMLElement2.getRealValue();
                        } else {
                            this.throwException("Conversion for field " + string + " is not possible");
                        }
                    }
                    ++n2;
                    continue block28;
                }
                case 0: {
                    byteBuffer.extend(n2 + 1);
                    if (xMLElement2 != null) {
                        if (xMLElement2.isIntValue()) {
                            byteBuffer.arr[n2] = (byte)(xMLElement2.getIntValue() != 0L ? 1 : 0);
                        } else if (xMLElement2.isRealValue()) {
                            byteBuffer.arr[n2] = (byte)(xMLElement2.getRealValue() != 0.0 ? 1 : 0);
                        } else {
                            this.throwException("Conversion for field " + string + " is not possible");
                        }
                    }
                    ++n2;
                    continue block28;
                }
                case 2: 
                case 3: {
                    byteBuffer.extend(n2 + 2);
                    if (xMLElement2 != null) {
                        if (xMLElement2.isIntValue()) {
                            Bytes.pack2(byteBuffer.arr, n2, (short)xMLElement2.getIntValue());
                        } else if (xMLElement2.isRealValue()) {
                            Bytes.pack2(byteBuffer.arr, n2, (short)xMLElement2.getRealValue());
                        } else {
                            this.throwException("Conversion for field " + string + " is not possible");
                        }
                    }
                    n2 += 2;
                    continue block28;
                }
                case 4: {
                    byteBuffer.extend(n2 + 4);
                    if (xMLElement2 != null) {
                        if (xMLElement2.isIntValue()) {
                            Bytes.pack4(byteBuffer.arr, n2, (int)xMLElement2.getIntValue());
                        } else if (xMLElement2.isRealValue()) {
                            Bytes.pack4(byteBuffer.arr, n2, (int)xMLElement2.getRealValue());
                        } else {
                            this.throwException("Conversion for field " + string + " is not possible");
                        }
                    }
                    n2 += 4;
                    continue block28;
                }
                case 5: {
                    byteBuffer.extend(n2 + 8);
                    if (xMLElement2 != null) {
                        if (xMLElement2.isIntValue()) {
                            Bytes.pack8(byteBuffer.arr, n2, xMLElement2.getIntValue());
                        } else if (xMLElement2.isRealValue()) {
                            Bytes.pack8(byteBuffer.arr, n2, (long)xMLElement2.getRealValue());
                        } else {
                            this.throwException("Conversion for field " + string + " is not possible");
                        }
                    }
                    n2 += 8;
                    continue block28;
                }
                case 6: {
                    byteBuffer.extend(n2 + 4);
                    if (xMLElement2 != null) {
                        if (xMLElement2.isIntValue()) {
                            Bytes.pack4(byteBuffer.arr, n2, Float.floatToIntBits(xMLElement2.getIntValue()));
                        } else if (xMLElement2.isRealValue()) {
                            Bytes.pack4(byteBuffer.arr, n2, Float.floatToIntBits((float)xMLElement2.getRealValue()));
                        } else {
                            this.throwException("Conversion for field " + string + " is not possible");
                        }
                    }
                    n2 += 4;
                    continue block28;
                }
                case 7: {
                    byteBuffer.extend(n2 + 8);
                    if (xMLElement2 != null) {
                        if (xMLElement2.isIntValue()) {
                            Bytes.pack8(byteBuffer.arr, n2, Double.doubleToLongBits(xMLElement2.getIntValue()));
                        } else if (xMLElement2.isRealValue()) {
                            Bytes.pack8(byteBuffer.arr, n2, Double.doubleToLongBits(xMLElement2.getRealValue()));
                        } else {
                            this.throwException("Conversion for field " + string + " is not possible");
                        }
                    }
                    n2 += 8;
                    continue block28;
                }
                case 9: {
                    byteBuffer.extend(n2 + 8);
                    if (xMLElement2 != null) {
                        if (xMLElement2.isIntValue()) {
                            Bytes.pack8(byteBuffer.arr, n2, xMLElement2.getIntValue());
                        } else if (xMLElement2.isNullValue()) {
                            Bytes.pack8(byteBuffer.arr, n2, -1L);
                        } else if (xMLElement2.isStringValue()) {
                            Date date = httpFormatter.parse(xMLElement2.getStringValue(), new ParsePosition(0));
                            if (date == null) {
                                this.throwException("Invalid date");
                            }
                            Bytes.pack8(byteBuffer.arr, n2, date.getTime());
                        } else {
                            this.throwException("Conversion for field " + string + " is not possible");
                        }
                    }
                    n2 += 8;
                    continue block28;
                }
                case 8: {
                    if (xMLElement2 != null) {
                        String string2 = null;
                        if (xMLElement2.isIntValue()) {
                            string2 = Long.toString(xMLElement2.getIntValue());
                        } else if (xMLElement2.isRealValue()) {
                            string2 = Double.toString(xMLElement2.getRealValue());
                        } else if (xMLElement2.isStringValue()) {
                            string2 = xMLElement2.getStringValue();
                        } else if (xMLElement2.isNullValue()) {
                            string2 = null;
                        } else {
                            this.throwException("Conversion for field " + string + " is not possible");
                        }
                        n2 = byteBuffer.packString(n2, string2, this.storage.encoding);
                        continue block28;
                    }
                    byteBuffer.extend(n2 + 4);
                    Bytes.pack4(byteBuffer.arr, n2, -1);
                    n2 += 4;
                    continue block28;
                }
                case 10: {
                    int n4 = 0;
                    if (xMLElement2 != null) {
                        XMLElement xMLElement3 = xMLElement2.getSibling("ref");
                        if (xMLElement3 == null) {
                            this.throwException("<ref> element expected");
                        }
                        n4 = this.mapId(this.getIntAttribute(xMLElement3, "id"));
                    }
                    byteBuffer.extend(n2 + 4);
                    Bytes.pack4(byteBuffer.arr, n2, n4);
                    n2 += 4;
                    continue block28;
                }
                case 11: {
                    n2 = this.packObject(xMLElement2, fieldDescriptor.valueDesc, n2, byteBuffer);
                    continue block28;
                }
                case 12: 
                case 21: {
                    n2 = this.importBinary(xMLElement2, n2, byteBuffer, string);
                    continue block28;
                }
                case 15: {
                    if (!xMLElement2.isStringValue()) {
                        this.throwException("text element expected");
                    }
                    String string3 = xMLElement2.getStringValue();
                    try {
                        CustomSerializable customSerializable = this.storage.serializer.parse(string3);
                        this.storage.serializer.pack(customSerializable, byteBuffer.getOutputStream());
                        n2 = byteBuffer.size();
                    }
                    catch (IOException iOException) {
                        this.throwException("exception in custom serializer: " + iOException);
                    }
                    continue block28;
                }
                case 20: {
                    if (xMLElement2 == null || xMLElement2.isNullValue()) {
                        byteBuffer.extend(n2 + 4);
                        Bytes.pack4(byteBuffer.arr, n2, -1);
                        n2 += 4;
                        continue block28;
                    }
                    XMLElement xMLElement4 = xMLElement2.getSibling("element");
                    int n5 = xMLElement4 == null ? 0 : xMLElement4.getCounter();
                    byteBuffer.extend(n2 + 4 + n5);
                    Bytes.pack4(byteBuffer.arr, n2, n5);
                    n2 += 4;
                    while (--n5 >= 0) {
                        if (xMLElement4.isIntValue()) {
                            byteBuffer.arr[n2] = (byte)(xMLElement4.getIntValue() != 0L ? 1 : 0);
                        } else if (xMLElement4.isRealValue()) {
                            byteBuffer.arr[n2] = (byte)(xMLElement4.getRealValue() != 0.0 ? 1 : 0);
                        } else {
                            this.throwException("Conversion for field " + string + " is not possible");
                        }
                        xMLElement4 = xMLElement4.getNextSibling();
                        ++n2;
                    }
                    continue block28;
                }
                case 22: 
                case 23: {
                    if (xMLElement2 == null || xMLElement2.isNullValue()) {
                        byteBuffer.extend(n2 + 4);
                        Bytes.pack4(byteBuffer.arr, n2, -1);
                        n2 += 4;
                        continue block28;
                    }
                    XMLElement xMLElement5 = xMLElement2.getSibling("element");
                    int n6 = xMLElement5 == null ? 0 : xMLElement5.getCounter();
                    byteBuffer.extend(n2 + 4 + n6 * 2);
                    Bytes.pack4(byteBuffer.arr, n2, n6);
                    n2 += 4;
                    while (--n6 >= 0) {
                        if (xMLElement5.isIntValue()) {
                            Bytes.pack2(byteBuffer.arr, n2, (short)xMLElement5.getIntValue());
                        } else if (xMLElement5.isRealValue()) {
                            Bytes.pack2(byteBuffer.arr, n2, (short)xMLElement5.getRealValue());
                        } else {
                            this.throwException("Conversion for field " + string + " is not possible");
                        }
                        xMLElement5 = xMLElement5.getNextSibling();
                        n2 += 2;
                    }
                    continue block28;
                }
                case 24: {
                    if (xMLElement2 == null || xMLElement2.isNullValue()) {
                        byteBuffer.extend(n2 + 4);
                        Bytes.pack4(byteBuffer.arr, n2, -1);
                        n2 += 4;
                        continue block28;
                    }
                    XMLElement xMLElement6 = xMLElement2.getSibling("element");
                    int n7 = xMLElement6 == null ? 0 : xMLElement6.getCounter();
                    byteBuffer.extend(n2 + 4 + n7 * 4);
                    Bytes.pack4(byteBuffer.arr, n2, n7);
                    n2 += 4;
                    while (--n7 >= 0) {
                        if (xMLElement6.isIntValue()) {
                            Bytes.pack4(byteBuffer.arr, n2, (int)xMLElement6.getIntValue());
                        } else if (xMLElement6.isRealValue()) {
                            Bytes.pack4(byteBuffer.arr, n2, (int)xMLElement6.getRealValue());
                        } else {
                            this.throwException("Conversion for field " + string + " is not possible");
                        }
                        xMLElement6 = xMLElement6.getNextSibling();
                        n2 += 4;
                    }
                    continue block28;
                }
                case 25: {
                    if (xMLElement2 == null || xMLElement2.isNullValue()) {
                        byteBuffer.extend(n2 + 4);
                        Bytes.pack4(byteBuffer.arr, n2, -1);
                        n2 += 4;
                        continue block28;
                    }
                    XMLElement xMLElement7 = xMLElement2.getSibling("element");
                    int n8 = xMLElement7 == null ? 0 : xMLElement7.getCounter();
                    byteBuffer.extend(n2 + 4 + n8 * 8);
                    Bytes.pack4(byteBuffer.arr, n2, n8);
                    n2 += 4;
                    while (--n8 >= 0) {
                        if (xMLElement7.isIntValue()) {
                            Bytes.pack8(byteBuffer.arr, n2, xMLElement7.getIntValue());
                        } else if (xMLElement7.isRealValue()) {
                            Bytes.pack8(byteBuffer.arr, n2, (long)xMLElement7.getRealValue());
                        } else {
                            this.throwException("Conversion for field " + string + " is not possible");
                        }
                        xMLElement7 = xMLElement7.getNextSibling();
                        n2 += 8;
                    }
                    continue block28;
                }
                case 26: {
                    if (xMLElement2 == null || xMLElement2.isNullValue()) {
                        byteBuffer.extend(n2 + 4);
                        Bytes.pack4(byteBuffer.arr, n2, -1);
                        n2 += 4;
                        continue block28;
                    }
                    XMLElement xMLElement8 = xMLElement2.getSibling("element");
                    int n9 = xMLElement8 == null ? 0 : xMLElement8.getCounter();
                    byteBuffer.extend(n2 + 4 + n9 * 4);
                    Bytes.pack4(byteBuffer.arr, n2, n9);
                    n2 += 4;
                    while (--n9 >= 0) {
                        if (xMLElement8.isIntValue()) {
                            Bytes.pack4(byteBuffer.arr, n2, Float.floatToIntBits(xMLElement8.getIntValue()));
                        } else if (xMLElement8.isRealValue()) {
                            Bytes.pack4(byteBuffer.arr, n2, Float.floatToIntBits((float)xMLElement8.getRealValue()));
                        } else {
                            this.throwException("Conversion for field " + string + " is not possible");
                        }
                        xMLElement8 = xMLElement8.getNextSibling();
                        n2 += 4;
                    }
                    continue block28;
                }
                case 27: {
                    if (xMLElement2 == null || xMLElement2.isNullValue()) {
                        byteBuffer.extend(n2 + 4);
                        Bytes.pack4(byteBuffer.arr, n2, -1);
                        n2 += 4;
                        continue block28;
                    }
                    XMLElement xMLElement9 = xMLElement2.getSibling("element");
                    int n10 = xMLElement9 == null ? 0 : xMLElement9.getCounter();
                    byteBuffer.extend(n2 + 4 + n10 * 8);
                    Bytes.pack4(byteBuffer.arr, n2, n10);
                    n2 += 4;
                    while (--n10 >= 0) {
                        if (xMLElement9.isIntValue()) {
                            Bytes.pack8(byteBuffer.arr, n2, Double.doubleToLongBits(xMLElement9.getIntValue()));
                        } else if (xMLElement9.isRealValue()) {
                            Bytes.pack8(byteBuffer.arr, n2, Double.doubleToLongBits(xMLElement9.getRealValue()));
                        } else {
                            this.throwException("Conversion for field " + string + " is not possible");
                        }
                        xMLElement9 = xMLElement9.getNextSibling();
                        n2 += 8;
                    }
                    continue block28;
                }
                case 29: {
                    Object object;
                    if (xMLElement2 == null || xMLElement2.isNullValue()) {
                        byteBuffer.extend(n2 + 4);
                        Bytes.pack4(byteBuffer.arr, n2, -1);
                        n2 += 4;
                        continue block28;
                    }
                    XMLElement xMLElement10 = xMLElement2.getSibling("element");
                    int n11 = xMLElement10 == null ? 0 : xMLElement10.getCounter();
                    byteBuffer.extend(n2 + 4 + n11 * 8);
                    Bytes.pack4(byteBuffer.arr, n2, n11);
                    n2 += 4;
                    while (--n11 >= 0) {
                        if (xMLElement10.isNullValue()) {
                            Bytes.pack8(byteBuffer.arr, n2, -1L);
                        } else if (xMLElement10.isStringValue()) {
                            object = httpFormatter.parse(xMLElement10.getStringValue(), new ParsePosition(0));
                            if (object == null) {
                                this.throwException("Invalid date");
                            }
                            Bytes.pack8(byteBuffer.arr, n2, ((Date)object).getTime());
                        } else {
                            this.throwException("Conversion for field " + string + " is not possible");
                        }
                        xMLElement10 = xMLElement10.getNextSibling();
                        n2 += 8;
                    }
                    continue block28;
                }
                case 28: {
                    Object object;
                    if (xMLElement2 == null || xMLElement2.isNullValue()) {
                        byteBuffer.extend(n2 + 4);
                        Bytes.pack4(byteBuffer.arr, n2, -1);
                        n2 += 4;
                        continue block28;
                    }
                    XMLElement xMLElement11 = xMLElement2.getSibling("element");
                    int n12 = xMLElement11 == null ? 0 : xMLElement11.getCounter();
                    byteBuffer.extend(n2 + 4);
                    Bytes.pack4(byteBuffer.arr, n2, n12);
                    n2 += 4;
                    while (--n12 >= 0) {
                        object = null;
                        if (xMLElement11.isIntValue()) {
                            object = Long.toString(xMLElement11.getIntValue());
                        } else if (xMLElement11.isRealValue()) {
                            object = Double.toString(xMLElement11.getRealValue());
                        } else if (xMLElement11.isStringValue()) {
                            object = xMLElement11.getStringValue();
                        } else if (xMLElement11.isNullValue()) {
                            object = null;
                        } else {
                            this.throwException("Conversion for field " + string + " is not possible");
                        }
                        n2 = byteBuffer.packString(n2, (String)object, this.storage.encoding);
                        xMLElement11 = xMLElement11.getNextSibling();
                    }
                    continue block28;
                }
                case 13: 
                case 30: {
                    Object object;
                    if (xMLElement2 == null || xMLElement2.isNullValue()) {
                        byteBuffer.extend(n2 + 4);
                        Bytes.pack4(byteBuffer.arr, n2, -1);
                        n2 += 4;
                        continue block28;
                    }
                    XMLElement xMLElement12 = xMLElement2.getSibling("element");
                    int n13 = xMLElement12 == null ? 0 : xMLElement12.getCounter();
                    byteBuffer.extend(n2 + 4 + n13 * 4);
                    Bytes.pack4(byteBuffer.arr, n2, n13);
                    n2 += 4;
                    while (--n13 >= 0) {
                        object = xMLElement12.getSibling("ref");
                        if (object == null) {
                            this.throwException("<ref> element expected");
                        }
                        int n14 = this.mapId(this.getIntAttribute((XMLElement)object, "id"));
                        Bytes.pack4(byteBuffer.arr, n2, n14);
                        xMLElement12 = xMLElement12.getNextSibling();
                        n2 += 4;
                    }
                    continue block28;
                }
                case 31: {
                    if (xMLElement2 == null || xMLElement2.isNullValue()) {
                        byteBuffer.extend(n2 + 4);
                        Bytes.pack4(byteBuffer.arr, n2, -1);
                        n2 += 4;
                        continue block28;
                    }
                    XMLElement xMLElement13 = xMLElement2.getSibling("element");
                    int n15 = xMLElement13 == null ? 0 : xMLElement13.getCounter();
                    Bytes.pack4(byteBuffer.arr, n2, n15);
                    n2 += 4;
                    Object object = fieldDescriptor.valueDesc;
                    while (--n15 >= 0) {
                        n2 = this.packObject(xMLElement13, (ClassDescriptor)object, n2, byteBuffer);
                        xMLElement13 = xMLElement13.getNextSibling();
                    }
                    continue block28;
                }
                case 32: {
                    if (xMLElement2 == null || xMLElement2.isNullValue()) {
                        byteBuffer.extend(n2 + 4);
                        Bytes.pack4(byteBuffer.arr, n2, -1);
                        n2 += 4;
                        continue block28;
                    }
                    XMLElement xMLElement14 = xMLElement2.getSibling("element");
                    int n16 = xMLElement14 == null ? 0 : xMLElement14.getCounter();
                    Bytes.pack4(byteBuffer.arr, n2, n16);
                    n2 += 4;
                    while (--n16 >= 0) {
                        n2 = this.importBinary(xMLElement14, n2, byteBuffer, string);
                        xMLElement14 = xMLElement14.getNextSibling();
                    }
                    continue block28;
                }
            }
        }
        return n2;
    }

    final XMLElement readElement(String string) throws XMLImportException {
        XMLElement xMLElement = new XMLElement(string);
        block11: while (true) {
            switch (this.scanner.scan()) {
                case 7: {
                    return xMLElement;
                }
                case 5: {
                    int n2;
                    while ((n2 = this.scanner.scan()) == 4) {
                        if (this.scanner.scan() != 0) {
                            this.throwException("Element name expected");
                        }
                        String string2 = this.scanner.getIdentifier();
                        XMLElement xMLElement2 = this.readElement(string2);
                        xMLElement.addSibling(xMLElement2);
                    }
                    switch (n2) {
                        case 1: {
                            xMLElement.setStringValue(this.scanner.getString());
                            n2 = this.scanner.scan();
                            break;
                        }
                        case 2: {
                            xMLElement.setIntValue(this.scanner.getInt());
                            n2 = this.scanner.scan();
                            break;
                        }
                        case 3: {
                            xMLElement.setRealValue(this.scanner.getReal());
                            n2 = this.scanner.scan();
                            break;
                        }
                        case 0: {
                            if (this.scanner.getIdentifier().equals("null")) {
                                xMLElement.setNullValue();
                            } else {
                                xMLElement.setStringValue(this.scanner.getIdentifier());
                            }
                            n2 = this.scanner.scan();
                        }
                    }
                    if (n2 != 6 || this.scanner.scan() != 0 || !this.scanner.getIdentifier().equals(string) || this.scanner.scan() != 5) {
                        this.throwException("Element is not closed");
                    }
                    return xMLElement;
                }
                case 0: {
                    String string3 = this.scanner.getIdentifier();
                    if (this.scanner.scan() != 8 || this.scanner.scan() != 1) {
                        this.throwException("Attribute value expected");
                    }
                    xMLElement.addAttribute(string3, this.scanner.getString());
                    continue block11;
                }
            }
            this.throwException("Unexpected token");
        }
    }

    final void throwException(String string) throws XMLImportException {
        throw new XMLImportException(this.scanner.getLine(), this.scanner.getColumn(), string);
    }

    static class XMLScanner {
        static final int XML_IDENT = 0;
        static final int XML_SCONST = 1;
        static final int XML_ICONST = 2;
        static final int XML_FCONST = 3;
        static final int XML_LT = 4;
        static final int XML_GT = 5;
        static final int XML_LTS = 6;
        static final int XML_GTS = 7;
        static final int XML_EQ = 8;
        static final int XML_EOF = 9;
        Reader reader;
        int line;
        int column;
        char[] sconst;
        long iconst;
        double fconst;
        int slen;
        String ident;
        int size;
        int ungetChar;
        boolean hasUngetChar;

        XMLScanner(Reader reader) {
            this.reader = reader;
            this.size = 1024;
            this.sconst = new char[1024];
            this.line = 1;
            this.column = 0;
            this.hasUngetChar = false;
        }

        final int get() throws XMLImportException {
            if (this.hasUngetChar) {
                this.hasUngetChar = false;
                return this.ungetChar;
            }
            try {
                int n2 = this.reader.read();
                if (n2 == 10) {
                    ++this.line;
                    this.column = 0;
                } else {
                    this.column = n2 == 9 ? (this.column += this.column + 8 & 0xFFFFFFF8) : ++this.column;
                }
                return n2;
            }
            catch (IOException iOException) {
                throw new XMLImportException(this.line, this.column, iOException.getMessage());
            }
        }

        final void unget(int n2) {
            if (n2 == 10) {
                --this.line;
            } else {
                --this.column;
            }
            this.ungetChar = n2;
            this.hasUngetChar = true;
        }

        /*
         * Unable to fully structure code
         */
        final int scan() throws XMLImportException {
            block16: while (true) {
                if ((var2_1 = this.get()) < 0) {
                    return 9;
                }
                if (var2_1 <= 32) continue;
                switch (var2_1) {
                    case 60: {
                        var2_1 = this.get();
                        if (var2_1 == 63) {
                            while ((var2_1 = this.get()) != 63) {
                                if (var2_1 >= 0) continue;
                                throw new XMLImportException(this.line, this.column, "Bad XML file format");
                            }
                            var2_1 = this.get();
                            if (var2_1 != 62) ** break;
                            continue block16;
                            throw new XMLImportException(this.line, this.column, "Bad XML file format");
                        }
                        if (var2_1 != 47) {
                            this.unget(var2_1);
                            return 4;
                        }
                        return 6;
                    }
                    case 62: {
                        return 5;
                    }
                    case 47: {
                        var2_1 = this.get();
                        if (var2_1 != 62) {
                            this.unget(var2_1);
                            throw new XMLImportException(this.line, this.column, "Bad XML file format");
                        }
                        return 7;
                    }
                    case 61: {
                        return 8;
                    }
                    case 34: {
                        var1_2 = 0;
                        while (true) {
                            if ((var2_1 = this.get()) < 0) {
                                throw new XMLImportException(this.line, this.column, "Bad XML file format");
                            }
                            if (var2_1 != 38) ** GOTO lbl59
                            switch (this.get()) {
                                case 97: {
                                    if (this.get() != 109 || this.get() != 112 || this.get() != 59) {
                                        throw new XMLImportException(this.line, this.column, "Bad XML file format");
                                    }
                                    var2_1 = 38;
                                    ** GOTO lbl62
                                }
                                case 108: {
                                    if (this.get() != 116 || this.get() != 59) {
                                        throw new XMLImportException(this.line, this.column, "Bad XML file format");
                                    }
                                    var2_1 = 60;
                                    ** GOTO lbl62
                                }
                                case 103: {
                                    if (this.get() != 116 || this.get() != 59) {
                                        throw new XMLImportException(this.line, this.column, "Bad XML file format");
                                    }
                                    var2_1 = 62;
                                    ** GOTO lbl62
                                }
                                case 113: {
                                    if (this.get() != 117 || this.get() != 111 || this.get() != 116 || this.get() != 59) {
                                        throw new XMLImportException(this.line, this.column, "Bad XML file format");
                                    }
                                    var2_1 = 34;
                                    ** GOTO lbl62
                                }
                                default: {
                                    throw new XMLImportException(this.line, this.column, "Bad XML file format");
                                }
                            }
lbl59:
                            // 1 sources

                            if (var2_1 == 34) {
                                this.slen = var1_2;
                                return 1;
                            }
lbl62:
                            // 6 sources

                            if (var1_2 == this.size) {
                                var4_5 = new char[this.size *= 2];
                                System.arraycopy(this.sconst, 0, var4_5, 0, var1_2);
                                this.sconst = var4_5;
                            }
                            this.sconst[var1_2++] = (char)var2_1;
                        }
                    }
                    case 43: 
                    case 45: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        var1_3 = 0;
                        var3_7 = false;
                        while (true) {
                            if (!Character.isDigit((char)var2_1) && var2_1 != 45 && var2_1 != 43 && var2_1 != 46 && var2_1 != 69) {
                                this.unget(var2_1);
                                try {
                                    if (var3_7) {
                                        this.fconst = Double.parseDouble(new String(this.sconst, 0, var1_3));
                                        return 3;
                                    }
                                    this.iconst = Long.parseLong(new String(this.sconst, 0, var1_3));
                                    return 2;
                                }
                                catch (NumberFormatException var4_6) {
                                    throw new XMLImportException(this.line, this.column, "Bad XML file format");
                                }
                            }
                            if (var1_3 == this.size) {
                                throw new XMLImportException(this.line, this.column, "Bad XML file format");
                            }
                            this.sconst[var1_3++] = (char)var2_1;
                            if (var2_1 == 46) {
                                var3_7 = true;
                            }
                            var2_1 = this.get();
                        }
                    }
                }
                break;
            }
            var1_4 = 0;
            while (Character.isLetterOrDigit((char)var2_1) || var2_1 == 45 || var2_1 == 58 || var2_1 == 95 || var2_1 == 46) {
                if (var1_4 == this.size) {
                    throw new XMLImportException(this.line, this.column, "Bad XML file format");
                }
                if (var2_1 == 45) {
                    var2_1 = 36;
                }
                this.sconst[var1_4++] = (char)var2_1;
                var2_1 = this.get();
            }
            this.unget(var2_1);
            if (var1_4 == 0) {
                throw new XMLImportException(this.line, this.column, "Bad XML file format");
            }
            this.ident = new String(this.sconst, 0, var1_4);
            return 0;
        }

        final String getIdentifier() {
            return this.ident;
        }

        final String getString() {
            return new String(this.sconst, 0, this.slen);
        }

        final long getInt() {
            return this.iconst;
        }

        final double getReal() {
            return this.fconst;
        }

        final int getLine() {
            return this.line;
        }

        final int getColumn() {
            return this.column;
        }
    }

    static class XMLElement {
        private XMLElement next;
        private XMLElement prev;
        private String name;
        private HashMap siblings;
        private HashMap attributes;
        private String svalue;
        private long ivalue;
        private double rvalue;
        private int valueType;
        private int counter;
        static final int NO_VALUE = 0;
        static final int STRING_VALUE = 1;
        static final int INT_VALUE = 2;
        static final int REAL_VALUE = 3;
        static final int NULL_VALUE = 4;

        XMLElement(String string) {
            this.name = string;
            this.valueType = 0;
        }

        final void addSibling(XMLElement xMLElement) {
            XMLElement xMLElement2;
            if (this.siblings == null) {
                this.siblings = new HashMap();
            }
            if ((xMLElement2 = (XMLElement)this.siblings.get(xMLElement.name)) != null) {
                xMLElement.next = null;
                xMLElement.prev = xMLElement2.prev;
                xMLElement.prev.next = xMLElement;
                xMLElement2.prev = xMLElement;
                ++xMLElement2.counter;
            } else {
                this.siblings.put(xMLElement.name, xMLElement);
                xMLElement.prev = xMLElement;
                xMLElement.counter = 1;
            }
        }

        final void addAttribute(String string, String string2) {
            if (this.attributes == null) {
                this.attributes = new HashMap();
            }
            this.attributes.put(string, string2);
        }

        final XMLElement getSibling(String string) {
            if (this.siblings != null) {
                return (XMLElement)this.siblings.get(string);
            }
            return null;
        }

        final XMLElement getNextSibling() {
            return this.next;
        }

        final int getCounter() {
            return this.counter;
        }

        final String getAttribute(String string) {
            return this.attributes != null ? (String)this.attributes.get(string) : null;
        }

        final void setIntValue(long l2) {
            this.ivalue = l2;
            this.valueType = 2;
        }

        final void setRealValue(double d2) {
            this.rvalue = d2;
            this.valueType = 3;
        }

        final void setStringValue(String string) {
            this.svalue = string;
            this.valueType = 1;
        }

        final void setNullValue() {
            this.valueType = 4;
        }

        final String getStringValue() {
            return this.svalue;
        }

        final long getIntValue() {
            return this.ivalue;
        }

        final double getRealValue() {
            return this.rvalue;
        }

        final boolean isIntValue() {
            return this.valueType == 2;
        }

        final boolean isRealValue() {
            return this.valueType == 3;
        }

        final boolean isStringValue() {
            return this.valueType == 1;
        }

        final boolean isNullValue() {
            return this.valueType == 4;
        }
    }
}

