/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import org.garret.perst.IPersistent;
import org.garret.perst.impl.OidHashTable;

public class StrongHashTable
implements OidHashTable {
    Entry[] table;
    static final float loadFactor = 0.75f;
    int count;
    int threshold;
    boolean flushing;
    static final int MODIFIED_BUFFER_SIZE = 1024;
    IPersistent[] modified;
    int nModified;

    public StrongHashTable(int n2) {
        this.threshold = (int)((float)n2 * 0.75f);
        if (n2 != 0) {
            this.table = new Entry[n2];
        }
        this.modified = new IPersistent[1024];
    }

    public synchronized boolean remove(int n2) {
        Entry[] entryArray = this.table;
        int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n3];
        Entry entry2 = null;
        while (entry != null) {
            if (entry.oid == n2) {
                entry.obj = null;
                --this.count;
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    entryArray[n3] = entry.next;
                }
                return true;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return false;
    }

    public synchronized void put(int n2, IPersistent iPersistent) {
        Entry[] entryArray = this.table;
        int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n3];
        while (entry != null) {
            if (entry.oid == n2) {
                entry.obj = iPersistent;
                return;
            }
            entry = entry.next;
        }
        if (this.count >= this.threshold && !this.flushing) {
            this.rehash();
            entryArray = this.table;
            n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        }
        entryArray[n3] = new Entry(n2, iPersistent, entryArray[n3]);
        ++this.count;
    }

    public synchronized IPersistent get(int n2) {
        Entry[] entryArray = this.table;
        int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n3];
        while (entry != null) {
            if (entry.oid == n2) {
                return entry.obj;
            }
            entry = entry.next;
        }
        return null;
    }

    void rehash() {
        int n2 = this.table.length;
        Entry[] entryArray = this.table;
        int n3 = n2 * 2 + 1;
        Entry[] entryArray2 = new Entry[n3];
        this.threshold = (int)((float)n3 * 0.75f);
        this.table = entryArray2;
        int n4 = n2;
        while (--n4 >= 0) {
            Entry entry = entryArray[n4];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n5 = (entry2.oid & Integer.MAX_VALUE) % n3;
                entry2.next = entryArray2[n5];
                entryArray2[n5] = entry2;
            }
        }
    }

    public synchronized void flush() {
        if (this.nModified < 1024) {
            IPersistent[] iPersistentArray = this.modified;
            int n2 = this.nModified;
            while (--n2 >= 0) {
                IPersistent iPersistent = iPersistentArray[n2];
                if (!iPersistent.isModified()) continue;
                iPersistent.store();
            }
        } else {
            Entry[] entryArray = this.table;
            this.flushing = true;
            for (int i2 = 0; i2 < entryArray.length; ++i2) {
                Entry entry = entryArray[i2];
                while (entry != null) {
                    if (entry.obj.isModified()) {
                        entry.obj.store();
                    }
                    entry = entry.next;
                }
            }
            this.flushing = false;
            if (this.count >= this.threshold) {
                this.rehash();
            }
        }
        this.nModified = 0;
    }

    public synchronized void clear() {
        Entry[] entryArray = this.table;
        for (int i2 = 0; i2 < entryArray.length; ++i2) {
            entryArray[i2] = null;
        }
        this.count = 0;
        this.nModified = 0;
    }

    public synchronized void invalidate() {
        for (int i2 = 0; i2 < this.table.length; ++i2) {
            Entry entry = this.table[i2];
            while (entry != null) {
                if (entry.obj.isModified()) {
                    entry.obj.invalidate();
                }
                entry = entry.next;
            }
            this.table[i2] = null;
        }
        this.count = 0;
        this.nModified = 0;
    }

    public synchronized void setDirty(IPersistent iPersistent) {
        if (this.nModified < 1024) {
            this.modified[this.nModified++] = iPersistent;
        }
    }

    public void clearDirty(IPersistent iPersistent) {
    }

    public int size() {
        return this.count;
    }

    public void preprocess() {
    }

    static class Entry {
        Entry next;
        IPersistent obj;
        int oid;

        Entry(int n2, IPersistent iPersistent, Entry entry) {
            this.next = entry;
            this.oid = n2;
            this.obj = iPersistent;
        }
    }
}

