/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import org.garret.perst.IPersistent;
import org.garret.perst.IPersistentMap;
import org.garret.perst.Index;
import org.garret.perst.Key;
import org.garret.perst.Link;
import org.garret.perst.PersistentResource;
import org.garret.perst.Storage;
import org.garret.perst.StorageError;
import org.garret.perst.impl.Btree;
import org.garret.perst.impl.PersistentMapImpl;
import org.garret.perst.impl.QueryImpl;

class PersistentMapImpl
extends PersistentResource
implements IPersistentMap {
    Index index;
    Object keys;
    Link values;
    int type;
    volatile transient Set entrySet;
    volatile transient Set keySet;
    volatile transient Collection valuesCol;
    static final int BTREE_TRESHOLD = 128;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$org$garret$perst$IPersistent;
    static /* synthetic */ Class class$java$lang$Comparable;

    PersistentMapImpl(Storage storage, Class clazz, int n2) {
        super(storage);
        this.type = this.getTypeCode(clazz);
        this.keys = new Comparable[n2];
        this.values = storage.createLink(n2);
    }

    PersistentMapImpl() {
    }

    protected int getTypeCode(Class clazz) {
        if (clazz.equals(Byte.TYPE) || clazz.equals(class$java$lang$Byte == null ? (class$java$lang$Byte = PersistentMapImpl.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return 1;
        }
        if (clazz.equals(Short.TYPE) || clazz.equals(class$java$lang$Short == null ? (class$java$lang$Short = PersistentMapImpl.class$("java.lang.Short")) : class$java$lang$Short)) {
            return 3;
        }
        if (clazz.equals(Character.TYPE) || clazz.equals(class$java$lang$Character == null ? (class$java$lang$Character = PersistentMapImpl.class$("java.lang.Character")) : class$java$lang$Character)) {
            return 2;
        }
        if (clazz.equals(Integer.TYPE) || clazz.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = PersistentMapImpl.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return 4;
        }
        if (clazz.equals(Long.TYPE) || clazz.equals(class$java$lang$Long == null ? (class$java$lang$Long = PersistentMapImpl.class$("java.lang.Long")) : class$java$lang$Long)) {
            return 5;
        }
        if (clazz.equals(Float.TYPE) || clazz.equals(class$java$lang$Float == null ? (class$java$lang$Float = PersistentMapImpl.class$("java.lang.Float")) : class$java$lang$Float)) {
            return 6;
        }
        if (clazz.equals(Double.TYPE) || clazz.equals(class$java$lang$Double == null ? (class$java$lang$Double = PersistentMapImpl.class$("java.lang.Double")) : class$java$lang$Double)) {
            return 7;
        }
        if (clazz.equals(class$java$lang$String == null ? (class$java$lang$String = PersistentMapImpl.class$("java.lang.String")) : class$java$lang$String)) {
            return 8;
        }
        if (clazz.equals(Boolean.TYPE) || clazz.equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = PersistentMapImpl.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return 0;
        }
        if (clazz.equals(class$java$util$Date == null ? (class$java$util$Date = PersistentMapImpl.class$("java.util.Date")) : class$java$util$Date)) {
            return 9;
        }
        if ((class$org$garret$perst$IPersistent == null ? (class$org$garret$perst$IPersistent = PersistentMapImpl.class$("org.garret.perst.IPersistent")) : class$org$garret$perst$IPersistent).isAssignableFrom(clazz)) {
            return 10;
        }
        if ((class$java$lang$Comparable == null ? (class$java$lang$Comparable = PersistentMapImpl.class$("java.lang.Comparable")) : class$java$lang$Comparable).isAssignableFrom(clazz)) {
            return 12;
        }
        throw new StorageError(7, clazz);
    }

    public Iterator iterator() {
        return this.values().iterator();
    }

    public int size() {
        return this.index != null ? this.index.size() : this.values.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsValue(Object object) {
        Iterator iterator = this.entrySet().iterator();
        if (object == null) {
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (entry.getValue() != null) continue;
                return true;
            }
        } else {
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (!object.equals(entry.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    private int binarySearch(Object object) {
        Comparable[] comparableArray = (Comparable[])this.keys;
        int n2 = 0;
        int n3 = this.values.size();
        while (n2 < n3) {
            int n4 = n2 + n3 >> 1;
            if (comparableArray[n4].compareTo(object) < 0) {
                n2 = n4 + 1;
                continue;
            }
            n3 = n4;
        }
        return n3;
    }

    public boolean containsKey(Object object) {
        if (this.index != null) {
            Key key = this.generateKey(object);
            return this.index.entryIterator(key, key, 0).hasNext();
        }
        int n2 = this.binarySearch(object);
        return n2 < this.values.size() && ((Comparable[])this.keys)[n2].equals(object);
    }

    public Object get(Object object) {
        if (this.index != null) {
            return this.index.get(this.generateKey(object));
        }
        int n2 = this.binarySearch(object);
        if (n2 < this.values.size() && ((Comparable[])this.keys)[n2].equals(object)) {
            return this.values.get(n2);
        }
        return null;
    }

    public Object put(Object object, Object object2) {
        IPersistent iPersistent = null;
        if (this.index == null) {
            int n2 = this.values.size();
            int n3 = this.binarySearch(object);
            if (n3 < n2 && object.equals(((Comparable[])this.keys)[n3])) {
                iPersistent = this.values.get(n3);
                this.values.set(n3, (IPersistent)object2);
            } else if (n2 == 128) {
                this.index = this.getStorage().createIndex(Btree.mapKeyType(this.type), true);
                Comparable[] comparableArray = (Comparable[])this.keys;
                for (n3 = 0; n3 < n2; ++n3) {
                    this.index.set(this.generateKey(comparableArray[n3]), this.values.get(n3));
                }
                this.index.set(this.generateKey(object), (IPersistent)object2);
                this.keys = null;
                this.values = null;
                this.modify();
            } else {
                Comparable[] comparableArray = (Comparable[])this.keys;
                if (n2 >= comparableArray.length) {
                    Comparable[] comparableArray2 = new Comparable[n2 + 1 > comparableArray.length * 2 ? n2 + 1 : comparableArray.length * 2];
                    System.arraycopy(comparableArray, 0, comparableArray2, 0, n3);
                    System.arraycopy(comparableArray, n3, comparableArray2, n3 + 1, n2 - n3);
                    this.keys = comparableArray2;
                    comparableArray2[n3] = (Comparable)object;
                } else {
                    System.arraycopy(comparableArray, n3, comparableArray, n3 + 1, n2 - n3);
                    comparableArray[n3] = (Comparable)object;
                }
                this.values.insert(n3, (IPersistent)object2);
            }
        } else {
            iPersistent = this.index.set(this.generateKey(object), (IPersistent)object2);
        }
        return iPersistent;
    }

    public Object remove(Object object) {
        if (this.index == null) {
            int n2 = this.values.size();
            int n3 = this.binarySearch(object);
            if (n3 < n2 && ((Comparable[])this.keys)[n3].equals(object)) {
                System.arraycopy(this.keys, n3 + 1, this.keys, n3, n2 - n3 - 1);
                ((Comparable[])this.keys)[n2 - 1] = null;
                IPersistent iPersistent = this.values.get(n3);
                this.values.remove(n3);
                return iPersistent;
            }
            return null;
        }
        try {
            return this.index.remove(this.generateKey(object));
        }
        catch (StorageError storageError) {
            if (storageError.getErrorCode() == 5) {
                return null;
            }
            throw storageError;
        }
    }

    public void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.put(entry.getKey(), (IPersistent)entry.getValue());
        }
    }

    public void clear() {
        if (this.index != null) {
            this.index.clear();
        } else {
            this.values.clear();
            this.keys = new Comparable[((Comparable[])this.keys).length];
        }
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet(){

                public Iterator iterator() {
                    return new Iterator(this){
                        private Iterator i;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                            this.i = 1.access$000(this.this$1).entrySet().iterator();
                        }

                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        public Object next() {
                            return ((Map.Entry)this.i.next()).getKey();
                        }

                        public void remove() {
                            this.i.remove();
                        }
                    };
                }

                public int size() {
                    return PersistentMapImpl.this.size();
                }

                public boolean contains(Object object) {
                    return PersistentMapImpl.this.containsKey(object);
                }

                static /* synthetic */ PersistentMapImpl access$000(1 var0) {
                    return var0.PersistentMapImpl.this;
                }
            };
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.valuesCol == null) {
            this.valuesCol = new AbstractCollection(){

                public Iterator iterator() {
                    return new Iterator(this){
                        private Iterator i;
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = var1_1;
                            this.i = 3.access$100(this.this$1).entrySet().iterator();
                        }

                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        public Object next() {
                            return ((Map.Entry)this.i.next()).getValue();
                        }

                        public void remove() {
                            this.i.remove();
                        }
                    };
                }

                public int size() {
                    return PersistentMapImpl.this.size();
                }

                public boolean contains(Object object) {
                    return PersistentMapImpl.this.containsValue(object);
                }

                static /* synthetic */ PersistentMapImpl access$100(3 var0) {
                    return var0.PersistentMapImpl.this;
                }
            };
        }
        return this.valuesCol;
    }

    protected Iterator entryIterator() {
        if (this.index != null) {
            return this.index.entryIterator();
        }
        return new Iterator(){
            private int i = -1;

            public boolean hasNext() {
                return this.i + 1 < PersistentMapImpl.this.values.size();
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this.i;
                return new Map.Entry(this){
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public Object getKey() {
                        return ((Comparable[])5.access$200(this.this$1).keys)[5.access$300(this.this$1)];
                    }

                    public Object getValue() {
                        return 5.access$200(this.this$1).values.get(5.access$300(this.this$1));
                    }

                    public Object setValue(Object object) {
                        throw new UnsupportedOperationException("Entry.Map.setValue");
                    }
                };
            }

            public void remove() {
                if (this.i < 0) {
                    throw new IllegalStateException();
                }
                int n2 = PersistentMapImpl.this.values.size();
                System.arraycopy(PersistentMapImpl.this.keys, this.i + 1, PersistentMapImpl.this.keys, this.i, n2 - this.i - 1);
                ((Comparable[])PersistentMapImpl.this.keys)[n2 - 1] = null;
                PersistentMapImpl.this.values.remove(this.i);
                --this.i;
            }

            static /* synthetic */ PersistentMapImpl access$200(5 var0) {
                return var0.PersistentMapImpl.this;
            }

            static /* synthetic */ int access$300(5 var0) {
                return var0.i;
            }
        };
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet(){

                public Iterator iterator() {
                    return PersistentMapImpl.this.entryIterator();
                }

                public int size() {
                    return PersistentMapImpl.this.size();
                }

                public boolean remove(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Object k2 = entry.getKey();
                    Object v2 = entry.getValue();
                    if (v2 != null) {
                        Object object2 = PersistentMapImpl.this.get(k2);
                        if (v2.equals(object2)) {
                            PersistentMapImpl.this.remove(k2);
                            return true;
                        }
                    } else if (PersistentMapImpl.this.containsKey(k2) && PersistentMapImpl.this.get(k2) == null) {
                        PersistentMapImpl.this.remove(k2);
                        return true;
                    }
                    return false;
                }

                public boolean contains(Object object) {
                    Map.Entry entry = (Map.Entry)object;
                    if (entry.getValue() != null) {
                        return entry.getValue().equals(PersistentMapImpl.this.get(entry.getKey()));
                    }
                    return PersistentMapImpl.this.containsKey(entry.getKey()) && PersistentMapImpl.this.get(entry.getKey()) == null;
                }
            };
        }
        return this.entrySet;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (map.size() != this.size()) {
            return false;
        }
        try {
            Iterator iterator = this.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                Object k2 = entry.getKey();
                Object v2 = entry.getValue();
                if (!(v2 == null ? map.get(k2) != null || !map.containsKey(k2) : !v2.equals(map.get(k2)))) continue;
                return false;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n2 = 0;
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            n2 += iterator.next().hashCode();
        }
        return n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        Iterator iterator = this.entrySet().iterator();
        boolean bl2 = iterator.hasNext();
        while (bl2) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Object k2 = entry.getKey();
            Object v2 = entry.getValue();
            if (k2 == this) {
                stringBuffer.append("(this Map)");
            } else {
                stringBuffer.append(k2);
            }
            stringBuffer.append("=");
            if (v2 == this) {
                stringBuffer.append("(this Map)");
            } else {
                stringBuffer.append(v2);
            }
            if (!(bl2 = iterator.hasNext())) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    final Key generateKey(Object object) {
        return this.generateKey(object, true);
    }

    final Key generateKey(Object object, boolean bl2) {
        if (object instanceof Integer) {
            return new Key((Integer)object, bl2);
        }
        if (object instanceof Byte) {
            return new Key((Byte)object, bl2);
        }
        if (object instanceof Character) {
            return new Key(((Character)object).charValue(), bl2);
        }
        if (object instanceof Short) {
            return new Key((Short)object, bl2);
        }
        if (object instanceof Long) {
            return new Key((Long)object, bl2);
        }
        if (object instanceof Float) {
            return new Key(((Float)object).floatValue(), bl2);
        }
        if (object instanceof Double) {
            return new Key((Double)object, bl2);
        }
        if (object instanceof String) {
            return new Key((String)object, bl2);
        }
        if (object instanceof Date) {
            return new Key((Date)object, bl2);
        }
        if (object instanceof IPersistent) {
            return new Key((IPersistent)object, bl2);
        }
        if (object instanceof Comparable) {
            return new Key((Comparable)object, bl2);
        }
        if (object == null) {
            return new Key((IPersistent)object, bl2);
        }
        throw new StorageError(8, object.getClass());
    }

    public Comparator comparator() {
        return null;
    }

    public SortedMap subMap(Object object, Object object2) {
        if (((Comparable)object).compareTo(object2) > 0) {
            throw new IllegalArgumentException("from > to");
        }
        return new SubMap(object, object2);
    }

    public SortedMap headMap(Object object) {
        return new SubMap(null, object);
    }

    public SortedMap tailMap(Object object) {
        return new SubMap(object, null);
    }

    public Object firstKey() {
        if (this.index != null) {
            return ((Map.Entry)this.index.entryIterator().next()).getKey();
        }
        Comparable[] comparableArray = (Comparable[])this.keys;
        if (this.values.size() == 0) {
            throw new NoSuchElementException();
        }
        return comparableArray[0];
    }

    public Object lastKey() {
        if (this.index != null) {
            return ((Map.Entry)this.index.entryIterator(null, null, 1).next()).getKey();
        }
        int n2 = this.values.size();
        if (n2 == 0) {
            throw new NoSuchElementException();
        }
        return ((Comparable[])this.keys)[n2 - 1];
    }

    public Iterator select(Class clazz, String string) {
        QueryImpl queryImpl = new QueryImpl(this.getStorage());
        return queryImpl.select(clazz, this.values().iterator(), string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SubMap
    extends AbstractMap
    implements SortedMap {
        private Key fromKey;
        private Key toKey;
        private Object from;
        private Object to;
        volatile Set entrySet;

        SubMap(Object object, Object object2) {
            this.from = object;
            this.to = object2;
            this.fromKey = object != null ? PersistentMapImpl.this.generateKey(object, true) : null;
            this.toKey = object2 != null ? PersistentMapImpl.this.generateKey(object2, false) : null;
        }

        public boolean isEmpty() {
            return this.entrySet().isEmpty();
        }

        public boolean containsKey(Object object) {
            return this.inRange(object) && PersistentMapImpl.this.containsKey(object);
        }

        public Object get(Object object) {
            if (!this.inRange(object)) {
                return null;
            }
            return PersistentMapImpl.this.get(object);
        }

        public Object put(Object object, Object object2) {
            if (!this.inRange(object)) {
                throw new IllegalArgumentException("key out of range");
            }
            return PersistentMapImpl.this.put(object, object2);
        }

        public Comparator comparator() {
            return null;
        }

        public Object firstKey() {
            return ((Map.Entry)this.entryIterator(0).next()).getKey();
        }

        public Object lastKey() {
            return ((Map.Entry)this.entryIterator(1).next()).getKey();
        }

        protected Iterator entryIterator(int n2) {
            if (PersistentMapImpl.this.index != null) {
                return PersistentMapImpl.this.index.entryIterator(this.fromKey, this.toKey, n2);
            }
            if (n2 == 0) {
                int n3 = (this.from != null ? PersistentMapImpl.this.binarySearch(this.from) : 0) - 1;
                int n4 = PersistentMapImpl.this.values.size();
                return new Iterator(this, n3, n4){
                    private int i;
                    private final /* synthetic */ int val$beg;
                    private final /* synthetic */ int val$end;
                    private final /* synthetic */ SubMap this$1;
                    {
                        this.this$1 = subMap;
                        this.val$beg = n2;
                        this.val$end = n3;
                        this.i = this.val$beg;
                    }

                    public boolean hasNext() {
                        return this.i + 1 < this.val$end && (SubMap.access$500(this.this$1) == null || ((Comparable[])SubMap.access$600((SubMap)this.this$1).keys)[this.i + 1].compareTo(SubMap.access$500(this.this$1)) < 0);
                    }

                    public Object next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        ++this.i;
                        return new Map.Entry(this){
                            private final /* synthetic */ 8 this$2;
                            {
                                this.this$2 = var1_1;
                            }

                            public Object getKey() {
                                return ((Comparable[])SubMap.access$600((SubMap)8.access$700(this.this$2)).keys)[8.access$800(this.this$2)];
                            }

                            public Object getValue() {
                                return SubMap.access$600((SubMap)8.access$700(this.this$2)).values.get(8.access$800(this.this$2));
                            }

                            public Object setValue(Object object) {
                                throw new UnsupportedOperationException("Entry.Map.setValue");
                            }
                        };
                    }

                    public void remove() {
                        if (this.i < 0) {
                            throw new IllegalStateException();
                        }
                        int n2 = SubMap.access$600((SubMap)this.this$1).values.size();
                        System.arraycopy(SubMap.access$600((SubMap)this.this$1).keys, this.i + 1, SubMap.access$600((SubMap)this.this$1).keys, this.i, n2 - this.i - 1);
                        ((Comparable[])SubMap.access$600((SubMap)this.this$1).keys)[n2 - 1] = null;
                        SubMap.access$600((SubMap)this.this$1).values.remove(this.i);
                        --this.i;
                    }

                    static /* synthetic */ SubMap access$700(8 var0) {
                        return var0.this$1;
                    }

                    static /* synthetic */ int access$800(8 var0) {
                        return var0.i;
                    }
                };
            }
            int n5 = this.to != null ? PersistentMapImpl.this.binarySearch(this.to) : PersistentMapImpl.this.values.size();
            return new Iterator(this, n5){
                private int i;
                private final /* synthetic */ int val$beg;
                private final /* synthetic */ SubMap this$1;
                {
                    this.this$1 = subMap;
                    this.i = this.val$beg = n2;
                }

                public boolean hasNext() {
                    return this.i > 0 && (SubMap.access$900(this.this$1) == null || ((Comparable[])SubMap.access$600((SubMap)this.this$1).keys)[this.i - 1].compareTo(SubMap.access$900(this.this$1)) >= 0);
                }

                public Object next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    --this.i;
                    return new Map.Entry(this){
                        private final /* synthetic */ 10 this$2;
                        {
                            this.this$2 = var1_1;
                        }

                        public Object getKey() {
                            return ((Comparable[])SubMap.access$600((SubMap)10.access$1000(this.this$2)).keys)[10.access$1100(this.this$2)];
                        }

                        public Object getValue() {
                            return SubMap.access$600((SubMap)10.access$1000(this.this$2)).values.get(10.access$1100(this.this$2));
                        }

                        public Object setValue(Object object) {
                            throw new UnsupportedOperationException("Entry.Map.setValue");
                        }
                    };
                }

                public void remove() {
                    if (this.i < 0) {
                        throw new IllegalStateException();
                    }
                    int n2 = SubMap.access$600((SubMap)this.this$1).values.size();
                    System.arraycopy(SubMap.access$600((SubMap)this.this$1).keys, this.i + 1, SubMap.access$600((SubMap)this.this$1).keys, this.i, n2 - this.i - 1);
                    ((Comparable[])SubMap.access$600((SubMap)this.this$1).keys)[n2 - 1] = null;
                    SubMap.access$600((SubMap)this.this$1).values.remove(this.i);
                }

                static /* synthetic */ SubMap access$1000(10 var0) {
                    return var0.this$1;
                }

                static /* synthetic */ int access$1100(10 var0) {
                    return var0.i;
                }
            };
        }

        public Set entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new AbstractSet(this){
                    private final /* synthetic */ SubMap this$1;
                    {
                        this.this$1 = subMap;
                    }

                    public Iterator iterator() {
                        return this.this$1.entryIterator(0);
                    }

                    public int size() {
                        Iterator iterator = this.iterator();
                        int n2 = 0;
                        while (iterator.hasNext()) {
                            ++n2;
                            iterator.next();
                        }
                        return n2;
                    }

                    public boolean isEmpty() {
                        return !this.iterator().hasNext();
                    }

                    public boolean remove(Object object) {
                        if (!(object instanceof Map.Entry)) {
                            return false;
                        }
                        Map.Entry entry = (Map.Entry)object;
                        K k2 = entry.getKey();
                        if (!SubMap.access$1200(this.this$1, k2)) {
                            return false;
                        }
                        V v2 = entry.getValue();
                        if (v2 != null) {
                            Object object2 = SubMap.access$600(this.this$1).get(k2);
                            if (v2.equals(object2)) {
                                SubMap.access$600(this.this$1).remove(k2);
                                return true;
                            }
                        } else if (SubMap.access$600(this.this$1).containsKey(k2) && SubMap.access$600(this.this$1).get(k2) == null) {
                            SubMap.access$600(this.this$1).remove(k2);
                            return true;
                        }
                        return false;
                    }

                    public boolean contains(Object object) {
                        Map.Entry entry = (Map.Entry)object;
                        if (!SubMap.access$1200(this.this$1, entry.getKey())) {
                            return false;
                        }
                        if (entry.getValue() != null) {
                            return entry.getValue().equals(SubMap.access$600(this.this$1).get(entry.getKey()));
                        }
                        return SubMap.access$600(this.this$1).containsKey(entry.getKey()) && SubMap.access$600(this.this$1).get(entry.getKey()) == null;
                    }
                };
            }
            return this.entrySet;
        }

        public SortedMap subMap(Object object, Object object2) {
            if (!this.inRange2(object)) {
                throw new IllegalArgumentException("'from' out of range");
            }
            if (!this.inRange2(object2)) {
                throw new IllegalArgumentException("'to' out of range");
            }
            return new SubMap(object, object2);
        }

        public SortedMap headMap(Object object) {
            if (!this.inRange2(object)) {
                throw new IllegalArgumentException("'to' out of range");
            }
            return new SubMap(this.from, object);
        }

        public SortedMap tailMap(Object object) {
            if (!this.inRange2(object)) {
                throw new IllegalArgumentException("'from' out of range");
            }
            return new SubMap(object, this.to);
        }

        private boolean inRange(Object object) {
            Comparable comparable = (Comparable)object;
            return !(this.from != null && comparable.compareTo(this.from) < 0 || this.to != null && comparable.compareTo(this.to) >= 0);
        }

        private boolean inRange2(Object object) {
            Comparable comparable = (Comparable)object;
            return !(this.from != null && comparable.compareTo(this.from) < 0 || this.to != null && comparable.compareTo(this.to) > 0);
        }

        static /* synthetic */ Object access$500(SubMap subMap) {
            return subMap.to;
        }

        static /* synthetic */ PersistentMapImpl access$600(SubMap subMap) {
            return subMap.PersistentMapImpl.this;
        }

        static /* synthetic */ Object access$900(SubMap subMap) {
            return subMap.from;
        }

        static /* synthetic */ boolean access$1200(SubMap subMap, Object object) {
            return subMap.inRange(object);
        }
    }
}

