/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.gs.digester.plugins.strategies;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.gs.digester.Digester;
import org.apache.commons.gs.digester.plugins.PluginException;
import org.apache.commons.gs.digester.plugins.RuleFinder;
import org.apache.commons.gs.digester.plugins.RuleLoader;
import org.apache.commons.gs.digester.plugins.strategies.LoaderFromStream;

public class FinderFromResource
extends RuleFinder {
    public static String DFLT_RESOURCE_ATTR = "resource";
    private String resourceAttr;

    public FinderFromResource() {
        this(DFLT_RESOURCE_ATTR);
    }

    public FinderFromResource(String string) {
        this.resourceAttr = string;
    }

    public RuleLoader findLoader(Digester digester, Class clazz, Properties properties) throws PluginException {
        String string = properties.getProperty(this.resourceAttr);
        if (string == null) {
            return null;
        }
        InputStream inputStream = clazz.getClassLoader().getResourceAsStream(string);
        if (inputStream == null) {
            throw new PluginException("Resource " + string + " not found.");
        }
        return FinderFromResource.loadRules(digester, clazz, inputStream, string);
    }

    public static RuleLoader loadRules(Digester digester, Class clazz, InputStream inputStream, String string) throws PluginException {
        try {
            LoaderFromStream loaderFromStream;
            LoaderFromStream loaderFromStream2 = loaderFromStream = new LoaderFromStream(inputStream);
            return loaderFromStream2;
        }
        catch (Exception exception) {
            throw new PluginException("Unable to load xmlrules from resource [" + string + "]", exception);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                throw new PluginException("Unable to close stream for resource [" + string + "]", iOException);
            }
        }
    }
}

