/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.gs.beanutils.converters;

import org.apache.commons.gs.beanutils.ConversionException;
import org.apache.commons.gs.beanutils.Converter;

public final class LongConverter
implements Converter {
    private Object defaultValue = null;
    private boolean useDefault = true;

    public LongConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public LongConverter(Object object) {
        this.defaultValue = object;
        this.useDefault = true;
    }

    public Object convert(Class clazz, Object object) {
        if (object == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (object instanceof Long) {
            return object;
        }
        if (object instanceof Number) {
            return new Long(((Number)object).longValue());
        }
        try {
            return new Long(object.toString());
        }
        catch (Exception exception) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(exception);
        }
    }
}

