/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.gs.beanutils;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.gs.beans.BeanInfo;
import org.apache.commons.gs.beans.IndexedPropertyDescriptor;
import org.apache.commons.gs.beans.IntrospectionException;
import org.apache.commons.gs.beans.Introspector;
import org.apache.commons.gs.beans.PropertyDescriptor;
import org.apache.commons.gs.beanutils.BeanUtilsBean;
import org.apache.commons.gs.beanutils.DynaBean;
import org.apache.commons.gs.beanutils.DynaProperty;
import org.apache.commons.gs.beanutils.MappedPropertyDescriptor;
import org.apache.commons.gs.beanutils.MethodUtils;
import org.apache.commons.gs.beanutils.NestedNullException;
import org.apache.commons.gs.beanutils.PropertyUtils;
import org.apache.commons.gs.collections.FastHashMap;

public class PropertyUtilsBean {
    private FastHashMap descriptorsCache = null;
    private FastHashMap mappedDescriptorsCache = null;
    private Logger log;
    static /* synthetic */ Class class$org$apache$commons$gs$beanutils$PropertyUtils;

    public static PropertyUtilsBean getInstance() {
        return BeanUtilsBean.getInstance().getPropertyUtils();
    }

    public PropertyUtilsBean() {
        Class<?> clazz = class$org$apache$commons$gs$beanutils$PropertyUtils;
        if (clazz == null) {
            clazz = class$org$apache$commons$gs$beanutils$PropertyUtils = new PropertyUtils[0].getClass().getComponentType();
        }
        this.log = Logger.getLogger(clazz.getName());
        this.descriptorsCache = new FastHashMap();
        this.descriptorsCache.setFast(true);
        this.mappedDescriptorsCache = new FastHashMap();
        this.mappedDescriptorsCache.setFast(true);
    }

    public void clearDescriptors() {
        this.descriptorsCache.clear();
        this.mappedDescriptorsCache.clear();
        Introspector.flushCaches();
    }

    public void copyProperties(Object object, Object object2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (object == null) {
            throw new IllegalArgumentException("No destination bean specified");
        }
        if (object2 == null) {
            throw new IllegalArgumentException("No origin bean specified");
        }
        if (object2 instanceof DynaBean) {
            DynaProperty[] dynaPropertyArray = ((DynaBean)object2).getDynaClass().getDynaProperties();
            for (int i2 = 0; i2 < dynaPropertyArray.length; ++i2) {
                Object object3;
                String string = dynaPropertyArray[i2].getName();
                if (object instanceof DynaBean) {
                    if (!this.isWriteable(object, string)) continue;
                    object3 = ((DynaBean)object2).get(string);
                    ((DynaBean)object).set(string, object3);
                    continue;
                }
                if (!this.isWriteable(object, string)) continue;
                object3 = ((DynaBean)object2).get(string);
                this.setSimpleProperty(object, string, object3);
            }
        } else if (object2 instanceof Map) {
            Iterator iterator = ((Map)object2).keySet().iterator();
            while (iterator.hasNext()) {
                Object v2;
                String string = (String)iterator.next();
                if (object instanceof DynaBean) {
                    if (!this.isWriteable(object, string)) continue;
                    v2 = ((Map)object2).get(string);
                    ((DynaBean)object).set(string, v2);
                    continue;
                }
                if (!this.isWriteable(object, string)) continue;
                v2 = ((Map)object2).get(string);
                this.setSimpleProperty(object, string, v2);
            }
        } else {
            PropertyDescriptor[] propertyDescriptorArray = this.getPropertyDescriptors(object2);
            for (int i3 = 0; i3 < propertyDescriptorArray.length; ++i3) {
                Object object4;
                String string = propertyDescriptorArray[i3].getName();
                if (!this.isReadable(object2, string)) continue;
                if (object instanceof DynaBean) {
                    if (!this.isWriteable(object, string)) continue;
                    object4 = this.getSimpleProperty(object2, string);
                    ((DynaBean)object).set(string, object4);
                    continue;
                }
                if (!this.isWriteable(object, string)) continue;
                object4 = this.getSimpleProperty(object2, string);
                this.setSimpleProperty(object, string, object4);
            }
        }
    }

    public Map describe(Object object) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (object == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (object instanceof DynaBean) {
            DynaProperty[] dynaPropertyArray = ((DynaBean)object).getDynaClass().getDynaProperties();
            for (int i2 = 0; i2 < dynaPropertyArray.length; ++i2) {
                String string = dynaPropertyArray[i2].getName();
                hashMap.put(string, this.getProperty(object, string));
            }
        } else {
            PropertyDescriptor[] propertyDescriptorArray = this.getPropertyDescriptors(object);
            for (int i3 = 0; i3 < propertyDescriptorArray.length; ++i3) {
                String string = propertyDescriptorArray[i3].getName();
                if (propertyDescriptorArray[i3].getReadMethod() == null) continue;
                hashMap.put(string, this.getProperty(object, string));
            }
        }
        return hashMap;
    }

    public Object getIndexedProperty(Object object, String string) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (object == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (string == null) {
            throw new IllegalArgumentException("No name specified");
        }
        int n2 = string.indexOf(91);
        int n3 = string.indexOf(93);
        if (n2 < 0 || n3 <= n2) {
            throw new IllegalArgumentException("Invalid indexed property '" + string + "'");
        }
        int n4 = -1;
        try {
            String string2 = string.substring(n2 + 1, n3);
            n4 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid indexed property '" + string + "'");
        }
        string = string.substring(0, n2);
        return this.getIndexedProperty(object, string, n4);
    }

    public Object getIndexedProperty(Object object, String string, int n2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method method;
        if (object == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (string == null) {
            throw new IllegalArgumentException("No name specified");
        }
        if (object instanceof DynaBean) {
            DynaProperty dynaProperty = ((DynaBean)object).getDynaClass().getDynaProperty(string);
            if (dynaProperty == null) {
                throw new NoSuchMethodException("Unknown property '" + string + "'");
            }
            return ((DynaBean)object).get(string, n2);
        }
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(object, string);
        if (propertyDescriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + string + "'");
        }
        if (propertyDescriptor instanceof IndexedPropertyDescriptor && (method = ((IndexedPropertyDescriptor)propertyDescriptor).getIndexedReadMethod()) != null) {
            Object[] objectArray = new Object[]{new Integer(n2)};
            try {
                return this.invokeMethod(method, object, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getTargetException() instanceof ArrayIndexOutOfBoundsException) {
                    throw (ArrayIndexOutOfBoundsException)invocationTargetException.getTargetException();
                }
                throw invocationTargetException;
            }
        }
        method = this.getReadMethod(propertyDescriptor);
        if (method == null) {
            throw new NoSuchMethodException("Property '" + string + "' has no getter method");
        }
        Object object2 = this.invokeMethod(method, object, new Object[0]);
        if (!object2.getClass().isArray()) {
            if (!(object2 instanceof List)) {
                throw new IllegalArgumentException("Property '" + string + "' is not indexed");
            }
            return ((List)object2).get(n2);
        }
        return Array.get(object2, n2);
    }

    public Object getMappedProperty(Object object, String string) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (object == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (string == null) {
            throw new IllegalArgumentException("No name specified");
        }
        int n2 = string.indexOf(40);
        int n3 = string.indexOf(41);
        if (n2 < 0 || n3 <= n2) {
            throw new IllegalArgumentException("Invalid mapped property '" + string + "'");
        }
        String string2 = string.substring(n2 + 1, n3);
        string = string.substring(0, n2);
        return this.getMappedProperty(object, string, string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getMappedProperty(Object object, String string, String string2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (object == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (string == null) {
            throw new IllegalArgumentException("No name specified");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("No key specified");
        }
        if (object instanceof DynaBean) {
            DynaProperty dynaProperty = ((DynaBean)object).getDynaClass().getDynaProperty(string);
            if (dynaProperty != null) return ((DynaBean)object).get(string, string2);
            throw new NoSuchMethodException("Unknown property '" + string + "'");
        }
        Object object2 = null;
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(object, string);
        if (propertyDescriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + string + "'");
        }
        if (propertyDescriptor instanceof MappedPropertyDescriptor) {
            Method method = ((MappedPropertyDescriptor)propertyDescriptor).getMappedReadMethod();
            if (method == null) throw new NoSuchMethodException("Property '" + string + "' has no mapped getter method");
            Object[] objectArray = new Object[]{string2};
            return this.invokeMethod(method, object, objectArray);
        }
        Method method = propertyDescriptor.getReadMethod();
        if (method == null) throw new NoSuchMethodException("Property '" + string + "' has no mapped getter method");
        Object object3 = this.invokeMethod(method, object, new Object[0]);
        if (!(object3 instanceof Map)) return object2;
        return ((Map)object3).get(string2);
    }

    public FastHashMap getMappedPropertyDescriptors(Class clazz) {
        if (clazz == null) {
            return null;
        }
        return (FastHashMap)this.mappedDescriptorsCache.get(clazz);
    }

    public FastHashMap getMappedPropertyDescriptors(Object object) {
        if (object == null) {
            return null;
        }
        return this.getMappedPropertyDescriptors(object.getClass());
    }

    public Object getNestedProperty(Object object, String string) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (object == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (string == null) {
            throw new IllegalArgumentException("No name specified");
        }
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        while (true) {
            n5 = string.indexOf(46);
            n3 = string.indexOf(40);
            n4 = string.indexOf(41);
            n5 = n4 >= 0 && n3 >= 0 && (n5 < 0 || n5 > n3) ? string.indexOf(46, n4) : string.indexOf(46);
            if (n5 < 0) break;
            String string2 = string.substring(0, n5);
            n2 = string2.indexOf(91);
            n3 = string2.indexOf(40);
            if ((object = object instanceof Map ? ((Map)object).get(string2) : (n3 >= 0 ? this.getMappedProperty(object, string2) : (n2 >= 0 ? this.getIndexedProperty(object, string2) : this.getSimpleProperty(object, string2)))) == null) {
                throw new NestedNullException("Null property value for '" + string.substring(0, n5) + "'");
            }
            string = string.substring(n5 + 1);
        }
        n2 = string.indexOf(91);
        n3 = string.indexOf(40);
        object = object instanceof Map ? ((Map)object).get(string) : (n3 >= 0 ? this.getMappedProperty(object, string) : (n2 >= 0 ? this.getIndexedProperty(object, string) : this.getSimpleProperty(object, string)));
        return object;
    }

    public Object getProperty(Object object, String string) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.getNestedProperty(object, string);
    }

    public PropertyDescriptor getPropertyDescriptor(Object object, String string) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        int n2;
        PropertyDescriptor[] propertyDescriptorArray;
        int n3;
        if (object == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (string == null) {
            throw new IllegalArgumentException("No name specified");
        }
        while ((n3 = this.findNextNestedIndex(string)) >= 0) {
            propertyDescriptorArray = string.substring(0, n3);
            n2 = propertyDescriptorArray.indexOf(91);
            int n4 = propertyDescriptorArray.indexOf(40);
            object = n4 >= 0 && (n2 < 0 || n4 < n2) ? this.getMappedProperty(object, (String)propertyDescriptorArray) : (n2 >= 0 ? this.getIndexedProperty(object, (String)propertyDescriptorArray) : this.getSimpleProperty(object, (String)propertyDescriptorArray));
            if (object == null) {
                throw new IllegalArgumentException("Null property value for '" + string.substring(0, n3) + "'");
            }
            string = string.substring(n3 + 1);
        }
        n3 = string.indexOf(91);
        if (n3 >= 0) {
            string = string.substring(0, n3);
        }
        if ((n3 = string.indexOf(40)) >= 0) {
            string = string.substring(0, n3);
        }
        if (object == null || string == null) {
            return null;
        }
        propertyDescriptorArray = this.getPropertyDescriptors(object);
        if (propertyDescriptorArray != null) {
            for (n2 = 0; n2 < propertyDescriptorArray.length; ++n2) {
                if (!string.equals(propertyDescriptorArray[n2].getName())) continue;
                return propertyDescriptorArray[n2];
            }
        }
        PropertyDescriptor propertyDescriptor = null;
        FastHashMap fastHashMap = this.getMappedPropertyDescriptors(object);
        if (fastHashMap == null) {
            fastHashMap = new FastHashMap();
            fastHashMap.setFast(true);
            this.mappedDescriptorsCache.put(object.getClass(), fastHashMap);
        }
        if ((propertyDescriptor = (PropertyDescriptor)fastHashMap.get(string)) == null) {
            try {
                propertyDescriptor = new MappedPropertyDescriptor(string, object.getClass());
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
            if (propertyDescriptor != null) {
                fastHashMap.put(string, propertyDescriptor);
            }
        }
        return propertyDescriptor;
    }

    private int findNextNestedIndex(String string) {
        int n2 = 0;
        int n3 = string.length();
        block5: for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '.': {
                    if (n2 >= 1) continue block5;
                    return i2;
                }
                case '(': 
                case '[': {
                    ++n2;
                    continue block5;
                }
                case ')': 
                case ']': {
                    --n2;
                }
            }
        }
        return -1;
    }

    public PropertyDescriptor[] getPropertyDescriptors(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("No bean class specified");
        }
        PropertyDescriptor[] propertyDescriptorArray = null;
        propertyDescriptorArray = (PropertyDescriptor[])this.descriptorsCache.get(clazz);
        if (propertyDescriptorArray != null) {
            return propertyDescriptorArray;
        }
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException introspectionException) {
            return new PropertyDescriptor[0];
        }
        propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        if (propertyDescriptorArray == null) {
            propertyDescriptorArray = new PropertyDescriptor[]{};
        }
        this.descriptorsCache.put(clazz, propertyDescriptorArray);
        return propertyDescriptorArray;
    }

    public PropertyDescriptor[] getPropertyDescriptors(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        return this.getPropertyDescriptors(object.getClass());
    }

    public Class getPropertyEditorClass(Object object, String string) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (object == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (string == null) {
            throw new IllegalArgumentException("No name specified");
        }
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(object, string);
        if (propertyDescriptor != null) {
            return propertyDescriptor.getPropertyEditorClass();
        }
        return null;
    }

    public Class getPropertyType(Object object, String string) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (object == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (string == null) {
            throw new IllegalArgumentException("No name specified");
        }
        if (object instanceof DynaBean) {
            DynaProperty dynaProperty = ((DynaBean)object).getDynaClass().getDynaProperty(string);
            if (dynaProperty == null) {
                return null;
            }
            Class clazz = dynaProperty.getType();
            if (clazz == null) {
                return null;
            }
            if (clazz.isArray()) {
                return clazz.getComponentType();
            }
            return clazz;
        }
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(object, string);
        if (propertyDescriptor == null) {
            return null;
        }
        if (propertyDescriptor instanceof IndexedPropertyDescriptor) {
            return ((IndexedPropertyDescriptor)propertyDescriptor).getIndexedPropertyType();
        }
        if (propertyDescriptor instanceof MappedPropertyDescriptor) {
            return ((MappedPropertyDescriptor)propertyDescriptor).getMappedPropertyType();
        }
        return propertyDescriptor.getPropertyType();
    }

    public Method getReadMethod(PropertyDescriptor propertyDescriptor) {
        return MethodUtils.getAccessibleMethod(propertyDescriptor.getReadMethod());
    }

    public Object getSimpleProperty(Object object, String string) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (object == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (string == null) {
            throw new IllegalArgumentException("No name specified");
        }
        if (string.indexOf(46) >= 0) {
            throw new IllegalArgumentException("Nested property names are not allowed");
        }
        if (string.indexOf(91) >= 0) {
            throw new IllegalArgumentException("Indexed property names are not allowed");
        }
        if (string.indexOf(40) >= 0) {
            throw new IllegalArgumentException("Mapped property names are not allowed");
        }
        if (object instanceof DynaBean) {
            DynaProperty dynaProperty = ((DynaBean)object).getDynaClass().getDynaProperty(string);
            if (dynaProperty == null) {
                throw new NoSuchMethodException("Unknown property '" + string + "'");
            }
            return ((DynaBean)object).get(string);
        }
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(object, string);
        if (propertyDescriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + string + "'");
        }
        Method method = this.getReadMethod(propertyDescriptor);
        if (method == null) {
            throw new NoSuchMethodException("Property '" + string + "' has no getter method");
        }
        Object object2 = this.invokeMethod(method, object, new Object[0]);
        return object2;
    }

    public Method getWriteMethod(PropertyDescriptor propertyDescriptor) {
        return MethodUtils.getAccessibleMethod(propertyDescriptor.getWriteMethod());
    }

    public boolean isReadable(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (string == null) {
            throw new IllegalArgumentException("No name specified");
        }
        if (object instanceof DynaBean) {
            return ((DynaBean)object).getDynaClass().getDynaProperty(string) != null;
        }
        try {
            PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(object, string);
            if (propertyDescriptor != null) {
                Method method = propertyDescriptor.getReadMethod();
                if (method == null && propertyDescriptor instanceof IndexedPropertyDescriptor) {
                    method = ((IndexedPropertyDescriptor)propertyDescriptor).getIndexedReadMethod();
                }
                return method != null;
            }
            return false;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    public boolean isWriteable(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (string == null) {
            throw new IllegalArgumentException("No name specified");
        }
        if (object instanceof DynaBean) {
            return ((DynaBean)object).getDynaClass().getDynaProperty(string) != null;
        }
        try {
            PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(object, string);
            if (propertyDescriptor != null) {
                Method method = propertyDescriptor.getWriteMethod();
                if (method == null && propertyDescriptor instanceof IndexedPropertyDescriptor) {
                    method = ((IndexedPropertyDescriptor)propertyDescriptor).getIndexedWriteMethod();
                }
                return method != null;
            }
            return false;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    public void setIndexedProperty(Object object, String string, Object object2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (object == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (string == null) {
            throw new IllegalArgumentException("No name specified");
        }
        int n2 = string.indexOf(91);
        int n3 = string.indexOf(93);
        if (n2 < 0 || n3 <= n2) {
            throw new IllegalArgumentException("Invalid indexed property '" + string + "'");
        }
        int n4 = -1;
        try {
            String string2 = string.substring(n2 + 1, n3);
            n4 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid indexed property '" + string + "'");
        }
        string = string.substring(0, n2);
        this.setIndexedProperty(object, string, n4, object2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setIndexedProperty(Object object, String string, int n2, Object object2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method method;
        if (object == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (string == null) {
            throw new IllegalArgumentException("No name specified");
        }
        if (object instanceof DynaBean) {
            DynaProperty dynaProperty = ((DynaBean)object).getDynaClass().getDynaProperty(string);
            if (dynaProperty == null) {
                throw new NoSuchMethodException("Unknown property '" + string + "'");
            }
            ((DynaBean)object).set(string, n2, object2);
            return;
        }
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(object, string);
        if (propertyDescriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + string + "'");
        }
        if (propertyDescriptor instanceof IndexedPropertyDescriptor && (method = ((IndexedPropertyDescriptor)propertyDescriptor).getIndexedWriteMethod()) != null) {
            Object[] objectArray = new Object[]{new Integer(n2), object2};
            try {
                if (this.log.isLoggable(Level.FINEST)) {
                    String string2 = object2 == null ? "<null>" : object2.getClass().getName();
                    this.log.finest("setSimpleProperty: Invoking method " + method + " with index=" + n2 + ", value=" + object2 + " (class " + string2 + ")");
                }
                this.invokeMethod(method, object, objectArray);
                return;
            }
            catch (InvocationTargetException invocationTargetException) {
                if (!(invocationTargetException.getTargetException() instanceof ArrayIndexOutOfBoundsException)) throw invocationTargetException;
                throw (ArrayIndexOutOfBoundsException)invocationTargetException.getTargetException();
            }
        }
        method = propertyDescriptor.getReadMethod();
        if (method == null) {
            throw new NoSuchMethodException("Property '" + string + "' has no getter method");
        }
        Object object3 = this.invokeMethod(method, object, new Object[0]);
        if (!object3.getClass().isArray()) {
            if (!(object3 instanceof List)) throw new IllegalArgumentException("Property '" + string + "' is not indexed");
            ((List)object3).set(n2, object2);
            return;
        } else {
            Array.set(object3, n2, object2);
        }
    }

    public void setMappedProperty(Object object, String string, Object object2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (object == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (string == null) {
            throw new IllegalArgumentException("No name specified");
        }
        int n2 = string.indexOf(40);
        int n3 = string.indexOf(41);
        if (n2 < 0 || n3 <= n2) {
            throw new IllegalArgumentException("Invalid mapped property '" + string + "'");
        }
        String string2 = string.substring(n2 + 1, n3);
        string = string.substring(0, n2);
        this.setMappedProperty(object, string, string2, object2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setMappedProperty(Object object, String string, String string2, Object object2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (object == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (string == null) {
            throw new IllegalArgumentException("No name specified");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("No key specified");
        }
        if (object instanceof DynaBean) {
            DynaProperty dynaProperty = ((DynaBean)object).getDynaClass().getDynaProperty(string);
            if (dynaProperty == null) {
                throw new NoSuchMethodException("Unknown property '" + string + "'");
            }
            ((DynaBean)object).set(string, string2, object2);
            return;
        }
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(object, string);
        if (propertyDescriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + string + "'");
        }
        if (propertyDescriptor instanceof MappedPropertyDescriptor) {
            Method method = ((MappedPropertyDescriptor)propertyDescriptor).getMappedWriteMethod();
            if (method == null) throw new NoSuchMethodException("Property '" + string + "' has no mapped setter method");
            Object[] objectArray = new Object[]{string2, object2};
            if (this.log.isLoggable(Level.FINEST)) {
                String string3 = object2 == null ? "<null>" : object2.getClass().getName();
                this.log.finest("setSimpleProperty: Invoking method " + method + " with key=" + string2 + ", value=" + object2 + " (class " + string3 + ")");
            }
            this.invokeMethod(method, object, objectArray);
            return;
        } else {
            Method method = propertyDescriptor.getReadMethod();
            if (method == null) throw new NoSuchMethodException("Property '" + string + "' has no mapped getter method");
            Object object3 = this.invokeMethod(method, object, new Object[0]);
            if (!(object3 instanceof Map)) return;
            ((Map)object3).put(string2, object2);
        }
    }

    public void setNestedProperty(Object object, String string, Object object2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        int n2;
        if (object == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (string == null) {
            throw new IllegalArgumentException("No name specified");
        }
        int n3 = -1;
        int n4 = -1;
        while ((n2 = string.indexOf(46)) >= 0) {
            String string2 = string.substring(0, n2);
            n3 = string2.indexOf(91);
            n4 = string2.indexOf(40);
            if ((object = object instanceof Map ? ((Map)object).get(string2) : (n4 >= 0 ? this.getMappedProperty(object, string2) : (n3 >= 0 ? this.getIndexedProperty(object, string2) : this.getSimpleProperty(object, string2)))) == null) {
                throw new IllegalArgumentException("Null property value for '" + string.substring(0, n2) + "'");
            }
            string = string.substring(n2 + 1);
        }
        n3 = string.indexOf(91);
        n4 = string.indexOf(40);
        if (object instanceof Map) {
            PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(object, string);
            if (propertyDescriptor == null) {
                ((Map)object).put(string, object2);
            } else {
                this.setSimpleProperty(object, string, object2);
            }
        } else if (n4 >= 0) {
            this.setMappedProperty(object, string, object2);
        } else if (n3 >= 0) {
            this.setIndexedProperty(object, string, object2);
        } else {
            this.setSimpleProperty(object, string, object2);
        }
    }

    public void setProperty(Object object, String string, Object object2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        this.setNestedProperty(object, string, object2);
    }

    public void setSimpleProperty(Object object, String string, Object object2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (object == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (string == null) {
            throw new IllegalArgumentException("No name specified");
        }
        if (string.indexOf(46) >= 0) {
            throw new IllegalArgumentException("Nested property names are not allowed");
        }
        if (string.indexOf(91) >= 0) {
            throw new IllegalArgumentException("Indexed property names are not allowed");
        }
        if (string.indexOf(40) >= 0) {
            throw new IllegalArgumentException("Mapped property names are not allowed");
        }
        if (object instanceof DynaBean) {
            DynaProperty dynaProperty = ((DynaBean)object).getDynaClass().getDynaProperty(string);
            if (dynaProperty == null) {
                throw new NoSuchMethodException("Unknown property '" + string + "'");
            }
            ((DynaBean)object).set(string, object2);
            return;
        }
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(object, string);
        if (propertyDescriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + string + "'");
        }
        Method method = this.getWriteMethod(propertyDescriptor);
        if (method == null) {
            throw new NoSuchMethodException("Property '" + string + "' has no setter method");
        }
        Object[] objectArray = new Object[]{object2};
        if (this.log.isLoggable(Level.FINEST)) {
            String string2 = object2 == null ? "<null>" : object2.getClass().getName();
            this.log.finest("setSimpleProperty: Invoking method " + method + " with value " + object2 + " (class " + string2 + ")");
        }
        this.invokeMethod(method, object, objectArray);
    }

    private Object invokeMethod(Method method, Object object, Object[] objectArray) throws IllegalAccessException, InvocationTargetException {
        try {
            return method.invoke(object, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.log(Level.SEVERE, "Method invocation failed.", illegalArgumentException);
            throw new IllegalArgumentException("Cannot invoke " + method.getDeclaringClass().getName() + "." + method.getName() + " - " + illegalArgumentException.getMessage());
        }
    }
}

