/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.cluster;

import com.borland.jbcl.layout.VerticalFlowLayout;
import com.j_spaces.core.cluster.FailOverPolicy;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.cluster.ClusterMemberInfo;
import com.j_spaces.tools.cluster.CreateGroups;
import com.j_spaces.tools.cluster.GroupFailOverPanel;
import com.j_spaces.tools.cluster.GroupInfo;
import com.j_spaces.tools.cluster.GroupLBPanel;
import com.j_spaces.tools.cluster.GroupReplicationPanel;
import com.j_spaces.tools.cluster.ListItemAlreadyExistsException;
import com.j_spaces.tools.cluster.ResourcesInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class NewGroup
extends JDialog {
    private GroupReplicationPanel m_replicationPanel;
    private GroupLBPanel m_loadBalancingPanel;
    private GroupFailOverPanel m_failOverPanel;
    private CreateGroups m_createGroupDialog;
    public JButton butCancel;
    public JButton butCreate;
    public JButton butReset;
    public JButton butAddMember;
    public JButton butRemoveMember;
    public JTextField txtfGroupName;
    public JLabel labGroupName;
    public JLabel labGroupMembers;
    public JLabel labClusterMembers;
    public DefaultListModel listModelClusterMembers;
    public DefaultListModel listModelGroupMembers;
    public JList listClusterMembers;
    public JList listGroupMembers;
    public JTabbedPane tabbedPane;
    public JCheckBox chboxReplication;
    public JCheckBox chboxLoadBalancing;
    public JCheckBox chboxFailOver;
    private String clusterName;
    private static Logger _logger = Logger.getLogger("com.gigaspaces.ui.cluster.view");

    public NewGroup(CreateGroups createGroups) {
        block2: {
            super((Dialog)createGroups.m_createMemDialog.m_newCluster, true);
            this.butCancel = new JButton();
            this.butCreate = new JButton();
            this.butReset = new JButton();
            this.butAddMember = new JButton();
            this.butRemoveMember = new JButton();
            this.txtfGroupName = new JTextField();
            this.labGroupName = new JLabel();
            this.labGroupMembers = new JLabel();
            this.labClusterMembers = new JLabel();
            this.listModelClusterMembers = new DefaultListModel();
            this.listModelGroupMembers = new DefaultListModel();
            this.listClusterMembers = new JList(this.listModelClusterMembers);
            this.listGroupMembers = new JList(this.listModelGroupMembers);
            this.tabbedPane = new JTabbedPane();
            this.chboxReplication = new JCheckBox();
            this.chboxLoadBalancing = new JCheckBox();
            this.chboxFailOver = new JCheckBox();
            this.m_createGroupDialog = createGroups;
            try {
                this.jbInit();
                this.setListeners();
            }
            catch (Exception exception) {
                if (!_logger.isLoggable(Level.SEVERE)) break block2;
                _logger.log(Level.SEVERE, exception.toString(), exception);
            }
        }
    }

    private void jbInit() {
        this.setTitle("Create New Cluster Group");
        this.butCancel.setText("Cancel");
        this.butCreate.setText("Create");
        this.butReset.setText("Reset");
        this.m_replicationPanel = new GroupReplicationPanel(null, null, this);
        this.m_loadBalancingPanel = new GroupLBPanel(false);
        this.m_failOverPanel = new GroupFailOverPanel();
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/image/cluster-wizard/rigth_pointer.gif"));
        ImageIcon imageIcon2 = new ImageIcon(this.getClass().getResource("/image/cluster-wizard/left_pointer.gif"));
        this.butAddMember.setIcon(imageIcon);
        this.butRemoveMember.setIcon(imageIcon2);
        this.formatArrowButton(this.butAddMember);
        this.formatArrowButton(this.butRemoveMember);
        this.chboxReplication.setText("Replication");
        this.chboxLoadBalancing.setText("LoadBalancing");
        this.chboxFailOver.setText("Fail Over");
        this.chboxReplication.setRequestFocusEnabled(false);
        this.chboxLoadBalancing.setRequestFocusEnabled(false);
        this.chboxLoadBalancing.setHorizontalAlignment(0);
        this.chboxFailOver.setRequestFocusEnabled(false);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.chboxReplication, "West");
        jPanel.add((Component)this.chboxLoadBalancing, "Center");
        jPanel.add((Component)this.chboxFailOver, "East");
        JPanel jPanel2 = new JPanel(new VerticalFlowLayout());
        jPanel2.add(this.butAddMember);
        jPanel2.add(this.butRemoveMember);
        Dimension dimension = new Dimension(170, 130);
        this.listGroupMembers.setVisibleRowCount(6);
        this.listClusterMembers.setVisibleRowCount(6);
        JScrollPane jScrollPane = new JScrollPane(this.listGroupMembers);
        jScrollPane.setPreferredSize(dimension);
        JScrollPane jScrollPane2 = new JScrollPane(this.listClusterMembers);
        jScrollPane2.setPreferredSize(dimension);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.add((Component)this.labClusterMembers, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        jPanel3.add((Component)jScrollPane2, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        jPanel3.add((Component)jPanel2, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        jPanel3.add((Component)this.labGroupMembers, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        jPanel3.add((Component)jScrollPane, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.tabbedPane.add((Component)this.m_replicationPanel, "Replication");
        this.tabbedPane.add((Component)this.m_loadBalancingPanel, "LoadBalancing");
        this.tabbedPane.add((Component)this.m_failOverPanel, "Fail Over");
        String[] stringArray = ResourcesInfo.newGroup.getLabels();
        this.labGroupName.setText(stringArray[0] + " ");
        this.labClusterMembers.setText(stringArray[3]);
        this.labGroupMembers.setText(stringArray[4]);
        jPanel.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createLineBorder(new Color(153, 153, 153), 1), stringArray[1]), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        jPanel3.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createLineBorder(new Color(153, 153, 153), 1), stringArray[2]), BorderFactory.createEmptyBorder(0, 3, 3, 3)));
        String[] stringArray2 = ResourcesInfo.newGroup.getToolTips();
        this.txtfGroupName.setToolTipText(stringArray2[0]);
        jPanel.setToolTipText(stringArray2[1]);
        this.chboxReplication.setToolTipText(stringArray2[2]);
        this.chboxLoadBalancing.setToolTipText(stringArray2[3]);
        this.chboxFailOver.setToolTipText(stringArray2[4]);
        this.listClusterMembers.setToolTipText(stringArray2[5]);
        this.listGroupMembers.setToolTipText(stringArray2[6]);
        JPanel jPanel4 = (JPanel)this.getContentPane();
        jPanel4.setLayout(new GridBagLayout());
        jPanel4.add((Component)this.labGroupName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 4, 2, 2), 0, 0));
        jPanel4.add((Component)this.txtfGroupName, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        jPanel4.add((Component)jPanel, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel4.add((Component)jPanel3, new GridBagConstraints(0, 2, 3, 1, 1.0, 2.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel4.add((Component)this.tabbedPane, new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel4.add((Component)this.butReset, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 2, 2, 2), 0, 0));
        jPanel4.add((Component)this.butCreate, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 13, 0, new Insets(3, 2, 2, 2), 0, 0));
        jPanel4.add((Component)this.butCancel, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 2, 2, 2), 0, 0));
        this.setSize(470, 620);
    }

    private void formatArrowButton(JButton jButton) {
        jButton.setFocusPainted(false);
        jButton.setBorderPainted(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
    }

    private void setListeners() {
        this.butReset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JOptionPane.showConfirmDialog(NewGroup.this, "Reset all settings, are you sure?", "Confirm Reset Settings", 0) != 0) {
                    return;
                }
                NewGroup.this.clearDialogBox();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                NewGroup.this.dispose();
            }
        });
        this.chboxReplication.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewGroup.this.setEnabledReplicationPanel();
            }
        });
        this.chboxLoadBalancing.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewGroup.this.setEnabledLoadBalancingPanel();
            }
        });
        this.chboxFailOver.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewGroup.this.setEnabledFailOverPanel();
            }
        });
        this.butCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewGroup.this.dispose();
            }
        });
        this.butCreate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewGroup.this.createNewGroup(!actionEvent.getActionCommand().equals("Create"));
            }
        });
        this.butAddMember.addActionListener(new ListAddRemoveActionListener(this.listClusterMembers, this.listGroupMembers, false, 1));
        this.butRemoveMember.addActionListener(new ListAddRemoveActionListener(this.listGroupMembers, this.listClusterMembers, false, 2));
        this.txtfGroupName.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (NewGroup.this.txtfGroupName.getText().trim().length() == 0) {
                    NewGroup.this.butCreate.setEnabled(false);
                } else {
                    NewGroup.this.butCreate.setEnabled(true);
                }
            }
        });
    }

    public static int getEnabledTabIndex(JTabbedPane jTabbedPane) {
        int n2 = -1;
        for (int i2 = 0; i2 < jTabbedPane.getTabCount(); ++i2) {
            if (!jTabbedPane.isEnabledAt(i2)) continue;
            n2 = i2;
            break;
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setEnabledReplicationPanel() {
        if (!this.chboxReplication.isSelected()) {
            this.tabbedPane.setEnabledAt(0, this.chboxReplication.isSelected());
            if (this.tabbedPane.getSelectedIndex() != 0) return;
            int n2 = NewGroup.getEnabledTabIndex(this.tabbedPane);
            if (n2 != -1) {
                this.tabbedPane.setSelectedIndex(n2);
            }
        } else {
            this.tabbedPane.setSelectedIndex(0);
            this.tabbedPane.setEnabledAt(0, this.chboxReplication.isSelected());
        }
        JSpaceUtilities.setAWTComponentsStatus(this.m_replicationPanel, this.chboxReplication.isSelected());
        this.m_replicationPanel.updateDataForRepMatrix(this.listModelGroupMembers, this.chboxReplication.isSelected());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setEnabledLoadBalancingPanel() {
        if (!this.chboxLoadBalancing.isSelected()) {
            this.tabbedPane.setEnabledAt(1, this.chboxLoadBalancing.isSelected());
            if (this.tabbedPane.getSelectedIndex() != 1) return;
            int n2 = NewGroup.getEnabledTabIndex(this.tabbedPane);
            if (n2 != -1) {
                this.tabbedPane.setSelectedIndex(n2);
            }
        } else {
            this.tabbedPane.setSelectedIndex(1);
            this.tabbedPane.setEnabledAt(1, this.chboxLoadBalancing.isSelected());
        }
        this.m_loadBalancingPanel.setEnableComponentsStatus(this.chboxLoadBalancing.isSelected());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setEnabledFailOverPanel() {
        if (!this.chboxFailOver.isSelected()) {
            this.tabbedPane.setEnabledAt(2, this.chboxFailOver.isSelected());
            if (this.tabbedPane.getSelectedIndex() != 2) return;
            int n2 = NewGroup.getEnabledTabIndex(this.tabbedPane);
            if (n2 != -1) {
                this.tabbedPane.setSelectedIndex(n2);
            }
        } else {
            this.tabbedPane.setSelectedIndex(2);
            this.tabbedPane.setEnabledAt(2, this.chboxFailOver.isSelected());
        }
        this.m_failOverPanel.setEnableComponentsStatus(this.chboxFailOver.isSelected());
    }

    private void createNewGroup(boolean bl2) {
        ClusterMemberInfo[] clusterMemberInfoArray;
        GroupInfo groupInfo;
        block17: {
            Object object;
            GroupInfo.ReplicationInfo replicationInfo = null;
            GroupInfo.LoadBalancingInfo loadBalancingInfo = null;
            FailOverPolicy failOverPolicy = null;
            String string = null;
            string = this.txtfGroupName.getText().trim();
            if (!(this.chboxReplication.isSelected() || this.chboxLoadBalancing.isSelected() || this.chboxFailOver.isSelected())) {
                JOptionPane.showConfirmDialog(this, "You should select at least one of cluster options.", "Missing cluster options", -1, 2, ResourcesInfo.WARNING_ICON);
                return;
            }
            if (this.listModelGroupMembers.getSize() <= 1) {
                JOptionPane.showConfirmDialog(this, "Add to group members at lease 2 members.", "Warning", -1, 2, ResourcesInfo.WARNING_ICON);
                return;
            }
            if (!this.chboxFailOver.isSelected()) {
                int n2 = this.m_createGroupDialog.getGroupModel().size();
                Object[] objectArray = new GroupInfo[n2];
                this.m_createGroupDialog.getGroupModel().copyInto(objectArray);
                object = this.getAvailableAlternateGroups();
                for (int i2 = 0; i2 < ((Object[])object).length; ++i2) {
                    if (((GroupInfo)objectArray[i2]).failOverInfo == null || ((GroupInfo)objectArray[i2]).failOverInfo.alterGroup == null || !this.contains(this.txtfGroupName.getText().trim(), ((GroupInfo)objectArray[i2]).failOverInfo.alterGroup)) continue;
                    JOptionPane.showMessageDialog(this, "Can not remove FailOver policy.This group defined as alternate in " + ((GroupInfo)objectArray[i2]).groupName + " group.", "Information", 1);
                    return;
                }
            }
            if (!bl2) {
                try {
                    this.m_createGroupDialog.isGroupExists(string);
                }
                catch (ListItemAlreadyExistsException listItemAlreadyExistsException) {
                    JOptionPane.showConfirmDialog(this, listItemAlreadyExistsException.getMessage(), "Already exists", -1, 2, ResourcesInfo.WARNING_ICON);
                    return;
                }
            }
            this.dispose();
            if (this.chboxReplication.isSelected()) {
                replicationInfo = (GroupInfo.ReplicationInfo)this.m_replicationPanel.saveSettings();
            }
            if (this.chboxLoadBalancing.isSelected()) {
                loadBalancingInfo = (GroupInfo.LoadBalancingInfo)this.m_loadBalancingPanel.saveSettings();
            }
            if (this.chboxFailOver.isSelected()) {
                failOverPolicy = (FailOverPolicy)this.m_failOverPanel.saveSettings();
            }
            groupInfo = new GroupInfo(replicationInfo, loadBalancingInfo, failOverPolicy, string, this.clusterName);
            int n3 = this.listModelGroupMembers.getSize();
            object = null;
            clusterMemberInfoArray = new ClusterMemberInfo[n3];
            boolean bl3 = false;
            try {
                for (int i3 = 0; i3 < n3; ++i3) {
                    object = (ClusterMemberInfo)this.listModelGroupMembers.getElementAt(i3);
                    if (replicationInfo == null || replicationInfo != null && !replicationInfo.m_TransmissionMatrix) {
                        ((ClusterMemberInfo)object).m_replTransmissionPolicies = null;
                        ((ClusterMemberInfo)object).m_replFilters = null;
                        ((ClusterMemberInfo)object).m_replRecovery = null;
                    } else if (((ClusterMemberInfo)object).m_replTransmissionPolicies != null || ((ClusterMemberInfo)object).m_replFilters != null || ((ClusterMemberInfo)object).m_replRecovery != null) {
                        bl3 = true;
                    }
                    clusterMemberInfoArray[i3] = (ClusterMemberInfo)((ClusterMemberInfo)object).clone();
                }
                if (replicationInfo != null) {
                    groupInfo.repInfo.m_TransmissionMatrix = bl3;
                }
            }
            catch (Exception exception) {
                if (!_logger.isLoggable(Level.SEVERE)) break block17;
                _logger.log(Level.SEVERE, exception.toString(), exception);
            }
        }
        groupInfo.groupMembers = clusterMemberInfoArray;
        this.m_createGroupDialog.setGroupInfo(groupInfo, bl2);
    }

    private void clearDialogBox() {
        this.setTitle("Create New Cluster Group");
        this.txtfGroupName.setText("");
        this.txtfGroupName.setEditable(true);
        this.butCreate.setEnabled(false);
        this.butCreate.setText("Create");
        this.chboxReplication.setSelected(false);
        this.chboxLoadBalancing.setSelected(false);
        this.chboxFailOver.setSelected(false);
        this.m_replicationPanel.reset();
        this.m_loadBalancingPanel.reset();
        this.m_failOverPanel.reset();
        this.tabbedPane.setSelectedIndex(0);
        this.tabbedPane.setEnabledAt(1, false);
        this.tabbedPane.setEnabledAt(2, false);
        this.setEnabledReplicationPanel();
        this.listModelGroupMembers.clear();
        this.listModelClusterMembers.clear();
        DefaultListModel defaultListModel = this.m_createGroupDialog.m_createMemDialog.getMemberListModel();
        for (int i2 = 0; i2 < defaultListModel.size(); ++i2) {
            ClusterMemberInfo clusterMemberInfo = (ClusterMemberInfo)defaultListModel.get(i2);
            this.listModelClusterMembers.addElement(clusterMemberInfo);
            this.m_loadBalancingPanel.setParamDialogs(clusterMemberInfo.memberName);
        }
        this.m_failOverPanel.init(null, this.getAvailableAlternateGroups());
    }

    public void showEditData(GroupInfo groupInfo, boolean bl2) {
        int n2;
        this.clearDialogBox();
        this.m_replicationPanel.updateDataForRepMatrix(groupInfo.groupMembers, groupInfo.repInfo != null);
        if (bl2) {
            this.setTitle("Edit Cluster Group");
            this.butCreate.setText("Update");
            this.txtfGroupName.setEditable(false);
            this.txtfGroupName.setText(groupInfo.groupName);
            this.butCreate.setEnabled(true);
            if (groupInfo.repInfo != null) {
                this.chboxReplication.setSelected(true);
                this.setEnabledReplicationPanel();
                this.m_replicationPanel.restoreSettings(groupInfo.repInfo);
            }
            if (groupInfo.loadBalInfo != null) {
                this.chboxLoadBalancing.setSelected(true);
                this.setEnabledLoadBalancingPanel();
                this.m_loadBalancingPanel.restoreSettings(groupInfo.loadBalInfo);
            }
            this.m_failOverPanel.init(groupInfo, this.getAvailableAlternateGroups());
            if (groupInfo.failOverInfo != null) {
                this.chboxFailOver.setSelected(true);
                this.setEnabledFailOverPanel();
                this.m_failOverPanel.restoreSettings(groupInfo.failOverInfo);
            }
        }
        for (n2 = 0; n2 < groupInfo.groupMembers.length; ++n2) {
            ClusterMemberInfo clusterMemberInfo = groupInfo.groupMembers[n2];
            if (!this.listModelClusterMembers.contains(clusterMemberInfo)) {
                if (groupInfo.repInfo == null) continue;
                groupInfo.repInfo.m_TransmissionMatrix = false;
                continue;
            }
            this.listModelClusterMembers.removeElement(clusterMemberInfo);
            this.listModelGroupMembers.addElement(clusterMemberInfo);
        }
        n2 = NewGroup.getEnabledTabIndex(this.tabbedPane);
        if (n2 != -1) {
            this.tabbedPane.setSelectedIndex(n2);
        }
        JSpaceUtilities.setLocationRelativeTo(this, this.m_createGroupDialog);
        this.setVisible(true);
    }

    public Object[] getAvailableAlternateGroups() {
        Vector<String> vector = new Vector<String>();
        int n2 = this.m_createGroupDialog.getGroupModel().size();
        Object[] objectArray = new GroupInfo[n2];
        this.m_createGroupDialog.getGroupModel().copyInto(objectArray);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (((GroupInfo)objectArray[i2]).failOverInfo == null) continue;
            vector.addElement(((GroupInfo)objectArray[i2]).toString());
        }
        return vector.toArray();
    }

    private boolean contains(Object object, Object[] objectArray) {
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (!objectArray[i2].toString().equals(object)) continue;
            return true;
        }
        return false;
    }

    public void showDialog(String string) {
        this.clusterName = string;
        this.clearDialogBox();
        JSpaceUtilities.setLocationRelativeTo(this, this.m_createGroupDialog);
        this.show();
    }

    public class ListAddRemoveActionListener
    extends MouseAdapter
    implements ActionListener {
        public static final byte ACTION_MOVE_RIGHT = 1;
        public static final byte ACTION_MOVE_LEFT = 2;
        public JList removeList;
        public JList addList;
        public DefaultListModel removeModel;
        public DefaultListModel addModel;
        public boolean toStringConvert;
        public byte actionType;

        public ListAddRemoveActionListener(JList jList, JList jList2, boolean bl2, byte by2) {
            this.removeList = jList;
            this.addList = jList2;
            this.addModel = (DefaultListModel)jList2.getModel();
            this.removeModel = (DefaultListModel)jList.getModel();
            this.toStringConvert = bl2;
            this.actionType = by2;
            jList.addMouseListener(this);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                int n2 = this.removeList.locationToIndex(mouseEvent.getPoint());
                if (n2 == -1) {
                    return;
                }
                Object e2 = this.removeModel.remove(n2);
                this.addModel.addElement(this.toStringConvert ? e2.toString() : e2);
                this.updateFailOverUI(e2.toString());
                this.addList.setSelectedIndex(this.addModel.getSize() - 1);
                this.addList.ensureIndexIsVisible(this.addModel.getSize() - 1);
                NewGroup.this.m_replicationPanel.updateDataForRepMatrix(NewGroup.this.listModelGroupMembers, NewGroup.this.chboxReplication.isSelected());
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = this.removeList.getSelectedValues();
            if (objectArray.length <= 0) {
                return;
            }
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                this.removeModel.removeElement(this.toStringConvert ? objectArray[i2].toString() : objectArray[i2]);
                this.addModel.addElement(this.toStringConvert ? objectArray[i2].toString() : objectArray[i2]);
                this.updateFailOverUI(objectArray[i2].toString());
            }
            this.addList.setSelectedIndex(this.addModel.getSize() - 1);
            this.addList.ensureIndexIsVisible(this.addModel.getSize() - 1);
            NewGroup.this.m_replicationPanel.updateDataForRepMatrix(NewGroup.this.listModelGroupMembers, NewGroup.this.chboxReplication.isSelected());
        }

        private void updateFailOverUI(String string) {
            if (this.actionType == 1) {
                NewGroup.this.m_failOverPanel.addGroupMember(string);
            } else if (this.actionType == 2) {
                NewGroup.this.m_failOverPanel.removeGroupMember(string);
            }
        }
    }
}

