/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cluster.dynamic.mapping;

import com.j_spaces.core.cluster.dynamic.mapping.LogicSpace;
import com.j_spaces.core.cluster.dynamic.mapping.PhysicalSpace;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReadWriteLock;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantReadWriteLock;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import net.jini.space.InternalSpaceException;
import net.sf.retrotranslator.runtime.java.lang._Integer;

public class LogicSpaceMap
implements Serializable {
    private final transient ReadWriteLock _mapsLocks = new ReentrantReadWriteLock();
    public final transient ReentrantLock _changeLocks = new ReentrantLock();
    public final LogicSpace[] _logics;
    public final HashMap _physicals;
    public final ConcurrentHashMap _LBproxies;
    private final int _logical;
    private final int _backup;

    public LogicSpaceMap(LogicSpaceMap logicSpaceMap) {
        LogicSpaceMap logicSpaceMap2;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(logicSpaceMap);
            objectOutputStream.flush();
            logicSpaceMap2 = (LogicSpaceMap)new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray())).readObject();
        }
        catch (Exception exception) {
            throw new InternalSpaceException("Fail to clone LogicSpaceMap.", exception);
        }
        this._logical = logicSpaceMap2._logical;
        this._backup = logicSpaceMap2._backup;
        this._logics = logicSpaceMap2._logics;
        this._physicals = logicSpaceMap2._physicals;
        this._LBproxies = logicSpaceMap2._LBproxies;
    }

    public LogicSpaceMap(int n2, int n3, String string) {
        this._backup = n3;
        this._logical = n2;
        this._logics = new LogicSpace[n2];
        this._physicals = new HashMap();
        this._LBproxies = new ConcurrentHashMap();
        PhysicalSpace physicalSpace = new PhysicalSpace(string, n3);
        for (int i2 = 0; i2 < n2; ++i2) {
            LogicSpace logicSpace;
            LinkedList<PhysicalSpace> linkedList = new LinkedList<PhysicalSpace>();
            for (int i3 = 0; i3 < n3; ++i3) {
                physicalSpace.addLogic(_Integer.valueOf(i2), _Integer.valueOf(i3));
                linkedList.add(physicalSpace);
            }
            this._logics[i2] = logicSpace = new LogicSpace(this._LBproxies, _Integer.valueOf(i2), linkedList);
        }
        this._physicals.put(string, physicalSpace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PhysicalSpace getPhysical(int n2, int n3) {
        try {
            this.readLock();
            PhysicalSpace physicalSpace = this._logics[n2].getPhyical(n3);
            return physicalSpace;
        }
        finally {
            this.readUnlock();
        }
    }

    private PhysicalSpace getPhysical(int n2) {
        return this.getPhysical(n2, 0);
    }

    public String getPhysicalName(int n2) {
        return this.getPhysical(n2, 0).getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePhysical(String string) {
        try {
            this.writeLock();
            PhysicalSpace physicalSpace = (PhysicalSpace)this._physicals.remove(string);
            if (physicalSpace == null) {
                return;
            }
            Iterator iterator = physicalSpace.getLogics().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                LogicSpace logicSpace = this._logics[(Integer)entry.getKey()];
                while (logicSpace.removePhyical(physicalSpace)) {
                }
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addPhysical(String string) {
        try {
            this.writeLock();
            if (!this._physicals.containsKey(string)) {
                this._physicals.put(string, new PhysicalSpace(string, this._backup));
                boolean bl2 = true;
                return bl2;
            }
        }
        finally {
            this.writeUnlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean changeMapping(String string, String string2, int n2, int n3) {
        try {
            this.writeLock();
            PhysicalSpace physicalSpace = (PhysicalSpace)this._physicals.get(string);
            LogicSpace logicSpace = this._logics[n2];
            if (!logicSpace.isOwner(string)) {
                boolean bl2 = false;
                return bl2;
            }
            physicalSpace.removeLogic(_Integer.valueOf(n2), _Integer.valueOf(n3));
            PhysicalSpace physicalSpace2 = (PhysicalSpace)this._physicals.get(string2);
            if (physicalSpace2 == null) {
                this.addPhysical(string2);
                physicalSpace2 = (PhysicalSpace)this._physicals.get(string2);
            }
            physicalSpace2.addLogic(_Integer.valueOf(n2), _Integer.valueOf(n3));
            logicSpace.setPhyical(n3, physicalSpace2);
            boolean bl3 = true;
            return bl3;
        }
        finally {
            this.writeUnlock();
        }
    }

    public int logicalSize() {
        return this._logical;
    }

    public int backupSize() {
        return this._backup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int physicalSize() {
        try {
            this._mapsLocks.readLock().lock();
            int n2 = this._physicals.size();
            return n2;
        }
        finally {
            this._mapsLocks.readLock().unlock();
        }
    }

    public Set physicals() {
        return this._physicals.entrySet();
    }

    public ConcurrentHashMap getProxies() {
        return this._LBproxies;
    }

    public void readLock() {
        this._mapsLocks.readLock().lock();
    }

    public void readUnlock() {
        this._mapsLocks.readLock().unlock();
    }

    public void mightWriteLock() {
        this._changeLocks.lock();
    }

    public void mightWriteUnlock() {
        this._changeLocks.unlock();
    }

    public void writeLock() {
        this._mapsLocks.writeLock().lock();
    }

    public void writeUnlock() {
        this._mapsLocks.writeLock().unlock();
    }
}

