/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.converter.pojo;

import com.gigaspaces.converter.ConversionException;
import com.gigaspaces.converter.ConverterTracer;
import com.gigaspaces.converter.pojo.GSBinder;
import com.gigaspaces.converter.pojo.Mappings;
import com.j_spaces.kernel.ResourceLoader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.zip.ZipEntry;

public class Configuration
implements Serializable {
    private GSBinder gsBinder;
    private Map classLoaderMapHolders;
    private Map externalEntryMap;

    public Configuration() {
        this.reset();
    }

    public void reset() {
        this.gsBinder = new GSBinder();
        this.externalEntryMap = new HashMap();
    }

    public Configuration addFile(File file) throws ConversionException {
        if (ConverterTracer.getLogger().isLoggable(Level.FINE)) {
            ConverterTracer.getLogger().log(Level.FINE, "Reading mappings from file:{0} ", file.getPath());
        }
        try {
            this.addInputStream(new FileInputStream(file));
        }
        catch (Exception exception) {
            throw new ConversionException("Could not read mapping document from file: " + file.getPath(), exception);
        }
        return this;
    }

    public Configuration addXML(String string) throws ConversionException {
        if (ConverterTracer.getLogger().isLoggable(Level.FINE)) {
            ConverterTracer.getLogger().log(Level.FINE, "Mapping XML:{0}", string);
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            this.add(byteArrayInputStream);
        }
        catch (Exception exception) {
            throw new ConversionException("Could not parse the mapping document in the XML string", exception);
        }
        return this;
    }

    public Configuration addURL(URL uRL) throws ConversionException {
        if (ConverterTracer.getLogger().isLoggable(Level.FINE)) {
            ConverterTracer.getLogger().log(Level.FINE, "Reading mapping document from URL: {0}", uRL);
        }
        try {
            this.addInputStream(uRL.openStream());
        }
        catch (Exception exception) {
            throw new ConversionException("Could not read the mapping document from the URL: " + uRL, exception);
        }
        return this;
    }

    public Mappings createMappings() {
        return new Mappings(this.getExternalEntryMap());
    }

    public Configuration addResource(String string) throws ConversionException {
        InputStream inputStream;
        if (ConverterTracer.getLogger().isLoggable(Level.FINE)) {
            ConverterTracer.getLogger().log(Level.FINE, "Reading mappings from resource: {0}", string);
        }
        if ((inputStream = ResourceLoader.getResourceStream(string)) == null) {
            throw new ConversionException("Resource: " + string + " not found");
        }
        try {
            return this.addInputStream(inputStream);
        }
        catch (ConversionException conversionException) {
            throw new ConversionException("Could not read the mapping document from resource: " + string, conversionException);
        }
    }

    public Configuration addClass(Class clazz) throws ConversionException {
        return this.addClass(clazz.getName());
    }

    public Configuration addClass(String string) throws ConversionException {
        InputStream inputStream;
        String string2 = "/" + string.replace('.', '/') + ".gs.xml";
        if (ConverterTracer.getLogger().isLoggable(Level.FINE)) {
            ConverterTracer.getLogger().log(Level.FINE, "Reading mappings from resource: {0}", string2);
        }
        if ((inputStream = ResourceLoader.getResourceStream(string2)) == null) {
            throw new ConversionException("Resource: " + string2 + " not found");
        }
        try {
            return this.addInputStream(inputStream);
        }
        catch (ConversionException conversionException) {
            throw new ConversionException("Could not read the mapping documents from resource: " + string2, conversionException);
        }
    }

    public Configuration addInputStream(InputStream inputStream) throws ConversionException {
        try {
            this.add(inputStream);
            Configuration configuration = this;
            return configuration;
        }
        catch (Exception exception) {
            throw new ConversionException("Could not parse the mapping document in input stream", exception);
        }
        finally {
            block9: {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    if (!ConverterTracer.getLogger().isLoggable(Level.WARNING)) break block9;
                    ConverterTracer.getLogger().log(Level.WARNING, "Could not close input stream", iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Configuration addJar(File file) throws ConversionException {
        if (ConverterTracer.getLogger().isLoggable(Level.FINE)) {
            ConverterTracer.getLogger().log(Level.FINE, "Searching for mapping documents in jar: {0}", file.getName());
        }
        JarFile jarFile = null;
        try {
            try {
                jarFile = new JarFile(file);
            }
            catch (IOException iOException) {
                throw new ConversionException("Could not read the mapping documents from jar: " + file.getName(), iOException);
            }
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (!zipEntry.getName().endsWith(".gs.xml")) continue;
                ConverterTracer.getLogger().log(Level.FINE, "Found the mapping document in jar: {0}", zipEntry.getName());
                try {
                    this.addInputStream(jarFile.getInputStream(zipEntry));
                }
                catch (Exception exception) {
                    throw new ConversionException("Could not read the mapping documents from jar: " + file.getName(), exception);
                    return this;
                }
            }
        }
        finally {
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException iOException) {
                ConverterTracer.getLogger().log(Level.WARNING, "could not close jar ", iOException);
            }
        }
    }

    public Configuration addDirectory(File file) throws ConversionException {
        File[] fileArray = file.listFiles();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            if (fileArray[i2].isDirectory()) {
                this.addDirectory(fileArray[i2]);
                continue;
            }
            if (!fileArray[i2].getName().endsWith(".gs.xml")) continue;
            try {
                this.addFile(fileArray[i2]);
                continue;
            }
            catch (Exception exception) {
                if (!ConverterTracer.getLogger().isLoggable(Level.SEVERE)) continue;
                ConverterTracer.getLogger().log(Level.SEVERE, "Failed to parse gs.xml file name " + fileArray[i2], exception);
            }
        }
        return this;
    }

    public void add(InputStream inputStream) throws ConversionException {
        try {
            this.gsBinder.bindRoot(inputStream, this.createMappings());
        }
        catch (Exception exception) {
            if (ConverterTracer.getLogger().isLoggable(Level.SEVERE)) {
                ConverterTracer.getLogger().log(Level.SEVERE, "Failed to parse input stream ", exception);
            }
            throw new ConversionException("Failed to parse input stream", exception);
        }
    }

    public Map getExternalEntryMap() {
        return this.externalEntryMap;
    }

    public Map getClassLoaderMapHolders() {
        return this.classLoaderMapHolders;
    }

    public class MapHolder {
        public boolean a = false;
        public Map b = null;

        public MapHolder(Map map) {
            this.b = map;
        }
    }
}

