/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli.multicast;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MulticastUtilities {
    public static final int TTL_DEFAULT = 1;
    public static final int ACK_EVENT_PORT_DEFAULT = 4161;
    public static final int DESTINATION_PORT_DEFAULT = 4160;
    public static final int EVENT_SIZE_DEFAULT = 100;
    public static final String MULTICAST_ADDRESS_DEFAULT = "224.0.1.85";
    public static final int DEFAULT_BUFFER_SIZE = 64000;
    private static Logger a = Logger.getLogger("com.gigaspaces.admin");

    public static void dumpNetworkInterfaceInfo() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            String string = InetAddress.getLocalHost().getHostName();
            stringBuffer.append("\n---------- [" + string + "] NETWORK INTERFACE INFO -----------");
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                stringBuffer.append("\nNames: " + networkInterface.getName() + " / " + networkInterface.getDisplayName());
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    stringBuffer.append("\n\tAddress: " + inetAddress.getHostAddress());
                }
            }
            stringBuffer.append("\n---------- [" + string + "] NETWORK INTERFACE INFO -----------");
            System.out.println(stringBuffer.toString());
        }
        catch (Exception exception) {
            System.out.println("Failed to dump network interface info.");
            a.log(Level.SEVERE, exception.toString(), exception);
        }
    }
}

