/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli.multicast;

import com.gigaspaces.admin.cli.CLIUtilities;
import com.gigaspaces.admin.cli.Constants;
import com.gigaspaces.admin.cli.Formatter;
import com.gigaspaces.admin.cli.GS;
import com.gigaspaces.admin.cli.OptionHandler;
import com.gigaspaces.admin.cli.multicast.MulticastReceiver;
import com.gigaspaces.admin.cli.multicast.MulticastSender;
import com.j_spaces.cli.CommandException;
import java.io.BufferedReader;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MulticastTest
implements Constants,
GS.OptionHandler {
    private static Logger a = Logger.getLogger("com.gigaspaces.admin");
    private OptionHandler b;
    public static final String OPERATION_NAME = "multicastTest";

    public MulticastTest() {
        OptionHandler optionHandler = new OptionHandler("help,ba,ma,t,p,s,verbose,sender,receiver");
        String[] stringArray = new String[]{"h", "help", "ba", "ma", "t", "verbose", "sender", "receiver"};
        this.b = new OptionHandler(Formatter.fromArray((String[])stringArray));
    }

    public String process(String string, BufferedReader bufferedReader) throws CommandException {
        block18: {
            InetAddress inetAddress = null;
            InetAddress inetAddress2 = null;
            int n2 = 4160;
            boolean bl2 = false;
            try {
                Map map = this.b.getOptions(string);
                if (!map.containsKey("sender") && !map.containsKey("receiver")) {
                    CLIUtilities.printMissingParametersMessage("sender", "receiver");
                    return this.getUsage();
                }
                if (map.containsKey("ba")) {
                    inetAddress2 = InetAddress.getByName((String)map.get("ba"));
                }
                inetAddress = map.containsKey("ma") ? InetAddress.getByName((String)map.get("ma")) : InetAddress.getByName("224.0.1.85");
                if (map.containsKey("port")) {
                    n2 = Integer.parseInt((String)map.get("port"));
                }
                if (map.containsKey("sender")) {
                    System.out.println("Starting Multicast-Sender...");
                    MulticastSender multicastSender = new MulticastSender();
                    multicastSender.setMulticastAddr(inetAddress);
                    if (inetAddress2 != null) {
                        multicastSender.setBindAddr(inetAddress2);
                    }
                    if (map.containsKey("port")) {
                        multicastSender.setDestinationPort(n2);
                    }
                    if (map.containsKey("t")) {
                        multicastSender.setTTL(Integer.parseInt((String)map.get("t")));
                    }
                    if (map.containsKey("s")) {
                        multicastSender.setEventSize(Integer.parseInt((String)map.get("s")));
                    }
                    multicastSender.go();
                    break block18;
                }
                if (map.containsKey("receiver")) {
                    System.out.println("Starting Multicast-Receiver...");
                    MulticastSocket multicastSocket = new MulticastSocket(n2);
                    multicastSocket.setReceiveBufferSize(64000);
                    if (inetAddress2 != null) {
                        multicastSocket.setInterface(inetAddress2);
                    }
                    if (inetAddress != null) {
                        multicastSocket.joinGroup(inetAddress);
                    }
                    if (map.containsKey("verbose")) {
                        bl2 = true;
                    }
                    new MulticastReceiver(multicastSocket, bl2);
                    break block18;
                }
                return this.getUsage();
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Please, provide integer numbers only.");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (illegalArgumentException.getMessage() != null) {
                    System.out.println(illegalArgumentException.getMessage());
                } else {
                    System.out.println(illegalArgumentException.toString());
                }
                System.out.println(this.getUsage());
            }
            catch (Exception exception) {
                a.log(Level.SEVERE, exception.toString(), exception);
            }
        }
        return "";
    }

    public String getUsage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n***************************************************************\n\n");
        stringBuffer.append(" Usage: admin multicastTest [options]\n");
        stringBuffer.append(" Options:\n");
        stringBuffer.append("    -h/-help             This help screen\n");
        stringBuffer.append("    -sender/-receiver  Sender or receiver, specify one\n");
        stringBuffer.append("    -ba            Binding address. Useful for multihomed hosts.\n");
        stringBuffer.append("    -ma            Multicast address\n");
        stringBuffer.append("    -t             Time to live for multicast packets\n");
        stringBuffer.append("    -verbose       Print out the received messages\n\n");
        stringBuffer.append(" Example:  admin multicastTest -sender \n");
        stringBuffer.append(" Example:  admin multicastTest -receiver -verbose\n\n");
        stringBuffer.append(" DESCRIPTION\n");
        stringBuffer.append(" This multicast utility serves to check multicast communication between sender and receiver.\n");
        stringBuffer.append(" 1. Run admin multicastTest -sender on source machine\n");
        stringBuffer.append(" 2. Run admin multicastTest -receiver on each target machine.\n");
        stringBuffer.append(" On the source machine it should display a round-trip \"Reply\" from all target machines.\n");
        stringBuffer.append(" e.g. : \"Reply from 192.138.120.56:5558 bytes=100 time=1.539ms\"");
        stringBuffer.append(" if multicast is enabled between source and targets.\n");
        stringBuffer.append(" Note: For multi-homed network card machine use multicastTest -sender -ba [network card IP]\n");
        stringBuffer.append("\n***************************************************************\n");
        return stringBuffer.toString();
    }
}

