/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import com.gigaspaces.admin.cli.AbstractSpaceCommand;
import com.gigaspaces.admin.cli.CLIFinder;
import com.gigaspaces.admin.cli.CLIUtilities;
import com.gigaspaces.admin.cli.Formatter;
import com.gigaspaces.admin.cli.OptionHandler;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.IJSpaceContainer;
import com.j_spaces.core.NoSuchNameException;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.core.client.FinderException;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.client.SpaceURLParser;
import com.j_spaces.core.cluster.ClusterPolicy;
import com.j_spaces.kernel.JSpaceUtilities;
import java.io.BufferedReader;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.lookup.ServiceItem;

public class SpaceConfiguration
extends AbstractSpaceCommand {
    private OptionHandler a;
    public static final String OPERATION_NAME = "config";
    public static final Logger _logger = Logger.getLogger("com.gigaspaces.admin");
    public static final String YES_OPTION = "Yes";
    public static final String NO_OPTION = "No";

    public SpaceConfiguration() {
        String[] stringArray = new String[]{"h", "help", "url", "c", "cluster"};
        this.a = new OptionHandler(Formatter.fromArray((String[])stringArray));
        this.operationName = OPERATION_NAME;
        this.searchedSpaceState = -1;
    }

    public String getUsage() {
        StringBuffer stringBuffer = this.getBasicUsage();
        return stringBuffer.toString();
    }

    public String process(String string, BufferedReader bufferedReader) {
        try {
            Map map = this.a.getOptions(string);
            if (map.containsKey("h") || map.containsKey("help")) {
                return this.getUsage();
            }
            if (!map.containsKey("url")) {
                IJSpace[] iJSpaceArray = this.getSelectedSpaceProxies(bufferedReader);
                this.a(iJSpaceArray);
                return "";
            }
            String string2 = (String)map.get("url");
            if (JSpaceUtilities.isEmpty(string2, true)) {
                CLIUtilities.printMissingValueMessage("url");
                return "";
            }
            Object object = null;
            try {
                object = this.find(string2);
            }
            catch (FinderException finderException) {
                return "";
            }
            if (object == null) {
                CLIUtilities.printWrongServiceURLMessage(string2);
                return "";
            }
            IJSpace iJSpace = null;
            if (object instanceof IJSpaceContainer) {
                SpaceURL spaceURL = SpaceURLParser.parseURL(string2);
                ServiceItem[] serviceItemArray = this.getContainerSpaces((IJSpaceContainer)object, spaceURL.getProtocol());
                IJSpace[] iJSpaceArray = this.getSelectedFromListSpaceProxies(serviceItemArray, bufferedReader);
                this.a(iJSpaceArray);
                return "";
            }
            if (object instanceof IJSpace) {
                iJSpace = (IJSpace)object;
            }
            String string3 = iJSpace.getName();
            System.out.println("Started to print <" + string3 + "> space configuration...");
            ClusterPolicy clusterPolicy = this.getClusterPolicy(iJSpace);
            if (clusterPolicy != null) {
                if (map.containsKey("c") || map.containsKey("cluster")) {
                    System.out.println("Attempting to receive cluster members...");
                    this.a(clusterPolicy);
                } else {
                    IJSpace[] iJSpaceArray = this.getAllClusterMembers(clusterPolicy, bufferedReader);
                    if (iJSpaceArray == null) {
                        return "No cluster members found.";
                    }
                    this.a(iJSpaceArray);
                }
            } else {
                this.a(iJSpace);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (illegalArgumentException.getMessage() != null) {
                System.out.println(illegalArgumentException.getMessage());
            } else {
                System.out.println(illegalArgumentException.toString());
            }
            System.out.println(this.getUsage());
        }
        catch (Exception exception) {
            System.out.println("Failed to print configuration.");
            _logger.log(Level.SEVERE, exception.toString(), exception);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(ClusterPolicy clusterPolicy) throws RemoteException, FinderException, NoSuchNameException {
        Map map = CLIFinder.getClusterMembersSpaceProxies(clusterPolicy);
        Set set = map.entrySet();
        int n2 = map.size();
        System.out.println("There are " + n2 + " cluster space configurations to be printed.");
        int n3 = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            IJSpace iJSpace = (IJSpace)entry.getValue();
            String string = (String)entry.getKey();
            try {
                if (iJSpace == null) {
                    CLIUtilities.printWrongClusterMemberMessage(string);
                    continue;
                }
                System.out.println(" " + this.operationName + " of <" + string + "> cluster member (" + (n3 + 1) + " of " + n2 + "): ");
                this.a(iJSpace);
            }
            catch (Exception exception) {
                System.out.println("Failed to print configuration of \"" + string + "\" member");
                _logger.log(Level.SEVERE, exception.toString(), exception);
            }
            finally {
                ++n3;
            }
        }
    }

    private void a(IJSpace[] iJSpaceArray) {
        if (iJSpaceArray != null) {
            int n2 = iJSpaceArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                try {
                    this.a(iJSpaceArray[i2]);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("Failed to print configuration of spaces list");
                    _logger.log(Level.SEVERE, exception.toString(), exception);
                }
            }
        }
    }

    private void a(IJSpace iJSpace) throws Exception {
        IRemoteJSpaceAdmin iRemoteJSpaceAdmin = (IRemoteJSpaceAdmin)iJSpace.getAdmin();
        SpaceConfig spaceConfig = iRemoteJSpaceAdmin.getConfig();
        String string = spaceConfig.toString();
        System.out.println(string);
        _logger.log(Level.INFO, string);
    }
}

