/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.reliableLog;

import com.sun.jini.reliableLog.LogException;
import com.sun.jini.reliableLog.LogHandler;
import com.sun.jini.reliableLog.LogInputStream;
import com.sun.jini.reliableLog.LogOutputStream;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.SyncFailedException;

public class ReliableLog {
    private static final String snapshotPrefix = "Snapshot.";
    private static final String logfilePrefix = "Logfile.";
    private static final String versionFile = "Version_Number";
    private static final int MAGIC = -219353113;
    private static final int FORMAT_UNPADDED = 0;
    private static final int FORMAT_PADDED = 1;
    private static final long intBytes = 4L;
    private final File dir;
    private int version = 0;
    private int format = 0;
    private String logName = null;
    private RandomAccessFile log = null;
    private FileDescriptor logFD;
    private long snapshotBytes = 0L;
    private long logBytes = 0L;
    private final LogHandler handler;
    private final byte[] intBuf = new byte[4];
    private final byte[] zeroBuf = new byte[4];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReliableLog(String dirPath, LogHandler handler) throws IOException {
        this.dir = new File(dirPath);
        if (!(!this.dir.exists() ? this.dir.mkdir() : this.dir.isDirectory())) {
            throw new LogException("could not create directory for log: " + dirPath);
        }
        this.handler = handler;
        try {
            DataInputStream in = new DataInputStream(new FileInputStream(this.fName(versionFile)));
            try {
                this.version = in.readInt();
            }
            finally {
                in.close();
            }
        }
        catch (IOException ex) {
            this.writeVersionFile();
        }
        if (this.version < 0) {
            throw new LogException("corrupted version file");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover() throws IOException {
        if (this.version == 0) {
            return;
        }
        String fname = this.versionName(snapshotPrefix);
        File file = new File(fname);
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        try {
            this.handler.recover(in);
        }
        catch (Exception e) {
            throw new LogException("recovery failed", e);
        }
        finally {
            ((InputStream)in).close();
        }
        this.snapshotBytes = file.length();
        fname = this.versionName(logfilePrefix);
        file = new File(fname);
        DataInputStream din = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        long length = file.length();
        try {
            int updateLen = din.readInt();
            if (updateLen == -219353113) {
                this.format = din.readInt();
                if (this.format != 1) {
                    throw new LogException("corrupted log: bad log format");
                }
                this.logBytes += 8L;
                updateLen = din.readInt();
            }
            while (updateLen != 0) {
                int offset;
                if (updateLen < 0) {
                    throw new LogException("corrupted log: bad update length");
                }
                if (length - this.logBytes - 4L < (long)updateLen) {
                    break;
                }
                try {
                    this.handler.readUpdate(new LogInputStream(din, updateLen));
                }
                catch (Exception e) {
                    throw new LogException("read update failed", e);
                }
                this.logBytes += 4L + (long)updateLen;
                if (this.format == 1 && (offset = (int)this.logBytes & 3) > 0) {
                    offset = 4 - offset;
                    this.logBytes += (long)offset;
                    din.skipBytes(offset);
                }
                updateLen = din.readInt();
            }
        }
        catch (EOFException e) {
        }
        finally {
            din.close();
        }
        this.openLogFile();
    }

    public void update(Object value) throws IOException {
        this.update(value, true);
    }

    public void update(Object value, boolean forceToDisk) throws IOException {
        long entryEnd;
        long updateLen;
        if (this.log == null) {
            throw new LogException("log file for persistent state is inaccessible, it may have been corrupted or closed");
        }
        try {
            this.handler.writeUpdate(new LogOutputStream(this.log), value);
        }
        catch (Exception e) {
            throw new LogException("write update failed", e);
        }
        if (forceToDisk) {
            try {
                this.logFD.sync();
            }
            catch (SyncFailedException sfe) {
                throw new LogException("sync log failed", sfe);
            }
        }
        if ((updateLen = (entryEnd = this.log.getFilePointer()) - this.logBytes - 4L) > Integer.MAX_VALUE) {
            throw new LogException("maximum record length exceeded");
        }
        this.log.seek(this.logBytes);
        this.writeInt(this.log, (int)updateLen);
        if (this.format == 1) {
            entryEnd = entryEnd + 3L & 0xFFFFFFFFFFFFFFFCL;
        }
        this.log.seek(entryEnd);
        this.log.write(this.zeroBuf);
        this.logBytes = entryEnd;
        if (forceToDisk) {
            try {
                this.logFD.sync();
            }
            catch (SyncFailedException sfe) {
                throw new LogException("sync log failed", sfe);
            }
        }
    }

    private void writeInt(DataOutput out, int val) throws IOException {
        this.intBuf[0] = (byte)(val >> 24);
        this.intBuf[1] = (byte)(val >> 16);
        this.intBuf[2] = (byte)(val >> 8);
        this.intBuf[3] = (byte)val;
        out.write(this.intBuf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snapshot() throws IOException {
        int oldVersion = this.version++;
        String fname = this.versionName(snapshotPrefix);
        File snapshotFile = new File(fname);
        FileOutputStream out = new FileOutputStream(snapshotFile);
        try {
            try {
                this.handler.snapshot(out);
                out.getFD().sync();
            }
            catch (Exception e) {
                throw new LogException("snapshot failed", e);
            }
            this.snapshotBytes = snapshotFile.length();
        }
        finally {
            out.close();
        }
        this.logBytes = 0L;
        this.openLogFile();
        this.writeVersionFile();
        this.deleteSnapshot(oldVersion);
        this.deleteLogFile(oldVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.log == null) {
            return;
        }
        try {
            this.log.close();
        }
        finally {
            this.log = null;
        }
    }

    public void deletePersistentStore() {
        try {
            this.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.deleteLogFile(this.version);
        }
        catch (LogException e) {
            // empty catch block
        }
        try {
            this.deleteSnapshot(this.version);
        }
        catch (LogException e) {
            // empty catch block
        }
        try {
            this.deleteFile(this.fName(versionFile));
        }
        catch (LogException e) {
            // empty catch block
        }
        try {
            this.dir.delete();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public long snapshotSize() {
        return this.snapshotBytes;
    }

    public long logSize() {
        return this.logBytes;
    }

    private String fName(String name) {
        return this.dir.getPath() + File.separator + name;
    }

    private String versionName(String name) {
        return this.versionName(name, this.version);
    }

    private String versionName(String prefix, int ver) {
        return this.fName(prefix) + String.valueOf(ver);
    }

    private void deleteFile(String name) throws LogException {
        if (!new File(name).delete()) {
            throw new LogException("couldn't delete file: " + name);
        }
    }

    private void deleteSnapshot(int ver) throws LogException {
        if (ver != 0) {
            this.deleteFile(this.versionName(snapshotPrefix, ver));
        }
    }

    private void deleteLogFile(int ver) throws LogException {
        if (ver != 0) {
            this.deleteFile(this.versionName(logfilePrefix, ver));
        }
    }

    private void openLogFile() throws IOException {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.logName = this.versionName(logfilePrefix);
        this.log = new RandomAccessFile(this.logName, "rw");
        this.logFD = this.log.getFD();
        if (this.logBytes == 0L) {
            this.format = 1;
            this.writeInt(this.log, -219353113);
            this.writeInt(this.log, this.format);
            this.logBytes = 8L;
        } else {
            this.log.seek(this.logBytes);
        }
        this.log.setLength(this.logBytes);
        this.log.write(this.zeroBuf);
        this.logFD.sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeVersionFile() throws IOException {
        RandomAccessFile out = new RandomAccessFile(this.fName(versionFile), "rw");
        try {
            this.writeInt(out, this.version);
            out.getFD().sync();
        }
        finally {
            out.close();
        }
    }
}

