/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.proxy;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.TrustEquivalence;

public final class BasicProxyTrustVerifier
implements TrustVerifier,
Serializable {
    private static final long serialVersionUID = 2L;
    private final RemoteMethodControl proxy;

    public BasicProxyTrustVerifier(Object proxy) {
        if (!(proxy instanceof RemoteMethodControl)) {
            throw new IllegalArgumentException("proxy not a RemoteMethodControl instance");
        }
        if (!(proxy instanceof TrustEquivalence)) {
            throw new IllegalArgumentException("proxy not a TrustEquivalence instance");
        }
        this.proxy = (RemoteMethodControl)proxy;
    }

    public boolean isTrustedObject(Object obj, TrustVerifier.Context ctx) {
        if (obj == null || ctx == null) {
            throw new NullPointerException();
        }
        if (!(obj instanceof RemoteMethodControl)) {
            return false;
        }
        RemoteMethodControl unverifiedProxy = (RemoteMethodControl)obj;
        MethodConstraints constraints = unverifiedProxy.getConstraints();
        TrustEquivalence trustedProxy = (TrustEquivalence)this.proxy.setConstraints(constraints);
        return trustedProxy.checkTrustEquivalence((Object)unverifiedProxy);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (!(this.proxy instanceof RemoteMethodControl)) {
            throw new InvalidObjectException("proxy not a RemoteMethodControl instance");
        }
        if (!(this.proxy instanceof TrustEquivalence)) {
            throw new InvalidObjectException("proxy not a TrustEquivalence instance");
        }
    }
}

