/*
 * Decompiled with CFR 0.152.
 */
package net.jini.core.constraint;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.jini.core.constraint.ConnectionAbsoluteTime;
import net.jini.core.constraint.InvocationConstraint;
import net.jini.core.constraint.RelativeTimeConstraint;

public final class ConnectionRelativeTime
implements RelativeTimeConstraint,
Serializable {
    private static final long serialVersionUID = 6854732178792183150L;
    private final long time;

    public ConnectionRelativeTime(long time) {
        if (time < 0L) {
            throw new IllegalArgumentException("invalid duration");
        }
        this.time = time;
    }

    public long getTime() {
        return this.time;
    }

    public InvocationConstraint makeAbsolute(long baseTime) {
        return new ConnectionAbsoluteTime(ConnectionRelativeTime.add(this.time, baseTime));
    }

    private static long add(long dur, long time) {
        long ntime = time + dur;
        if (ntime < 0L && time > 0L) {
            ntime = Long.MAX_VALUE;
        }
        return ntime;
    }

    public int hashCode() {
        return (int)((long)ConnectionRelativeTime.class.hashCode() + this.time);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConnectionRelativeTime)) {
            return false;
        }
        ConnectionRelativeTime cc = (ConnectionRelativeTime)obj;
        return this.time == cc.time;
    }

    public String toString() {
        return "ConnectionRelativeTime[" + this.time + "]";
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.time < 0L) {
            throw new InvalidObjectException("invalid duration");
        }
    }
}

