/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.mux;

import com.sun.jini.jeri.internal.mux.ConnectionIO;
import com.sun.jini.jeri.internal.mux.IOFuture;
import com.sun.jini.jeri.internal.mux.Mux;
import com.sun.jini.jeri.internal.mux.ProtocolException;
import com.sun.jini.logging.Levels;
import com.sun.jini.thread.Executor;
import com.sun.jini.thread.GetThreadPoolAction;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.AccessController;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

final class StreamConnectionIO
extends ConnectionIO {
    private static final int RECEIVE_BUFFER_SIZE = 2048;
    private static final Executor systemThreadPool = (Executor)AccessController.doPrivileged(new GetThreadPoolAction(false));
    private static final Logger logger = Logger.getLogger("net.jini.jeri.connection.mux");
    private final OutputStream out;
    private final InputStream in;
    private final WritableByteChannel outChannel;
    private final ReadableByteChannel inChannel;
    private LinkedList sendQueue = new LinkedList();
    private final ByteBuffer inputBuffer = ByteBuffer.allocate(2048);
    static /* synthetic */ Class class$com$sun$jini$jeri$internal$mux$StreamConnectionIO;

    StreamConnectionIO(Mux mux, OutputStream out, InputStream in) {
        super(mux);
        this.out = out;
        this.in = in;
        this.outChannel = StreamConnectionIO.newChannel(out);
        this.inChannel = StreamConnectionIO.newChannel(in);
    }

    void start() throws IOException {
        try {
            systemThreadPool.execute(new Writer(), "mux writer");
            systemThreadPool.execute(new Reader(), "mux reader");
        }
        catch (OutOfMemoryError e) {
            try {
                logger.log(Level.WARNING, "could not create thread for request dispatch", e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            IOException ioe = new IOException("could not create I/O threads");
            ioe.initCause(e);
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void asyncSend(ByteBuffer buffer) {
        Object object = this.mux.muxLock;
        synchronized (object) {
            if (this.mux.muxDown) {
                return;
            }
            this.sendQueue.addLast(buffer);
            this.mux.muxLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void asyncSend(ByteBuffer first, ByteBuffer second) {
        Object object = this.mux.muxLock;
        synchronized (object) {
            if (this.mux.muxDown) {
                return;
            }
            this.sendQueue.addLast(first);
            this.sendQueue.addLast(second);
            this.mux.muxLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IOFuture futureSend(ByteBuffer first, ByteBuffer second) {
        Object object = this.mux.muxLock;
        synchronized (object) {
            IOFuture future = new IOFuture();
            if (this.mux.muxDown) {
                IOException ioe = new IOException(this.mux.muxDownMessage);
                ioe.initCause(this.mux.muxDownCause);
                future.done(ioe);
                return future;
            }
            this.sendQueue.addLast(first);
            this.sendQueue.addLast(second);
            this.sendQueue.addLast(future);
            this.mux.muxLock.notifyAll();
            return future;
        }
    }

    private void drainQueue(LinkedList queue) {
        while (!queue.isEmpty()) {
            Object next = queue.removeFirst();
            if (!(next instanceof IOFuture)) continue;
            IOException ioe = new IOException(this.mux.muxDownMessage);
            ioe.initCause(this.mux.muxDownCause);
            ((IOFuture)next).done(ioe);
        }
    }

    public static ReadableByteChannel newChannel(final InputStream in) {
        return new ReadableByteChannel(){
            private boolean open = true;
            static final /* synthetic */ boolean $assertionsDisabled;

            public int read(ByteBuffer dst) throws IOException {
                int pos;
                int totalRead;
                int bytesToRead;
                if (!$assertionsDisabled && !dst.hasArray()) {
                    throw new AssertionError();
                }
                byte[] array = dst.array();
                int arrayOffset = dst.arrayOffset();
                int bytesRead = 0;
                for (totalRead = 0; (bytesToRead = dst.remaining()) > 0 && (totalRead <= 0 || in.available() > 0) && (bytesRead = in.read(array, arrayOffset + (pos = dst.position()), bytesToRead)) >= 0; totalRead += bytesRead) {
                    dst.position(pos + bytesRead);
                }
                if (bytesRead < 0 && totalRead == 0) {
                    return -1;
                }
                return totalRead;
            }

            public boolean isOpen() {
                return this.open;
            }

            public void close() throws IOException {
                in.close();
                this.open = false;
            }

            static {
                $assertionsDisabled = !(class$com$sun$jini$jeri$internal$mux$StreamConnectionIO == null ? (class$com$sun$jini$jeri$internal$mux$StreamConnectionIO = StreamConnectionIO.class$("com.sun.jini.jeri.internal.mux.StreamConnectionIO")) : class$com$sun$jini$jeri$internal$mux$StreamConnectionIO).desiredAssertionStatus();
            }
        };
    }

    public static WritableByteChannel newChannel(final OutputStream out) {
        return new WritableByteChannel(){
            private boolean open = true;
            static final /* synthetic */ boolean $assertionsDisabled;

            public int write(ByteBuffer src) throws IOException {
                if (!$assertionsDisabled && !src.hasArray()) {
                    throw new AssertionError();
                }
                int len = src.remaining();
                if (len > 0) {
                    int pos = src.position();
                    out.write(src.array(), src.arrayOffset() + pos, len);
                    src.position(pos + len);
                }
                return len;
            }

            public boolean isOpen() {
                return this.open;
            }

            public void close() throws IOException {
                out.close();
                this.open = false;
            }

            static {
                $assertionsDisabled = !(class$com$sun$jini$jeri$internal$mux$StreamConnectionIO == null ? (class$com$sun$jini$jeri$internal$mux$StreamConnectionIO = StreamConnectionIO.class$("com.sun.jini.jeri.internal.mux.StreamConnectionIO")) : class$com$sun$jini$jeri$internal$mux$StreamConnectionIO).desiredAssertionStatus();
            }
        };
    }

    private class Reader
    implements Runnable {
        static final /* synthetic */ boolean $assertionsDisabled;

        Reader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            try {
                do {
                    int n;
                    if ((n = StreamConnectionIO.this.inChannel.read(StreamConnectionIO.this.inputBuffer)) == -1) {
                        throw new EOFException();
                    }
                    if (!$assertionsDisabled && n <= 0) {
                        throw new AssertionError();
                    }
                    StreamConnectionIO.this.mux.processIncomingData(StreamConnectionIO.this.inputBuffer);
                } while ($assertionsDisabled || StreamConnectionIO.this.inputBuffer.hasRemaining());
                throw new AssertionError();
            }
            catch (ProtocolException e) {
                IOFuture future = null;
                Object object = StreamConnectionIO.this.mux.muxLock;
                synchronized (object) {
                    if (!StreamConnectionIO.this.mux.muxDown) {
                        try {
                            logger.log(Levels.HANDLED, "mux reader thread dying, protocol error", e);
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        future = StreamConnectionIO.this.mux.futureSendError(e.getMessage());
                        StreamConnectionIO.this.mux.setDown("protocol violation detected: " + e.getMessage(), null);
                    } else {
                        try {
                            logger.log(Level.FINEST, "mux reader thread dying: " + e.getMessage());
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                }
                if (future != null) {
                    try {
                        future.waitUntilDone();
                    }
                    catch (IOException ignore) {
                    }
                    catch (InterruptedException interrupt) {
                        Thread.currentThread().interrupt();
                    }
                }
                try {
                    StreamConnectionIO.this.inChannel.close();
                }
                catch (IOException e2) {}
            }
            catch (IOException e) {
                try {
                    logger.log(Levels.HANDLED, "mux reader thread dying, I/O error", e);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                StreamConnectionIO.this.mux.setDown("I/O error reading from mux connection: " + e.toString(), e);
            }
            catch (Throwable t) {
                try {
                    logger.log(Level.WARNING, "mux reader thread dying, unexpected exception", t);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                StreamConnectionIO.this.mux.setDown("unexpected exception in mux reader thread: " + t.toString(), t);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    StreamConnectionIO.this.inChannel.close();
                }
                catch (IOException iOException) {}
            }
            {
                finally {
                    try {
                        StreamConnectionIO.this.inChannel.close();
                    }
                    catch (IOException e) {}
                }
            }
        }

        static {
            $assertionsDisabled = !(class$com$sun$jini$jeri$internal$mux$StreamConnectionIO == null ? (class$com$sun$jini$jeri$internal$mux$StreamConnectionIO = StreamConnectionIO.class$("com.sun.jini.jeri.internal.mux.StreamConnectionIO")) : class$com$sun$jini$jeri$internal$mux$StreamConnectionIO).desiredAssertionStatus();
        }
    }

    private class Writer
    implements Runnable {
        static final /* synthetic */ boolean $assertionsDisabled;

        Writer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block52: {
                LinkedList localQueue = null;
                while (true) {
                    Object object = StreamConnectionIO.this.mux.muxLock;
                    synchronized (object) {
                        while (!StreamConnectionIO.this.mux.muxDown && StreamConnectionIO.this.sendQueue.size() == 0) {
                            StreamConnectionIO.this.mux.muxLock.wait();
                        }
                        if (StreamConnectionIO.this.mux.muxDown && StreamConnectionIO.this.sendQueue.size() == 0) {
                            logger.log(Level.FINEST, "mux writer thread dying, connection down and nothing more to send");
                            break;
                        }
                        localQueue = StreamConnectionIO.this.sendQueue;
                        StreamConnectionIO.this.sendQueue = new LinkedList();
                    }
                    boolean needToFlush = false;
                    while (!localQueue.isEmpty()) {
                        Object next = localQueue.getFirst();
                        if (next instanceof ByteBuffer) {
                            StreamConnectionIO.this.outChannel.write((ByteBuffer)next);
                            needToFlush = true;
                        } else {
                            if (!$assertionsDisabled && !(next instanceof IOFuture)) {
                                throw new AssertionError();
                            }
                            if (needToFlush) {
                                StreamConnectionIO.this.out.flush();
                                needToFlush = false;
                            }
                            ((IOFuture)next).done();
                        }
                        localQueue.removeFirst();
                    }
                    if (!needToFlush) continue;
                    StreamConnectionIO.this.out.flush();
                }
                Object var5_12 = null;
                Object object = StreamConnectionIO.this.mux.muxLock;
                synchronized (object) {
                    if (!$assertionsDisabled && !StreamConnectionIO.this.mux.muxDown) {
                        throw new AssertionError();
                    }
                    if (localQueue != null) {
                        StreamConnectionIO.this.drainQueue(localQueue);
                    }
                    StreamConnectionIO.this.drainQueue(StreamConnectionIO.this.sendQueue);
                }
                try {
                    StreamConnectionIO.this.outChannel.close();
                }
                catch (IOException e2) {}
                break block52;
                {
                    catch (InterruptedException e) {
                        try {
                            logger.log(Level.WARNING, "mux writer thread dying, interrupted", e);
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        StreamConnectionIO.this.mux.setDown("mux writer thread interrupted", e);
                        Object var5_13 = null;
                        Object object2 = StreamConnectionIO.this.mux.muxLock;
                        synchronized (object2) {
                            if (!$assertionsDisabled && !StreamConnectionIO.this.mux.muxDown) {
                                throw new AssertionError();
                            }
                            if (localQueue != null) {
                                StreamConnectionIO.this.drainQueue(localQueue);
                            }
                            StreamConnectionIO.this.drainQueue(StreamConnectionIO.this.sendQueue);
                        }
                        try {
                            StreamConnectionIO.this.outChannel.close();
                        }
                        catch (IOException e2) {}
                        break block52;
                    }
                    catch (IOException e) {
                        try {
                            logger.log(Levels.HANDLED, "mux writer thread dying, I/O error", e);
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        StreamConnectionIO.this.mux.setDown("I/O error writing to mux connection: " + e.toString(), e);
                        Object var5_14 = null;
                        Object object3 = StreamConnectionIO.this.mux.muxLock;
                        synchronized (object3) {
                            if (!$assertionsDisabled && !StreamConnectionIO.this.mux.muxDown) {
                                throw new AssertionError();
                            }
                            if (localQueue != null) {
                                StreamConnectionIO.this.drainQueue(localQueue);
                            }
                            StreamConnectionIO.this.drainQueue(StreamConnectionIO.this.sendQueue);
                        }
                        try {
                            StreamConnectionIO.this.outChannel.close();
                        }
                        catch (IOException e2) {}
                        break block52;
                    }
                    catch (Throwable t) {
                        try {
                            logger.log(Level.WARNING, "mux writer thread dying, unexpected exception", t);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        StreamConnectionIO.this.mux.setDown("unexpected exception in mux writer thread: " + t.toString(), t);
                        Object var5_15 = null;
                        Object object4 = StreamConnectionIO.this.mux.muxLock;
                        synchronized (object4) {
                            if (!$assertionsDisabled && !StreamConnectionIO.this.mux.muxDown) {
                                throw new AssertionError();
                            }
                            if (localQueue != null) {
                                StreamConnectionIO.this.drainQueue(localQueue);
                            }
                            StreamConnectionIO.this.drainQueue(StreamConnectionIO.this.sendQueue);
                        }
                        try {
                            StreamConnectionIO.this.outChannel.close();
                        }
                        catch (IOException e2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var5_16 = null;
                    Object object5 = StreamConnectionIO.this.mux.muxLock;
                    synchronized (object5) {
                        if (!$assertionsDisabled && !StreamConnectionIO.this.mux.muxDown) {
                            throw new AssertionError();
                        }
                        if (localQueue != null) {
                            StreamConnectionIO.this.drainQueue(localQueue);
                        }
                        StreamConnectionIO.this.drainQueue(StreamConnectionIO.this.sendQueue);
                    }
                    try {
                        StreamConnectionIO.this.outChannel.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }

        static {
            $assertionsDisabled = !(class$com$sun$jini$jeri$internal$mux$StreamConnectionIO == null ? (class$com$sun$jini$jeri$internal$mux$StreamConnectionIO = StreamConnectionIO.class$("com.sun.jini.jeri.internal.mux.StreamConnectionIO")) : class$com$sun$jini$jeri$internal$mux$StreamConnectionIO).desiredAssertionStatus();
        }
    }
}

