/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.discovery.internal;

import com.sun.jini.discovery.UnicastDiscoveryClient;
import com.sun.jini.discovery.UnicastResponse;
import com.sun.jini.discovery.internal.EndpointBasedClient;
import com.sun.jini.discovery.internal.EndpointBasedProvider;
import com.sun.jini.discovery.internal.EndpointInternals;
import com.sun.jini.discovery.internal.Plaintext;
import com.sun.jini.jeri.internal.connection.ConnManager;
import com.sun.jini.jeri.internal.connection.ConnManagerFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.NoSuchElementException;
import javax.net.SocketFactory;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.Endpoint;
import net.jini.jeri.OutboundRequest;
import net.jini.jeri.OutboundRequestIterator;
import net.jini.jeri.connection.Connection;
import net.jini.jeri.connection.ConnectionEndpoint;
import net.jini.jeri.connection.OutboundRequestHandle;

public abstract class EndpointBasedClient
extends EndpointBasedProvider
implements UnicastDiscoveryClient {
    protected EndpointBasedClient(String formatName, EndpointInternals endpointInternals) {
        super(formatName, endpointInternals);
    }

    public void checkUnicastDiscoveryConstraints(InvocationConstraints constraints) throws UnsupportedConstraintException {
        if (constraints == null) {
            constraints = InvocationConstraints.EMPTY;
        }
        ConnectionInfo ci = this.getConnectionInfo(null, constraints);
        EndpointBasedClient.checkIntegrity(this.endpointInternals.getUnfulfilledConstraints(ci.handle));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnicastResponse doUnicastDiscovery(Socket socket, InvocationConstraints constraints, ClassLoader defaultLoader, ClassLoader verifierLoader, Collection context, ByteBuffer sent, ByteBuffer received) throws IOException, ClassNotFoundException {
        if (socket == null || sent == null || received == null) {
            throw new NullPointerException();
        }
        if (constraints == null) {
            constraints = InvocationConstraints.EMPTY;
        }
        ConnectionInfo ci = this.getConnectionInfo(socket, constraints);
        Connection conn = ci.endpoint.connect(ci.handle);
        try {
            boolean integrity = EndpointBasedClient.checkIntegrity(conn.getUnfulfilledConstraints(ci.handle));
            BufferedOutputStream out = new BufferedOutputStream(conn.getOutputStream());
            conn.writeRequestData(ci.handle, out);
            ((OutputStream)out).write(EndpointBasedClient.calcHandshakeHash(sent, received));
            ((OutputStream)out).flush();
            BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
            IOException e = conn.readResponseData(ci.handle, in);
            if (e != null) {
                throw e;
            }
            UnicastResponse unicastResponse = Plaintext.readUnicastResponse(in, defaultLoader, integrity, verifierLoader, context);
            return unicastResponse;
        }
        finally {
            conn.close();
        }
    }

    protected abstract Endpoint getEndpoint(SocketFactory var1, InvocationConstraints var2) throws UnsupportedConstraintException;

    private ConnectionInfo getConnectionInfo(Socket socket, InvocationConstraints constraints) throws UnsupportedConstraintException {
        Endpoint ep = this.getEndpoint(new PrearrangedSocketFactory(socket), constraints);
        ConnManagerFactoryImpl factory = new ConnManagerFactoryImpl();
        this.endpointInternals.setConnManagerFactory(ep, factory);
        this.endpointInternals.disableSocketConnect(ep);
        OutboundRequestIterator iter = ep.newRequest(constraints);
        ConnectionInfo ci = factory.getConnectionInfo();
        if (ci != null) {
            return ci;
        }
        if (iter.hasNext()) {
            try {
                iter.next();
            }
            catch (UnsupportedConstraintException e) {
                throw e;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        throw new AssertionError((Object)"expected UnsupportedConstraintException");
    }

    private static class PrearrangedSocketFactory
    extends SocketFactory {
        private final Socket socket;

        PrearrangedSocketFactory(Socket socket) {
            this.socket = socket;
        }

        public Socket createSocket() throws IOException {
            return this.socket;
        }

        public Socket createSocket(String host, int port) throws IOException {
            return this.socket;
        }

        public Socket createSocket(InetAddress host, int port) throws IOException {
            return this.socket;
        }

        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
            return this.socket;
        }

        public Socket createSocket(InetAddress host, int port, InetAddress localHost, int localPort) throws IOException {
            return this.socket;
        }

        public String toString() {
            return "PrearrangedSocketFactory[" + this.socket + "]";
        }
    }

    private static class ConnManagerFactoryImpl
    implements ConnManagerFactory {
        private ConnectionInfo connInfo = null;

        ConnManagerFactoryImpl() {
        }

        public ConnManager create(ConnectionEndpoint endpoint) {
            if (endpoint == null) {
                throw new NullPointerException();
            }
            return new ConnManager(this, endpoint){
                private final /* synthetic */ ConnectionEndpoint val$endpoint;
                private final /* synthetic */ ConnManagerFactoryImpl this$0;
                {
                    this.this$0 = this$0;
                    this.val$endpoint = val$endpoint;
                }

                public OutboundRequestIterator newRequest(OutboundRequestHandle handle) {
                    if (handle == null) {
                        throw new NullPointerException();
                    }
                    ConnManagerFactoryImpl.access$002(this.this$0, new ConnectionInfo(this.val$endpoint, handle));
                    return new OutboundRequestIterator(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public boolean hasNext() {
                            return false;
                        }

                        public OutboundRequest next() throws IOException {
                            throw new NoSuchElementException();
                        }
                    };
                }
            };
        }

        ConnectionInfo getConnectionInfo() {
            return this.connInfo;
        }

        static /* synthetic */ ConnectionInfo access$002(ConnManagerFactoryImpl x0, ConnectionInfo x1) {
            x0.connInfo = x1;
            return x0.connInfo;
        }
    }

    private static class ConnectionInfo {
        final ConnectionEndpoint endpoint;
        final OutboundRequestHandle handle;

        ConnectionInfo(ConnectionEndpoint endpoint, OutboundRequestHandle handle) {
            this.endpoint = endpoint;
            this.handle = handle;
        }
    }
}

