/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.util.Assert;

public class MockRequestDispatcher
implements RequestDispatcher {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final String url;

    public MockRequestDispatcher(String url) {
        Assert.notNull((Object)url, (String)"URL must not be null");
        this.url = url;
    }

    public void forward(ServletRequest request, ServletResponse response) {
        Assert.notNull((Object)request, (String)"Request must not be null");
        Assert.notNull((Object)response, (String)"Response must not be null");
        if (response.isCommitted()) {
            throw new IllegalStateException("Cannot perform forward - response is already committed");
        }
        if (!(response instanceof MockHttpServletResponse)) {
            throw new IllegalArgumentException("MockRequestDispatcher requires MockHttpServletResponse");
        }
        ((MockHttpServletResponse)response).setForwardedUrl(this.url);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("MockRequestDispatcher: forwarding to URL [" + this.url + "]"));
        }
    }

    public void include(ServletRequest request, ServletResponse response) {
        Assert.notNull((Object)request, (String)"Request must not be null");
        Assert.notNull((Object)response, (String)"Response must not be null");
        if (!(response instanceof MockHttpServletResponse)) {
            throw new IllegalArgumentException("MockRequestDispatcher requires MockHttpServletResponse");
        }
        ((MockHttpServletResponse)response).setIncludedUrl(this.url);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("MockRequestDispatcher: including URL [" + this.url + "]"));
        }
    }
}

