/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import javax.servlet.jsp.JspException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.tags.form.AbstractHtmlElementTag;
import org.springframework.web.servlet.tags.form.TagWriter;

public class LabelTag
extends AbstractHtmlElementTag {
    private static final String LABEL_TAG = "label";
    private static final String FOR_ATTRIBUTE = "for";
    private TagWriter tagWriter;
    private String forId;

    public void setFor(String forId) {
        Assert.notNull(forId, "'forId' cannot be null.");
        this.forId = forId;
    }

    public String getFor() {
        return this.forId;
    }

    protected int writeTagContent(TagWriter tagWriter) throws JspException {
        tagWriter.startTag(LABEL_TAG);
        tagWriter.writeAttribute(FOR_ATTRIBUTE, this.resolveFor());
        this.writeDefaultAttributes(tagWriter);
        tagWriter.forceBlock();
        this.tagWriter = tagWriter;
        return 1;
    }

    protected String getName() throws JspException {
        return "";
    }

    protected final String resolveFor() throws JspException {
        if (StringUtils.hasText(this.forId)) {
            return this.getDisplayString(this.evaluate(FOR_ATTRIBUTE, this.forId));
        }
        return this.getCompletePath();
    }

    public int doEndTag() throws JspException {
        this.tagWriter.endTag();
        return 6;
    }

    public void doFinally() {
        super.doFinally();
        this.tagWriter = null;
    }
}

