/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.sql;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.isqlviewer.util.BasicUtilities;

public class FileBlob
implements Blob {
    public File file;
    public StringBuffer blob = new StringBuffer("");

    public FileBlob(File file) throws IOException {
        this.file = file;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((int)file.length());
        FileInputStream fileInputStream = new FileInputStream(this.file);
        BasicUtilities.copyStream(fileInputStream, byteArrayOutputStream);
        this.blob.append(new String(byteArrayOutputStream.toByteArray()));
        fileInputStream.close();
        fileInputStream = null;
        byteArrayOutputStream.close();
        byteArrayOutputStream = null;
    }

    public long length() {
        return this.file.length();
    }

    public byte[] getBytes(long l2, int n2) {
        byte[] byArray = new byte[n2];
        System.arraycopy(this.blob.toString().getBytes(), (int)l2, byArray, 0, n2);
        return byArray;
    }

    public InputStream getBinaryStream() throws SQLException {
        try {
            return new BufferedInputStream(new ByteArrayInputStream(this.blob.toString().getBytes()));
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.getMessage());
        }
    }

    public long position(byte[] byArray, long l2) throws SQLException {
        try {
            String string = new String(byArray);
            String string2 = this.blob.toString();
            return string2.indexOf(string);
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.getMessage());
        }
    }

    public long position(Blob blob, long l2) throws SQLException {
        return this.position(blob.getBytes(0L, (int)blob.length()), l2);
    }

    public void truncate(long l2) throws SQLException {
        try {
            this.blob.setLength((int)l2);
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.getMessage());
        }
    }

    public OutputStream setBinaryStream(long l2) throws SQLException {
        try {
            BlobAdapterStream blobAdapterStream = new BlobAdapterStream(null);
            blobAdapterStream.setOffset(l2);
            return blobAdapterStream;
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.getMessage());
        }
    }

    public int setBytes(long l2, byte[] byArray, int n2, int n3) throws SQLException {
        try {
            String string = new String(byArray, n2, n3);
            this.blob.replace((int)l2, (int)(l2 + (long)n3), string);
            return n3;
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.getMessage());
        }
    }

    public int setBytes(long l2, byte[] byArray) throws SQLException {
        return this.setBytes(l2, byArray, 0, byArray.length);
    }

    public static class 1 {
    }

    private class BlobAdapterStream
    extends OutputStream {
        private StringBuffer buf = new StringBuffer("");
        private long offset = -1L;

        private BlobAdapterStream() {
        }

        public void setOffset(long l2) {
            this.offset = l2;
            if (this.offset > (long)FileBlob.this.blob.length()) {
                this.offset = -1L;
            }
        }

        public synchronized void write(int n2) {
            char c2 = (char)(n2 &= 0xFF);
            this.buf.append(String.valueOf(c2));
        }

        public synchronized void write(byte[] byArray, int n2, int n3) {
            this.buf.append(new String(byArray, n2, n3));
        }

        public synchronized void write(byte[] byArray) {
            this.buf.append(new String(byArray));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void flush() {
            StringBuffer stringBuffer = this.buf;
            synchronized (stringBuffer) {
                if (this.buf.length() > 0) {
                    if (this.offset < (long)FileBlob.this.blob.length() && this.offset >= 0L) {
                        try {
                            FileBlob.this.setBytes(this.offset, this.buf.toString().getBytes());
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        this.offset += (long)this.buf.length();
                    } else {
                        FileBlob.this.blob.append(this.buf.toString());
                        this.offset = FileBlob.this.blob.length();
                    }
                }
                this.buf.setLength(0);
            }
        }

        public void close() {
            this.flush();
            this.buf.setLength(0);
        }

        public /* synthetic */ BlobAdapterStream(1 var2_2) {
            this();
        }
    }
}

