/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import org.garret.perst.Assert;
import org.garret.perst.CustomSerializable;
import org.garret.perst.impl.Btree;
import org.garret.perst.impl.Bytes;
import org.garret.perst.impl.ClassDescriptor;
import org.garret.perst.impl.ObjectHeader;
import org.garret.perst.impl.StorageImpl;
import org.garret.perst.impl.XMLImporter;

public class XMLExporter {
    static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private StorageImpl storage;
    private Writer writer;
    private int[] markedBitmap;
    private int[] exportedBitmap;
    private int[] compoundKeyTypes;
    static /* synthetic */ Class class$org$garret$perst$impl$Btree;
    static /* synthetic */ Class class$org$garret$perst$impl$BitIndexImpl;
    static /* synthetic */ Class class$org$garret$perst$impl$PersistentSet;
    static /* synthetic */ Class class$org$garret$perst$impl$BtreeFieldIndex;
    static /* synthetic */ Class class$org$garret$perst$impl$BtreeMultiFieldIndex;
    static /* synthetic */ Class class$org$garret$perst$impl$BtreeCompoundIndex;

    public XMLExporter(StorageImpl storageImpl, Writer writer) {
        this.storage = storageImpl;
        this.writer = writer;
    }

    public void exportDatabase(int n2) throws IOException {
        int n3;
        if (this.storage.encoding != null) {
            this.writer.write("<?xml version=\"1.0\" encoding=\"" + this.storage.encoding + "\"?>\n");
        } else {
            this.writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        }
        this.writer.write("<database root=\"" + n2 + "\">\n");
        this.exportedBitmap = new int[(this.storage.currIndexSize + 31) / 32];
        this.markedBitmap = new int[(this.storage.currIndexSize + 31) / 32];
        int n4 = n2 >> 5;
        this.markedBitmap[n4] = this.markedBitmap[n4] | 1 << (n2 & 0x1F);
        do {
            n3 = 0;
            for (int i2 = 0; i2 < this.markedBitmap.length; ++i2) {
                int n5 = this.markedBitmap[i2];
                if (n5 == 0) continue;
                int n6 = 0;
                int n7 = 1;
                while (n6 < 32) {
                    if ((n5 & n7) != 0) {
                        int n8 = (i2 << 5) + n6;
                        int n9 = i2;
                        this.exportedBitmap[n9] = this.exportedBitmap[n9] | n7;
                        int n10 = i2;
                        this.markedBitmap[n10] = this.markedBitmap[n10] & ~n7;
                        byte[] byArray = this.storage.get(n8);
                        int n11 = ObjectHeader.getType(byArray, 0);
                        ClassDescriptor classDescriptor = this.storage.findClassDescriptor(n11);
                        if (classDescriptor.cls == (class$org$garret$perst$impl$Btree == null ? XMLExporter.class$("org.garret.perst.impl.Btree") : class$org$garret$perst$impl$Btree)) {
                            this.exportIndex(n8, byArray, "org.garret.perst.impl.Btree");
                        } else if (classDescriptor.cls == (class$org$garret$perst$impl$BitIndexImpl == null ? XMLExporter.class$("org.garret.perst.impl.BitIndexImpl") : class$org$garret$perst$impl$BitIndexImpl)) {
                            this.exportIndex(n8, byArray, "org.garret.perst.impl.BitIndexImpl");
                        } else if (classDescriptor.cls == (class$org$garret$perst$impl$PersistentSet == null ? XMLExporter.class$("org.garret.perst.impl.PersistentSet") : class$org$garret$perst$impl$PersistentSet)) {
                            this.exportSet(n8, byArray);
                        } else if (classDescriptor.cls == (class$org$garret$perst$impl$BtreeFieldIndex == null ? XMLExporter.class$("org.garret.perst.impl.BtreeFieldIndex") : class$org$garret$perst$impl$BtreeFieldIndex)) {
                            this.exportFieldIndex(n8, byArray);
                        } else if (classDescriptor.cls == (class$org$garret$perst$impl$BtreeMultiFieldIndex == null ? XMLExporter.class$("org.garret.perst.impl.BtreeMultiFieldIndex") : class$org$garret$perst$impl$BtreeMultiFieldIndex)) {
                            this.exportMultiFieldIndex(n8, byArray);
                        } else if (classDescriptor.cls == (class$org$garret$perst$impl$BtreeCompoundIndex == null ? XMLExporter.class$("org.garret.perst.impl.BtreeCompoundIndex") : class$org$garret$perst$impl$BtreeCompoundIndex)) {
                            this.exportCompoundIndex(n8, byArray);
                        } else {
                            String string = this.exportIdentifier(classDescriptor.name);
                            this.writer.write(" <" + string + " id=\"" + n8 + "\">\n");
                            this.exportObject(classDescriptor, byArray, 8, 2);
                            this.writer.write(" </" + string + ">\n");
                        }
                        ++n3;
                    }
                    ++n6;
                    n7 <<= 1;
                }
            }
        } while (n3 != 0);
        this.writer.write("</database>\n");
        this.writer.flush();
    }

    final String exportIdentifier(String string) {
        return string.replace('$', '-');
    }

    final void exportSet(int n2, byte[] byArray) throws IOException {
        Btree btree = new Btree(byArray, 8);
        this.storage.assignOid(btree, n2);
        this.writer.write(" <org.garret.perst.impl.PersistentSet id=\"" + n2 + "\">\n");
        btree.export(this);
        this.writer.write(" </org.garret.perst.impl.PersistentSet>\n");
    }

    final void exportIndex(int n2, byte[] byArray, String string) throws IOException {
        Btree btree = new Btree(byArray, 8);
        this.storage.assignOid(btree, n2);
        this.writer.write(" <" + string + " id=\"" + n2 + "\" unique=\"" + (btree.unique ? (char)'1' : '0') + "\" type=\"" + ClassDescriptor.signature[btree.type] + "\">\n");
        btree.export(this);
        this.writer.write(" </" + string + ">\n");
    }

    final void exportFieldIndex(int n2, byte[] byArray) throws IOException {
        Btree btree = new Btree(byArray, 8);
        this.storage.assignOid(btree, n2);
        this.writer.write(" <org.garret.perst.impl.BtreeFieldIndex id=\"" + n2 + "\" unique=\"" + (btree.unique ? (char)'1' : '0') + "\" class=");
        int n3 = this.exportString(byArray, 25);
        this.writer.write(" field=");
        n3 = this.exportString(byArray, n3);
        this.writer.write(" autoinc=\"" + Bytes.unpack8(byArray, n3) + "\">\n");
        btree.export(this);
        this.writer.write(" </org.garret.perst.impl.BtreeFieldIndex>\n");
    }

    final void exportMultiFieldIndex(int n2, byte[] byArray) throws IOException {
        int n3;
        Btree btree = new Btree(byArray, 8);
        this.storage.assignOid(btree, n2);
        this.writer.write(" <org.garret.perst.impl.BtreeMultiFieldIndex id=\"" + n2 + "\" unique=\"" + (btree.unique ? (char)'1' : '0') + "\" class=");
        int n4 = this.exportString(byArray, 25);
        int n5 = Bytes.unpack4(byArray, n4);
        n4 += 4;
        for (n3 = 0; n3 < n5; ++n3) {
            this.writer.write(" field" + n3 + "=");
            n4 = this.exportString(byArray, n4);
        }
        this.writer.write(">\n");
        n3 = Bytes.unpack4(byArray, n4);
        n4 += 4;
        this.compoundKeyTypes = new int[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            this.compoundKeyTypes[i2] = Bytes.unpack4(byArray, n4);
            n4 += 4;
        }
        btree.export(this);
        this.compoundKeyTypes = null;
        this.writer.write(" </org.garret.perst.impl.BtreeMultiFieldIndex>\n");
    }

    final void exportCompoundIndex(int n2, byte[] byArray) throws IOException {
        Btree btree = new Btree(byArray, 8);
        this.storage.assignOid(btree, n2);
        this.writer.write(" <org.garret.perst.impl.BtreeCompoundIndex id=\"" + n2 + "\" unique=\"" + (btree.unique ? (char)'1' : '0') + "\"");
        int n3 = 25;
        int n4 = Bytes.unpack4(byArray, n3);
        n3 += 4;
        this.compoundKeyTypes = new int[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = Bytes.unpack4(byArray, n3);
            this.writer.write(" type" + i2 + "=\"" + ClassDescriptor.signature[n5] + "\"");
            this.compoundKeyTypes[i2] = n5;
            n3 += 4;
        }
        this.writer.write(">\n");
        btree.export(this);
        this.compoundKeyTypes = null;
        this.writer.write(" </org.garret.perst.impl.BtreeCompoundIndex>\n");
    }

    final int exportKey(byte[] byArray, int n2, int n3, int n4) throws IOException {
        switch (n4) {
            case 0: {
                this.writer.write(byArray[n2++] != 0 ? "1" : "0");
                break;
            }
            case 1: {
                this.writer.write(Integer.toString(byArray[n2++]));
                break;
            }
            case 2: {
                this.writer.write(Integer.toString((char)Bytes.unpack2(byArray, n2)));
                n2 += 2;
                break;
            }
            case 3: {
                this.writer.write(Integer.toString(Bytes.unpack2(byArray, n2)));
                n2 += 2;
                break;
            }
            case 4: 
            case 10: {
                this.writer.write(Integer.toString(Bytes.unpack4(byArray, n2)));
                n2 += 4;
                break;
            }
            case 5: {
                this.writer.write(Long.toString(Bytes.unpack8(byArray, n2)));
                n2 += 8;
                break;
            }
            case 6: {
                this.writer.write(Float.toString(Float.intBitsToFloat(Bytes.unpack4(byArray, n2))));
                n2 += 4;
                break;
            }
            case 7: {
                this.writer.write(Double.toString(Double.longBitsToDouble(Bytes.unpack8(byArray, n2))));
                n2 += 8;
                break;
            }
            case 8: {
                for (int i2 = 0; i2 < n3; ++i2) {
                    this.exportChar((char)Bytes.unpack2(byArray, n2));
                    n2 += 2;
                }
                break;
            }
            case 21: {
                for (int i3 = 0; i3 < n3; ++i3) {
                    byte by2 = byArray[n2++];
                    this.writer.write(hexDigit[by2 >>> 4 & 0xF]);
                    this.writer.write(hexDigit[by2 & 0xF]);
                }
                break;
            }
            case 9: {
                long l2 = Bytes.unpack8(byArray, n2);
                n2 += 8;
                if (l2 >= 0L) {
                    this.writer.write(XMLImporter.httpFormatter.format(new Date(l2)));
                    break;
                }
                this.writer.write("null");
                break;
            }
            default: {
                Assert.that(false);
            }
        }
        return n2;
    }

    final void exportCompoundKey(byte[] byArray, int n2, int n3, int n4) throws IOException {
        Assert.that(n4 == 21);
        int n5 = n2 + n3;
        for (int i2 = 0; i2 < this.compoundKeyTypes.length; ++i2) {
            n4 = this.compoundKeyTypes[i2];
            if (n4 == 21 || n4 == 8) {
                n3 = Bytes.unpack4(byArray, n2);
                n2 += 4;
            }
            this.writer.write(" key" + i2 + "=\"");
            n2 = this.exportKey(byArray, n2, n3, n4);
            this.writer.write("\"");
        }
        Assert.that(n2 == n5);
    }

    final void exportAssoc(int n2, byte[] byArray, int n3, int n4, int n5) throws IOException {
        this.writer.write("  <ref id=\"" + n2 + "\"");
        if ((this.exportedBitmap[n2 >> 5] & 1 << (n2 & 0x1F)) == 0) {
            int n6 = n2 >> 5;
            this.markedBitmap[n6] = this.markedBitmap[n6] | 1 << (n2 & 0x1F);
        }
        if (this.compoundKeyTypes != null) {
            this.exportCompoundKey(byArray, n3, n4, n5);
        } else {
            this.writer.write(" key=\"");
            this.exportKey(byArray, n3, n4, n5);
            this.writer.write("\"");
        }
        this.writer.write("/>\n");
    }

    final void indentation(int n2) throws IOException {
        while (--n2 >= 0) {
            this.writer.write(32);
        }
    }

    final void exportChar(char c2) throws IOException {
        switch (c2) {
            case '<': {
                this.writer.write("&lt;");
                break;
            }
            case '>': {
                this.writer.write("&gt;");
                break;
            }
            case '&': {
                this.writer.write("&amp;");
                break;
            }
            case '\"': {
                this.writer.write("&quot;");
                break;
            }
            default: {
                this.writer.write(c2);
            }
        }
    }

    final int exportString(byte[] byArray, int n2) throws IOException {
        int n3 = Bytes.unpack4(byArray, n2);
        n2 += 4;
        if (n3 >= 0) {
            this.writer.write("\"");
            while (--n3 >= 0) {
                this.exportChar((char)Bytes.unpack2(byArray, n2));
                n2 += 2;
            }
            this.writer.write("\"");
        } else if (n3 < -1) {
            this.writer.write("\"");
            String string = this.storage.encoding != null ? new String(byArray, n2, -n3 - 2, this.storage.encoding) : new String(byArray, n2, -n3 - 2);
            n2 -= n3 + 2;
            int n4 = string.length();
            for (int i2 = 0; i2 < n4; ++i2) {
                this.exportChar(string.charAt(i2));
            }
            this.writer.write("\"");
        } else {
            this.writer.write("null");
        }
        return n2;
    }

    final int exportBinary(byte[] byArray, int n2) throws IOException {
        int n3 = Bytes.unpack4(byArray, n2);
        n2 += 4;
        if (n3 < 0) {
            if (n3 == -12) {
                this.exportRef(Bytes.unpack4(byArray, n2));
                n2 += 4;
            } else if (n3 < -1) {
                this.writer.write("\"#");
                this.writer.write(hexDigit[-2 - n3]);
                n3 = ClassDescriptor.sizeof[-2 - n3];
                while (--n3 >= 0) {
                    byte by2 = byArray[n2++];
                    this.writer.write(hexDigit[by2 >>> 4 & 0xF]);
                    this.writer.write(hexDigit[by2 & 0xF]);
                }
                this.writer.write(34);
            } else {
                this.writer.write("null");
            }
        } else {
            this.writer.write(34);
            while (--n3 >= 0) {
                byte by3 = byArray[n2++];
                this.writer.write(hexDigit[by3 >>> 4 & 0xF]);
                this.writer.write(hexDigit[by3 & 0xF]);
            }
            this.writer.write(34);
        }
        return n2;
    }

    final void exportRef(int n2) throws IOException {
        this.writer.write("<ref id=\"" + n2 + "\"/>");
        if (n2 != 0 && (this.exportedBitmap[n2 >> 5] & 1 << (n2 & 0x1F)) == 0) {
            int n3 = n2 >> 5;
            this.markedBitmap[n3] = this.markedBitmap[n3] | 1 << (n2 & 0x1F);
        }
    }

    final int exportObject(ClassDescriptor classDescriptor, byte[] byArray, int n2, int n3) throws IOException {
        ClassDescriptor.FieldDescriptor[] fieldDescriptorArray = classDescriptor.allFields;
        int n4 = fieldDescriptorArray.length;
        for (int i2 = 0; i2 < n4; ++i2) {
            ClassDescriptor.FieldDescriptor fieldDescriptor = fieldDescriptorArray[i2];
            this.indentation(n3);
            String string = this.exportIdentifier(fieldDescriptor.fieldName);
            this.writer.write("<" + string + ">");
            switch (fieldDescriptor.type) {
                case 0: {
                    this.writer.write(byArray[n2++] != 0 ? "1" : "0");
                    break;
                }
                case 1: {
                    this.writer.write(Integer.toString(byArray[n2++]));
                    break;
                }
                case 2: {
                    this.writer.write(Integer.toString((char)Bytes.unpack2(byArray, n2)));
                    n2 += 2;
                    break;
                }
                case 3: {
                    this.writer.write(Integer.toString(Bytes.unpack2(byArray, n2)));
                    n2 += 2;
                    break;
                }
                case 4: {
                    this.writer.write(Integer.toString(Bytes.unpack4(byArray, n2)));
                    n2 += 4;
                    break;
                }
                case 5: {
                    this.writer.write(Long.toString(Bytes.unpack8(byArray, n2)));
                    n2 += 8;
                    break;
                }
                case 6: {
                    this.writer.write(Float.toString(Float.intBitsToFloat(Bytes.unpack4(byArray, n2))));
                    n2 += 4;
                    break;
                }
                case 7: {
                    this.writer.write(Double.toString(Double.longBitsToDouble(Bytes.unpack8(byArray, n2))));
                    n2 += 8;
                    break;
                }
                case 8: {
                    n2 = this.exportString(byArray, n2);
                    break;
                }
                case 9: {
                    long l2 = Bytes.unpack8(byArray, n2);
                    n2 += 8;
                    if (l2 >= 0L) {
                        this.writer.write("\"" + XMLImporter.httpFormatter.format(new Date(l2)) + "\"");
                        break;
                    }
                    this.writer.write("null");
                    break;
                }
                case 10: {
                    this.exportRef(Bytes.unpack4(byArray, n2));
                    n2 += 4;
                    break;
                }
                case 11: {
                    this.writer.write(10);
                    n2 = this.exportObject(fieldDescriptor.valueDesc, byArray, n2, n3 + 1);
                    this.indentation(n3);
                    break;
                }
                case 12: 
                case 21: {
                    n2 = this.exportBinary(byArray, n2);
                    break;
                }
                case 15: {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n2, byArray.length - n2);
                    CustomSerializable customSerializable = this.storage.serializer.unpack(byteArrayInputStream);
                    String string2 = ((Object)customSerializable).toString();
                    this.writer.write("\"");
                    int n5 = string2.length();
                    for (int i3 = 0; i3 < n5; ++i3) {
                        this.exportChar(string2.charAt(i3));
                    }
                    this.writer.write("\"");
                    n2 = byArray.length - byteArrayInputStream.available();
                    break;
                }
                case 20: {
                    int n6 = Bytes.unpack4(byArray, n2);
                    n2 += 4;
                    if (n6 < 0) {
                        this.writer.write("null");
                        break;
                    }
                    this.writer.write(10);
                    while (--n6 >= 0) {
                        this.indentation(n3 + 1);
                        this.writer.write("<element>" + (byArray[n2++] != 0 ? "1" : "0") + "</element>\n");
                    }
                    this.indentation(n3);
                    break;
                }
                case 22: {
                    int n7 = Bytes.unpack4(byArray, n2);
                    n2 += 4;
                    if (n7 < 0) {
                        this.writer.write("null");
                        break;
                    }
                    this.writer.write(10);
                    while (--n7 >= 0) {
                        this.indentation(n3 + 1);
                        this.writer.write("<element>" + (Bytes.unpack2(byArray, n2) & 0xFFFF) + "</element>\n");
                        n2 += 2;
                    }
                    this.indentation(n3);
                    break;
                }
                case 23: {
                    int n8 = Bytes.unpack4(byArray, n2);
                    n2 += 4;
                    if (n8 < 0) {
                        this.writer.write("null");
                        break;
                    }
                    this.writer.write(10);
                    while (--n8 >= 0) {
                        this.indentation(n3 + 1);
                        this.writer.write("<element>" + Bytes.unpack2(byArray, n2) + "</element>\n");
                        n2 += 2;
                    }
                    this.indentation(n3);
                    break;
                }
                case 24: {
                    int n9 = Bytes.unpack4(byArray, n2);
                    n2 += 4;
                    if (n9 < 0) {
                        this.writer.write("null");
                        break;
                    }
                    this.writer.write(10);
                    while (--n9 >= 0) {
                        this.indentation(n3 + 1);
                        this.writer.write("<element>" + Bytes.unpack4(byArray, n2) + "</element>\n");
                        n2 += 4;
                    }
                    this.indentation(n3);
                    break;
                }
                case 25: {
                    int n10 = Bytes.unpack4(byArray, n2);
                    n2 += 4;
                    if (n10 < 0) {
                        this.writer.write("null");
                        break;
                    }
                    this.writer.write(10);
                    while (--n10 >= 0) {
                        this.indentation(n3 + 1);
                        this.writer.write("<element>" + Bytes.unpack8(byArray, n2) + "</element>\n");
                        n2 += 8;
                    }
                    this.indentation(n3);
                    break;
                }
                case 26: {
                    int n11 = Bytes.unpack4(byArray, n2);
                    n2 += 4;
                    if (n11 < 0) {
                        this.writer.write("null");
                        break;
                    }
                    this.writer.write(10);
                    while (--n11 >= 0) {
                        this.indentation(n3 + 1);
                        this.writer.write("<element>" + Float.intBitsToFloat(Bytes.unpack4(byArray, n2)) + "</element>\n");
                        n2 += 4;
                    }
                    this.indentation(n3);
                    break;
                }
                case 27: {
                    int n12 = Bytes.unpack4(byArray, n2);
                    n2 += 4;
                    if (n12 < 0) {
                        this.writer.write("null");
                        break;
                    }
                    this.writer.write(10);
                    while (--n12 >= 0) {
                        this.indentation(n3 + 1);
                        this.writer.write("<element>" + Double.longBitsToDouble(Bytes.unpack8(byArray, n2)) + "</element>\n");
                        n2 += 8;
                    }
                    this.indentation(n3);
                    break;
                }
                case 29: {
                    int n13 = Bytes.unpack4(byArray, n2);
                    n2 += 4;
                    if (n13 < 0) {
                        this.writer.write("null");
                        break;
                    }
                    this.writer.write(10);
                    while (--n13 >= 0) {
                        this.indentation(n3 + 1);
                        long l3 = Bytes.unpack8(byArray, n2);
                        n2 += 8;
                        if (l3 >= 0L) {
                            this.writer.write("<element>\"");
                            this.writer.write(XMLImporter.httpFormatter.format(new Date(l3)));
                            this.writer.write("\"</element>\n");
                            continue;
                        }
                        this.writer.write("<element>null</element>\n");
                    }
                    break;
                }
                case 28: {
                    int n14 = Bytes.unpack4(byArray, n2);
                    n2 += 4;
                    if (n14 < 0) {
                        this.writer.write("null");
                        break;
                    }
                    this.writer.write(10);
                    while (--n14 >= 0) {
                        this.indentation(n3 + 1);
                        this.writer.write("<element>");
                        n2 = this.exportString(byArray, n2);
                        this.writer.write("</element>\n");
                    }
                    this.indentation(n3);
                    break;
                }
                case 13: 
                case 30: {
                    int n15 = Bytes.unpack4(byArray, n2);
                    n2 += 4;
                    if (n15 < 0) {
                        this.writer.write("null");
                        break;
                    }
                    this.writer.write(10);
                    while (--n15 >= 0) {
                        this.indentation(n3 + 1);
                        int n16 = Bytes.unpack4(byArray, n2);
                        if (n16 != 0 && (this.exportedBitmap[n16 >> 5] & 1 << (n16 & 0x1F)) == 0) {
                            int n17 = n16 >> 5;
                            this.markedBitmap[n17] = this.markedBitmap[n17] | 1 << (n16 & 0x1F);
                        }
                        this.writer.write("<element><ref id=\"" + n16 + "\"/></element>\n");
                        n2 += 4;
                    }
                    this.indentation(n3);
                    break;
                }
                case 31: {
                    int n18 = Bytes.unpack4(byArray, n2);
                    n2 += 4;
                    if (n18 < 0) {
                        this.writer.write("null");
                        break;
                    }
                    this.writer.write(10);
                    while (--n18 >= 0) {
                        this.indentation(n3 + 1);
                        this.writer.write("<element>\n");
                        n2 = this.exportObject(fieldDescriptor.valueDesc, byArray, n2, n3 + 2);
                        this.indentation(n3 + 1);
                        this.writer.write("</element>\n");
                    }
                    this.indentation(n3);
                    break;
                }
                case 32: {
                    int n19 = Bytes.unpack4(byArray, n2);
                    n2 += 4;
                    if (n19 < 0) {
                        this.writer.write("null");
                        break;
                    }
                    this.writer.write(10);
                    while (--n19 >= 0) {
                        this.indentation(n3 + 1);
                        this.writer.write("<element>");
                        n2 = this.exportBinary(byArray, n2);
                        this.writer.write("</element>\n");
                    }
                    this.indentation(n3);
                }
            }
            this.writer.write("</" + string + ">\n");
        }
        return n2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

