/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.util.ArrayList;
import org.garret.perst.Assert;
import org.garret.perst.IPersistent;
import org.garret.perst.Link;
import org.garret.perst.Persistent;
import org.garret.perst.Rectangle;
import org.garret.perst.Storage;

public class RtreePage
extends Persistent {
    static final int card = 203;
    static final int minFill = 101;
    int n;
    Rectangle[] b;
    Link branch;

    RtreePage(Storage storage, IPersistent iPersistent, Rectangle rectangle) {
        this.branch = storage.createLink(203);
        this.branch.setSize(203);
        this.b = new Rectangle[203];
        this.setBranch(0, new Rectangle(rectangle), iPersistent);
        this.n = 1;
        for (int i2 = 1; i2 < 203; ++i2) {
            this.b[i2] = new Rectangle();
        }
    }

    RtreePage(Storage storage, RtreePage rtreePage, RtreePage rtreePage2) {
        this.branch = storage.createLink(203);
        this.branch.setSize(203);
        this.b = new Rectangle[203];
        this.n = 2;
        this.setBranch(0, rtreePage.cover(), rtreePage);
        this.setBranch(1, rtreePage2.cover(), rtreePage2);
        for (int i2 = 2; i2 < 203; ++i2) {
            this.b[i2] = new Rectangle();
        }
    }

    RtreePage() {
    }

    RtreePage insert(Storage storage, Rectangle rectangle, IPersistent iPersistent, int n2) {
        this.modify();
        if (--n2 != 0) {
            int n3 = 0;
            long l2 = Long.MAX_VALUE;
            long l3 = Long.MAX_VALUE;
            for (int i2 = 0; i2 < this.n; ++i2) {
                long l4 = this.b[i2].area();
                long l5 = Rectangle.joinArea(this.b[i2], rectangle) - l4;
                if (l5 < l2) {
                    l2 = l5;
                    l3 = l4;
                    n3 = i2;
                    continue;
                }
                if (l5 != l2 || l4 >= l3) continue;
                l3 = l4;
                n3 = i2;
            }
            RtreePage rtreePage = (RtreePage)this.branch.get(n3);
            RtreePage rtreePage2 = rtreePage.insert(storage, rectangle, iPersistent, n2);
            if (rtreePage2 == null) {
                this.b[n3].join(rectangle);
                return null;
            }
            this.setBranch(n3, rtreePage.cover(), rtreePage);
            return this.addBranch(storage, rtreePage2.cover(), rtreePage2);
        }
        return this.addBranch(storage, new Rectangle(rectangle), iPersistent);
    }

    int remove(Rectangle rectangle, IPersistent iPersistent, int n2, ArrayList arrayList) {
        if (--n2 != 0) {
            for (int i2 = 0; i2 < this.n; ++i2) {
                RtreePage rtreePage;
                int n3;
                if (!rectangle.intersects(this.b[i2]) || (n3 = (rtreePage = (RtreePage)this.branch.get(i2)).remove(rectangle, iPersistent, n2, arrayList)) < 0) continue;
                if (rtreePage.n >= 101) {
                    this.setBranch(i2, rtreePage.cover(), rtreePage);
                    this.modify();
                } else {
                    arrayList.add(rtreePage);
                    n3 = n2 - 1;
                    this.removeBranch(i2);
                }
                return n3;
            }
        } else {
            for (int i3 = 0; i3 < this.n; ++i3) {
                if (!this.branch.containsElement(i3, iPersistent)) continue;
                this.removeBranch(i3);
                return 0;
            }
        }
        return -1;
    }

    void find(Rectangle rectangle, ArrayList arrayList, int n2) {
        if (--n2 != 0) {
            for (int i2 = 0; i2 < this.n; ++i2) {
                if (!rectangle.intersects(this.b[i2])) continue;
                ((RtreePage)this.branch.get(i2)).find(rectangle, arrayList, n2);
            }
        } else {
            for (int i3 = 0; i3 < this.n; ++i3) {
                if (!rectangle.intersects(this.b[i3])) continue;
                arrayList.add(this.branch.get(i3));
            }
        }
    }

    void purge(int n2) {
        if (--n2 != 0) {
            for (int i2 = 0; i2 < this.n; ++i2) {
                ((RtreePage)this.branch.get(i2)).purge(n2);
            }
        }
        this.deallocate();
    }

    final void setBranch(int n2, Rectangle rectangle, IPersistent iPersistent) {
        this.b[n2] = rectangle;
        this.branch.set(n2, iPersistent);
    }

    final void removeBranch(int n2) {
        --this.n;
        System.arraycopy(this.b, n2 + 1, this.b, n2, this.n - n2);
        this.branch.remove(n2);
        this.branch.setSize(203);
        this.modify();
    }

    final RtreePage addBranch(Storage storage, Rectangle rectangle, IPersistent iPersistent) {
        if (this.n < 203) {
            this.setBranch(this.n++, rectangle, iPersistent);
            return null;
        }
        return this.splitPage(storage, rectangle, iPersistent);
    }

    final RtreePage splitPage(Storage storage, Rectangle rectangle, IPersistent iPersistent) {
        RtreePage rtreePage;
        Rectangle rectangle2;
        int n2;
        int n3;
        int n4 = 0;
        int n5 = 0;
        long[] lArray = new long[204];
        long l2 = Long.MIN_VALUE;
        lArray[0] = rectangle.area();
        for (n3 = 0; n3 < 203; ++n3) {
            lArray[n3 + 1] = this.b[n3].area();
        }
        Rectangle rectangle3 = rectangle;
        for (n3 = 0; n3 < 203; ++n3) {
            for (n2 = n3 + 1; n2 <= 203; ++n2) {
                long l3 = Rectangle.joinArea(rectangle3, this.b[n2 - 1]) - lArray[n3] - lArray[n2];
                if (l3 <= l2) continue;
                l2 = l3;
                n4 = n3;
                n5 = n2;
            }
            rectangle3 = this.b[n3];
        }
        byte[] byArray = new byte[203];
        byArray[n5 - 1] = 2;
        Rectangle rectangle4 = new Rectangle(this.b[n5 - 1]);
        if (n4 == 0) {
            rectangle2 = new Rectangle(rectangle);
            rtreePage = new RtreePage(storage, iPersistent, rectangle);
        } else {
            rectangle2 = new Rectangle(this.b[n4 - 1]);
            rtreePage = new RtreePage(storage, this.branch.getRaw(n4 - 1), rectangle2);
            this.setBranch(n4 - 1, rectangle, iPersistent);
        }
        int n6 = 1;
        int n7 = 1;
        long l4 = lArray[n4];
        long l5 = lArray[n5];
        while (n7 + n6 < 204 && n7 < 103 && n6 < 103) {
            int n8 = -1;
            int n9 = -1;
            long l6 = -1L;
            for (n3 = 0; n3 < 203; ++n3) {
                long l7;
                if (byArray[n3] != 0 || (l7 = Rectangle.joinArea(rectangle2, this.b[n3]) - l4 - (Rectangle.joinArea(rectangle4, this.b[n3]) - l5)) <= l6 && -l7 <= l6) continue;
                n9 = n3;
                if (l7 < 0L) {
                    n8 = 0;
                    l6 = -l7;
                    continue;
                }
                n8 = 1;
                l6 = l7;
            }
            Assert.that(n9 >= 0);
            if (n8 == 0) {
                rectangle2.join(this.b[n9]);
                l4 = rectangle2.area();
                byArray[n9] = 1;
                rtreePage.setBranch(n7++, this.b[n9], this.branch.getRaw(n9));
                continue;
            }
            ++n6;
            rectangle4.join(this.b[n9]);
            l5 = rectangle4.area();
            byArray[n9] = 2;
        }
        if (n7 + n6 < 204) {
            for (n3 = 0; n3 < 203; ++n3) {
                if (byArray[n3] != 0) continue;
                if (n7 >= n6) {
                    byArray[n3] = 2;
                    ++n6;
                    continue;
                }
                byArray[n3] = 1;
                rtreePage.setBranch(n7++, this.b[n3], this.branch.getRaw(n3));
            }
        }
        rtreePage.n = n7;
        this.n = n6;
        n3 = 0;
        n2 = 0;
        while (n3 < n6) {
            if (byArray[n2] == 2) {
                this.setBranch(n3++, this.b[n2], this.branch.getRaw(n2));
            }
            ++n2;
        }
        return rtreePage;
    }

    final Rectangle cover() {
        Rectangle rectangle = new Rectangle(this.b[0]);
        for (int i2 = 1; i2 < this.n; ++i2) {
            rectangle.join(this.b[i2]);
        }
        return rectangle;
    }
}

