/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.garret.perst.Assert;
import org.garret.perst.FieldIndex;
import org.garret.perst.IPersistent;
import org.garret.perst.Key;
import org.garret.perst.StorageError;
import org.garret.perst.impl.Btree;
import org.garret.perst.impl.BtreeKey;
import org.garret.perst.impl.BtreePage;
import org.garret.perst.impl.ByteBuffer;
import org.garret.perst.impl.Bytes;
import org.garret.perst.impl.ClassDescriptor;
import org.garret.perst.impl.Page;
import org.garret.perst.impl.QueryImpl;
import org.garret.perst.impl.StorageImpl;

class BtreeMultiFieldIndex
extends Btree
implements FieldIndex {
    String className;
    String[] fieldName;
    int[] types;
    transient Class cls;
    transient Field[] fld;

    BtreeMultiFieldIndex() {
    }

    BtreeMultiFieldIndex(Class clazz, String[] stringArray, boolean bl2) {
        this.cls = clazz;
        this.unique = bl2;
        this.fieldName = stringArray;
        this.className = ClassDescriptor.getClassName(clazz);
        this.locateFields();
        this.type = 21;
        this.types = new int[stringArray.length];
        for (int i2 = 0; i2 < this.types.length; ++i2) {
            this.types[i2] = BtreeMultiFieldIndex.checkType(this.fld[i2].getType());
        }
    }

    private final void locateFields() {
        this.fld = new Field[this.fieldName.length];
        for (int i2 = 0; i2 < this.fieldName.length; ++i2) {
            this.fld[i2] = ClassDescriptor.locateField(this.cls, this.fieldName[i2]);
            if (this.fld[i2] != null) continue;
            throw new StorageError(20, this.className + "." + this.fieldName[i2]);
        }
    }

    public Class getIndexedClass() {
        return this.cls;
    }

    public Field[] getKeyFields() {
        return this.fld;
    }

    public void onLoad() {
        this.cls = ClassDescriptor.loadClass(this.getStorage(), this.className);
        this.locateFields();
    }

    int compareByteArrays(byte[] byArray, byte[] byArray2, int n2, int n3) {
        int n4 = 0;
        int n5 = n2;
        byte[] byArray3 = byArray;
        byte[] byArray4 = byArray2;
        for (int i2 = 0; i2 < this.fld.length && n4 < byArray.length; ++i2) {
            int n6 = 0;
            switch (this.types[i2]) {
                case 0: 
                case 1: {
                    n6 = byArray3[n4++] - byArray4[n5++];
                    break;
                }
                case 3: {
                    n6 = Bytes.unpack2(byArray3, n4) - Bytes.unpack2(byArray4, n5);
                    n4 += 2;
                    n5 += 2;
                    break;
                }
                case 2: {
                    n6 = (char)Bytes.unpack2(byArray3, n4) - (char)Bytes.unpack2(byArray4, n5);
                    n4 += 2;
                    n5 += 2;
                    break;
                }
                case 4: 
                case 10: {
                    int n7 = Bytes.unpack4(byArray3, n4);
                    int n8 = Bytes.unpack4(byArray4, n5);
                    n6 = n7 < n8 ? -1 : (n7 == n8 ? 0 : 1);
                    n4 += 4;
                    n5 += 4;
                    break;
                }
                case 5: 
                case 9: {
                    long l2 = Bytes.unpack8(byArray3, n4);
                    long l3 = Bytes.unpack8(byArray4, n5);
                    n6 = l2 < l3 ? -1 : (l2 == l3 ? 0 : 1);
                    n4 += 8;
                    n5 += 8;
                    break;
                }
                case 6: {
                    float f2 = Float.intBitsToFloat(Bytes.unpack4(byArray3, n4));
                    float f3 = Float.intBitsToFloat(Bytes.unpack4(byArray4, n5));
                    n6 = f2 < f3 ? -1 : (f2 == f3 ? 0 : 1);
                    n4 += 4;
                    n5 += 4;
                    break;
                }
                case 7: {
                    double d2 = Double.longBitsToDouble(Bytes.unpack8(byArray3, n4));
                    double d3 = Double.longBitsToDouble(Bytes.unpack8(byArray4, n5));
                    n6 = d2 < d3 ? -1 : (d2 == d3 ? 0 : 1);
                    n4 += 8;
                    n5 += 8;
                    break;
                }
                case 8: {
                    int n9;
                    int n7 = Bytes.unpack4(byArray3, n4);
                    int n8 = Bytes.unpack4(byArray4, n5);
                    n4 += 4;
                    n5 += 4;
                    int n10 = n9 = n7 < n8 ? n7 : n8;
                    while (--n9 >= 0) {
                        n6 = (char)Bytes.unpack2(byArray3, n4) - (char)Bytes.unpack2(byArray4, n5);
                        if (n6 != 0) {
                            return n6;
                        }
                        n4 += 2;
                        n5 += 2;
                    }
                    n6 = n7 - n8;
                    break;
                }
                case 21: {
                    int n11;
                    int n7 = Bytes.unpack4(byArray3, n4);
                    int n8 = Bytes.unpack4(byArray4, n5);
                    n4 += 4;
                    n5 += 4;
                    int n12 = n11 = n7 < n8 ? n7 : n8;
                    while (--n11 >= 0) {
                        if ((n6 = byArray3[n4++] - byArray4[n5++]) == 0) continue;
                        return n6;
                    }
                    n6 = n7 - n8;
                    break;
                }
                default: {
                    Assert.failed("Invalid type");
                }
            }
            if (n6 == 0) continue;
            return n6;
        }
        return 0;
    }

    Object unpackByteArrayKey(Page page, int n2) {
        int n3 = 4 + BtreePage.getKeyStrOffs(page, n2);
        byte[] byArray = page.data;
        Object[] objectArray = new Object[this.fld.length];
        for (int i2 = 0; i2 < this.fld.length; ++i2) {
            Object object = null;
            switch (this.types[i2]) {
                case 0: {
                    object = byArray[n3++] != 0;
                    break;
                }
                case 1: {
                    object = new Byte(byArray[n3++]);
                    break;
                }
                case 3: {
                    object = new Short(Bytes.unpack2(byArray, n3));
                    n3 += 2;
                    break;
                }
                case 2: {
                    object = new Character((char)Bytes.unpack2(byArray, n3));
                    n3 += 2;
                    break;
                }
                case 4: {
                    object = new Integer(Bytes.unpack4(byArray, n3));
                    n3 += 4;
                    break;
                }
                case 10: {
                    int n4 = Bytes.unpack4(byArray, n3);
                    object = n4 == 0 ? null : ((StorageImpl)this.getStorage()).lookupObject(n4, null);
                    n3 += 4;
                    break;
                }
                case 5: {
                    object = new Long(Bytes.unpack8(byArray, n3));
                    n3 += 8;
                    break;
                }
                case 9: {
                    long l2 = Bytes.unpack8(byArray, n3);
                    object = l2 == -1L ? null : new Date(l2);
                    n3 += 8;
                    break;
                }
                case 6: {
                    object = new Float(Float.intBitsToFloat(Bytes.unpack4(byArray, n3)));
                    n3 += 4;
                    break;
                }
                case 7: {
                    object = new Double(Double.longBitsToDouble(Bytes.unpack8(byArray, n3)));
                    n3 += 8;
                    break;
                }
                case 8: {
                    int n4 = Bytes.unpack4(byArray, n3);
                    n3 += 4;
                    Object[] objectArray2 = new char[n4];
                    for (int i3 = 0; i3 < n4; ++i3) {
                        objectArray2[i3] = (char)Bytes.unpack2(byArray, n3);
                        n3 += 2;
                    }
                    object = new String((char[])objectArray2);
                    break;
                }
                case 21: {
                    int n4 = Bytes.unpack4(byArray, n3);
                    Object[] objectArray2 = new byte[n4];
                    System.arraycopy(byArray, n3 += 4, objectArray2, 0, n4);
                    n3 += n4;
                    break;
                }
                default: {
                    Assert.failed("Invalid type");
                }
            }
            objectArray[i2] = object;
        }
        return objectArray;
    }

    private Key extractKey(IPersistent iPersistent) {
        try {
            ByteBuffer byteBuffer = new ByteBuffer();
            int n2 = 0;
            block16: for (int i2 = 0; i2 < this.fld.length; ++i2) {
                Field field = this.fld[i2];
                switch (this.types[i2]) {
                    case 0: {
                        byteBuffer.extend(n2 + 1);
                        byteBuffer.arr[n2++] = (byte)(field.getBoolean(iPersistent) ? 1 : 0);
                        continue block16;
                    }
                    case 1: {
                        byteBuffer.extend(n2 + 1);
                        byteBuffer.arr[n2++] = field.getByte(iPersistent);
                        continue block16;
                    }
                    case 3: {
                        byteBuffer.extend(n2 + 2);
                        Bytes.pack2(byteBuffer.arr, n2, field.getShort(iPersistent));
                        n2 += 2;
                        continue block16;
                    }
                    case 2: {
                        byteBuffer.extend(n2 + 2);
                        Bytes.pack2(byteBuffer.arr, n2, (short)field.getChar(iPersistent));
                        n2 += 2;
                        continue block16;
                    }
                    case 4: {
                        byteBuffer.extend(n2 + 4);
                        Bytes.pack4(byteBuffer.arr, n2, field.getInt(iPersistent));
                        n2 += 4;
                        continue block16;
                    }
                    case 10: {
                        Object object = (IPersistent)field.get(iPersistent);
                        byteBuffer.extend(n2 + 4);
                        if (object != null) {
                            if (!object.isPersistent()) {
                                this.getStorage().makePersistent((IPersistent)object);
                            }
                            Bytes.pack4(byteBuffer.arr, n2, object.getOid());
                        } else {
                            Bytes.pack4(byteBuffer.arr, n2, 0);
                        }
                        n2 += 4;
                        continue block16;
                    }
                    case 5: {
                        byteBuffer.extend(n2 + 8);
                        Bytes.pack8(byteBuffer.arr, n2, field.getLong(iPersistent));
                        n2 += 8;
                        continue block16;
                    }
                    case 9: {
                        Object object = (Date)field.get(iPersistent);
                        byteBuffer.extend(n2 + 8);
                        Bytes.pack8(byteBuffer.arr, n2, object == null ? -1L : ((Date)object).getTime());
                        n2 += 8;
                        continue block16;
                    }
                    case 6: {
                        byteBuffer.extend(n2 + 4);
                        Bytes.pack4(byteBuffer.arr, n2, Float.floatToIntBits(field.getFloat(iPersistent)));
                        n2 += 4;
                        continue block16;
                    }
                    case 7: {
                        byteBuffer.extend(n2 + 8);
                        Bytes.pack8(byteBuffer.arr, n2, Double.doubleToLongBits(field.getDouble(iPersistent)));
                        n2 += 8;
                        continue block16;
                    }
                    case 8: {
                        int n3;
                        byteBuffer.extend(n2 + 4);
                        Object object = (String)field.get(iPersistent);
                        if (object != null) {
                            n3 = ((String)object).length();
                            Bytes.pack4(byteBuffer.arr, n2, n3);
                            byteBuffer.extend((n2 += 4) + n3 * 2);
                            for (int i3 = 0; i3 < n3; ++i3) {
                                Bytes.pack2(byteBuffer.arr, n2, (short)((String)object).charAt(i3));
                                n2 += 2;
                            }
                            continue block16;
                        }
                        Bytes.pack4(byteBuffer.arr, n2, 0);
                        n2 += 4;
                        continue block16;
                    }
                    case 21: {
                        int n3;
                        byteBuffer.extend(n2 + 4);
                        Object object = (byte[])field.get(iPersistent);
                        if (object != null) {
                            n3 = ((Object)object).length;
                            Bytes.pack4(byteBuffer.arr, n2, n3);
                            byteBuffer.extend((n2 += 4) + n3);
                            System.arraycopy(object, 0, byteBuffer.arr, n2, n3);
                            n2 += n3;
                            continue block16;
                        }
                        Bytes.pack4(byteBuffer.arr, n2, 0);
                        n2 += 4;
                        continue block16;
                    }
                    default: {
                        Assert.failed("Invalid type");
                    }
                }
            }
            return new Key(byteBuffer.toArray());
        }
        catch (Exception exception) {
            throw new StorageError(17, exception);
        }
    }

    private Key convertKey(Key key) {
        if (key == null) {
            return null;
        }
        if (key.type != 30) {
            throw new StorageError(9);
        }
        Object[] objectArray = (Object[])key.oval;
        ByteBuffer byteBuffer = new ByteBuffer();
        int n2 = 0;
        block14: for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Object object = objectArray[i2];
            switch (this.types[i2]) {
                case 0: {
                    byteBuffer.extend(n2 + 1);
                    byteBuffer.arr[n2++] = (byte)((Boolean)object != false ? 1 : 0);
                    continue block14;
                }
                case 1: {
                    byteBuffer.extend(n2 + 1);
                    byteBuffer.arr[n2++] = ((Number)object).byteValue();
                    continue block14;
                }
                case 3: {
                    byteBuffer.extend(n2 + 2);
                    Bytes.pack2(byteBuffer.arr, n2, ((Number)object).shortValue());
                    n2 += 2;
                    continue block14;
                }
                case 2: {
                    byteBuffer.extend(n2 + 2);
                    Bytes.pack2(byteBuffer.arr, n2, object instanceof Number ? ((Number)object).shortValue() : (short)((Character)object).charValue());
                    n2 += 2;
                    continue block14;
                }
                case 4: {
                    byteBuffer.extend(n2 + 4);
                    Bytes.pack4(byteBuffer.arr, n2, ((Number)object).intValue());
                    n2 += 4;
                    continue block14;
                }
                case 10: {
                    byteBuffer.extend(n2 + 4);
                    Bytes.pack4(byteBuffer.arr, n2, object == null ? 0 : ((IPersistent)object).getOid());
                    n2 += 4;
                    continue block14;
                }
                case 5: {
                    byteBuffer.extend(n2 + 8);
                    Bytes.pack8(byteBuffer.arr, n2, ((Number)object).longValue());
                    n2 += 8;
                    continue block14;
                }
                case 9: {
                    byteBuffer.extend(n2 + 8);
                    Bytes.pack8(byteBuffer.arr, n2, object == null ? -1L : ((Date)object).getTime());
                    n2 += 8;
                    continue block14;
                }
                case 6: {
                    byteBuffer.extend(n2 + 4);
                    Bytes.pack4(byteBuffer.arr, n2, Float.floatToIntBits(((Number)object).floatValue()));
                    n2 += 4;
                    continue block14;
                }
                case 7: {
                    byteBuffer.extend(n2 + 8);
                    Bytes.pack8(byteBuffer.arr, n2, Double.doubleToLongBits(((Number)object).doubleValue()));
                    n2 += 8;
                    continue block14;
                }
                case 8: {
                    int n3;
                    Object object2;
                    byteBuffer.extend(n2 + 4);
                    if (object != null) {
                        object2 = (String)object;
                        n3 = ((String)object2).length();
                        Bytes.pack4(byteBuffer.arr, n2, n3);
                        byteBuffer.extend((n2 += 4) + n3 * 2);
                        for (int i3 = 0; i3 < n3; ++i3) {
                            Bytes.pack2(byteBuffer.arr, n2, (short)((String)object2).charAt(i3));
                            n2 += 2;
                        }
                        continue block14;
                    }
                    Bytes.pack4(byteBuffer.arr, n2, 0);
                    n2 += 4;
                    continue block14;
                }
                case 21: {
                    int n3;
                    Object object2;
                    byteBuffer.extend(n2 + 4);
                    if (object != null) {
                        object2 = (byte[])object;
                        n3 = ((Object)object2).length;
                        Bytes.pack4(byteBuffer.arr, n2, n3);
                        byteBuffer.extend((n2 += 4) + n3);
                        System.arraycopy(object2, 0, byteBuffer.arr, n2, n3);
                        n2 += n3;
                        continue block14;
                    }
                    Bytes.pack4(byteBuffer.arr, n2, 0);
                    n2 += 4;
                    continue block14;
                }
                default: {
                    Assert.failed("Invalid type");
                }
            }
        }
        return new Key(byteBuffer.toArray(), key.inclusion != 0);
    }

    public boolean put(IPersistent iPersistent) {
        return super.put(this.extractKey(iPersistent), iPersistent);
    }

    public IPersistent set(IPersistent iPersistent) {
        return super.set(this.extractKey(iPersistent), iPersistent);
    }

    public void remove(IPersistent iPersistent) {
        super.remove(new BtreeKey(this.extractKey(iPersistent), iPersistent.getOid()));
    }

    public IPersistent remove(Key key) {
        return super.remove(this.convertKey(key));
    }

    public boolean containsObject(IPersistent iPersistent) {
        Key key = this.extractKey(iPersistent);
        if (this.unique) {
            return super.get(key) != null;
        }
        IPersistent[] iPersistentArray = this.get(key, key);
        for (int i2 = 0; i2 < iPersistentArray.length; ++i2) {
            if (iPersistentArray[i2] != iPersistent) continue;
            return true;
        }
        return false;
    }

    public boolean contains(IPersistent iPersistent) {
        Key key = this.extractKey(iPersistent);
        if (this.unique) {
            return super.get(key) != null;
        }
        IPersistent[] iPersistentArray = this.get(key, key);
        for (int i2 = 0; i2 < iPersistentArray.length; ++i2) {
            if (!iPersistentArray[i2].equals(iPersistent)) continue;
            return true;
        }
        return false;
    }

    public void append(IPersistent iPersistent) {
        throw new StorageError(8);
    }

    public IPersistent[] get(Key key, Key key2) {
        ArrayList arrayList = new ArrayList();
        if (this.root != 0) {
            BtreePage.find((StorageImpl)this.getStorage(), this.root, this.convertKey(key), this.convertKey(key2), this, this.height, arrayList);
        }
        return (IPersistent[])arrayList.toArray((Object[])Array.newInstance(this.cls, arrayList.size()));
    }

    public IPersistent[] toPersistentArray() {
        IPersistent[] iPersistentArray = (IPersistent[])Array.newInstance(this.cls, this.nElems);
        if (this.root != 0) {
            BtreePage.traverseForward((StorageImpl)this.getStorage(), this.root, this.type, this.height, iPersistentArray, 0);
        }
        return iPersistentArray;
    }

    public IPersistent get(Key key) {
        return super.get(this.convertKey(key));
    }

    public Iterator iterator(Key key, Key key2, int n2) {
        return super.iterator(this.convertKey(key), this.convertKey(key2), n2);
    }

    public Iterator entryIterator(Key key, Key key2, int n2) {
        return super.entryIterator(this.convertKey(key), this.convertKey(key2), n2);
    }

    public Iterator select(String string) {
        QueryImpl queryImpl = new QueryImpl(this.getStorage());
        return queryImpl.select(this.cls, this.iterator(), string);
    }
}

