/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.garret.perst.IPersistent;
import org.garret.perst.ITable;
import org.garret.perst.L2ListElem;
import org.garret.perst.PersistentIterator;
import org.garret.perst.impl.QueryImpl;

public class L2List
extends L2ListElem
implements ITable,
Collection {
    private int nElems;
    private int updateCounter;

    public synchronized L2ListElem head() {
        return this.next != this ? this.next : null;
    }

    public synchronized L2ListElem tail() {
        return this.prev != this ? this.prev : null;
    }

    public synchronized void clear() {
        this.modify();
        this.next = this.prev = this;
        this.nElems = 0;
        ++this.updateCounter;
    }

    public synchronized void prepend(L2ListElem l2ListElem) {
        this.modify();
        this.next.modify();
        l2ListElem.modify();
        l2ListElem.next = this.next;
        l2ListElem.prev = this;
        this.next.prev = l2ListElem;
        this.next = l2ListElem;
        ++this.nElems;
        ++this.updateCounter;
    }

    public synchronized void append(L2ListElem l2ListElem) {
        this.modify();
        this.prev.modify();
        l2ListElem.modify();
        l2ListElem.next = this;
        l2ListElem.prev = this.prev;
        this.prev.next = l2ListElem;
        this.prev = l2ListElem;
        ++this.nElems;
        ++this.updateCounter;
    }

    public synchronized void remove(L2ListElem l2ListElem) {
        this.modify();
        l2ListElem.prev.modify();
        l2ListElem.next.modify();
        l2ListElem.next.prev = l2ListElem.prev;
        l2ListElem.prev.next = l2ListElem.next;
        --this.nElems;
        ++this.updateCounter;
    }

    public synchronized boolean isEmpty() {
        return this.next == this;
    }

    public synchronized boolean add(Object object) {
        this.append((L2ListElem)object);
        return true;
    }

    public synchronized boolean remove(Object object) {
        this.remove((L2ListElem)object);
        return true;
    }

    public int size() {
        return this.nElems;
    }

    public synchronized boolean contains(Object object) {
        L2ListElem l2ListElem = this.next;
        while (l2ListElem != this) {
            if (l2ListElem.equals(object)) {
                return true;
            }
            l2ListElem = l2ListElem.next;
        }
        return false;
    }

    public synchronized Iterator iterator() {
        return new L2ListIterator();
    }

    public synchronized Object[] toArray() {
        Object[] objectArray = new L2ListElem[this.nElems];
        L2ListElem l2ListElem = this;
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            l2ListElem = l2ListElem.next;
            objectArray[i2] = l2ListElem;
        }
        return objectArray;
    }

    public synchronized Object[] toArray(Object[] objectArray) {
        int n2 = this.nElems;
        if (objectArray.length < n2) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n2);
        }
        L2ListElem l2ListElem = this;
        for (int i2 = 0; i2 < n2; ++i2) {
            l2ListElem = l2ListElem.next;
            objectArray[i2] = l2ListElem;
        }
        if (objectArray.length > n2) {
            objectArray[n2] = null;
        }
        return objectArray;
    }

    public synchronized boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean addAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
        return true;
    }

    public synchronized boolean removeAll(Collection collection) {
        boolean bl2 = false;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!collection.contains(iterator.next())) continue;
            iterator.remove();
            bl2 = true;
        }
        return bl2;
    }

    public synchronized boolean retainAll(Collection collection) {
        boolean bl2 = false;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (collection.contains(iterator.next())) continue;
            iterator.remove();
            bl2 = true;
        }
        return bl2;
    }

    public Iterator select(Class clazz, String string) {
        QueryImpl queryImpl = new QueryImpl(this.getStorage());
        return queryImpl.select(clazz, this.iterator(), string);
    }

    class L2ListIterator
    implements PersistentIterator {
        private L2ListElem curr;
        private int counter;

        L2ListIterator() {
            this.curr = L2List.this;
            this.counter = L2List.this.updateCounter;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.curr = this.curr.next;
            return this.curr;
        }

        public int nextOid() {
            return ((IPersistent)this.next()).getOid();
        }

        public boolean hasNext() {
            if (this.counter != L2List.this.updateCounter) {
                throw new IllegalStateException();
            }
            return this.curr.next != L2List.this;
        }

        public void remove() {
            if (this.counter != L2List.this.updateCounter || this.curr == L2List.this) {
                throw new IllegalStateException();
            }
            L2List.this.remove(this.curr);
            this.counter = L2List.this.updateCounter;
            this.curr = this.curr.prev;
        }
    }
}

