/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.gs.digester.plugins.strategies;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.gs.digester.Digester;
import org.apache.commons.gs.digester.plugins.PluginException;
import org.apache.commons.gs.digester.plugins.RuleFinder;
import org.apache.commons.gs.digester.plugins.RuleLoader;
import org.apache.commons.gs.digester.plugins.strategies.LoaderFromStream;

public class FinderFromFile
extends RuleFinder {
    public static String DFLT_FILENAME_ATTR = "file";
    private String filenameAttr;

    public FinderFromFile() {
        this(DFLT_FILENAME_ATTR);
    }

    public FinderFromFile(String string) {
        this.filenameAttr = string;
    }

    public RuleLoader findLoader(Digester digester, Class clazz, Properties properties) throws PluginException {
        String string = properties.getProperty(this.filenameAttr);
        if (string == null) {
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (IOException iOException) {
            throw new PluginException("Unable to process file [" + string + "]", iOException);
        }
        try {
            LoaderFromStream loaderFromStream;
            LoaderFromStream loaderFromStream2 = loaderFromStream = new LoaderFromStream(fileInputStream);
            return loaderFromStream2;
        }
        catch (Exception exception) {
            throw new PluginException("Unable to load xmlrules from file [" + string + "]", exception);
        }
        finally {
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException) {
                throw new PluginException("Unable to close stream for file [" + string + "]", iOException);
            }
        }
    }
}

