/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.gs.beanutils.locale.converters;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Logger;
import org.apache.commons.gs.beanutils.locale.BaseLocaleConverter;

public class StringLocaleConverter
extends BaseLocaleConverter {
    private static Logger log;
    static /* synthetic */ Class class$org$apache$commons$gs$beanutils$locale$converters$StringLocaleConverter;

    public StringLocaleConverter() {
        this(false);
    }

    public StringLocaleConverter(boolean bl2) {
        this(Locale.getDefault(), bl2);
    }

    public StringLocaleConverter(Locale locale) {
        this(locale, false);
    }

    public StringLocaleConverter(Locale locale, boolean bl2) {
        this(locale, (String)null, bl2);
    }

    public StringLocaleConverter(Locale locale, String string) {
        this(locale, string, false);
    }

    public StringLocaleConverter(Locale locale, String string, boolean bl2) {
        super(locale, string, bl2);
    }

    public StringLocaleConverter(Object object) {
        this(object, false);
    }

    public StringLocaleConverter(Object object, boolean bl2) {
        this(object, Locale.getDefault(), bl2);
    }

    public StringLocaleConverter(Object object, Locale locale) {
        this(object, locale, false);
    }

    public StringLocaleConverter(Object object, Locale locale, boolean bl2) {
        this(object, locale, null, bl2);
    }

    public StringLocaleConverter(Object object, Locale locale, String string) {
        this(object, locale, string, false);
    }

    public StringLocaleConverter(Object object, Locale locale, String string, boolean bl2) {
        super(object, locale, string, bl2);
    }

    public Object parse(Object object, String string) throws ParseException {
        String string2 = null;
        if (object instanceof Integer || object instanceof Long || object instanceof BigInteger || object instanceof Byte || object instanceof Short) {
            string2 = this.getDecimalFormat(this.locale, string).format(((Number)object).longValue());
        } else if (object instanceof Double || object instanceof BigDecimal || object instanceof Float) {
            string2 = this.getDecimalFormat(this.locale, string).format(((Number)object).doubleValue());
        } else if (object instanceof Date) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, this.locale);
            string2 = simpleDateFormat.format(object);
        } else {
            string2 = object.toString();
        }
        return string2;
    }

    private DecimalFormat getDecimalFormat(Locale locale, String string) {
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance(locale);
        if (string != null) {
            if (this.locPattern) {
                decimalFormat.applyLocalizedPattern(string);
            } else {
                decimalFormat.applyPattern(string);
            }
        } else {
            log.warning("No pattern provided, using default.");
        }
        return decimalFormat;
    }

    static {
        Class<?> clazz = class$org$apache$commons$gs$beanutils$locale$converters$StringLocaleConverter;
        if (clazz == null) {
            clazz = class$org$apache$commons$gs$beanutils$locale$converters$StringLocaleConverter = new StringLocaleConverter[0].getClass().getComponentType();
        }
        log = Logger.getLogger(clazz.getName());
    }
}

